<?php
// app/api/login/login.php

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("usr","pwd",'lang');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $out= new stdClass();
    $usr = $_POST["usr"];
    $pwd = $_POST["pwd"];
    $lang = $_POST['lang'];
    
    $sessid = randomString(32);
    
    //Primero validamos que el usuario exista
    $sql = "SELECT id, pwd FROM users".
    "       WHERE  MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    $userid = $row["id"];
    if($row["id"] == null){
        badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario no existe",
            "eng"=>"User doesn't exist"), $lang, "Usuario no existe")));
    }
    
    // Validamos que su pwd no sea null
    if($row['pwd'] == null){
        badEnd('405', array("msg"=>determinateMsgFail(array(
            "esp"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave",
            "eng"=>"Your password has expired, please go through the password recovery process"), $lang, "Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave")));
    }
    
    // SI todo es exacto, validamos que exista
    $sql = "SELECT COUNT(id) AS qty FROM users ".
    "       WHERE  MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ".
    "       AND    pwd='".mysqli_real_escape_string($db, $pwd)."' " .
    "       AND    status<>0";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0){
        // se incrementa los reintentos y se desactiva la cuenta en caso de llegar al maxfails
        $sql =  "UPDATE users " .
                "       SET fails = " .
                "               CASE WHEN fails < maxfails THEN ".
                "                   fails + 1 ".
                "               ELSE ".
                "                   fails ".
                "               END, ".
                "           status = ".
                "               CASE WHEN fails >= maxfails THEN ".
                "                   0 ".
                "               ELSE ".
                "                   status ".
                "               END, ".
                "           blockedthru = ".
                "               CASE WHEN fails >= maxfails THEN ".
                "                   NOW() ".
                "               ELSE ".
                "                   null ".
                "               END ".
                "   WHERE  MD5(LOWER(usr))='".$usr."'".
                "   AND    fails < maxfails";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $sql = "SELECT status, usr FROM users WHERE MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $rs->fetch_assoc();
        
        if($row["status"] == "0"){
            createAlert($db, 1, $userid, 'El usuario '.$row['usr'].' ingreso 5 veces la contraseña equivocada');
            badEnd("402",array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario bloqueado",
            "eng"=>"User blocked"), $lang, "Usuario bloqueado")));
        }
            
        if($row["status"] == null){
            badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario no existe",
            "eng"=>"User doesn't exist"), $lang, "Usuario no existe")));
        }else{
            badEnd("401", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario/Clave Inválidos",
            "eng"=>"Invalid Username / Password"), $lang, "Usuario/Clave Inválidos")));
        }
    }
    
    //Validamos si el usuario tiene una session activa o no
    $sql = "SELECT id, sessionexpires, ".
    "       IF(sessionid IS NOT NULL, 1, 0) AS isSessionActive, ".
    "       IF(sessionexpires < NOW() OR sessionexpires IS NULL, 1, 0) AS isSessionExpiry ".
    "       FROM users ".
    "       WHERE  MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    //Si la fecha de expiracion es mayor a la actual y es nula, existe otra session activa
    if($row["isSessionActive"] == 1 && $row["isSessionExpiry"] == 0){
        // Colocamos para que la session expire y pueda loguearse
        if($row["sessionexpires"] != null){
            $sql =  "UPDATE users " .
            "SET    sessionexpires = DATE_ADD(NOW(), INTERVAL 3 MINUTE) ".
            "WHERE  MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ".
            "       AND sessionexpires > DATE_ADD(NOW(), INTERVAL 5 MINUTE)";
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>determinateDBError($db)));
            }
        }
        
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"Hemos detectado que exíste otra conexión activa en este momento y por su seguridad no podemos permitir el ingreso. Le recordamos que solo puede mantener una sesión activa con su usuario de ".$shortname.", intente nuevamente en 3 minutos",
            "eng"=>"We have detected that there is another active connection at this time and for your security we cannot allow the entry. We remind you that you can only maintain an active session with your ".$shortname." user, try again in 3 minutes"), $lang, "Hemos detectado que exíste otra conexión activa en este momento y por su seguridad no podemos permitir el ingreso. Le recordamos que solo puede mantener una sesión activa con su usuario de ".$shortname.", intente nuevamente en 3 minutos")));
    }
    
    
    //Validamos que la pwd no este vencida
    $sql = "SELECT IF(pwdexpiration IS NULL OR pwdexpiration < NOW(), 1, 0) AS pwdExpirated FROM users ".
    "       WHERE MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ".
    "       AND pwd='".mysqli_real_escape_string($db, $pwd)."' " .
    "       AND status<>0";
    if (!$rs = $db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    $row = $rs->fetch_assoc();
    
    if($row['pwdExpirated'] == 1){
        badEnd('405', array("msg"=>determinateMsgFail(array(
            "esp"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave",
            "eng"=>"Your password has expired, please go through the password recovery process"), $lang, "Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave")));
    }
    
    
    // destruir cualquier session anterior existente
    $sql =  "UPDATE users " .
            "SET    sessionid = '" . $sessid . "', ".
            "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY),".
            "       lastsession =  NOW(),".
            "       lang = '".mysqli_real_escape_string($db, $lang)."', ".
            "       fails = 0, ".
            "       sessionexpires = DATE_ADD(NOW(), INTERVAL 15 MINUTE) ".
            "WHERE  MD5(LOWER(usr))='".mysqli_real_escape_string($db, $usr)."' ".
            "AND    pwd='".mysqli_real_escape_string($db, $pwd)."' " .
            "AND    status<>0";
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
        
    $sql =  "SELECT  id, sessionid,  DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt, usr, type, login2fa, ".
            "IF(type = 1, CONCAT(IFNULL(up.fname,''),' ', IFNULL(up.flastname,'')), (IF(type = 2, IFNULL(uc.name,''), u.usr))) as name " .
            "FROM    users u ".
            "LEFT JOIN userpersons up ON up.usrid = u.id " .
            "LEFT JOIN usercompanies uc ON uc.usrid = u.id " .
            "WHERE   MD5(LOWER(u.usr))='".mysqli_real_escape_string($db, $usr)."' ".
            "AND     u.pwd='".mysqli_real_escape_string($db, $pwd)."'";

    if (!$rs = $db->query($sql)){
        badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    $row = $rs->fetch_assoc();
    
    $out->id =(int)$row["id"];
    $out->sessionid = $row["sessionid"];
    $out->validthru = $row["vt"];
    $out->name = $row["name"];
    $out->usr = $row["usr"];
    $out->type = (int)$row['type'];
    $out->login2fa = (int)$row['login2fa'];
    
    $ipaddress = getRealIP();
    //Query ajustado para devolver valor max
    $sql = "SELECT date, ipaddress, NOW() as today, date AS date ".
    "       FROM audit ".
    "       INNER JOIN (SELECT MAX(id) AS id FROM audit WHERE MODULE = 'USUARIOS APP' AND userid = ".$out->id." AND dsc LIKE '%inició sesión%') AS auditmax " .
    "       ON audit.id = auditmax.id ";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $res->fetch_assoc();
    /*
    $iptolocation = 'http://api.hostip.info/country.php?ip=' . $row['ipaddress'];
    $creatorlocation = file_get_contents($iptolocation);
    $countryaudit = $creatorlocation;
    
    $iptolocation = 'http://api.hostip.info/country.php?ip=' . $ipaddress;
    $creatorlocation = file_get_contents($iptolocation);
    $countrylogin = $creatorlocation;*/
    
    //$iptolocation = 'http://api.hostip.info/country.php?ip=' . $row['ipaddress'];
    if($row['ipaddress']!="" && $row['ipaddress']!= 'undefined' && $row['ipaddress']!= 'NULL'){
        $creatorlocation = json_decode(file_get_contents("http://ipinfo.io/{$row['ipaddress']}"));//file_get_contents($iptolocation);
        $countryaudit = $creatorlocation->country;
        
        //$iptolocation = 'http://api.hostip.info/country.php?ip=' . $ipaddress;
        $creatorlocation = json_decode(file_get_contents("http://ipinfo.io/{$ipaddress}"));//file_get_contents($iptolocation);
        $countrylogin = $creatorlocation->country;
        
        if ($countryaudit != $countrylogin) {
            createAlert($db, 4, $out->id, 'Última IP: '.$ipaddress." / ".$countrylogin." / ".date('d/m/Y - H:m', strtotime($row['today']))." | Penúltima IP: ".$row['ipaddress']." / ".$countryaudit." / ".date('d/m/Y - H:m', strtotime($row['date'])));
        }
    }
    //auditoria
    setAudit($db, "USUARIOS APP", $out->sessionid, "APP", "El usuario ".$out->name." inició sesión", $ipaddress);
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
