<?php
// app/api/p2p/baotp

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("rif","phone");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables e inicializacion
    $out = new stdClass();
    $rif = $_GET["rif"];
    $phone = $_GET['phone'];
    
    // Consultamos la api de banco activo
    $headers = array('Content-Type:application/json','apikey: '.$BA_API_KEY);
    $request = array(
        'usuario'=>$rifafxAPI, // Usuario
        'telefono'=>$phone,
        'cedula_rif'=>$rif,
    );
    $rest = queryApiBA($BA_URL_QA."otp_pago_movil/1.0.0/otp", "POST", $headers, $request);
    
    if($rest['httpres'] != 200 && $rest['httpres'] != 201){
        switch($rest['httpres']){
            case 503:
                badEnd("500", array("E"=>$rest,"msg"=>determinateMsgFail(array(
                    "esp"=>'El servidor no puede atender temporalmente su petici贸n',
                    "eng"=>'The server is temporarily unable to service your petition BA'), $lang, "El servidor no puede atender temporalmente su petici贸n")));
                break;
            default:
                badEnd("500", array("E"=>$rest,"msg"=>determinateMsgFail(array(
                    "esp"=>'Error llamada a API BA',
                    "eng"=>'Error Call to API'), $lang, "Error llamada a API BA")));
        }
    }
    
    $otp = $rest['bodyres']->otp;
    
    $out->otp = $otp;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>