<?php
// app/api/partners/delete
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","ids");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $ids = $_GET["ids"];
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    $idsArr = explode('-', $ids);
    
    foreach($idsArr as $id){
        $sql = "SELECT COUNT(id) AS qty FROM usercompanypartners WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
        $row = $rs->fetch_assoc();
            
        // Retornamos 404 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("404", array("msg"=>determinateMsgFail(array(
                "esp"=>"No se encuentra el registro ".$id,
                "eng"=>"Cannot find the record ".$id), $lang, "No se encuentra el registro ".$id)));
        }
        
        //Eliminamos las cuentas ya que no fue utilizada la moneda
        $sql = "DELETE FROM usercompanypartners WHERE id = ".$id;
        if (!$db->query($sql)){
            $error = $db->error;
            $errono = $db->errno;
            if ($errono == 1451)
                badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta socio"));
            else
                badEnd("500",array("msg"=>'Error interno'));
        }
    
    }

    
    $out->ids = $ids;
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE id = ".$userid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $userdataaudit = $res->fetch_assoc();
    
    //auditoria
    setAudit($db, "USUARIOS", $sessionid, "APP", "El usuario ".$userdataautir['name']." elimino socios");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
