<?php
// app/api/partners/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // parametros obligatorios
    $parmsob = array("sessionid","id","name","doc","phone");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del GET
    $sessionid = $_POST["sessionid"];
    $partnerid = $_POST["id"];
    $name = $_POST["name"];
    $doc = $_POST["doc"];
    $phone = $_POST["phone"];
    $out = new stdClass;
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Obtenemos los datos del usuario para saber si es juridico
    $sql = "SELECT id, usr, type FROM users WHERE sessionid='".$sessionid."'";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
    $userdata = $rs->fetch_assoc();
    
    //Si el usuario es de otro tipo no puede agregar/actualizar socios
    if($userdata["type"] != 2){
        badEnd("400", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario no es tipo juridico",
            "eng"=>"User is not legal type"), $lang, "Usuario no es tipo juridico")));
    }
    
    //Si el ID es igual a 0 agregamos un socio, si no, actualizamos en caso de que exista
    if($partnerid == 0){
        
        /*//Validamos que estos datos no han sido ingresados
        $sql = "SELECT * FROM usercompanypartners WHERE doc='".$doc."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $partnerdata = $rs->fetch_assoc();
        
        //Si la consulta retona datos retornamos 409/registro duplicado
        if($partnerdata["id"] != null){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }*/
        
        //Si el flujo sigue se insertan los datos del nuevo socio
        $sql = "INSERT INTO usercompanypartners(".
        "       companyid, ".
        "       name, ".
        "       doc, ".
        "       ".validateFieldValues("legalrep","legalrep").
        "       ".validateFieldValues("politicalexp","politicallyexposed").
        "       ".validateFieldValues("affiliationbody","affiliationbody").
        "       ".validateFieldValues("positionheld","positionheld").
        "       ".validateFieldValues("pepcountryid","pepcountryid").
        "       ".validateFieldValues("peprelatedid","peprelatedid").
        "       phone)".
        "       VALUES ".
        "       (".$userdata["id"].", ".
        "       '".$name."', ".
        "       '".$doc."', ".
        "       ".validateFieldInsert("legalrep","number").
        "       ".validateFieldInsert("politicalexp","number").
        "       ".validateFieldInsert("affiliationbody","string").
        "       ".validateFieldInsert("positionheld","string").
        "       ".validateFieldInsert("pepcountryid","number").
        "       ".validateFieldInsert("peprelatedid","string").
        "       '".$phone."')";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $out->id = (int) $db->insert_id;
        
        reqverifyuser($userdata["id"], $db, true);
    }else{
        /*
        //Contamos los datos por los datos recibidos para validar que exista
        $sql = "SELECT COUNT(id) as qty FROM usercompanypartners".
        "       WHERE id !=".$partnerid." AND doc='".$doc."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $res = $rs->fetch_assoc();
        
        if($res["qty"] > 0){
            badEnd("409", array("msg"=>"Registro Duplicado"));
        }*/
        
        
        //Consultamos los datos del usuario
        $sql = "SELECT * FROM usercompanypartners WHERE id = ".$partnerid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $res = $rs->fetch_assoc();
        
        $rejectedArr = explode(",",$res["rejected"]);
        
        //Validamos cada campo
        $rejectedArr = putInWait($res["name"], $name, "name", $rejectedArr);
        $rejectedArr = putInWait($res["doc"], $doc, "doc", $rejectedArr);
        $rejectedArr = putInWait($res["phone"], $phone, "phone", $rejectedArr);
        $_POST["peprelatedid"] == "" ? null : $rejectedArr = putInWait($res["peprelatedid"], $_POST["peprelatedid"], "peprelatedid", $rejectedArr);
        $_POST["legalrep"] == "" ? null : $rejectedArr = putInWait($res["legalrep"], $_POST["legalrep"], "legalrep", $rejectedArr);
        $_POST["politicalexp"] == "" ? null : $rejectedArr = putInWait($res["politicallyexposed"], $_POST["politicalexp"], "politicallyexposed", $rejectedArr);
        $_POST["affiliationbody"] == "" ? null : $rejectedArr = putInWait($res["affiliationbody"], $_POST["affiliationbody"], "affiliationbody", $rejectedArr);
        $_POST["positionheld"] == "" ? null : $rejectedArr = putInWait($res["positionheld"], $_POST["positionheld"], "positionheld", $rejectedArr);
        $_POST["pepcountryid"] == "" ? null : $rejectedArr = putInWait($res["pepcountryid"], $_POST["pepcountryid"], "pepcountryid", $rejectedArr);
        $_POST["peprelatedid"] == "" ? null : $rejectedArr = putInWait($res["peprelatedid"], $_POST["peprelatedid"], "peprelatedid", $rejectedArr);
        
        $strQuery = "";
        $strfields = "";
        
        if(sizeof($rejectedArr) > 0){
            foreach($rejectedArr as $rejected){
                $strfields .= $rejected.",";
            }
            
            $strQuery .= "'".substr($strfields, 0, -1)."'";
        }else{
            
            $strQuery .= "null";
        }
        
        //Actualizamos el socio
        $sql = "UPDATE usercompanypartners".
        "       SET".
        "       name='".$name."', ".
        "       doc='".$doc."', ".
        "       legalrep = ".($_POST["legalrep"] == "" ? "null" : $_POST["legalrep"]).", ".
        "       politicallyexposed = ".($_POST["politicalexp"] == "" ? "null" : $_POST["politicalexp"]).", ".
        "       affiliationbody = ".($_POST["affiliationbody"] == "" ? "null" : "'".$_POST["affiliationbody"]."'").", ".
        "       positionheld = ".($_POST["positionheld"] == "" ? "null" : "'".$_POST["positionheld"]."'").", ".
        "       pepcountryid = ".($_POST["pepcountryid"] == "" ? "null" : $_POST["pepcountryid"]).", ".
        "       peprelatedid = ".($_POST["peprelatedid"] == "" ? "''" : "'".$_POST["peprelatedid"]."'").", ".
        "       phone = '".$phone."', ".
        "       rejected = ".$strQuery.
        "       WHERE id=".$partnerid;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $out->id = (int) $partnerid;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para validar que el parametro fue enviado.
    * Si el parametro existe retorna true y si no retorna false
    */
    function validateUpdate($param){
        $bolValues = false;
        if(isset($_POST[$param]) && $_POST[$param] != ""){
            $bolValues = true;
        }
        return $bolValues;
    }
    
    /*Funcion valida la existencia del campo para asi ingresarlo en el query, en esta se reciben dos parametros
    * $field == Es el campo que se estara evaluando
    * $param == es el valor que se envia por la url
    */
    function validateFieldValues($param, $field){
        $strValues = "";
        if(isset($_POST[$param]) && $_POST[$param] != ""){
            $strValues .= " ".$field.",";
        }
        return $strValues;
    }
    
    /*Funcion valida la existencia del campo para asi ingresarlo a la base de datos, en esta se reciben dos parametros
    * $field == Es el campo que se estara evaluando.
    * $type == El tipo de dato que es el campo a evaluar, Estos pueden ser:
    * -string
    * -date
    * -number
    */
    function validateFieldInsert($field,$type){
        $strInsert = "";
        
        if(isset($_POST[$field]) && $_POST[$field] != ""){
            if($type == "string" || $type == "date"){
                $strInsert .= " '".$_POST[$field]."',";
            }else if($type == "number"){
                if($field === "step"){
                    $strInsert .= " ".($_POST[$field] + 1).",";
                }else{
                    $strInsert .= " ".$_POST[$field].",";
                }
            }
        }
        
        return $strInsert;
    }
    
    /*  Funcion para colocar en espera el campo del socio si fue actualizado
    *   -userField = Nombre del campo a evaluar
    *   -userdata = valor del campo del usuario
    *   -paramField = valor enviado para actualizar
    *   -rejectedArr = Arreglo de campos rechazados
    */
    function putInWait($userData, $paramField, $userfield, $rejectedArr){
        
        $validator = validateIfExist($rejectedArr, $userfield);
        
        if($userData != $paramField){
            if($validator == 1){
                foreach($rejectedArr as $index => $fieldRejected){
                    if($fieldRejected == $userfield){
                        unset($rejectedArr[$index]);
                    }
                }
            }    
        }
        
        return $rejectedArr;
    }
    
    /*  Funcion para validar que si el campo se encuentra en un arreglo
    *   $rejected = arreglo con los campos rechazados
    *   $field = campo a validar que se encuentre en cual arreglo
    *   
    *   Retornara 0 cuando no se encuentre en ninguno
    *   Retornara 1 cuando se encuentre en rejected
    */
    function validateIfExist($rejected, $field){
        
        foreach($rejected as $rejectedfield){
            if($field == $rejectedfield){
                return 1;
            }
        }
        
        return 0;
    }
?>
