<?php
//  app/api/payments/pagomovil/delete.php
    header("Content-Type:application/json");
    include("../../../../settings/dbconn.php");
    include("../../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", "paymentid");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $_POST["sessionid"];
    $paymentids = explode("-", $_POST["paymentid"]);
    
    //Validamos la session
    $userid = isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    foreach ($paymentids as $paymentid){
        //Validamos que existe
        $sql = "SELECT COUNT(payments_pagomovil.id) AS qty ".
        "       FROM payments_pagomovil ".
        "       JOIN accounts ON accounts.userid = ".$userid.
        "           AND accounts.id = payments_pagomovil.accountid".
        "       WHERE payments_pagomovil.id = ".$paymentid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        if($row['qty'] == 0){
            badEnd("405", array("msg"=>determinateMsgFail(array(
                "esp"=>"Pago no registrado",
                "eng"=>"Payment not registered"), $lang, "Pago no registrado")));
        }
        
        // Si existe, vemos que status posee
        $sql = "SELECT payments_pagomovil.* ".
        "       FROM payments_pagomovil ".
        "       JOIN accounts ON accounts.userid = ".$userid.
        "           AND accounts.id = payments_pagomovil.accountid".
        "       WHERE payments_pagomovil.id = ".$paymentid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Si es 1 podemos continuar, si no, no se puede obtener
        if($row['status'] != 1 && $row['status'] != 2){
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"No se puede eliminar ".$paymentid,
                "eng"=>"Cannot delete ".$paymentid), $lang, "No se puede eliminar ".$paymentid)));
        }
    }
    
    
    foreach ($paymentids as $paymentid){
        // Si llegamos aqui, podemos eliminar el registro
        $sql = "UPDATE payments_pagomovil SET".
        "       ref = 'Cancelado', ".
        "       validationcode = NULL, ".
        "       status = 4 ".
        "       WHERE id =".$paymentid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    }
    
    $out->id = $paymentids;
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAudit($db, "CRIPTO PAGOS", $sessionid, "APP", "Se eliminó un pago movil", $ipaddress);
    
    header("HTTP/1.1 200");
    echo(json_encode($out));
    die();
    
?>