<?php
//  app/api/payments/pagomovil/loadfile.php
    header("Content-Type:application/json");
    include("../../../../settings/dbconn.php");
    include("../../../../settings/utils.php");
    require '../../../hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array("sessionid", "accountid", "sendat");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    if (!isset($_FILES['FILE'])){
        badEnd("400", array("msg"=>"Parametros obligatorios FILE", "files"=>$_FILES));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $_POST["sessionid"];
    $accountid = $_POST["accountid"];
    $file = $_FILES['FILE'];
    $sendat = $_POST["sendat"];
    $maxfails = 10;
    
    //Validamos la session
    $userid = isSessionValid($db, $sessionid);
    
    isLevelValid($db, $userid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    // Validamos el type del archivo
    if($file['type'] != 'text/csv'){
        badEnd("400", array("msg"=>"Archivo debe ser text/csv"));
    }
    
    // Validamos el permiso del usuario
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $userPerm = $rs->fetch_assoc();
    
    // Preferencias de pago de terceros
    $paymentstothirdsparty = json_decode($userPerm['paymentstothirdsparty'], true);
    
    if(!$paymentstothirdsparty[0]['pagomovil']){
        badEnd("405", array("msg"=>determinateMsgFail(array(
            "esp"=>"No posee permisos",
            "eng"=>"does not have permissions"), $lang, "No posee permisos")));
    }
    
    // Obtenemos los datos de la cuenta del usuario
    $sql = "SELECT * FROM accounts ".
    "       WHERE id = ".$accountid.
    "       AND userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $accountdata = $rs->fetch_assoc();
    
    if($accountdata['id'] == null){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"Cuenta no encontrada",
            "eng"=>"Account not found"), $lang, "Cuenta no encontrada")));
    }
    
    $currencyid = $accountdata['currencyid'];
    
    // Obtenemos los datos de la cuenta del usuario FIAT
    $sql = "SELECT * FROM accounts ".
    "       WHERE currencyid = 1".
    "       AND userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $accountfiat = $rs->fetch_assoc();
    $accountfiatid = $accountfiat['id'];
    
    // Obtenemos los datos de la moneda
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currency = $rs->fetch_assoc();
    
    // Obtenemos los datos del BS
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currencyfiat = $rs->fetch_assoc();
    
    // Obtenemos la cuenta AFX del usuario
    $sql = "SELECT id FROM accounts  ".
    "       WHERE currencyid = ".$currencyid.
    "       AND paymentmethodid = -1 " .
    "       AND accounts.entityusrid = -1 ".
    "       AND userid=".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db).$sql));
        
    $account = $rs->fetch_assoc();
    
    // Consultamos de la vista ya creada con el balance
    $sql = "SELECT * FROM accountbalances WHERE accountid = ".$accountid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $balancetx = $res->fetch_assoc();
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    //Consultamos la cuenta que tiene los saldos de los pago moviles
    $sql = "SELECT * FROM accounts ".
    "       WHERE userid = -1".
    "       AND currencyid = ".$currency["id"].
    "       AND paymentmethodid = -7";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta AFX
    $afxdatabalances = $rs->fetch_assoc();
    
    //Consultamos la cuenta que tiene la moneda del retiro de AFX
    $sql = "SELECT * FROM accounts ".
    "       WHERE userid = -1".
    "       AND currencyid = ".$currency["id"].
    "       AND paymentmethodid = -6";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta AFX
    $afxdata = $rs->fetch_assoc();
    
    // Buscamos la cuenta de comision de AFX para retiros
    $sql = "SELECT * FROM accounts ".
    "       WHERE userid = -1".
    "       AND currencyid = ".$currency["id"].
    "       AND paymentmethodid = -2";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Guardamos la data de la cuenta AFX
    $afxdatawithdrawal = $rs->fetch_assoc();
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$currencyfiat["id"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    
    $validator = getValidator(8);
    $validatorMd5 = md5($validator);
    
    $bankinterface = getActiveBank($db, 2, 1);
    
    // Buscamos los bancos
    $banks = array();
    switch($bankinterface){
        case 0:
            badEnd("204", array("msg"=>determinateMsgFail(array(
                "esp"=>'Servicio inactivo, intente más tarde',
                "eng"=>'Service down, please try again later'), $lang, "Servicio inactivo, intente más tarde")));
            break;
        case 1:
            // Consultamos el listado de bancos
            $headers = array('Content-Type:application/json');
            $request = array();
            $rest = queryApiBP($BP_URL_QA, "pagos/p2p/bancos", $BP_VERSION_P2P, "GET", $headers, $request);
            
            if($rest['httpres'] != 200 && $rest['httpres'] != 201){
                switch($rest['httpres']){
                    case 503:
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>'El servidor no puede atender temporalmente su petición',
                            "eng"=>'The server is temporarily unable to service your petition BP'), $lang, "El servidor no puede atender temporalmente su petición")));
                        break;
                    default:
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>'Error llamada a API BP',
                            "eng"=>'Error Call to API'), $lang, "Error llamada a API BP")));
                }
            }
        
            $banks = $rest['bancos'];
        
            break;
        case 2:
            
            // Consultamos la api de banco activo
            $headers = array('Content-Type:application/json','apikey: '.$BA_API_KEY);
            $request = array("tipo_pagador"=>"P2P");
            $rest = queryApiBA($BA_URL_QA."lista_banco_pago_movil/1.0.0/bancos", "POST", $headers, $request);
            
            if($rest['httpres'] != 200 && $rest['httpres'] != 201){
                $msgs = validateErrorBancoActivo($rest['bodyres']->code, $rest['bodyres']->descripcion, $rest['bodyres']->descripcion);
                $msg_esp = $msgs->msg_esp;
                $msg_eng = $msgs->msg_eng;
                                
                $msg_esp = $msg_esp;
                $msg_eng = $msg_eng;
                
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>$msg_esp,
                    "eng"=>$msg_eng), $lang, $msg_esp)));
            }
            
            $banks = $rest['bodyres']->bancos;
        break;
    }
    
    // Borramos los registros de este usuario en la tabla load
    $sql = "DELETE FROM payments_loadpagomovil ".
    "       WHERE EXISTS(SELECT * FROM accounts WHERE accounts.userid = ".$userid." AND accounts.id = payments_loadpagomovil.accountid)";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $file = fopen($_FILES['FILE']['tmp_name'], 'r');
    $indexFile = 0;
    $errorsFinded = 0;
    $headers = [];
    // Monto a validar contra la cuenta
    $errors = [];
    $amountVal = 0;
    while (($line = fgetcsv($file)) !== FALSE) {
       // si es 0, es la cabecera
       if($indexFile == 0){
           $indexFile++;
           $headers = $line;
           continue;
       }
       
       // Validamos que ningun dato este vacio
       $emptyHeader = array();
       foreach($line as $index => $val){
            if(trim($val) == ''){
                $emptyHeader [] = $headers[$index];
            }
        }
       if(count($emptyHeader) > 0){
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"Operación invalida. Estructura incorrecta del archivo a partir de la linea ".($indexFile+1),
                "eng"=>"Invalid operation. Incorrect file structure from line ".($indexFile+1)), $lang, "Operación invalida. Estructura incorrecta del archivo a partir de la linea ".($indexFile+1))));
            break;
       }
       
       if(count($line) > 6){
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"Operación invalida. Estructura incorrecta del archivo a partir de la linea ".($indexFile+1),
                "eng"=>"Invalid operation. Incorrect file structure from line ".($indexFile+1)), $lang, "Operación invalida. Estructura incorrecta del archivo a partir de la linea ".($indexFile+1))));
            break;
                
       }
       
       if(count($line) < 6){
            
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"Operación invalida. Estructura incorrecta del archivo a partir de la linea ".($indexFile+1),
                "eng"=>"Invalid operation. Incorrect file structure from line ".($indexFile+1)), $lang, "Operación invalida. Estructura incorrecta del archivo a partir de la linea ".($indexFile+1))));
            break;
       }
       
       // Validamos que los datos sean correctos
       // Monto
       if(gettype(floatval($line[4])) != 'double' && gettype(floatval($line[4])) != 'integer'){
           $errorsFinded++;
           $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"Monto debe ser un número",
                "eng"=>"Amount have to be a number"),
                $lang,
                "Monto debe ser un número"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            continue;
        }
        
        // Telefono
        if(gettype(intval($line[3])) != 'double' && gettype(intval($line[3])) != 'integer'){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>ddeterminateMsgFail(array(
                "esp"=>"TLF debe ser un número",
                "eng"=>"TLF have to be a number"),
                $lang,
                "TLF debe ser un número"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Telefono maximo
        if(strlen($line[3]) > 11 || strlen($line[3]) < 11){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"TLF debe ser igual a 11 caracteres",
                "eng"=>"TLF have to be equal 11 characters"),
                $lang,
                "TLF debe ser igual a 11 caracteres"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Sacamos los 3 primeros numeros del telefono
        $phoneCode = strtoupper(substr($line[3], 0, 4));
        
        // Validamos que esten correctos
        if ($phoneCode != '0412'
            && $phoneCode != '0414'
            && $phoneCode != '0416'
            && $phoneCode != '0424'
            && $phoneCode != '0426'
        ) {
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1),"e"=> $phoneCode, "msg"=>determinateMsgFail(array(
                "esp"=>"TLF debe empezar con 0412, 0414, 0416, 0424 o 0426",
                "eng"=>"TLF have to start with 0412, 0414, 0416, 0424 or 0426"),
                $lang,
                "TLF debe empezar con 0412, 0414, 0416, 0424 o 0426"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        if($line[4] <= 0){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"Monto no puede ser menor o igual a 0",
                "eng"=>"Amount cannot be less than or equal to 0"), $lang, "Monto no puede ser menor o igual a 0"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Validamos la dsc
        if(gettype($line[5]) != 'string'){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"DSC debe ser un texto",
                "eng"=>"DSC have to be a texto"),
                $lang,
                "DSC debe ser un texto"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Validamos la cedula
        if(gettype($line[2]) != 'string'){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"RIF debe ser un texto",
                "eng"=>"RIF have to be a texto"),
                $lang,
                "RIF debe ser un texto"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Obtenemos la primera letra del RIF
        $kindDoc = strtoupper(substr($line[2], 0, 1));
        
        if ($kindDoc != 'V' && $kindDoc != 'J' && $kindDoc != 'E') {
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"RIF debe empezar con J, V o E",
                "eng"=>"RIF have to start with J, V or E"),
                $lang,
                "RIF debe empezar con J, V o E"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        $doc = substr($line[2], 1);
        
        if(gettype(intval($doc)) != 'integer'){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"Extensión del RIF debe ser número",
                "eng"=>"RIF extention have to be a number"),
                $lang,
                "Extensión del RIF debe ser número"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Validamos el tamano, si es J son 11 maximo
        if(strlen($line[2]) > 11 && $kindDoc == 'J'){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"RIF debe ser igual a 11 caracteres",
                "eng"=>"RIF have to be equal than 11 characters"),
                $lang,
                "RIF debe ser igual a 11 caracteres"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Validamos el tamano, si es V o E son 10 maximo
        if(strlen($line[2]) > 10 && ($kindDoc == 'V' || $kindDoc == 'E')){
            $errorsFinded++;
            $errors [] = array("line"=>($indexFile+1), "msg"=>determinateMsgFail(array(
                "esp"=>"RIF debe ser igual o menor a 10 caracteres",
                "eng"=>"RIF have to be equal or less than 10 characters"),
                $lang,
                "RIF debe ser igual o menor a 10 caracteres"));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
       
        // Obtenemos el rate de la moneda para VES para la descripcion
        $rate = determinateRate($db, $currencyfiat["id"], $currency['id'], $currencyfiat['decimals']); //se volteó las monedas y se cambiaron los decimals 
        $amountReal = number_format(floatval($line[4])*$rate->number, $currency['decimals'], '.', '');
        $showedAmountVes  = number_format(floatval($line[4]), $currencyfiat['decimals'], '.', '');
        
        //Validamos que el monto sea mas que el minimo aceptado para transferencia
        if(validateMin($accountdata["currencyid"],$userdata["type"], 2, $db, $amountReal)){
            $errorsFinded++;
            $errors [] = array("msg"=>"Monto m&iacute;nimo autorizado: ".numberFormatt($fee['minxfer'], $currencyfiat['decimals'])." ".$currencyfiat['symbol'], "line"=>($indexFile+1));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        // Insertamos los datos
        $bankname = '';
        switch($bankinterface){
            case 1:
                // recorremos los bancos para sacar el code a partir del nombre para la API
                foreach($banks as $bank){
                    if ($bank['codigo'] == $line[0]) {
                        $bankname = $bank['nombre'];
                    }
                }
            
                break;
            case 2:
                foreach($banks as $bank){
                    if ($bank->codBanco == $line[0]) {
                        $bankname = $bank->nombreBanco;
                    }
                }
            break;
        }
        
        if($bankname == ''){
            $errorsFinded++;
            $errors [] = array("msg"=>"Banco no disponible", "line"=>($indexFile+1));
        }
        
        if ($errorsFinded >= 10) {
            $errors [] = array("msg"=>"Cantidad maxima de errores alcanzado", "line"=>0);
            break;
        }
        
        if(count($errors) > 0){
            $indexFile++;
            continue;
        }
    
        // SACAMOS LA COMISION PARA PAGO MOVIL PRIMERO
        $feepagomovil = 0;
        if($fee["pagomovilpct"] != null){
            // Obtenemos el exonerado para depositos si posee
            $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
            "       WHERE currencyid = ".$currencyfiat["id"].
            "       AND userid = ".$userdata['id'].
            "       AND preffeesfield = 'pagomovilpct'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $userExg = $res->fetch_assoc();
            
            $feepagomovil = number_format((($fee["pagomovilpct"] - ($fee["pagomovilpct"]/100 * $userExg['exonerated']) )*$amountReal)/100, $currency['decimals'], '.', '');
        }
    
        // SACAMOS LA COMISION PARA RETIRO PORCENTAJE FIAT
        $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$currencyfiat["id"].
        "       AND levelid = ".$level.
        "       AND usertype = ".$userdata["type"];
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        //Guardamos la data de la cuenta
        $fee = $rs->fetch_assoc();
        
        $feewithdrawal = 0;
        if($fee["pctfeewithdrawals"] != null || $fee["nmlfeewithdrawals"] != null ){
            if($fee["pctfeewithdrawals"] == null){
                
                // Obtenemos el exonerado para depositos si podee
                $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
                "       WHERE currencyid = ".$currencyfiat["id"].
                "       AND userid = ".$userdata['id'].
                "       AND preffeesfield = 'nmlfeewithdrawals'";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                
                $userExg = $res->fetch_assoc();
                
                // Cambiamos a la moneda que es
                $userExgRated = number_format($userExg['exonerated']*$rate->number, $currency['decimals'], '.', '');
                $feeRated = number_format($fee["nmlfeewithdrawals"]*$rate->number, $currency['decimals'], '.', '');
                
                $feewithdrawal = number_format($amountReal - ($amountReal - ($feeRated - ($feeRated/100 * $userExgRated) )), $currency['decimals'], '.', '');
            }else{
                
                // Obtenemos el exonerado para depositos si podee
                $sql = "SELECT IF(exonerated IS NULL, 0, exonerated) AS exonerated FROM userportfolioprefs ".
                "       WHERE currencyid = ".$currencyfiat["id"].
                "       AND userid = ".$userdata['id'].
                "       AND preffeesfield = 'pctfeewithdrawals'";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                
                $userExg = $res->fetch_assoc();
                
                $feewithdrawal = number_format((($fee["pctfeewithdrawals"] - ($fee["pctfeewithdrawals"]/100 * $userExg['exonerated']) )*$amountReal)/100, $currency['decimals'], '.', '');
            }
        }
        
        // GUARDAMOS EL MONTO CON TODO
        $amountVal += $amountReal + $feewithdrawal + $feepagomovil;
        
        validateOperations($db, $accountfiatid, $userid, $showedAmountVes, 2);
       
        // Creamos el registro
        $sql = "INSERT INTO payments_loadpagomovil (".
        "       recipient,".
        "       recipientrif,".
        "       recipientphone,".
        "       bankcode,".
        "       bankname,".
        "       note,".
        "       sendat,".
        "       accountid, ".
        "       amount ".
        "       )".
        "       VALUES (".
        "       '".mysqli_real_escape_string($db, $line[1])."', ".
        "       '".mysqli_real_escape_string($db, strtoupper($line[2]))."', ".
        "       '".mysqli_real_escape_string($db, intval($line[3]))."', ".
        "       '".mysqli_real_escape_string($db, $line[0])."', ".
        "       '".$bankname."', ".
        "       '".mysqli_real_escape_string($db, $line[5])."', ".
        "       TIMESTAMP('".$sendat."'),".
        "       ".$accountid.", ".
        "       ".mysqli_real_escape_string($db, $line[4]).
        "       )";
        if (!$db->query($sql)){
            $error = $db->error;
            badEnd("500", array("msg"=>$error));
        }
       
        $indexFile++;
    }
    fclose($file);
    
    // Si llegamos aqui y tenemos errores lo lanzamos
    if(count($errors) > 0){
        badEnd("406", array("msg"=>$errors));
    }
    
    // Si llegamos aqui, recorremos todo los registros del usuario en la tabla para enviarlo a la otra
    $sql = "SELECT * FROM payments_loadpagomovil ".
    "       JOIN accounts ON accounts.userid = ".$userid.
    "           AND accounts.id = payments_loadpagomovil.accountid";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
                
    while($row = $res->fetch_assoc()){
        // Creamos el registro
        $sql = "INSERT INTO payments_pagomovil (".
        "       status,".
        "       datecreated,".
        "       recipient,".
        "       recipientrif,".
        "       recipientphone,".
        "       bankcode,".
        "       bankname,".
        "       note,".
        "       sendat,".
        "       sentat, ".
        "       ref, ".
        "       accountid, ".
        "       validationcode, ".
        "       amount, ".
        "       txid ".
        "       )".
        "       VALUES (".
        "       1, ".
        "       NOW(), ".
        "       '".$row['recipient']."', ".
        "       '".$row['recipientrif']."', ".
        "       '".$row['recipientphone']."', ".
        "       '".$row['bankcode']."', ".
        "       '".$row['bankname']."', ".
        "       '".$row['note']."', ".
        "       TIMESTAMP('".$row['sendat']."'),".
        "       NULL, ".
        "       NULL, ".
        "       ".$row['accountid'].", ".
        "       '".$validatorMd5."', ".
        "       ".$row['amount'].", ".
        "       NULL ".
        "       )";
        if (!$db->query($sql)){
            $error = $db->error;
            badEnd("500", array("msg"=>$error));
        }
    }
    
    // Borramos los registros de este usuario en la tabla load
    $sql = "DELETE FROM payments_loadpagomovil ".
    "       WHERE EXISTS(SELECT * FROM accounts WHERE accounts.userid = ".$userid." AND accounts.id = payments_loadpagomovil.accountid)";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $email = $userdata["usr"];
    $subject = "Código para Cripto Pago ".$shortname;
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $styleTag = 
        "<style rel='stylesheet' type='text/css'>".
        "           .emailBox {".
        "               background-color: #F8F8FA;".
        "               padding: 20px;".
        "           }".
        "           .copy {".
        "               font-family: 'Roboto', sans-serif;".
        "               font-weight: 400;".
        "               font-size: 12px;".
        "               margin-top:40px;".
        "               color: #767E93;".
        "               text-align:center;".
        "           }".
        "           .mainBox {".
        "               margin: auto;".
        "               display: block;".
        "               background-color: #FFF;".
        "               border-radius: 22px;".
        "               width: 60%;".
        "               padding:30px;".
        "           }".
        "           .msg { ".
        "               font-size: 18px;".
        "               color: #474C58;".
        "               text-align:center;".
        "               margin-bottom:30px;".
        "               margin-left:20px;".
        "               margin-right:20px;".
        "           }".
        "           .titleEmail {".
        "               color:#474C58;".
        "               text-align:center;".
        "               font-size: 20px;".
        "               font-weight: bold;".
        "               margin-left:20px;".
        "               margin-right:20px;".
        "           }".
        "           .note {".
        "               text-align:center;".
        "               font-size:12px;".
        "               color: #474C58;".
        "           }".
        "           .code {".
        "               margin: auto;".
        "               display: block;".
        "               color: #FFF;".
        "               font-size: 18px;".
        "               text-align:center;".
        "               line-height: 58px;".
        "               font-weight:bold;".
        "               letter-spacing: 10px;".
        "           }".
        "           .validatorBox {".
        "               margin: auto;".
        "               display: block;".
        "               background-color: #4287CE;".
        "               border-radius: 8px;".
        "               width: 200px;".
        "               height: 57px;".
        "               text-align:center;".
        "           }".
        "           @media (max-width: 450px) {".
        "               .mainBox {".
        "                   width: 95% !important;".
        "                   padding: 25px 0px;".
        "               }".
        "               .emailBox {".
        "                   padding: 0px;".
        "               }".
        "               .titleEmail {".
        "                   font-size: 18px;".
        "               }".
        "               .msg, .code {".
        "                   font-size: 14px;".
        "               }".
        "           }".
        "</style>";
        $body = 
            "<div class='emailBox'>".
            "   <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."./settings/img/logo-email.png'/>".
            "   <div class='mainBox'>".
            "       <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer.png'/>".
            "       <h1 class='titleEmail'>Hola ".strtolower($email)."</h1>".
            "       <p class='msg'>".
            "           Para completar el Cripto Pago, ingrese el c&oacute;digo a continuaci&oacute;n".
            "       </p>".
            "       <div class='validatorBox'>".
            "           <p class='code'>".$validator."</p>".
            "       </div>".
            "   </div>".
            "   <p class='copy'>".$footerEmails."</p>".
            "</div>";
            
    $body = templateEmail($body, $styleTag);
            
    enviarCorreo2($fromeMail, strtolower($email), $subject, $body);
        
    $msg = 'Para completar el Cripto Pago, ingrese el código a continuación: '.$validator;
    enviarSMS($userdata['paymobilephone'], $msg); //Cambiado "phone" que no se obtiene del users por paymobilephone
        
    // Audit
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAudit($db, "CRIPTO PAGOS", $sessionid, "APP", "Se registró un pago móvil masivo de ".($indexFile-1)." registros, del usuario ".$userdataaudit['name'], $ipaddress);
    
    $out->records = $indexFile-1;
    $out->test = $amountVal;
    $out->test2 = $balancetx["balance"];
    $out->test3 = $currency['decimals'];
    if(
        number_format($balancetx["balance"], $currency['decimals'], '.', '') <= 0 ||
        number_format($balancetx["balance"], $currency['decimals'], '.', '') < $amountVal
    ){
        header("HTTP/1.1 201");
        echo(json_encode($out));
        die();
    }
        
    header("HTTP/1.1 200");
    echo(json_encode($out));
    die();
    
    
    function errorMessage($msgesp, $msgeng, $qtyErrors){
        
    }
?>