<?php
//  app/api/payments/pagomovil/validatecode.php
    header("Content-Type:application/json");
    include("../../../../settings/dbconn.php");
    include("../../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", "code");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $_POST["sessionid"];
    $code = md5($_POST["code"]);
    
    //Validamos la session
    $userid  = isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Validamos que existe
    $sql = "SELECT COUNT(payments_pagomovil.id) AS qty ".
    "       FROM payments_pagomovil ".
    "       JOIN accounts ON accounts.userid = ".$userid.
    "           AND accounts.id = payments_pagomovil.accountid".
    "       WHERE payments_pagomovil.validationcode = '".$code."'".
    "       AND payments_pagomovil.status = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    if($row['qty'] == 0){
        badEnd("402", array("msg"=>determinateMsgFail(array(
            "esp"=>"Pago no registrado",
            "eng"=>"Payment not registered"), $lang, "Pago no registrado")));
    }
    
    // Si existe, vemos que status posee
    $sql = "SELECT payments_pagomovil.* ".
    "       FROM payments_pagomovil ".
    "       JOIN accounts ON accounts.userid = ".$userid.
    "           AND accounts.id = payments_pagomovil.accountid".
    "       WHERE payments_pagomovil.validationcode = '".$code."'".
    "       AND payments_pagomovil.status = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    // Si es 1 podemos continuar, si no, no se puede validar
    if($row['status'] != 1){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se puede validar",
            "eng"=>"Cannot validate"), $lang, "No se puede validar")));
    }
    
    // Si llegamos hasta aqui, podemos actualizar
    $sql = "UPDATE payments_pagomovil SET ".
    "       validationcode = NULL,".
    "       status = 2 ".
    "       WHERE validationcode = '".$code."'".
    "       AND status = 1".
    "       AND accountid = ".$row['accountid'];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $out->id = (int)$row['id'];
    
    // Obtenemos los datos del BS
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currencyfiat = $rs->fetch_assoc();
    
     // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM users ".
    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    //auditoria
    setAudit($db, "CRIPTO PAGOS", $sessionid, "APP", "Se validó un pago móvil por ".$row['amount']." ".$currencyfiat['symbol'].", del usuario ".$userdataaudit['name']." a la persona ".$row['recipient'], $ipaddress);
        
    header("HTTP/1.1 200");
    echo(json_encode($out));
    die();
    
?>