/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll(); getAge(dateString)
verifyData(files); clearErrors()

***Variables Globales utilizadas ***
upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){    
    

    htmlLang(texts);
    formLang(filesLang);

    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }
    
    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","jurInitImgs");
    });
    // Complete later salir sin guardar
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage("kyc","jurInitPrtnrs",{});
    });
    // Complete later salir sin guardar
    document.getElementById('later-button').addEventListener("click", function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });

    getEntry();

}
//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Load data del usuarios       
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
    var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                

                drawEntry(rsp);//Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales
                
                entry = rsp.entry;                
                getEconomicActs();   
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}
//Pintar select opciones de códigos de país
function drawSelCod(select, read, rsp, selected, first = ""){
    //rsp - (array) Registros
    //select - donde se insertan las opciones
    //first - si no está vacío crea un opcion sin value
    //selected - selecciona una opción especifica
    //read - campo a partir del cual muestra el LBL
    select.innerHTML = "";
    var opt;
    if(first !== ""){
        opt = "";
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for(var i=0; i<rsp.length; i++){
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][read]);
        opt.innerHTML = "+"+rsp[i][read];
        if(selected !== null && selected !== "" && selected !== undefined){
            if(rsp[i].id == selected)
                opt.setAttribute("selected", "");
        }
        select.appendChild(opt);
    }
}
var econmic = false;//Control de carga
function getEconomicActs(){
    var req = {"sessionid": sessionStorage.getItem('sessionid')};
    var response = function(status, rsp){
        switch(status){
            case 200:
                var resp = JSON.parse(rsp);
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.company.economicalactivity.value){
                        sel = entry.company.economicalactivity.value;
                        entry = undefined;
                    }
                }
                var first = sessionStorage.getItem('lang') == 'esp' ? "Selecciona" : 'Select'
                drawSelectN(document.getElementById("economicactivity"),'id','dsc',resp.records,sel,first);
            break;
            case 204:
            break;
            case 400:
                // Parametros incorrectos
            break;
            case 401:
                expiredSession();
            break;
            case 500:
                // Error
            break;
            default:
            break;
        }
    }    
    callWS("GET", "additional/economicacts", req, response);
        
}
//Save update
function updateSave(id,sid){    
    //Nombre de los campos para validación y valores
    var files = ["economicactivity","anualincome","patrimony"];
    //Nombre de los parametros para enviar difieren de los de arriba en algunos casos
    var parmsList = ["economicact","anualincome","patrimony"];
    if(verifyData(files)){  
        //Función llamada exitosa
        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 409:
                    // Ya existe esa cedula
                    break;
                case 401:
                    expiredSession();
                    break;
                case 500:
                    // Error
                    
                    break;
                default:
                
                    break;
            }
        } 
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;
                parms.append(parmsList[i],val);
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        //Paso Seguiente
        parms.append("step",4);
        updateCompany(parms,success);
    }else{
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    }
}

