/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll();
clearErrors(); verifyData(files); 

***Variables Globales utilizadas ***
cntryLoad (boolean); upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){  
    //Select Genero
    var gender = {};
    gender.esp = [{"id":"M","dsc":"Masculino"},
                {"id":"F","dsc":"Femenino"}];
    gender.eng = [{"id":"M","dsc":"Male"},
                {"id":"F","dsc":"Female"}]; 
    var first = sessionStorage.getItem('lang') == 'esp' ? "Selecciona" : 'Select'
    drawSelectN(document.getElementById("gender"),'id','dsc',gender[sessionStorage.getItem('lang')],"",first); 
    //Select marital status
    var maritalstatus = {};
    maritalstatus.esp = [{"id":1,"dsc":"Soltero"},{"id":2,"dsc":"Casado"},
                        {"id":3,"dsc":"Divorciado"},{"id":4,"dsc":"Viudo"}];
    maritalstatus.eng = [{"id":1,"dsc":"Single"},{"id":2,"dsc":"Married"},
                        {"id":3,"dsc":"Divorced"},{"id":4,"dsc":"Widower"}];
    var first = sessionStorage.getItem('lang') == 'esp' ? "Selecciona" : 'Select'
    drawSelectN(document.getElementById("maritalstatus"),'id','dsc',maritalstatus[sessionStorage.getItem('lang')],"",first); 
    
    
    htmlLang(texts);
    formLang(filesLang);
    
    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }

    //Cargar uploads previos necesarios
    getUploads();

    //Ciclo que se repite hasta que se completan todas las cargas dando prioridad a las que son previas al entry    
    wait = setInterval(function(){
        if(upLoad){ //Si los uploads ya fueron cargados se carga el entry y se detiene el ciclo
            clearInterval(wait);
            getEntry();
        }
    },1000);    

    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","natMiddleLvl");
    });
    //Guardar y Salir al dashboard
    document.getElementById("later-button").addEventListener("click",function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });
    // Ir a pagina anterior
    document.getElementById('previous-button').addEventListener("click", function(){ 
        gotoPage('kyc','natInitialLvl',"");
    });

    //Actualizar ciudades al modificar la region (estado)
    document.getElementById("regionid").addEventListener("change",function(){
        getCities(this.value);   
    });

    //Pep evento ocultar campos o mostrar
    document.getElementById("politicallyexposed").addEventListener("click",function(){
        pepFiles(this);
    });  

    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("save-button").addEventListener("click",function(){
        var id,sid;
        if(this.getAttribute("view") == 0){
            id = "dashboard";
            sid = "home";
        }else{
            id = "step";
            sid = "main";
        }
        updateSave(id,sid);
    });
}

//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                drawEntry(rsp); 
                //Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales
                entry = rsp.entry;
                getCountries();     
                getEconomicActs();
                getOcupations();
                //Si el politicaliexposed es true 
                if(entry.person.politicalexposed.value){//El valor ya debería haberse chequeado por el "drawEntry()"
                    pepFiles(document.getElementById("politicallyexposed"));
                }
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}
//Se carga el listado de uploads y se pintan donde corresponda
function getUploads(){    
    //Cargar listado de uploads    
    var parms = {
        "type":1,
        "sessionid": sessionStorage.getItem('sessionid')
    }
    //Funcion si tiene exito el request
    var uplsRsp = function(status, rsp){        
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                uploadsDraw(rsp.records,1); //Nivel básico;
                upLoad = true;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
    uploadsLoad(parms,uplsRsp);
}
//Se carga el listado de paises y se arma el select correspondiente si la respuesta es exitosa
function getCountries(){        
    //Funcion si tiene exito el request  
    var cntryRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                var first = sessionStorage.getItem('lang') == 'esp' ? "País emisor" : 'Issuing country'
                //Pais de residencia
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.person.document.country.id){
                        sel = entry.person.document.country.id;
                    }
                }
                drawSelectN(document.getElementById("doccountryid"),'id','dsc',rsp.records,sel,first);
                //Se cargan las regiones
                getRegions();  
                var first = sessionStorage.getItem('lang') == 'esp' ? "Seleccione" : 'Select'   
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.person.pepcountryid.value){
                        sel = entry.person.pepcountryid.value;
                    }
                }
                //Listado pais pepcountryid
                drawSelectN(document.getElementById("pepcountryid"),'id','dsc',rsp.records,sel,first);
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    countriesLoad(cntryRsp);
}
//Se carga el listado de estados y se arma el select correspondiente si la respuesta es exitosa
function getRegions(val=""){ 
    //Funcion si tiene exito el request  
    var regionRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                var first = sessionStorage.getItem('lang') == 'esp' ? "Estado de residencia" : "State of residence"  
                //Pais de residencia
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.person.region.id){
                        sel = entry.person.region.id;
                    }
                }
                drawSelectN(document.getElementById("regionid"),'id','dsc',rsp.records,sel,first);
                //Una vez que se obtiene respuesta exitosa del estado cargamos la ciudades 
                var regsel = false;
                for(var x=0;x<rsp.records.length;x++){
                    if(rsp.records[x].id==sel){
                        regsel = true;
                    }
                }
                if(!regsel)sel=""; 

                getCities(sel);              
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    if(entry){
        if(entry.person.country.id!=null && entry.person.country.id!="")
            regionsLoad(entry.person.country.id,regionRsp);
        else{        
            if(val!=null && val!="")
                regionsLoad(val,regionRsp);
            else{
                document.getElementById("regionid").value = "";
            }    
        }
    }else{
        if(val!=null && val!="")
            regionsLoad(val,regionRsp);
        else{
            document.getElementById("regionid").value = "";
        } 
    }
}
//Se carga el listado de ciudades y se arma el select correspondiente si la respuesta es exitosa
function getCities(val=""){ 
    //Funcion si tiene exito el request  
    var citiesRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                var first = sessionStorage.getItem('lang') == 'esp' ? "Ciudad de residencia" : "City of residence"  
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.person.city.id){
                        sel = entry.person.city.id;
                    }
                }
                //ciudad de residencia
                drawSelectN(document.getElementById("cityid"),'id','dsc',rsp.records,sel,first);
                //Una vez que se obtiene respuesta exitosa de las ciudades blanqueamos la variable global entry         
                //Ciclo que se repite hasta que se completan todas las cargas dando prioridad a las que son previas al entry    
                wait = setInterval(function(){
                    if(econmic && ocup){ //Si los uploads ya fueron cargados se carga el entry y se detiene el ciclo
                        clearInterval(wait);
                        entry = undefined;  
                    }
                },1000);                         
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
           
            if(val!=null && val!="")
                citiesLoad(val,citiesRsp);
            else
                document.getElementById("cityid").value = "";
        
}
var econmic = false;//Control de carga
function getEconomicActs(){
    var req = {"sessionid": sessionStorage.getItem('sessionid')};
    var response = function(status, rsp){
        switch(status){
            case 200:
                var resp = JSON.parse(rsp);
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.person.economicalactivity.value){
                        sel = entry.person.economicalactivity.value;
                    }
                }
                econmic = true;
                var first = sessionStorage.getItem('lang') == 'esp' ? "Seleccione" : 'Select' 
                drawSelectN(document.getElementById("economicactivity"),'id','dsc',resp.records,sel,first);
            break;
            case 204:
            break;
            case 400:
                // Parametros incorrectos
            break;
            case 401:
                expiredSession();
            break;
            case 500:
                // Error
            break;
            default:
            break;
        }
    }    
    callWS("GET", "additional/economicacts", req, response);
        
}
var ocup = false;//Control de carga
function getOcupations(){
    var req = {"sessionid": sessionStorage.getItem('sessionid')};
    var response = function(status, rsp){
        switch(status){
            case 200:
                var resp = JSON.parse(rsp);
                var sel = "";//Valor seleccionado
                if(entry){
                    if(entry.person.ocupation.value){
                        sel = entry.person.ocupation.value;
                    }
                }
                ocup = true;
                var first = sessionStorage.getItem('lang') == 'esp' ? "Seleccione" : 'Select' 
                drawSelectN(document.getElementById("ocupation"),'id','dsc',resp.records,sel,first);
            break;
            case 204:
            break;
            case 400:
                // Parametros incorrectos
            break;
            case 401:
                expiredSession();
            break;
            case 500:
                // Error
            break;
            default:
            break;
        }
    }    
    callWS("GET", "additional/ocupations", req, response);
        
}

//Save update
function updateSave(id,sid){    
    //Campos a verificar
    var files = ["gender","maritalstatus","regionid","cityid","profession",
    "economicactivity","ocupation","street",
    "postalcode","doccountryid","docissue","docexpiry"];
    //Nombre de los parametros para enviar difieren de los de arriba en algunos casos
    var parmsList = ["gender","maritalstatus","stateid","cityid","profession",
    "economicact","ocupation","street",
    "postalcode","doccountryid","docissue","docexpiry"];

    if(document.getElementById("politicallyexposed").checked){
        files.push("peprelatedid","pepcountryid","positionheld","affiliationbody");
        parmsList.push("peprelatedid","pepcountryid","positionheld","affiliationbody");        
    }
    
    //Se agregan los uploads a validar
    var uplsCnt = document.getElementsByClassName("upldsCnt");
    var recaudos = uplsCnt[0].getElementsByTagName("input");
    var fuploads = [];
    for(var i=0; i<recaudos.length; i++){
        fuploads.push(recaudos[i].getAttribute("id"));
    }  
    var lang = localStorage.getItem("lang");
    if(verifyData(files) && verifyData(fuploads)){    
        //Validaciones adicionales documento de identidad
        var docexpiry = document.getElementById("docexpiry");
        var docissue = document.getElementById("docissue");
        if (new Date(docissue.value).getTime() > new Date(docexpiry.value).getTime()){ 
            var err = docissue.nextElementSibling;
            if(err.classList.contains("errorReg")){
                err.innerHTML = getLangById("err1docdates")[lang];
                err.style.display = "block";
            }
            return;  
        }else if (new Date().getTime() > new Date(docexpiry.value).getTime()){
            var err = docexpiry.nextElementSibling;
            if(err.classList.contains("errorReg")){
                err.innerHTML = getLangById("err2docdates")[lang];
                err.style.display = "block";
            }
            return;
        }



        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                break;
                case 415:
                    errFile(document.getElementById("file"+JSON.parse(rsp).invalid),JSON.parse(rsp).msg);
                    
                break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 409:
                    // Ya existe esa cedula
                    
                    break;
                case 401:
                    expiredSession();
                    break;
                case 500:
                    // Error
                    
                    break;
                default:
                
                    break;
            }
        } 
        //Se agregan los campos que no requieren verificación antes de enviar los parametros
        //Se agregan los pparams para mantener el orden entre parametros y files
        files.push("independentdealer","american","politicallyexposed","company");
        parmsList.push("indepmerch","american","politicalexp","company");
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;
                parms.append(parmsList[i],val);
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        //Uploads
        var uplsCnt = document.getElementsByClassName("upldsCnt");
        var recaudos = uplsCnt[0].getElementsByTagName("input");
        var docids = idsloaded;
        for(var i=0; i<recaudos.length; i++){
            if(recaudos[i].getAttribute("loaded") == 1 && docids.indexOf(recaudos[i].getAttribute("label"))<0){
                docids  += recaudos[i].getAttribute("label")+"-"; 
            }
            if(recaudos[i].value !== ""){    
                parms.append(recaudos[i].getAttribute("label"), recaudos[i].files[0]);
            }
        }
        docids = docids.slice(0,-1); // Controla si estoy editando, guardando o eliminando algun archivo
        parms.append("uploadids",docids);
        
        parms.append("step",2);
        updatePerson(parms,success);
    }else{
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    } 
}
