/*

***Funciones globales utilizadas (main.js)***
gotoPage(id, sid, params); esconderHTML(hide); drawSelectN(select,id, read, rsp, selected, first = "");

***Funciones globales utilizadas (register.js)***
countriesLoad(success); uploadsLoad(parms,success); uploadsDraw(rsp);
userEntry(success); expiredSession(); showInf(id);  closeAll(); getAge(dateString)
verifyData(files); clearErrors()

***Variables Globales utilizadas ***
upLoad (boolean) ; countriesJSON (json); 

*/
var wait = "";
var entry = {};
function start(){       
    //Select Tipo de documentos en doble idioma
    var doctypes = {};
    doctypes.esp = [{"id":1,"dsc":"Cédula"},
                    {"id":2,"dsc":"Pasaporte"}];
    doctypes.eng = [{"id":1,"dsc":"ID"},
                    {"id":2,"dsc":"Passport"}];
    var first = sessionStorage.getItem('lang') == 'esp' ? "Selecciona" : 'Select'
    drawSelectN(document.getElementById("doctype"),'id','dsc',doctypes[sessionStorage.getItem('lang')],"",first);

    //Inicializas el doble idioma
    htmlLang(texts);
    formLang(filesLang);

    //Mostrar HTML cargado
    esconderHTML(false);

    //Asignar evento cerrar popup
    var close = document.getElementsByClassName("clickClose");
    for(var i=0;i<close.length;i++){
        close[i].addEventListener("click",function(){
            closeAll();
        });
    }

    //Se cargan los uploads correspondientes
    getUploads();

    //Ciclo que se repite hasta que se completan todas las cargas dando prioridad a las que son previas al entry
    wait = setInterval(function(){
        if(upLoad){               
            clearInterval(wait);        
            getEntry();
        }
    },1000);

    //Cargar paises de telefono
    drawSelCod(document.getElementById("phoneCode"),'phone_code',countriesJSON,'58',undefined);
    countriesJSON = "";//Vaciar variable luego de cargar
    
    //Asignar evento "mostrar statment"
    document.getElementById("viewStatment").addEventListener("click",function(){
        viewStatment();
    });
    var files = ["fname","flastname","birthdate","phone","countryid",
            "doctype","doc"];
    for(var i=0;i<files.length;i++){
        //Se valida que todos los campos "files" estén llenos
        var file = document.getElementById(files[i]);
        if(file){//Validamos que existe
            file.addEventListener("change",function(){
                var cntStat = document.getElementsByClassName("txtLngCnt")[1];
                cntStat.style.height = "";
                cntStat.classList.remove("txtLngAct");
                document.getElementById("declarationTxt").setAttribute("loaded",false);
                document.getElementById("declaration").checked = false; 
                document.getElementById("declaration").removeAttribute("disabled");
                document.getElementById("declaration").setAttribute("validated",0);
            });
        }
    }

    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("next-button").addEventListener("click",function(){
        updateSave("kyc","natBasicLvl");
    });
    //Actualizar información y avanzar al siguiente nivel
    document.getElementById("save-button").addEventListener("click",function(){
        var id,sid;
        if(this.getAttribute("view") == 0){
            id = "dashboard";
            sid = "home";
        }else{
            id = "step";
            sid = "main";
        }
        updateSave(id,sid);
    });
    //Guardar y Salir al dashboard
    document.getElementById("later-button").addEventListener("click",function(){
        document.getElementsByClassName('completeLater')[0].style.display = 'table';
    });
    // Complete later salir sin guardar
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage("kyc","regC",{});
    });

    formatFields2(["phone"],["tel"]);

}
//Se carga el entry y se pinta la data que corresponde
function getEntry(){
    //Load data del usuarios       
    //Funcion que se ejecuta al obtener respuesta
    var userResp = function(status, rsp){
    var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                drawEntry(rsp);//Se arma la variable global entry con la respuesta y se cargan las llamadas adicionales
                //Nivel criptos
                var lvlcripto = {};
                lvlcripto.esp = [{"id":1,"dsc":"Básico"},
                                {"id":0,"dsc":"Avanzado"}];
                lvlcripto.eng = [{"id":1,"dsc":"Basic"},
                                {"id":0,"dsc":"Advanced"}]; 
                drawSelectN(document.getElementById("lvlcripto"),'id','dsc',lvlcripto[sessionStorage.getItem('lang')],rsp.entry.view,""); 
                entry = rsp.entry;  
                hideNotNew(rsp);  
                getCountries();   
            break;
            case 204:
            break;
            case 400:
            break;
            case 401:
                expiredSession();
            break;
            case 500:
            break;
            default:
            break;
        }
    }           
    userEntry(userResp);
}

//Pintar select opciones de códigos de país
function drawSelCod(select, read, rsp, selected, first = ""){
    //rsp - (array) Registros
    //select - donde se insertan las opciones
    //first - si no está vacío crea un opcion sin value
    //selected - selecciona una opción especifica
    //read - campo a partir del cual muestra el LBL
    select.innerHTML = "";
    var opt;
    if(first !== ""){
        opt = "";
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for(var i=0; i<rsp.length; i++){
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][read]);
        opt.innerHTML = "+"+rsp[i][read];
        if(selected !== null && selected !== "" && selected !== undefined){
            if(rsp[i][read] == selected)
                opt.setAttribute("selected", "");
        }
        select.appendChild(opt);
    }
}
//Se carga el listado de uploads y se pintan donde corresponda
function getUploads(){    
    //Cargar listado de uploads    
    var parms = {
        "type":1,
        "sessionid": sessionStorage.getItem('sessionid')
    }
    //Funcion si tiene exito el request
    var uplsRsp = function(status, rsp){        
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                uploadsDraw(rsp.records,0); //Nivel inicial 1
                upLoad = true;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }  
    uploadsLoad(parms,uplsRsp);
}
//Se carga el listado de paises y se arma el select correspondiente si la respuesta es exitosa
function getCountries(){        
    //Funcion si tiene exito el request  
    var cntryRsp = function(status, rsp){
        var rsp = JSON.parse(rsp);
        switch(status){
            case 200:
                var first = sessionStorage.getItem('lang') == 'esp' ? "País de residencia" : 'Country of residence'
                //Pais de residencia
                drawSelectN(document.getElementById("countryid"),'id','dsc',rsp.records,entry.person.country.id,first);
                
                //Se blanquea la variable global entry
                entry = undefined;
            break;
            case 204:
            break;
            default:
            break;
        }
    } 
    countriesLoad(cntryRsp);
}
//Mostrar declaración
function viewStatment(){
    //Validar que la declaración se armó completa, osea los datos se cargaron antes
    var stat = document.getElementsByClassName("statment")[0];
    var nwHeight = stat.offsetHeight;
    var cntStat = document.getElementsByClassName("txtLngCnt")[1];
    if(cntStat.offsetHeight == 0){
        if(document.getElementById("declarationTxt").getAttribute("loaded") == 'false'){
            if(!drawStatment()){
                var lang = sessionStorage.getItem('lang');
                var errm = getLangById("err1declaration")[lang];
                var file = document.getElementById("declaration");            
                var err = file.parentElement.parentElement.parentElement.parentElement.nextElementSibling;
                if(err){                    
                    if(err.classList.contains("errorReg")){
                        err.innerHTML = errm;
                        err.style.display = "block";
                    }
                }
                setTimeout(function(){
                    clearErrors(); // Se blanquean todos los errores
                },5000);
                return;
            }
        }
        stat = document.getElementsByClassName("statment")[0];
        nwHeight = stat.offsetHeight;
        cntStat.classList.add("txtLngAct");
        cntStat.style.height = nwHeight+"px";
        document.getElementById("viewStatment").innerText = getLangById("hideStatment")[sessionStorage.getItem('lang')];
    }else{
        document.getElementById("viewStatment").innerText = getLangById("viewStatment")[sessionStorage.getItem('lang')];
        cntStat.style.height = "";
        cntStat.classList.remove("txtLngAct");
    }
}
//Save update
function updateSave(id,sid){    
    //Nombre de los campos para validación y valores
    var files = ["fname","flastname","birthdate","phone","countryid",
    "doctype","doc","declaration"];
    //Se agregan los uploads a validar
    var uplsCnt = document.getElementsByClassName("upldsCnt");
    var recaudos = uplsCnt[0].getElementsByTagName("input");
    var filesup = [];
    for(var i=0; i<recaudos.length; i++){
        filesup.push(recaudos[i].getAttribute("id"));
    }  
    //Nombre de los parametros para enviar difieren de los de arriba en algunos casos
    var parmsList = ["fname","flastname","birthdate","phone","countryid",
    "doctype","doc","declaration","venezuelan"];
    if(verifyData(files) && verifyData(filesup)){    
        var success = function(status, rsp){
            switch(status){
                case 200:
                    gotoPage(id,sid,"");                    
                    break;
                case 204:
                    break;
                case 400:
                    // Parametros incorrectos
                    break;
                case 415:
                    
                    errFile(document.getElementById("file"+JSON.parse(rsp).invalid),JSON.parse(rsp).msg);
                break;
                case 409:
                    // Ya existe esa cedula
                    var doc = document.getElementById("doc");
                    if(doc){
                        var lang = sessionStorage.getItem('lang');
                        var err = doc.nextElementSibling;
                        if(err.classList.contains("errorReg")){
                            err.innerHTML = getLangById("erruserexist")[lang];
                            err.style.display = "block";
                        }
                    } 
                    break;
                case 401:
                    expiredSession();
                    break;
                case 500:
                    // Error
                    
                    break;
                default:
                
                    break;
            }
        } 
        files.push("venezuelan");
        var parms = new FormData();
        //Session
        parms.append("sessionid",sessionStorage.getItem('sessionid'));
        //Parametros generales definidos en arreglos
        for(var i=0;i<files.length;i++){
            if(files[i] == "phone"){
                parms.append(parmsList[i],(document.getElementById("phoneCode").value+" "+document.getElementById(files[i]).value));
            }else if(document.getElementById(files[i]).getAttribute("type")=="checkbox"){
                var val = 0;
                if(document.getElementById(files[i]).checked)val = 1;

                if(files[i]=='declaration' && document.getElementById(files[i]).getAttribute("validated")==0){
                    parms.append(parmsList[i],val);
                }else if(files[i]!=='declaration'){
                    parms.append(parmsList[i],val);
                }
            }else{                
                parms.append(parmsList[i],document.getElementById(files[i]).value);
            }
        }
        //Uploads
        var uplsCnt = document.getElementsByClassName("upldsCnt");
        var recaudos = uplsCnt[0].getElementsByTagName("input");
        var docids = idsloaded;
        for(var i=0; i<recaudos.length; i++){
            if(recaudos[i].getAttribute("loaded") == 1 && docids.indexOf(recaudos[i].getAttribute("label"))<0){
                docids  += recaudos[i].getAttribute("label")+"-"; 
            }
            if(recaudos[i].value !== ""){    
                parms.append(recaudos[i].getAttribute("label"), recaudos[i].files[0]);
            }
        }
        docids = docids.slice(0,-1); //Se elimina el ultimo "-" 
        parms.append("uploadids",docids);
        //Parametro para el view
        parms.append("view",document.getElementById("lvlcripto").value);
        //Paso Seguiente
        parms.append("step",1);
        updatePerson(parms,success);
    }else{        
        if(!erroractive){   
            erroractive = true;
            setTimeout(function(){
                clearErrors(); // Se blanquean todos los errores            
                erroractive = false;
            },6000);
        }
    }
}
//Se arma la declaración jurada o del entry o con los valores si se altera alguno
function drawStatment(entry=null){
    var fname = "",flastname = "",doctype = "",docnumber = "", country = "";    

    
    if(entry){
        if(entry.person.firstname.value){        
            fname = entry.person.firstname.value;
        }
        if(entry.person.firstlastname.value){        
            flastname = entry.person.firstlastname.value;
        }        
        if(entry.person.document.type.dsc){
            doctype = entry.person.document.type.dsc;            
        }    
        if(entry.person.document.dsc.value){
            docnumber = entry.person.document.dsc.value;
        }
        if(entry.person.country.dsc){
            country = entry.person.country.dsc;
        }
    }else{
        fname = document.getElementById("fname").value;    
        flastname = document.getElementById("flastname").value;
        doctype = document.getElementById("doctype").options[document.getElementById("doctype").selectedIndex].innerHTML;
        docnumber = document.getElementById("doc").value;
        if(document.getElementById("countryid").value!="")
            country = document.getElementById("countryid").options[document.getElementById("countryid").selectedIndex].innerHTML;
   
    }
    if(fname == "" || fname == null || flastname == "" || flastname == null ||
        doctype == "" || doctype == null || docnumber == "" || docnumber == null
        || country == "" || country == null){
            return false;
    }
    var lang = sessionStorage.getItem('lang');
    if(lang == 'esp'){
        var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
        var html = "";
        html += "Yo "+fname+" "+flastname;
        if(doctype=='Cédula'){
            html += ', titular de la '+ doctype+ " de identidad Nro."+docnumber; 
        }else{
            html += ', titular del '+ doctype+ " Nro."+docnumber; 
        }
        html += ' domiciliado en '+country;
        html += `, declaro bajo fe de juramento que todos los datos y documentos suministrados son ciertos y fehacientes. 
                Igualmente autorizo a la empresa `+companynm+` a efectos de verificar la veracidad de lo aquí declarado, en cumplimiento 
                con la providencia 044-2021 sobre normas relativas a la administración y fiscalización de los riesgos relacionados con
                la Legitimación de Capitales, el Financiamiento del Terrorismo y el Financiamiento de la Proliferación de Armas de
                Destrucción Masiva, aplicables a los Proveedores de Servicios de Activos Virtuales y a las personas y entidades que
                proporcionen productos y servicios a través de actividades que involucren Activos Virtuales, en el sistema integral de
                criptoactivos, emanada por la Superintendencia Nacional de Criptoactivos y Actividades Conexas (SUNACRIP) y
                publicado en la Gaceta Oficial número 42.110, en fecha 21 de abril del año 2021.<br/><br/>
                De esta misma forma declaro bajo fe de juramento, que los capitales, bienes, fondos, haberes, beneficios o
                criptoactivos, que sean depositados en la plataforma, durante todo el período que permanezca vigente la relación
                con la empresa `+companynm+`, son provenientes de actividades legítimas. Por lo tanto, declaro que
                tienen una procedencia lícita, la cual puede ser corroborada por los organismos competentes y no tienen relación
                alguna con dinero, capitales, bienes, fondos, haberes, beneficios o criptoactivos que se consideren producto de
                actividades ilícitas o hechos típicos antijurídicos contemplados en la Ley Orgánica contra la Delincuencia Organizada
                y Financiamiento al Terrorismo publicada en Gaceta Oficial No 39.912 el 30 de abril de 2012, así como en lo
                establecido en la Ley Orgánica de Drogas publicada en Gaceta Oficial No 39.546 el 05 de noviembre de 2010.`;
        html += '<br/><br/>'+ getDateD(entry,meses);
        document.getElementById("declarationTxt").innerHTML = html;   
    
    }else{
    
        var meses = new Array ("January","February","March","April","May","June","July","August","September","October","November","December");
        var html = "";
        html += "I "+fname+" "+flastname;
        html += ', holder of '+ doctype+ " No."+docnumber; 
        html += ' domiciled at '+country;   
        html += `, declare under oath that all the data and documents provided are true and reliable. 
                I also authorize the company `+companynm+` in order to verify the veracity of what is stated here,'
                in compliance with Order 044-2021 on regulations relating to the administration and control of risks related to Money Laundering, 
                the Financing of Terrorism and the Financing of the Proliferation of Weapons of Mass Destruction, applicable to Asset Service Providers 
                Virtual Assets and to people and entities that provide products and services through activities that involve Virtual Assets, in the comprehensive 
                crypto assets system, issued by the National Superintendency of Crypto Assets and Related Activities (SUNACRIP) and published in Official Gazette number 
                42,110, in dated April 21, 2021. <br/><br/>
                In this same way, I declare under oath, that the capital, goods, funds, assets, benefits or crypto assets, 
                that are deposited in the platform, during the entire period that the relationship with the Financial Advisory 
                company remains in force. IO, C.A., are from legitimate activities. Therefore, I declare that they have a legal origin, which can be corroborated 
                by the competent bodies and they have no relationship whatsoever with money, capital, goods, funds, assets, benefits or crypto assets that are 
                considered the product of illegal activities or typical unlawful events. contemplated in the Organic Law against Organized Crime and Terrorism 
                Financing published in Official Gazette No. 39,912 on April 30, 2012, as well as in the provisions of the Organic Law on Drugs published in Official 
                Gazette No. 39,546 on November 5, 2010. `;
        html += '<br/><br/>'+ getDateD(entry,meses);
        document.getElementById("declarationTxt").innerHTML = html;   
    }
    return true;         
}
//Obtener formato de fecha para la declaración jurada
function getDateD(entry,meses){
    var lang = localStorage.getItem("lang");
    var msg = "";
    if(entry){
        var dF = new Date(entry.declaration);
        msg =  'A los '+dF.getDate()+' días del mes de '+meses[dF.getMonth()]+' de '+dF.getFullYear()+'.';
        if(lang=='eng') msg = 'On the '+dF.getDate()+'th day of the month of '+meses[dF.getMonth()]+' '+dF.getFullYear()+'.';        
    }else{
        var f=new Date();
        msg = 'A los '+f.getDate()+' días del mes de '+meses[f.getMonth()]+' de '+f.getFullYear()+'.';
        if(lang=='eng') msg = 'On the '+f.getDate()+'th day of the month of '+meses[f.getMonth()]+' '+f.getFullYear()+'.';
    }
    return msg;
}

