WS_waitscreen = true;

function start() {
    sessionStorage.removeItem('sessionid')

    // Window Load
    document.getElementsByClassName('pageCnt')[0].style.visibility = "visible";
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;

    // Go to Register Page
    document.getElementById('register').addEventListener("click", function () {
        gotoPage('register', 'register-term', '');
    });

    // Hide or show a Password
    document.getElementById('icon-eye').addEventListener("click", function () {
        show('icon-eye');
    });

    // Login
    document.getElementById('login').addEventListener("click", function () {
        login();
    });

    // Recover
    document.getElementById('forgot').addEventListener("click", function () {
        gotoPage('recover', 'forgot', '');
    });



    document.getElementById('lan').addEventListener("change", function () {
        sessionStorage.setItem('lang', document.getElementById('lan').value);
        changeLang()
    })

    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function () {
        if (document.getElementById('user').value !== '') {
            noError('user', 'euser');
        }
        if (document.getElementById('password').value !== '') {
            noError('password', 'epassword');
        }
        if (document.getElementById('lan').value !== '') {
            noError('lan', 'elan');
        }
    });

    document.getElementById('user').addEventListener('keydown', (event) => focusE(event, 'password'));

    document.getElementById('password').addEventListener('keydown', (event) => focusE(event, 'login'));

    document.getElementById('lan').addEventListener("click", function () {
        if (document.getElementById('lan').value != '') {
            document.getElementById('lan').style.color = "#262624 !important;"
        }
    });

    if (sessionStorage.getItem('lang')) {
        document.getElementById('lan').value = sessionStorage.getItem('lang')
    } else {
        sessionStorage.setItem('lang', document.getElementById('lan').value);
    }

    setLang();
}

// Show or hide password with eye icon
function show(a) {
    var icon = document.getElementById(a);
    var passwordInput = document.getElementById('password');
    if (passwordInput.getAttribute('type') == "password") {
        icon.removeAttribute("class");
        icon.setAttribute("class", "fas fa-eye");
        passwordInput.removeAttribute("type");
        passwordInput.setAttribute("type", "text");
    } else {
        passwordInput.removeAttribute("type");
        passwordInput.setAttribute('type', 'password');
        icon.removeAttribute("class");
        icon.setAttribute("class", "fas fa-eye-slash");
    }
}

// Service login/login
function login() {
    var user = document.getElementById('user');
    var pwd = document.getElementById('password');
    var lan = document.getElementById('lan');
    if (user.value === "" || pwd.value === "" || lan.value === "") {
        if (user.value === "") {
            error('user', 'euser', getLangById('loginlogin0')[lang]);
        }
        if (pwd.value === "") {
            error('password', 'epassword', getLangById('loginlogin1')[lang]);
        }
        if (lan.value === "") {
            error('lan', 'elan', getLangById('loginlogin2')[lang]);
        }
        return;
    } else {
        var req = {
            "usr": MD5((user.value).toLowerCase()),
            "pwd": MD5(pwd.value),
            "lang": lan.value
        }
        callWS("POST", "login/login", req, response);

        function response(status, rsp) {
            switch (status) {
                case 200:
                    sessionStorage.setItem('sessionid', JSON.parse(rsp).sessionid);
                    sessionStorage.setItem('headname', JSON.parse(rsp).name);
                    var resp = JSON.parse(rsp);

                    if (resp.login2fa == 1) {
                        document.getElementById('loginOne').classList.add("noShow");
                        document.getElementById('login2fa').classList.remove("noShow");
                        document.getElementById('login2faButton').addEventListener("click", function () {
                            if (document.getElementById('code2fa').value == "" || document.getElementById('code2fa').value == null) {
                                document.getElementById("code2fa").focus();
                                document.getElementById("code2fa").style.borderColor = "red";
                                document.getElementById('ecode').classList.remove("vHidden")
                                document.getElementById('ecode').innerHTML = getLangById('2faEmptyCod')[lang];
                                setTimeout(function () {
                                    document.getElementById('ecode').classList.add("vHidden")
                                }, 6000);
                            } else {
                                login2faFunc(document.getElementById('code2fa').value, resp);
                            }
                        });
                        document.getElementById('cancel2fa').addEventListener("click", function () {
                            document.getElementById('loginOne').classList.remove("noShow");
                            document.getElementById('login2fa').classList.add("noShow");
                            myLogout();
                        });
                    } else {
                        switch (resp.type) {
                            case 0:
                                gotoPage('kyc', 'regC', "");
                                break;
                            case 1:
                            case 2:
                                getEntry(resp.sessionid);
                                break;
                        }
                    }
                    break;
                case 400:
                    break;
                case 401:
                    error('password', 'epassword', getLangById('loginlogin401')[lang]);
                    break;
                case 402:
                    document.getElementById('epassword').innerHTML = getLangById('loginlogin402')[lang]
                    break;
                case 403:
                    document.getElementById('epassword').innerHTML = getLangById('loginlogin403')[lang]
                    break;
                case 404:
                    document.getElementById('epassword').innerHTML = getLangById('loginlogin404')[lang]
                    break;
                case 405:
                    document.getElementById('epassword').innerHTML = getLangById('loginlogin405')[lang]
                    break;
                case 500:
                    document.getElementById('epassword').innerHTML = getLangById('loginlogin500')[lang]
                    break;
                default:
                    document.getElementById('epassword').innerHTML = getLangById('loginloginDefault')[lang]
                    break;
            }
        }
    }
}

function getEntry(sessionid) {

    callWS("GET", "users/entry", { 'sessionid': sessionid }, response);
    function response(status, rsp) {

        switch (status) {
            case 200:
                gotoStep(JSON.parse(rsp));
                break;
            case 304:
                gotoPage('kyc', 'regC', "");
                break;
            default:
                break;
        }
    }
}
function gotoStep(rsp) {
    /*
            //Valido que tegna un tipo seleccionado
            if(rsp.entry.type.id !== 0 ){
                //Redirecciono a paginas de persona natural dependiendo del paso
                if(rsp.entry.type.id == 1){
                    switch(rsp.entry.person.step){
                        case 0:
                        case 1:
                            gotoPage('kyc','natInitialLvl',"");
                        break;
                        default:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',"");
                            }else{
                                gotoPage('step','main',"");
                            }
                        break;
                    }
                }else{
                    switch(rsp.entry.company.step){
                        case 0:
                        case 1:
                            gotoPage('kyc','jurInitBasic',"");
                        break;
                        default:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',"");
                            }else{
                                gotoPage('step','main',"");
                            }
                        break;
                }
            }
            }else{
                gotoPage('kyc','regC',"");
            }*/
    //Valido que tegna un tipo seleccionado
    if (rsp.entry.type.id !== 0) {
        //Redirecciono a paginas de persona natural dependiendo del paso
        if (rsp.entry.type.id == 1) {
            switch (rsp.entry.person.step) {
                case 0:
                case 1:
                    gotoPage('kyc', 'natInitialLvl', "");
                    break;
                case 2:
                    gotoPage('kyc', 'natBasicLvl', "");
                    break;
                case 3:
                    gotoPage('kyc', 'natMiddleLvl', "");
                    break;
                case 4:
                    gotoPage('kyc', 'natAdvancedLvl', "");
                    break;
                case 5:
                    if (rsp.entry.view == 0) {
                        gotoPage('dashboard', 'home', "");
                    } else {
                        gotoPage('step', 'main', "");
                    }
                    break;
            }
        } else {
            switch (rsp.entry.company.step) {
                case 0:
                case 1:
                    gotoPage('kyc', 'jurInitBasic', "");
                    break;
                case 2:
                    gotoPage('kyc', 'jurInitReg', "");
                    break;
                case 3:
                    gotoPage('kyc', 'jurInitPrtnrs', "");
                    break;
                case 4:
                    gotoPage('kyc', 'jurInitEconom', "");
                    break;
                case 5:
                    gotoPage('kyc', 'jurInitBasic', "");
                    break;
                case 6:
                    gotoPage('kyc', 'jurInitImgs', "");
                    break;
                case 7:
                    gotoPage('kyc', 'jurMiddleLvl', "");
                    break;
                case 7:
                    gotoPage('kyc', 'jurAdvancedLvl', "");
                    break;
                case 8:
                    if (rsp.entry.view == 0) {
                        gotoPage('dashboard', 'home', "");
                    } else {
                        gotoPage('step', 'main', "");
                    }
                    break;
            }
        }
    } else {
        document.getElementById("cellTypeUsr").style.visibility = "";
        esconderHTML(false);
    }

}
function setLang() {

    addFooter()

    lang = sessionStorage.getItem('lang');

    /* inner HTML */
    setWordLanginnerHTML('access', 'access');
    setWordLanginnerHTML('lang', 'lang');
    setWordLanginnerHTML('esp', 'spanish');
    setWordLanginnerHTML('eng', 'english');
    setWordLanginnerHTML('userLabel', 'user');
    setWordLanginnerHTML('passLabel', 'password');
    setWordLanginnerHTML('forgot', 'forgot');
    setWordLanginnerHTML('login', 'login');
    setWordLanginnerHTML('register', 'sigin');
    setWordLanginnerHTML('ts', 'ts');

    /*2fa incluido*/
    setWordLanginnerHTML('access2fa', 'access2fa');
    setWordLanginnerHTML('lblmsg2fa', 'lblmsg2fa');
    setWordLanginnerHTML('login2faButton', 'login2faButton');
    setWordLanginnerHTML('cancel2fa', 'cancel2fa');

    /* placeholder */
    setWordLangPlaceHolder('user', 'userph');
    setWordLangPlaceHolder('password', 'passwordph');

    //Mostrar HTML cargado
    esconderHTML(false);
}

function changeLang() {

    lang = sessionStorage.getItem('lang');

    /* inner HTML */
    setWordLanginnerHTML('access', 'access');
    setWordLanginnerHTML('lang', 'lang');
    setWordLanginnerHTML('esp', 'spanish');
    setWordLanginnerHTML('eng', 'english');
    setWordLanginnerHTML('userLabel', 'user');
    setWordLanginnerHTML('passLabel', 'password');
    setWordLanginnerHTML('forgot', 'forgot');
    setWordLanginnerHTML('login', 'login');
    setWordLanginnerHTML('register', 'sigin');
    setWordLanginnerHTML('ts', 'ts');

    /*2fa incluido*/
    setWordLanginnerHTML('access2fa', 'access2fa');
    setWordLanginnerHTML('lblmsg2fa', 'lblmsg2fa');
    setWordLanginnerHTML('login2faButton', 'login2faButton');
    setWordLanginnerHTML('cancel2fa', 'cancel2fa');

    /* placeholder */
    setWordLangPlaceHolder('user', 'userph');
    setWordLangPlaceHolder('password', 'passwordph');
}

function login2faFunc(code, resp) {
    var sessionid = sessionStorage.getItem('sessionid')
    var req = {
        'sessionid': sessionid,
        'otp': code
    }

    callWS('GET', 'login2fa/accept', req, response);

    function response(status, rsp) {
        switch (status) {
            case 200:
                switch (resp.type) {
                    case 0:
                        gotoPage('kyc', 'regC', "");
                        break;
                    case 1:
                    case 2:
                        getEntry(resp.sessionid);
                        break;
                }
                break;
            case 400:
                break;
            case 401:
                document.getElementById("code2fa").focus();
                document.getElementById("code2fa").style.borderColor = "red";
                document.getElementById('ecode').classList.remove("vHidden")
                document.getElementById('ecode').innerHTML = JSON.parse(rsp).msg
                setTimeout(function () {
                    document.getElementById('ecode').classList.add("vHidden")
                }, 6000);
                break;
            case 500:
                break;
            default:
                break;
        }
    }
}
