var globalurl = ".";
//view - Determina si la pantalla principal es modo basico o avanzado
var view = "";
var lang = 'eng';
//Controla si el wait ('esperar pantalla de carga') está visible o no
var WS_waitscreen = false;
//PARA LLAMAR A TODOS LOS SERVICIOS
var opnWS = [];
//Mostrar waitscrean / control de multiples
function waitOn(id) {
    var waitExist = document.getElementById("waitScreen");
    var wait = document.createElement("div");
    wait.classList.add("waitScreen");
    wait.setAttribute("id", "waitScreen");
    var spin = document.createElement("div");
    spin.classList.add("spinChar");
    spin.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i>';
    if (WS_waitscreen == false && opnWS.length == 0 && waitExist == null) {
        WS_waitscreen = true;
        wait.appendChild(spin);
        document.getElementsByTagName("body")[0].appendChild(wait);
        setTimeout(function () {
            document.getElementById("waitScreen").style.opacity = "1";
        }, 100);
    }
    opnWS.push(id);
}
//Mostrar waitscrean / control de multiples
function waitOff(id) {
    Array.prototype.removeItem = function (a) {
        for (var i = 0; i < this.length; i++) {
            if (this[i] == a) {
                for (var i2 = i; i2 < this.length - 1; i2++) {
                    this[i2] = this[i2 + 1];
                }
                this.length = this.length - 1;
                return;
            }
        }
    };
    opnWS.removeItem(id);
    //var waitScreen = document.getElementsByClassName("waitScreen")[0];
    setTimeout(function () {
        if (WS_waitscreen && opnWS.length == 0) {
            WS_waitscreen = false;
            var waitScreen = document.getElementById("waitScreen");
            waitScreen.style.opacity = "";
            setTimeout(function () {
                document.getElementsByTagName("body")[0].removeChild(waitScreen);
            }, 450);
        }
    }, 500);
}
//Request ajax al servidor de datos api
function callWS(type, service, params, response) {
    var url = globalurl + "/api/" + service + ".php";
    var waitid = 'w' + document.getElementsByClassName("waitScreen").length;
    waitOn(waitid);
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4) {
            var rsp = "";
            if (this.responseText !== "") {
                rsp = JSON.parse(this.responseText);
                response(this.status, this.responseText);
            } else {
                response(this.status, this.responseText);
            }
            waitOff(waitid);
        }
    }
    switch (type) {
        case "GET":
            var parsedPars = Object.keys(params).map(function (k) {
                return encodeURIComponent(k) + '=' + encodeURIComponent(params[k]);
            }).join('&');
            var random = Math.random();
            xhttp.open(type.toUpperCase(), url + "?v=" + random + "&" + parsedPars, true);
            xhttp.send();
            break;
        case "POST":
            xhttp.open("POST", url, true);
            var formdata = new FormData();
            for (var key in params) {
                formdata.append(key, params[key]);
            }
            xhttp.send(formdata);
            break;
        case "POSTUP":
            xhttp.open("POST", url, true);
            xhttp.send(params);
            break;
    }
}
//Va a una pagina
function gotoPage(id, sid, params) {
    esconderHTML(true);
    var url = globalurl + "/";
    var parsedPars = Object.keys(params).map(function (k) {
        return encodeURIComponent(k) + '=' + encodeURIComponent(params[k]);
    }).join('&');
    if (parsedPars.length)
        parsedPars = "&" + parsedPars;

    location.href = url + "?id=" + id + "&sid=" + sid + parsedPars;
}
//Va a una pagina en una ventana nueva
function gotoNewPage(id, sid) {
    var url = globalurl + "/";
    window.open(url + "?id=" + id + "&sid=" + sid, '_blank');
}
//Oculta o muestra el body para esparar la carga de datos antes de mostrarlo
function esconderHTML(hide) {
    var html = document.getElementsByTagName("body")[0];
    if (html !== null) {
        if (!hide) {
            html.style.display = "block";
            setTimeout(function () {
                html.style.opacity = "1";
            }, 500);
        } else {
            html.removeAttribute("style");
        }
    }
}
//Obtener el valor de un parametro en la url
function getParameterByName(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
        results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}

//Javier - Armar un select html con datos 
function drawSelectN(select, id, read, rsp, selected, first = "") {
    //rsp - (array) Registros
    //select - donde se insertan las opciones
    //first - si no está vacío crea un opcion sin value
    //selected - selecciona una opción especifica
    //read - campo a partir del cual muestra el LBL
    select.innerHTML = "";
    var opt;
    if (first !== "") {
        opt = "";
        opt = document.createElement("option");
        opt.setAttribute("value", "");
        opt.innerHTML = first;
        select.appendChild(opt);
    }
    for (var i = 0; i < rsp.length; i++) {
        opt = document.createElement("option");
        opt.setAttribute("value", rsp[i][id]);
        if (read.split("+").length > 1) {
            var readarr = read.split("+");
            var lbl = "";
            for (var x = 0; x < readarr.length; x++) {
                if (readarr[x].split(".").length > 1) {
                    var a = readarr[x].split(".")[0];
                    var ab = readarr[x].split(".")[1];
                    lbl = lbl + rsp[i][a][ab];
                } else {
                    if (rsp[i][readarr[x]] != undefined)
                        lbl = lbl + rsp[i][readarr[x]];
                    else
                        lbl = lbl + readarr[x];
                }
            }
            opt.innerHTML = lbl;
        } else {
            opt.innerHTML = rsp[i][read];
        }

        if (selected !== null && selected !== "" && selected !== undefined) {
            if (rsp[i].id == selected)
                opt.setAttribute("selected", "");
        }
        select.appendChild(opt);
    }
}
// Magui - No more error
function noError(inputId, messageId) {
    document.getElementById(inputId).style.border = "1px solid #D5DCE5";
    document.getElementById(messageId).innerHTML = "";
}
// Error
function error(inputId, messageId, message) {
    document.getElementById(inputId).style.border = "2px solid #D0021B";
    if (messageId != "") document.getElementById(messageId).innerHTML = message;
}
// Focus in inputs and submit
function focusE(event, idnext) {
    if (event.keyCode == 13) {
        document.getElementById(idnext).focus();
    }
}
// Ej formatFields({"campo1", "campo2"}, {"rif","phone"})
function formatPhone(valor) {
    var cleaned = ('' + valor).replace(/\D/g, '');
    if (cleaned.length) {
        var prefijo, area, numero;
        if (cleaned[0] == "0") {
            //prefijo = "1";
            area = cleaned.substr(1, 3);
            numero = cleaned.substr(4);
        } else {
            //prefijo = cleaned.substr(0,2);
            area = cleaned.substr(0, 3);
            numero = cleaned.substr(3);
        }
        if (numero.length) return (area + "" + numero);
        else return (area);
    } else {
        return ("");
    }
}
//Por ahora solo se usa el amount
function formatFields2(campos, formato) {
    var e;
    for (var i = 0; i < campos.length; i++) {
        e = document.getElementById(campos[i]);
        if (e !== null) {
            switch (formato[i]) {
                case "text":
                    setTextFormat(document.getElementById(campos[i]));
                    break;
                case "rif":
                    // definir formato de entrada
                    document.getElementById(campos[i]).addEventListener("keyup", function (e) {
                        var cursorStart = e.target.selectionStart,
                            cursorEnd = e.target.selectionEnd;
                        this.value = formatRIF(this.value);
                        e.target.setSelectionRange(cursorStart, cursorEnd);
                    });
                    // definir validacion
                    document.getElementById(campos[i]).addEventListener("change", function () {
                        if (isRIF(this.value) || !this.value.length) {
                            showError(this, "", this.id);
                        } else {
                            //showError(this, "Formato de RIF/Cedula Invalido");
                            showError(this, "Formato de RIF/Cédula Inválido", this.id);
                            //alert("Formato de RIF/Cédula Inválido");
                        }
                    });
                    break;
                case "email":
                    document.getElementById(campos[i]).addEventListener("keyup", function (e) {
                        var cursorStart = e.target.selectionStart,
                            cursorEnd = e.target.selectionEnd;
                        this.value = formatEmail(this.value);
                        e.target.setSelectionRange(cursorStart, cursorEnd);
                    });
                    document.getElementById(campos[i]).addEventListener("change", function () {
                        if (isEmail(this.value) || !this.value.length) {
                            showError(this, "", this.id);
                        } else {
                            showError(this, "Formato de Correo Inválido", this.id);
                            //alert("Formato de Correo Inválido");
                        }
                    });
                    break;
                case "phone":
                    // console.log("hello");
                    document.getElementById(campos[i]).addEventListener("keyup", function (e) {
                        //var cursorStart = e.target.selectionStart,
                        //    cursorEnd = e.target.selectionEnd;
                        var codigo = e.which || e.keyCode;
                        if (codigo !== 8) {
                            this.value = formatPhone(this.value);
                        }
                        //e.target.setSelectionRange(cursorEnd, cursorEnd);
                    });
                    document.getElementById(campos[i]).addEventListener("change", function () {
                        if (isPhone(this.value) || !this.value.length) {
                            showError(this, "", this.id);
                        } else {
                            showError(this, "Teléfono Inválido", this.id);
                            // alert("Teléfono Inválido");
                        }
                    });
                    break;
                case "tel":
                    document.getElementById(campos[i]).addEventListener("keyup", function (e) {
                        this.value = formatPhone(this.value);
                    });
                    break;
                case "amount":
                    document.getElementById(campos[i]).addEventListener("keyup", function (e) {
                        //var cursorStart = e.target.selectionStart,
                        //    cursorEnd = e.target.selectionEnd;
                        var currency = this.getAttribute("data-currency");
                        //if(currency == "" || currency == undefined)currency = "VBS";
                        this.value = puntito(this, this.value.charAt(this.value.length - 1));
                        var cnt;
                        if (this.getAttribute("data-cnt") === null)
                            cnt = 1;
                        else
                            cnt = parseInt(this.getAttribute("data-cnt"));

                        if (cnt === 0) {
                            this.value = puntito(this, this.value.charAt(this.value.length - 1));
                        } else {
                            this.setAttribute("data-amount", (parseFloat(this.value.replace(/\D/g, '')) / 100) / cnt);
                        }
                    });
                    break;
            }
        } else {
            //console.log("Validando el campo '"+campos[i]+"' como '" + formato + "' que no existe");
        }
    }
}
//Formateo de amount real;
function puntito(donde, caracter, campo) {
    var decimales = false
    dec = 2;
    if (dec != 0) { decimales = true }

    pat = /[\*,\+,\(,\),\?,\\,\$,\[,\],\^]/
    valor = donde.value
    largo = valor.length
    crtr = true

    if (isNaN(caracter) || pat.test(caracter) == true) {
        if (pat.test(caracter) == true) { caracter = "\\" + caracter }
        carcter = new RegExp(caracter, "g")
        valor = valor.replace(carcter, "")
        donde.value = valor
        crtr = false
    } else {
        var nums = new Array()
        cont = 0
        for (m = 0; m < largo; m++) {
            if (valor.charAt(m) == "." || valor.charAt(m) == " " || valor.charAt(m) == ",") {
                continue;
            } else {
                nums[cont] = valor.charAt(m)
                cont++
            }
        }
    }
    if (decimales == true) {
        ctdd = eval(1 + dec);
        nmrs = 1
    } else {
        ctdd = 1; nmrs = 3
    }
    var cad1 = "", cad2 = "", cad3 = "", tres = 0;
    if (nums.length > nmrs && crtr == true) {
        for (k = nums.length - ctdd; k >= 0; k--) {
            cad1 = nums[k]
            cad2 = cad1 + cad2
            tres++
            if ((tres % 3) == 0) {
                if (k != 0) {
                    cad2 = "." + cad2
                }
            }
        }
        for (dd = dec; dd > 0; dd--) {
            cad3 += nums[nums.length - dd]
        }
        if (decimales == true) { cad2 += "," + cad3 }
    } else {
        if (nums.length > 0) cad2 = nums[0];
    }
    return (cad2);

    donde.focus();
}
function moveCursorToEnd(el) {
    //console.log(typeof el.selectionStart)
    //el.focus();
    var data = el.getAttribute('datanumber');
    el.value = '';
    //console.log(el.value)
    if (!isNaN(data) && data !== "")
        el.value = data;
    //console.log(el.value)
}
/*AJUSTE PARA CAER SIEMPRE CON CURSOR A LA DERECHA AGREGADO-PROBAR*/
function formatAmount(fields) {
    for (var i = 0; i < fields.length; i++) {
        var ele = document.getElementById(fields[i]);
        ele.addEventListener("keyup", function (e) {
            if (e.keyCode !== 190 && e.keyCode !== 188 && e.keyCode !== 110 && e.keyCode !== 229 && e.keyCode !== 8) {
                if (this.value.indexOf('e-') == -1) this.value = this.value.replace(new RegExp('-', 'g'), '');
            }
        });
        ele.addEventListener("focusin", function () {
            var val = this.getAttribute("dataNumber");
            if (!isNaN(val) && val !== "") {
                this.value = parseFloat(val).noExponents();
            }
            this.setAttribute("type", "number");
            eletmp = this;
            setTimeout(function () {
                eletmp.dispatchEvent(new Event("click"));
            }, 100);
        });
        ele.addEventListener("focusout", function () {
            this.setAttribute("dataNumber", parseFloat(this.value).noExponents());
            this.value = "";
            this.setAttribute("type", "text");
            if (typeof (window['decimCoin']) == "undefined") decimCoin = this.getAttribute("decimCoin");
            this.value = number_format(this.getAttribute("dataNumber"), decimCoin);
        });
        ele.addEventListener("click", function () {
            moveCursorToEnd(this);
        });
    }

}
/* Magui */
/* Funcion que se aplica a tipos numericos para eliminar los exponentes */
Number.prototype.noExponents = function () {
    var data = String(this).split(/[eE]/);
    if (data.length == 1) return data[0];

    var z = '', sign = this < 0 ? '-' : '',
        str = data[0].replace('.', ''),
        mag = Number(data[1]) + 1;

    if (mag < 0) {
        z = sign + '0.';
        while (mag++) z += '0';
        return z + str.replace(/^\-/, '');
    }
    mag -= str.length;
    while (mag--) z += '0';
    return str + z;
}

function formatCurrency(fractionDigits, number) {
    var ln = window.navigator.language;
    var decim = "";
    maxDig = false;
    var num = "";
    //
    if (number.split(".").length > 1) {
        num = number.split(".")[0];
        decim = number.split(".")[1];
        if (decim.length >= fractionDigits) {
            decim = decim.substr(0, fractionDigits);
            maxDig = true;
        }
    } else if (number.split(".").length > 0) {
        num = number.split(".")[0];
    } else if (number.split(",").length > 1) {
        num = number.split(",")[0];
        decim = number.split(",")[1];
        if (decim.length >= fractionDigits) {
            decim = decim.substr(0, fractionDigits);
            maxDig = true;
        }
    } else if (number.split(",").length > 1) {
        num = number.split(",")[0];
    }
    var formatted = "";
    if (decim !== "") formatted = num + "." + decim;
    else formatted = num;
    if (maxDig == true && (number.split(".").length == 2 || number.split(",").length == 2)) return formatted;
    else return "";
}
/**Copio la función 2 para evitar daños en otros lugares donde se use*/
function formatCurrency2(fractionDigits, number) {
    var ln = window.navigator.language;
    var decim = "";
    maxDig = false;
    var num = "";
    //
    if (number.split(".").length > 1) {
        num = number.split(".")[0];
        decim = number.split(".")[1];
        if (decim.length >= fractionDigits) {
            decim = decim.substr(0, fractionDigits);
            maxDig = true;
        }
    } else if (number.split(".").length > 0) {
        num = number.split(".")[0];
    } else if (number.split(",").length > 1) {
        num = number.split(",")[0];
        decim = number.split(",")[1];
        if (decim.length >= fractionDigits) {
            decim = decim.substr(0, fractionDigits);
            maxDig = true;
        }
    } else if (number.split(",").length > 1) {
        num = number.split(",")[0];
    }
    var formatted = "";
    if (decim !== "") formatted = num + "." + decim;
    else formatted = num;

    if (maxDig == true && (number.split(".").length == 2 || number.split(",").length == 2)) return formatted;
    else return formatted;

    /*
    if(ln == 'en'){
        var formatted = new Intl.NumberFormat('en-US',{
            maximumFractionDigits: fractionDigits,
        }).format(number);
        return formatted.replace(new RegExp(',', 'g'),'');
    }else if(ln == 'es-ES' || ln == 'es'){
        //
       var formatted = new Intl.NumberFormat('en-US',{
            maximumFractionDigits: fractionDigits,
        }).format(number);
        return  formatted.replace(new RegExp(',', 'g'),'');
    }
    */
}

function formatVisual(number) {
    var formatted = new Intl.NumberFormat('es-ES', { maximumFractionDigits: decimCoin, minimunFractionDigits: decimCoin }).format(number);
    return formatted;
}
function number_format(amount, decimals) {

    amount += ''; // por si pasan un numero en vez de un string
    amount = parseFloat(amount.replace(/[^0-9\.]/g, '')); // elimino cualquier cosa que no sea numero o punto

    decimals = decimals || 0; // por si la variable no fue fue pasada

    // si no es un numero o es igual a cero retorno el mismo cero
    if (isNaN(amount) || amount === 0)
        return parseFloat(0).toFixed(decimals);

    // si es mayor o menor que cero retorno el valor formateado como numero
    amount = '' + amount.toFixed(decimals);

    var amount_parts = amount.split('.'),
        regexp = /(\d+)(\d{3})/;

    while (regexp.test(amount_parts[0]))
        amount_parts[0] = amount_parts[0].replace(regexp, '$1' + '.' + '$2');

    return amount_parts.join(',');
}

//funcion md5 formateo
function MD5(string) {
    function RotateLeft(lValue, iShiftBits) {
        return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
    }

    function AddUnsigned(lX, lY) {
        var lX4, lY4, lX8, lY8, lResult;
        lX8 = (lX & 0x80000000);
        lY8 = (lY & 0x80000000);
        lX4 = (lX & 0x40000000);
        lY4 = (lY & 0x40000000);
        lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
        if (lX4 & lY4) {
            return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
        }
        if (lX4 | lY4) {
            if (lResult & 0x40000000) {
                return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
            } else {
                return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
            }
        } else {
            return (lResult ^ lX8 ^ lY8);
        }
    }

    function F(x, y, z) { return (x & y) | ((~x) & z); }
    function G(x, y, z) { return (x & z) | (y & (~z)); }
    function H(x, y, z) { return (x ^ y ^ z); }
    function I(x, y, z) { return (y ^ (x | (~z))); }

    function FF(a, b, c, d, x, s, ac) {
        a = AddUnsigned(a, AddUnsigned(AddUnsigned(F(b, c, d), x), ac));
        return AddUnsigned(RotateLeft(a, s), b);
    };

    function GG(a, b, c, d, x, s, ac) {
        a = AddUnsigned(a, AddUnsigned(AddUnsigned(G(b, c, d), x), ac));
        return AddUnsigned(RotateLeft(a, s), b);
    };

    function HH(a, b, c, d, x, s, ac) {
        a = AddUnsigned(a, AddUnsigned(AddUnsigned(H(b, c, d), x), ac));
        return AddUnsigned(RotateLeft(a, s), b);
    };

    function II(a, b, c, d, x, s, ac) {
        a = AddUnsigned(a, AddUnsigned(AddUnsigned(I(b, c, d), x), ac));
        return AddUnsigned(RotateLeft(a, s), b);
    };

    function ConvertToWordArray(string) {
        var lWordCount;
        var lMessageLength = string.length;
        var lNumberOfWords_temp1 = lMessageLength + 8;
        var lNumberOfWords_temp2 = (lNumberOfWords_temp1 - (lNumberOfWords_temp1 % 64)) / 64;
        var lNumberOfWords = (lNumberOfWords_temp2 + 1) * 16;
        var lWordArray = Array(lNumberOfWords - 1);
        var lBytePosition = 0;
        var lByteCount = 0;
        while (lByteCount < lMessageLength) {
            lWordCount = (lByteCount - (lByteCount % 4)) / 4;
            lBytePosition = (lByteCount % 4) * 8;
            lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition));
            lByteCount++;
        }
        lWordCount = (lByteCount - (lByteCount % 4)) / 4;
        lBytePosition = (lByteCount % 4) * 8;
        lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
        lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
        lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
        return lWordArray;
    };

    function WordToHex(lValue) {
        var WordToHexValue = "", WordToHexValue_temp = "", lByte, lCount;
        for (lCount = 0; lCount <= 3; lCount++) {
            lByte = (lValue >>> (lCount * 8)) & 255;
            WordToHexValue_temp = "0" + lByte.toString(16);
            WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length - 2, 2);
        }
        return WordToHexValue;
    };

    function Utf8Encode(string) {
        string = string.replace(/\r\n/g, "\n");

        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    };

    var x = Array();
    var k, AA, BB, CC, DD, a, b, c, d;
    var S11 = 7, S12 = 12, S13 = 17, S14 = 22;
    var S21 = 5, S22 = 9, S23 = 14, S24 = 20;
    var S31 = 4, S32 = 11, S33 = 16, S34 = 23;
    var S41 = 6, S42 = 10, S43 = 15, S44 = 21;

    string = Utf8Encode(string);
    x = ConvertToWordArray(string);
    a = 0x67452301; b = 0xEFCDAB89; c = 0x98BADCFE; d = 0x10325476;
    for (k = 0; k < x.length; k += 16) {
        AA = a; BB = b; CC = c; DD = d;
        a = FF(a, b, c, d, x[k + 0], S11, 0xD76AA478);
        d = FF(d, a, b, c, x[k + 1], S12, 0xE8C7B756);
        c = FF(c, d, a, b, x[k + 2], S13, 0x242070DB);
        b = FF(b, c, d, a, x[k + 3], S14, 0xC1BDCEEE);
        a = FF(a, b, c, d, x[k + 4], S11, 0xF57C0FAF);
        d = FF(d, a, b, c, x[k + 5], S12, 0x4787C62A);
        c = FF(c, d, a, b, x[k + 6], S13, 0xA8304613);
        b = FF(b, c, d, a, x[k + 7], S14, 0xFD469501);
        a = FF(a, b, c, d, x[k + 8], S11, 0x698098D8);
        d = FF(d, a, b, c, x[k + 9], S12, 0x8B44F7AF);
        c = FF(c, d, a, b, x[k + 10], S13, 0xFFFF5BB1);
        b = FF(b, c, d, a, x[k + 11], S14, 0x895CD7BE);
        a = FF(a, b, c, d, x[k + 12], S11, 0x6B901122);
        d = FF(d, a, b, c, x[k + 13], S12, 0xFD987193);
        c = FF(c, d, a, b, x[k + 14], S13, 0xA679438E);
        b = FF(b, c, d, a, x[k + 15], S14, 0x49B40821);
        a = GG(a, b, c, d, x[k + 1], S21, 0xF61E2562);
        d = GG(d, a, b, c, x[k + 6], S22, 0xC040B340);
        c = GG(c, d, a, b, x[k + 11], S23, 0x265E5A51);
        b = GG(b, c, d, a, x[k + 0], S24, 0xE9B6C7AA);
        a = GG(a, b, c, d, x[k + 5], S21, 0xD62F105D);
        d = GG(d, a, b, c, x[k + 10], S22, 0x2441453);
        c = GG(c, d, a, b, x[k + 15], S23, 0xD8A1E681);
        b = GG(b, c, d, a, x[k + 4], S24, 0xE7D3FBC8);
        a = GG(a, b, c, d, x[k + 9], S21, 0x21E1CDE6);
        d = GG(d, a, b, c, x[k + 14], S22, 0xC33707D6);
        c = GG(c, d, a, b, x[k + 3], S23, 0xF4D50D87);
        b = GG(b, c, d, a, x[k + 8], S24, 0x455A14ED);
        a = GG(a, b, c, d, x[k + 13], S21, 0xA9E3E905);
        d = GG(d, a, b, c, x[k + 2], S22, 0xFCEFA3F8);
        c = GG(c, d, a, b, x[k + 7], S23, 0x676F02D9);
        b = GG(b, c, d, a, x[k + 12], S24, 0x8D2A4C8A);
        a = HH(a, b, c, d, x[k + 5], S31, 0xFFFA3942);
        d = HH(d, a, b, c, x[k + 8], S32, 0x8771F681);
        c = HH(c, d, a, b, x[k + 11], S33, 0x6D9D6122);
        b = HH(b, c, d, a, x[k + 14], S34, 0xFDE5380C);
        a = HH(a, b, c, d, x[k + 1], S31, 0xA4BEEA44);
        d = HH(d, a, b, c, x[k + 4], S32, 0x4BDECFA9);
        c = HH(c, d, a, b, x[k + 7], S33, 0xF6BB4B60);
        b = HH(b, c, d, a, x[k + 10], S34, 0xBEBFBC70);
        a = HH(a, b, c, d, x[k + 13], S31, 0x289B7EC6);
        d = HH(d, a, b, c, x[k + 0], S32, 0xEAA127FA);
        c = HH(c, d, a, b, x[k + 3], S33, 0xD4EF3085);
        b = HH(b, c, d, a, x[k + 6], S34, 0x4881D05);
        a = HH(a, b, c, d, x[k + 9], S31, 0xD9D4D039);
        d = HH(d, a, b, c, x[k + 12], S32, 0xE6DB99E5);
        c = HH(c, d, a, b, x[k + 15], S33, 0x1FA27CF8);
        b = HH(b, c, d, a, x[k + 2], S34, 0xC4AC5665);
        a = II(a, b, c, d, x[k + 0], S41, 0xF4292244);
        d = II(d, a, b, c, x[k + 7], S42, 0x432AFF97);
        c = II(c, d, a, b, x[k + 14], S43, 0xAB9423A7);
        b = II(b, c, d, a, x[k + 5], S44, 0xFC93A039);
        a = II(a, b, c, d, x[k + 12], S41, 0x655B59C3);
        d = II(d, a, b, c, x[k + 3], S42, 0x8F0CCC92);
        c = II(c, d, a, b, x[k + 10], S43, 0xFFEFF47D);
        b = II(b, c, d, a, x[k + 1], S44, 0x85845DD1);
        a = II(a, b, c, d, x[k + 8], S41, 0x6FA87E4F);
        d = II(d, a, b, c, x[k + 15], S42, 0xFE2CE6E0);
        c = II(c, d, a, b, x[k + 6], S43, 0xA3014314);
        b = II(b, c, d, a, x[k + 13], S44, 0x4E0811A1);
        a = II(a, b, c, d, x[k + 4], S41, 0xF7537E82);
        d = II(d, a, b, c, x[k + 11], S42, 0xBD3AF235);
        c = II(c, d, a, b, x[k + 2], S43, 0x2AD7D2BB);
        b = II(b, c, d, a, x[k + 9], S44, 0xEB86D391);
        a = AddUnsigned(a, AA);
        b = AddUnsigned(b, BB);
        c = AddUnsigned(c, CC);
        d = AddUnsigned(d, DD);
    }

    var temp = WordToHex(a) + WordToHex(b) + WordToHex(c) + WordToHex(d);

    return temp.toLowerCase();
}

const capitalize = (str, lower = false) =>
    (lower ? str.toLowerCase() : str).replace(/(?:^|\s|["'([{])+\S/g, match => match.toUpperCase());
;

/* Magui - call WS without WS_waitscreen */
function callWSWithoutWS(type, service, params, response) {
    var url = globalurl + "/api/" + service + ".php";
    var spin = document.createElement("div");
    spin.classList.add("spinChar");
    spin.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i>';

    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4) {
            var rsp = "";
            if (this.responseText !== "") {
                rsp = JSON.parse(this.responseText);
                response(this.status, this.responseText);
            } else {
                response(this.status, this.responseText);
            }
        }
    }
    switch (type) {
        case "GET":
            var parsedPars = Object.keys(params).map(function (k) {
                return encodeURIComponent(k) + '=' + encodeURIComponent(params[k]);
            }).join('&');
            xhttp.open(type.toUpperCase(), url + "?" + parsedPars, true);
            xhttp.send();
            break;
        case "POST":
            xhttp.open("POST", url, true);
            var formdata = new FormData();
            for (var key in params) {
                formdata.append(key, params[key]);
            }
            xhttp.send(formdata);
            break;
    }
}

/* Magui - go to dashboard or step */
function goToStart() {
    if (view === 1) {
        gotoPage('step', 'main', "");
    } else {
        gotoPage('dashboard', 'home', "");
    }
}

/* Magui: replaceAll isnt supported by various browsers */
String.prototype.replaceAll = function (strReplace, strWith) {
    var esc = strReplace.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
    var reg = new RegExp(esc, 'ig');
    return this.replace(reg, strWith);
};

/* Magui: Lang */
function getLangById(id) {
    return texts.filter(
        function (texts) { return texts.id == id }
    )[0];
}

function setWordLanginnerHTML(idHTML, idText) {
    if (document.getElementById(idHTML) && getLangById(idText)) {
        document.getElementById(idHTML).innerHTML = getLangById(idText)[lang]
    }
}

function setWordLangPlaceHolder(idHTML, idText) {
    if (getLangById(idText)) {
        document.getElementById(idHTML).placeholder = getLangById(idText)[lang]
    }
}

function numberWithoutSpecialChar(number) {
    return number.replace(/\D/g, '');
}

function onlyNumber(e) {
    tecla = (document.all) ? e.keyCode : e.which;

    if (tecla == 8) {
        return true;
    }

    patron = /[0-9]/;
    tecla_final = String.fromCharCode(tecla);
    return patron.test(tecla_final);
}

/**AQUI EL MANEJO DE LAS SESIONES */
var countdownGlobalTime = "";
// Session Update
var expiredBtn = document.getElementById('expSessionButton');
if (expiredBtn) {
    document.getElementById('expSessionButton').addEventListener("click", function () {
        var req = {
            'sessionid': sessionStorage.getItem('sessionid')
        }
        sessionUpdate(req)
    });
}
function countDownGlobal() {
    if (sessionStorage.getItem('sessionid')) {
        sessionValidUpdate(view);
    }
}
function expiredSession() {
    document.getElementsByClassName('expired')[0].style.display = "table";
    var seconds = 40;
    var countDown = function () {
        seconds--;
        if (seconds == 0) {
            if (document.getElementsByClassName('expired')[0].style.display == "table") {
                myLogout();
                clearInterval(countdown);
            }
        }
        if (document.getElementsByClassName('expired')[0].style.display == "none") {
            clearInterval(countdown);
            countdownGlobalTime = setInterval(countDownGlobal, 8000);
        }
    }
    var countdown = setInterval(countDown, 1000);

}
function sessionUpdate(req) {
    callWS('GET', 'session/update', req, response);
    function response(status, rsp) {
        switch (status) {
            case 200:
                if (entrydata == undefined || entrydata == null) {
                    window.location = window.location;
                } else {
                    document.getElementsByClassName('expired')[0].style.display = "none";
                }
                break;
            case 401:
                myLogout();
                break;
            default:
                console.log("unpexted error");
                setTimeout(myLogout(), 5000);
                break;
        }
    }
}
function sessionValidUpdate(id) {
    if (id == undefined || id == null) id = (view != "") ? view : 1;
    var req = {
        'sessionid': sessionStorage.getItem('sessionid'),
        'view': id
    }
    if (sessionStorage.getItem('sessionid')) {
        callWSWithoutWS('GET', 'session/valid', req, response);
        function response(status, rsp) {
            switch (status) {
                case 200:
                    view = JSON.parse(rsp).view;
                    break;
                case 401:
                    clearInterval(countdownGlobalTime);
                    expiredSession();
                    break;
                default:
                    view = (view != undefined) ? view : 1;
                    sessionValidUpdate(view);
                    break;
            }
        }
    } else {
        gotoPage('login', 'main', '');
        sessionStorage.clear();
    }
}
//CERRAR SESION no se si en este caso funciona igual
function myLogout() {
    var par = {};
    par.sessionid = sessionStorage.getItem("sessionid");
    callWS("GET", "login/logout", par, respuesta);

    function respuesta(status, rsp) {
        switch (status) {
            case 200:
                sessionStorage.clear();
                gotoPage("login", "main", "");
                break;
            default:
                sessionStorage.clear();
                gotoPage("login", "main", "");
                break;
        }
    }
}
/**HASTA QUÍ EL MANEJO DE LAS SESIONES */


/**AQUI EMPIEZA LA SECCION GLOBAL DE LOS TUTORIALES***/
//Dividimos el load del draw
//hasta ahora popup,card; ele=elmento ref; box = card a ocultar; mensaje; funcion exitosa}
//side agregado dirección del arrow
function drawTutorial(type, ele, box, dsc, success, side, arrow = 'left') {
    var top = 0, left = 0;
    var header = document.getElementsByTagName("header")[0];
    document.getElementsByClassName("hiddenBox")[0].style.position = "";
    document.getElementsByClassName("hiddenBox")[0].style.zIndex = "";
    document.getElementsByClassName("hiddenBg")[0].style.position = "";
    document.getElementsByClassName("hiddenBg")[0].style.zIndex = "";
    var cards = document.getElementsByClassName("miniCard");
    for (var i = 0; i < cards.length; i++) {
        cards[i].style.zIndex = "";
    }

    var waittime = 0;
    if (type == "popup") {
        if (box.scrollHeight > box.offsetHeight) {
            waittime = 100;
            var trys = 0;
            box.scroll(0, 0);
            while ((ele.offsetTop + ele.offsetHeight > (box.offsetHeight * trys))) {
                box.scroll(0, box.offsetHeight * trys);
                trys = trys + 1;
            }
        }
        setTimeout(function () {
            document.getElementsByClassName("hiddenBox")[0].style.zIndex = "102";
            document.getElementsByClassName("hiddenBg")[0].style.display = "none";
            top = (box.offsetTop + (window.scrollY - header.offsetHeight)) + (ele.offsetTop - box.offsetTop) + (ele.offsetHeight + 10);
            if (box.scrollHeight > box.offsetHeight) {
                top = top - box.scrollTop;
            }
            left = ele.offsetLeft + (ele.offsetWidth / 2) - (26 + 12);
            /*Oculto abajo */
            document.getElementsByClassName("privListBg")[0].style.height = (box.offsetHeight - ((ele.offsetTop - box.offsetTop) + ele.offsetHeight)) + "px";
            document.getElementsByClassName("privListBg")[0].style.width = (box.offsetWidth) + "px";
            document.getElementsByClassName("privListBg")[0].style.left = box.offsetLeft + "px";
            document.getElementsByClassName("privListBg")[0].style.top = top + "px";//Recuerda que es absoluto le sumas el scroll aca se hace arriba
            /*Oculto arriba */
            document.getElementsByClassName("privListBg")[1].style.height = (ele.offsetTop - box.offsetTop - 8) + "px";
            document.getElementsByClassName("privListBg")[1].style.width = (box.offsetWidth) + "px";
            document.getElementsByClassName("privListBg")[1].style.left = box.offsetLeft + "px";
            document.getElementsByClassName("privListBg")[1].style.top = (box.offsetTop + (window.scrollY - header.offsetHeight)) + "px";//Recuerda que es absoluto le sumas el scroll        

            if (box.scrollHeight > box.offsetHeight) {
                document.getElementsByClassName("privListBg")[1].style.height = (document.getElementsByClassName("privListBg")[1].offsetHeight) - box.scrollTop + "px";
                document.getElementsByClassName("privListBg")[0].style.height = box.offsetHeight - ((document.getElementsByClassName("privListBg")[1].offsetHeight + 8) + ele.offsetHeight) + "px";
            }

            document.getElementsByClassName("privListBg")[0].style.display = "";
            document.getElementsByClassName("privListBg")[1].style.display = "";
        }, waittime);



    } else if (type == "card") {
        box.style.zIndex = 3;
        top = box.offsetTop + ele.offsetTop + ele.offsetHeight + 12;
        left = box.offsetLeft + ele.offsetLeft + (ele.offsetWidth / 2) - (26 + 12);
        /*Oculto abajo */
        document.getElementsByClassName("privListBg")[0].style.height = (box.offsetHeight - ele.offsetTop) + "px";
        document.getElementsByClassName("privListBg")[0].style.width = (box.offsetWidth) + "px";
        document.getElementsByClassName("privListBg")[0].style.left = box.offsetLeft + "px";
        document.getElementsByClassName("privListBg")[0].style.top = top + "px";
        /*Oculto arriba */
        document.getElementsByClassName("privListBg")[1].style.height = (ele.offsetTop) + "px";
        document.getElementsByClassName("privListBg")[1].style.width = (box.offsetWidth) + "px";
        document.getElementsByClassName("privListBg")[1].style.left = box.offsetLeft + "px";
        document.getElementsByClassName("privListBg")[1].style.top = (box.offsetTop - 12) + "px"; //Consideramos mismo espacio de 12 que se toma para la flecha

        document.getElementsByClassName("privListBg")[0].style.display = "";
        document.getElementsByClassName("privListBg")[1].style.display = "";

        document.getElementsByTagName("html")[0].style.scrollBehavior = "smooth";
        document.getElementsByTagName("html")[0].style.transition = "all .2s";
        document.getElementsByTagName("html")[0].style.transtionDelay = ".5s";
        /**Ajustado aca para scroll auto en card */
        document.getElementsByClassName("privList")[0].style.display = "";
        document.getElementsByClassName("hiddenBox")[0].style.display = "";
        document.getElementsByClassName("hiddenBg")[0].style.display = "";
        window.scroll(0, top - (document.getElementsByClassName("privList")[0].offsetHeight + 20));
    } else if (type == "head") {
        document.getElementsByClassName("hiddenBox")[0].style.zIndex = "11";
        document.getElementsByClassName("hiddenBox")[0].style.position = "fixed";
        document.getElementsByClassName("hiddenBg")[0].style.display = "none";

        document.getElementsByClassName("privListBg")[0].style.display = "none";
        document.getElementsByClassName("privListBg")[1].style.display = "none";

        top = (box.offsetHeight - (box.offsetHeight / 2)) + 26;
        left = ele.offsetLeft + (ele.offsetWidth / 2) - (26 + 19);//19 de margin right opciones del header
    }
    //Debería ser 0 la mayor parte del tiempo
    setTimeout(function () {
        document.getElementById("tutInfo").innerHTML = getLangById(dsc)[lang];
        success(left, top);

        document.getElementsByClassName("privList")[0].style.display = "";
        document.getElementsByClassName("hiddenBox")[0].style.display = "";
        document.getElementsByClassName("hiddenBg")[0].style.display = "";
        switch (side) {
            case 'top':
                document.getElementsByClassName("privArrow")[0].classList.add("arrowTop");
                document.getElementsByClassName("privArrow")[0].classList.remove("arrowBot", "arrowLeft", "arrowRight");
                break;
            case 'bottom':
                top = top - (document.getElementsByClassName("privList")[0].offsetHeight + ele.offsetHeight + 20);
                if (type == 'card') window.scroll(0, top - (document.getElementsByClassName("privList")[0].offsetHeight + 20));
                document.getElementsByClassName("privArrow")[0].classList.add("arrowBot");
                document.getElementsByClassName("privArrow")[0].classList.remove("arrowTop", "arrowLeft", "arrowRight");
                break;
        }
        switch (arrow) {
            case 'left':
                document.getElementsByClassName("privArrow")[0].classList.add("arrowLeft");
                document.getElementsByClassName("privArrow")[0].classList.remove("arrowRight");
                break;
            case 'right':
                document.getElementsByClassName("privArrow")[0].classList.add("arrowRight");
                document.getElementsByClassName("privArrow")[0].classList.remove("arrowLeft");
                left = left - (document.getElementsByClassName("privList")[0].offsetWidth - (38 * 2));
                break;
        }

        if (box.scrollHeight > box.offsetHeight) {
            //Sección responsive        
            document.getElementsByClassName("privList")[0].style.left = left + "px";
            document.getElementsByClassName("privList")[0].style.top = top + "px";
        } else {
            document.getElementsByClassName("privList")[0].style.left = left + "px";
            document.getElementsByClassName("privList")[0].style.top = top + "px";
        }
        if (window.innerWidth < 420) {
            document.getElementsByClassName("privArrow")[0].style.left = (left + 7.5) + "px";
            document.getElementsByClassName("privList")[0].style.width = (window.innerWidth * 0.90) + "px";
            document.getElementsByClassName("privList")[0].style.left = ((window.innerWidth - (window.innerWidth * 0.90)) / 2) + "px";
        }
        setTimeout(function () {
            document.getElementsByClassName("hiddenBox")[0].style.opacity = "1";
            document.getElementsByTagName("html")[0].style.scrollBehavior = "";
            document.getElementsByTagName("html")[0].style.transition = "";
            document.getElementsByTagName("html")[0].style.transtionDelay = "";
        }, 300);
    }, waittime + 1);
}
function loadTutorial(step) {
    switch (step) {
        case 'dep1':
            var currid = 1;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    var cardportfolio = document.getElementById("card3");
                    var ele = accounts[i].getElementsByClassName("tablePortfolioImg")[0];
                    var success = function (left, top) {
                        document.getElementById("nextStepTut").setAttribute("nextStep", "dep2");
                    }
                    drawTutorial('card', ele, cardportfolio, 'depTutS1', success, 'top');
                }
            }
            break;
        case 'dep2':
            var currid = 1;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    accounts[i].dispatchEvent(new Event("click"));
                }
            }
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("depFiat");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep3");
            }
            drawTutorial('card', ele, cardportfolio, 'depTutS2', success, 'top');
            break;
        case 'dep3':
            document.getElementsByClassName("hiddenBox")[0].style.opacity = "";
            document.getElementById("depFiat").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("reportDTFiat");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep4");
            }
            var loaduntilopen = setInterval(function () {
                if (cardportfolio.parentElement.parentElement.style.display == "table") {
                    drawTutorial('popup', ele, cardportfolio, 'depTutS3', success, 'top');
                    clearInterval(loaduntilopen);
                }
            }, 300);
            loaduntilopen;
            break;
        case 'dep4':
            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("depFiatInfDestinationBank1");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep5");
            }
            drawTutorial('popup', ele, cardportfolio, 'depTutS4', success, 'top');
            break;
        case 'dep5':
            var opts = document.getElementById("depFiatInfDestinationBank1").options;
            if (opts.length > 1) document.getElementById("depFiatInfDestinationBank1").value = opts[1].getAttribute("value");
            document.getElementById("depFiatInfDestinationBank1").dispatchEvent(new Event("change"));
            if (document.getElementById("depFiatInfDestinationBank1").value != "") {
                var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
                var ele = document.getElementById("depFiatInfRec").parentElement;
                var success = function (left, top) {
                    document.getElementById("nextStepTut").setAttribute("nextStep", "dep6");
                }
                drawTutorial('popup', ele, cardportfolio, 'depTutS5', success, 'bottom');
            } else {
                endTutorial();
            }
            break;
        case 'dep6':
            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("depFiatAccept");
            var success = function (left, top) {
                if (isBPWorks) {
                    document.getElementById("nextStepTut").setAttribute("nextStep", "dep7");
                } else {
                    document.getElementById("nextStepTut").setAttribute("nextStep", "dep11");
                }

            }
            drawTutorial('popup', ele, cardportfolio, 'depTutS6', success, 'bottom');
            break;
        case 'dep7':
            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("p2cfiat");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep8");
                document.getElementsByClassName("privList")[0].style.display = "";
                document.getElementsByClassName("privList")[0].style.left = left + "px";
                document.getElementsByClassName("privList")[0].style.top = top + "px";
                document.getElementsByClassName("hiddenBox")[0].style.display = "";
                document.getElementsByClassName("hiddenBg")[0].style.display = "";
            }
            drawTutorial('popup', ele, cardportfolio, 'depTutS7', success, 'top');
            break;
        case 'dep8':
            document.getElementById("p2cfiat").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("depFiatInfDestinationBank2");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep9");
            }
            drawTutorial('popup', ele, cardportfolio, 'depTutS8', success, 'top');
            break;
        case 'dep9':
            var opts = document.getElementById("depFiatInfDestinationBank2").options;
            if (opts.length > 1) document.getElementById("depFiatInfDestinationBank2").value = opts[1].getAttribute("value");
            document.getElementById("depFiatInfDestinationBank2").dispatchEvent(new Event("change"));

            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("codePM");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep10");
            }
            drawTutorial('popup', ele, cardportfolio, 'depTutS9', success, 'bottom');
            break;
        case 'dep10':
            var opts = document.getElementById("depFiatInfDestinationBank2").options;
            if (opts.length > 1) document.getElementById("depFiatInfDestinationBank2").value = opts[1].getAttribute("value");
            document.getElementById("depFiatInfDestinationBank2").dispatchEvent(new Event("change"));
            var cardportfolio = document.getElementsByClassName("depFiatInf")[0].children[0].children[0];
            var ele = document.getElementById("depFiatDep");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "dep11");
            }
            drawTutorial('popup', ele, cardportfolio, 'depTutS6', success, 'bottom');
            break;
        case 'dep11':
            closeAllPop();
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("movButtonVES");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "end");
            }
            drawTutorial('card', ele, cardportfolio, 'depTutS11', success, 'top');
            break;
        case 'cripdp1':
            document.getElementById('FiatPortfolio').children[0].children[0].children[0].dispatchEvent(new Event("click"));
            var currid = 150;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    var cardportfolio = document.getElementById("card3");
                    var ele = accounts[i].getElementsByClassName("tablePortfolioImg")[0];
                    var success = function (left, top) {
                        document.getElementById("nextStepTut").setAttribute("nextStep", "cripdp2");
                    }
                    drawTutorial('card', ele, cardportfolio, 'cripdpTutS1', success, 'top');
                }
            }
            break;
        case 'cripdp2':
            var currid = 150;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    accounts[i].dispatchEvent(new Event("click"));
                }
            }
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("addressBTC");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "cripdp3");
            }
            drawTutorial('card', ele, cardportfolio, 'cripdpTutS2', success, 'top');
            break;
        case 'cripdp3':
            document.getElementsByClassName("hiddenBox")[0].style.opacity = "";
            document.getElementById("addressBTC").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("addressBTCInf")[0].children[0].children[0];
            var ele = document.getElementById("copyInfAFX").parentElement.parentElement;
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "cripdp4");
            }
            var loaduntilopen = setInterval(function () {
                if (cardportfolio.parentElement.parentElement.style.display == "table") {
                    drawTutorial('popup', ele, cardportfolio, 'cripdpTutS3', success, 'top');
                    clearInterval(loaduntilopen);
                }
            }, 300);
            loaduntilopen;
            break;
        case 'cripdp4':
            closeAllPop();
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("movButtonBTC");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "end");
            }
            drawTutorial('card', ele, cardportfolio, 'cripdpTutS4', success, 'top');
            break;
        case 'with1':
            document.getElementById('FiatPortfolio').children[0].children[0].children[0].dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByTagName("header")[0];
            var ele = document.getElementById("preferences");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "with2");
            }
            if (window.innerWidth < 420) {
                document.getElementById("togglebar").dispatchEvent(new Event("click"));
                setTimeout(function () {
                    var cardportfolio = document.getElementById("addView2").children[1];
                    ele = document.getElementById("preferencesR");
                    drawTutorial('card', ele, cardportfolio, 'withTutS1', success, 'top');
                }, 1000);

            } else {
                drawTutorial('head', ele, cardportfolio, 'withTutS1', success, 'top');
            }

            break;
        case 'with2':
            gotoPage("preferences", "main", '');
            break;
        case 'with3':
            var cardportfolio = document.getElementsByClassName("card2")[0];
            var ele = document.getElementById("addLabel");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "with4");
            }
            drawTutorial('card', ele, cardportfolio, 'withTutS2', success, 'top');
            break;
        case 'with4':
            gotoPage("dashboard", "home", '');
            break;
        case 'with5':
            var currid = 1;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    var cardportfolio = document.getElementById("card3");
                    var ele = accounts[i].getElementsByClassName("tablePortfolioImg")[0];
                    var success = function (left, top) {
                        document.getElementById("nextStepTut").setAttribute("nextStep", "with6");
                    }
                    drawTutorial('card', ele, cardportfolio, 'withTutS3', success, 'top');
                }
            }
            break;
        case 'with6':
            var currid = 1;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    accounts[i].dispatchEvent(new Event("click"));
                }
            }
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("withdrawFiat");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "with7");
            }
            drawTutorial('card', ele, cardportfolio, 'withTutS4', success, 'top');
            break;
        case 'with7':
            document.getElementsByClassName("hiddenBox")[0].style.opacity = "";
            document.getElementById("withdrawFiat").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("withdrawFiat")[0].children[0].children[0];
            var ele = document.getElementById("reportDTFiat2");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "with8");
            }
            var loaduntilopen = setInterval(function () {
                if (cardportfolio.parentElement.parentElement.style.display == "table") {
                    drawTutorial('popup', ele, cardportfolio, 'withTutS5', success, 'top');
                    clearInterval(loaduntilopen);
                }
            }, 300);
            loaduntilopen;
            break;
        case 'with8':
            var cardportfolio = document.getElementsByClassName("withdrawFiat")[0].children[0].children[0];
            var ele = document.getElementById("wdFiatbutton");
            var success = function (left, top) {
                if (isBPWorks) {
                    document.getElementById("nextStepTut").setAttribute("nextStep", "with9");
                } else {
                    document.getElementById("nextStepTut").setAttribute("nextStep", "with11");
                }
            }
            drawTutorial('popup', ele, cardportfolio, 'withTutS6', success, 'bottom');
            break;
        case 'with9':
            var cardportfolio = document.getElementsByClassName("withdrawFiat")[0].children[0].children[0];
            var ele = document.getElementById("p2cfiat2");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "with10");
            }
            if (cardportfolio.parentElement.parentElement.style.display == "table") {
                drawTutorial('popup', ele, cardportfolio, 'withTutS7', success, 'top');
                clearInterval(loaduntilopen);
            }
            break;
        case 'with10':
            document.getElementById("p2cfiat2").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("withdrawFiat")[0].children[0].children[0];
            var ele = document.getElementById("wdFiatbutton2");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "with11");
            }
            drawTutorial('popup', ele, cardportfolio, 'withTutS8', success, 'bottom');
            break;
        case 'with11':
            closeAllPop();
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("movButtonVES");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "end");
            }
            drawTutorial('card', ele, cardportfolio, 'withTutS9', success, 'top');
            break;
        case 'cripwth1':
            document.getElementById('FiatPortfolio').children[0].children[0].children[0].dispatchEvent(new Event("click"));
            var currid = 150;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    var cardportfolio = document.getElementById("card3");
                    var ele = accounts[i].getElementsByClassName("tablePortfolioImg")[0];
                    var success = function (left, top) {
                        document.getElementById("nextStepTut").setAttribute("nextStep", "cripwth2");
                    }
                    drawTutorial('card', ele, cardportfolio, 'cripwithTutS1', success, 'top');
                }
            }
            break;
        case 'cripwth2':
            var currid = 150;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    accounts[i].dispatchEvent(new Event("click"));
                }
            }
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("withdrawBTC");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "cripwth3");
            }
            drawTutorial('card', ele, cardportfolio, 'cripwithTutS2', success, 'top');
            break;
        case 'cripwth3':
            document.getElementsByClassName("hiddenBox")[0].style.opacity = "";
            document.getElementById("withdrawBTC").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("withdrawBTC")[0].children[0].children[0];
            var ele = document.getElementById("wdBTCbutton");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "cripwth4");
            }
            var loaduntilopen = setInterval(function () {
                if (cardportfolio.parentElement.parentElement.style.display == "table") {
                    drawTutorial('popup', ele, cardportfolio, 'cripwithTutS3', success, 'bottom');
                    clearInterval(loaduntilopen);
                }
            }, 300);
            loaduntilopen;
            break;
        case 'cripwth4':
            closeAllPop();
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("movButtonBTC");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "end");
            }
            drawTutorial('card', ele, cardportfolio, 'cripwithTutS4', success, 'top');
            break;
        case 'xfer1':
            document.getElementById('FiatPortfolio').children[0].children[0].children[0].dispatchEvent(new Event("click"));
            var currid = 150;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    var cardportfolio = document.getElementById("card3");
                    var ele = accounts[i].getElementsByClassName("tablePortfolioImg")[0];
                    var success = function (left, top) {
                        document.getElementById("nextStepTut").setAttribute("nextStep", "xfer2");
                    }
                    drawTutorial('card', ele, cardportfolio, 'xferTutS1', success, 'top');
                }
            }
            break;
        case 'xfer2':
            var currid = 150;
            var portafolio = document.getElementById("PortfolioScroll");
            var accounts = portafolio.getElementsByClassName("tablePortfolio");
            for (var i = 0; i < accounts.length; i++) {
                if (accounts[i].getAttribute("iccur") == currid) {
                    accounts[i].dispatchEvent(new Event("click"));
                }
            }
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("transferBTC");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "xfer3");
            }
            drawTutorial('card', ele, cardportfolio, 'xferTutS2', success, 'top');
            break;
        case 'xfer3':
            document.getElementsByClassName("hiddenBox")[0].style.opacity = "";
            document.getElementById("transferBTC").dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByClassName("transferBTC")[0].children[0].children[0];
            var ele = document.getElementById("trBTCbutton");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "xfer4");
            }
            var loaduntilopen = setInterval(function () {
                if (cardportfolio.parentElement.parentElement.style.display == "table") {
                    drawTutorial('popup', ele, cardportfolio, 'xferTutS3', success, 'bottom');
                    clearInterval(loaduntilopen);
                }
            }, 300);
            loaduntilopen;
            break;
        case 'xfer4':
            closeAllPop();
            var cardportfolio = document.getElementById("card3");
            var ele = document.getElementById("movButtonBTC");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "end");
            }
            drawTutorial('card', ele, cardportfolio, 'xferTutS4', success, 'top');
            break;
        case 'xch1':
            closeAllPop();
            document.getElementById('FiatPortfolio').children[0].children[0].children[0].dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementById("card4");
            var ele = document.getElementById("card4TItle");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "xch2");
                if (window.innerWidth > 420)
                    document.getElementsByClassName("privListBg")[0].style.display = "none";
            }
            var side = "bottom";
            if (window.innerWidth < 420) side = "top";
            drawTutorial('card', ele, cardportfolio, 'xchTutS1', success, side);
            break;
        case 'xch2':
            var pair = 5;
            var portafolio = document.getElementById("tableMarksCnt");
            var pairs = portafolio.getElementsByClassName("MarkersTable");
            for (var i = 0; i < pairs.length; i++) {
                if (pairs[i].getAttribute("parid") == pair) {
                    var cardportfolio = document.getElementById("card2");
                    var ele = pairs[i].getElementsByClassName("MarkersTableName")[0].children[0];
                    var success = function (left, top) {
                        document.getElementById("nextStepTut").setAttribute("nextStep", "xch3");

                    }
                    drawTutorial('card', ele, cardportfolio, 'xchTutS2', success, 'top');
                }
            }
            break;
        case 'xch3':
            var pair = 5;
            var portafolio = document.getElementById("tableMarksCnt");
            var pairs = portafolio.getElementsByClassName("MarkersTable");
            for (var i = 0; i < pairs.length; i++) {
                if (pairs[i].getAttribute("parid") == pair) {
                    pairs[i].dispatchEvent(new Event("click"));
                }
            }
            var cardportfolio = document.getElementById("card4");
            var ele = document.getElementById("BuyAndSellSelect");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "xch4");
            }
            drawTutorial('card', ele, cardportfolio, 'xchTutS3', success, 'top');
            break;
        case 'xch4':
            var cardportfolio = document.getElementById("card4");
            var ele = document.getElementById("BuyAndSellAmount").parentElement;
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "xch5");
            }
            var dir = 'right';
            if (window.innerWidth < 420) dir = 'left';
            drawTutorial('card', ele, cardportfolio, 'xchTutS4', success, 'top', dir);
            break;
        case 'xch5':
            var cardportfolio = document.getElementById("card7");
            var ele = document.getElementById("EXCHANGESTitle");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "xch6");
                document.getElementsByClassName("privListBg")[0].style.display = "none";
            }
            drawTutorial('card', ele, cardportfolio, 'xchTutS5', success, 'bottom');
            break;
        case 'xch6':
            document.getElementById('FiatPortfolio').children[0].children[0].children[0].dispatchEvent(new Event("click"));
            var cardportfolio = document.getElementsByTagName("header")[0];
            var ele = document.getElementById("balance");
            var success = function (left, top) {
                document.getElementById("nextStepTut").setAttribute("nextStep", "end");
            }
            if (window.innerWidth < 420) {
                document.getElementById("togglebar").dispatchEvent(new Event("click"));
                setTimeout(function () {
                    var cardportfolio = document.getElementById("addView2").children[1];
                    ele = document.getElementById("balanceR");
                    drawTutorial('card', ele, cardportfolio, 'xchTutS6', success, 'top');
                }, 1000);
            } else {
                drawTutorial('head', ele, cardportfolio, 'xchTutS6', success, 'top');
            }
            break;
        case 'end':
            endTutorial();
            break;
    }
    if (step.indexOf("dep") > -1) {
        setCookie('deptut', step, 360);
        document.getElementById("titTut").innerHTML = getLangById('titDepTut')[lang];
        document.getElementById("endTutorial").setAttribute("tut", "deptut");
        document.getElementById("endTutorial").setAttribute("last", "dep11");
        var lblNo = (document.getElementById("endTutorial").getAttribute("last")).replace("dep", "");
        var stepNo = step.replace("dep", "");
        if (!isBPWorks) {
            lblNo = parseFloat(lblNo) - 4;
            if (stepNo > 7) {
                stepNo = stepNo - 4;
            }
        }
        var steplbl = '<span> PASO ' + stepNo + '</span>/' + lblNo;
        if (lang == 'eng') steplbl = '<span> STEP ' + stepNo + '</span>/' + lblNo;
        document.getElementById("stepsTut").innerHTML = steplbl;
    } else if (step.indexOf("cripdp") > -1) {
        setCookie('cripdeptut', step, 360);
        document.getElementById("titTut").innerHTML = getLangById('titDepTut')[lang];
        document.getElementById("endTutorial").setAttribute("tut", "cripdeptut");
        document.getElementById("endTutorial").setAttribute("last", "cripdp4");
        var steplbl = '<span> PASO ' + step.replace("cripdp", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("cripdp", "");
        if (lang == 'eng') steplbl = '<span> STEP ' + step.replace("cripdp", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("cripdp", "");
        document.getElementById("stepsTut").innerHTML = steplbl;
    } else if (step.indexOf("with") > -1) {
        setCookie('withtut', step, 360);
        document.getElementById("titTut").innerHTML = getLangById('titWithTut')[lang];
        document.getElementById("endTutorial").setAttribute("tut", "withtut");
        document.getElementById("endTutorial").setAttribute("last", "with11");
        var nro = step.replace("with", "");
        nro = parseFloat(nro);
        if (nro > 4) {
            nro = nro - 2
        } else if (nro > 2) {
            nro = nro - 1;
        }
        var lblNo = (document.getElementById("endTutorial").getAttribute("last")).replace("with", "") - 2;
        var stepNo = nro;
        if (!isBPWorks) {
            lblNo = parseFloat(lblNo) - 2;
            if (stepNo > 8) {
                stepNo = stepNo - 2;
            }
        }
        var steplbl = '<span> PASO ' + stepNo + '</span>/' + lblNo;
        if (lang == 'eng') steplbl = '<span> STEP ' + stepNo + '</span>/' + lblNo;
        document.getElementById("stepsTut").innerHTML = steplbl;
    } else if (step.indexOf("cripwth") > -1) {
        setCookie('cripwithtut', step, 360);
        document.getElementById("titTut").innerHTML = getLangById('titWithTut')[lang];
        document.getElementById("endTutorial").setAttribute("tut", "cripwithtut");
        document.getElementById("endTutorial").setAttribute("last", "cripwth4");
        var steplbl = '<span> PASO ' + step.replace("cripwth", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("cripwth", "");
        if (lang == 'eng') steplbl = '<span> STEP ' + step.replace("cripwth", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("cripwth", "");
        document.getElementById("stepsTut").innerHTML = steplbl;
    } else if (step.indexOf("xfer") > -1) {
        setCookie('xfertut', step, 360);
        document.getElementById("titTut").innerHTML = getLangById('titXferTut')[lang];
        document.getElementById("endTutorial").setAttribute("tut", "xfertut");
        document.getElementById("endTutorial").setAttribute("last", "xfer4");
        var steplbl = '<span> PASO ' + step.replace("xfer", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("xfer", "");
        if (lang == 'eng') steplbl = '<span> STEP ' + step.replace("xfer", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("xfer", "");
        document.getElementById("stepsTut").innerHTML = steplbl;
    } else if (step.indexOf("xch") > -1) {
        setCookie('xchtut', step, 360);
        document.getElementById("titTut").innerHTML = getLangById('titXchTut')[lang];
        document.getElementById("endTutorial").setAttribute("tut", "xchtut");
        document.getElementById("endTutorial").setAttribute("last", "xch6");
        var steplbl = '<span> PASO ' + step.replace("xch", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("xch", "");
        if (lang == 'eng') steplbl = '<span> STEP ' + step.replace("xch", "") + '</span>/' + (document.getElementById("endTutorial").getAttribute("last")).replace("xch", "");
        document.getElementById("stepsTut").innerHTML = steplbl;
    }
    document.getElementById("nextStepTut").innerHTML = getLangById('nextStepTut')[lang];
}
function endTutorial() {
    setCookie(document.getElementById("endTutorial").getAttribute("tut"), document.getElementById("endTutorial").getAttribute("last"), 360);
    document.getElementById("endTutorial").getAttribute("last");
    document.getElementsByClassName("privListBg")[0].removeAttribute("style");
    document.getElementsByClassName("privListBg")[1].removeAttribute("style");
    document.getElementsByClassName("hiddenBox")[0].style.display = "none";
    document.getElementsByClassName("hiddenBg")[0].style.display = "none";
    var cards = document.getElementsByClassName("miniCard");
    for (var i = 0; i < cards.length; i++) {
        cards[i].style.zIndex = "";
    }
    validarStepTut();
}
function setCookie(name, value, daysToLive) {
    var cookie = name + "=" + encodeURIComponent(value);
    if (typeof daysToLive === "number") {
        cookie += "; max-age=" + (daysToLive * 24 * 60 * 60);
        document.cookie = cookie;
    }
}
function getCookie(name) {
    var cookieArr = document.cookie.split(";");
    for (var i = 0; i < cookieArr.length; i++) {
        var cookiePair = cookieArr[i].split("=");
        if (name == cookiePair[0].trim()) {
            return decodeURIComponent(cookiePair[1]);
        }
    }
    return null;
}
function checkCookie(name, newval, success) {
    var value = getCookie(name);
    if (value != "" && value != null) {
        if (success(value)) return true;
        else return false;
    } else {
        setCookie(name, newval, 360);
        if (success(newval)) return true;
        else return false;
    }
}
function validarStepTut() {
    var todook = function (val) {
        if (val !== 'dep11') {
            loadTutorial('dep1');
            return true;
        } else {
            return false;
        }
    }
    if (checkCookie('deptut', 'dep1', todook)) {
        return;
    }
    var todook = function (val) {
        if (val !== 'cripdp4') {
            loadTutorial('cripdp1');
            return true;
        } else {
            return false;
        }
    }
    if (checkCookie('cripdeptut', 'cripdp1', todook)) {
        return;
    }
    var todook = function (val) {
        if (val !== 'with11') {
            loadTutorial('with1');
            return true;
        } else {
            return false;
        }
    }
    if (checkCookie('withtut', 'with1', todook)) {
        return;
    }
    var todook = function (val) {
        if (val !== 'cripwth4') {
            loadTutorial('cripwth1');
            return true;
        } else {
            return false;
        }
    }
    if (checkCookie('cripwithtut', 'cripwth1', todook)) {
        return;
    }
    var todook = function (val) {
        if (val !== 'xfer4') {
            loadTutorial('xfer1');
            return true;
        } else {
            return false;
        }
    }

    if (checkCookie('xfertut', 'xfer1', todook)) {
        return;
    }
    var todook = function (val) {
        if (val !== 'xch6') {
            loadTutorial('xch1');
            return true;
        } else {
            return false;
        }
    }

    if (checkCookie('xchtut', 'xch1', todook)) {
        return;
    }
}
/***HASTA AQUÍ EL MANEJO DE LOS TUTORIALES**/


document.write('<script src="./settings/footer.js"></script>'); //Se carga la función que introduce el texto del footer

/****INIT*****/

var entrydata;
window.onload = function () {
    start();//Global definible cómo init internos

    //Si existe el popup de sesion expirada se comienza el ciclo de validar el tiempo de duración de la sesión
    var expiredpop = document.getElementsByClassName('expired');
    if (expiredpop.length > 0) {
        if (expiredpop[0].style.display !== "table" && expiredpop[0].style.display !== "block") {
            countdownGlobalTime = setInterval(countDownGlobal, 30000);
        }
    }

    //Marcar opción en el menú header (si existe)
    var menupage = getParameterByName("id");
    var page = "";
    switch (menupage) {//Dependiendo de la pagina actual se obtiene la opción del menú a 'resaltar'
        case 'balance':
            page = "balance";
            break;
        case 'step':
        case 'dashboard':
            page = "home";
            break;
        case 'cryptopayments':
            page = "cryptopayments";
            break;
        case 'preferences':
            page = "preferences";
            break;
    }
    var header = document.getElementsByTagName("header");
    if (header.length > 0) {   //Se valida que haya un header
        var optMenu = header[0].querySelectorAll('[id="' + page + '"]');
        if (optMenu.length > 0) {//Si no está dentro de los directores anteriores no se marca opción en el menú
            optMenu[0].classList.remove("poppins-regular");
            optMenu[0].classList.add("poppins-bold");
        }


        //Opciones del header
        document.getElementById('preferences').addEventListener("click", function () {
            gotoPage('preferences', 'main', "")
        });
        //Go to balance
        document.getElementById('balance').addEventListener("click", function () {
            gotoPage('balance', 'balance', "");
        });
        //Go to Cripto payments
        document.getElementById('cryptopayments').addEventListener("click", function () {
            gotoPage('cryptopayments', 'payments', "");
        });
        //Go to home dashboard or step
        document.getElementById('home').addEventListener("click", function () {
            goToStart()
        });
        //Go to logout session
        document.getElementById('logouticon').addEventListener("click", function () {
            myLogout();
        });
        // Go to messages
        document.getElementById('message').addEventListener("click", function () {
            gotoPage('messages', 'messages', "");
        });
    }

    var headerResponsive = document.getElementById("addView2");//Se valida que exista un header responsive
    if (headerResponsive != undefined) {
        var optMenuRsp = [];
        if (headerResponsive) optMenuRsp = headerResponsive.querySelectorAll('[id="' + page + 'R"]')
        if (optMenuRsp.length > 0) {//Si no está dentro de los directores anteriores no se marca opción en el menú
            optMenuRsp[0].classList.remove("poppins-regular");
            optMenuRsp[0].classList.add("poppins-bold");
        }

        //Preferencias del header responsive
        document.getElementById('example-element-toggle2').checked = false;

        // Barras abrir y cerrar menú
        var pen = null;
        document.getElementById('togglebar').addEventListener("click", function () {
            var ele = document.getElementById('addView2');
            if (document.getElementById('example-element-toggle2').checked) {
                pen = setTimeout(function () { ele.style.display = ""; }, 1000);
            } else {
                clearTimeout(pen);
                ele.style.display = "block";
            }
            setTimeout(function () {
                document.getElementById('example-element-toggle2').checked = !document.getElementById('example-element-toggle2').checked;
            }, 15);

        });

        // Go to home
        document.getElementById('homeR').addEventListener("click", function () {
            goToStart()
        });

        // Go to preferences
        document.getElementById('balanceR').addEventListener("click", function () {
            gotoPage('balance', 'balance', "")
        });
        //Go to Cripto payments
        document.getElementById('cryptopaymentsR').addEventListener("click", function () {
            gotoPage('cryptopayments', 'payments', "");
        });
        // Go to preferences
        document.getElementById('preferencesR').addEventListener("click", function () {
            gotoPage('preferences', 'main', "")
        });

        document.getElementById('logouticon2').addEventListener("click", function () {
            myLogout();
        });
    }


    //Asignación de eventos expandir y contraer secciones del dashboard
    var coll = document.getElementsByClassName("collapsible");
    for (let i = 0; i < coll.length; i++) {
        coll[i].addEventListener("click", function () {
            this.classList.toggle("active");
            var content = this.nextElementSibling;
            if (content.style.display === "block") {
                content.style.display = "none";
            } else {
                content.style.display = "block";
            }
        });
    }

    //Mostrar lbl nombre en el header
    var headLbl = document.getElementById("headname");
    if (headLbl != undefined && headLbl != null) {
        headLbl.innerHTML = sessionStorage.getItem("headname");
    }
    //Mostar lbl nombre en menu responsive
    var headLblR = document.getElementById("name2");
    if (headLblR != undefined && headLblR != null) {
        headLblR.innerHTML = sessionStorage.getItem("headname");
    }

    //Chequeamos el entrydata para ver si ya se cargó o no 
    if (document.getElementById('cryptopayments') != undefined) {
        //Lo valido local mente es decir acá en js para hacerlo global
        var criptohead = (sessionStorage.getItem("lang") == 'esp' ? "Cripto Pagos" : "Crypto Pays");
        document.getElementById("cryptopayments").innerHTML = criptohead;
        document.getElementById('cryptopaymentsR').innerHTML = criptohead;
        let cont = 0; let limit = 10;
        let interval = setInterval(function () {//Esto se hace así por la falta de uso de async y await
            if (entrydata != null || cont > limit) {
                //Validamos si tiene la preferenia del cripto pago para mostrarlo, si no removemos el elemento
                if (entrydata.paymentstothirdsparty != undefined) {
                    if (entrydata.paymentstothirdsparty.length > 0) {
                        //Seteamos el pago a tercero
                        for (type of entrydata.paymentstothirdsparty) {
                            if (type.pagomovil != undefined) {//Para el pago movil
                                if (type.pagomovil) {
                                    document.getElementById('cryptopaymentsR').style.display = "";
                                    document.getElementById('cryptopayments').style.display = "";
                                } else {
                                    document.getElementById('cryptopaymentsR').parentElement.removeChild(document.getElementById('cryptopaymentsR'));
                                    document.getElementById('cryptopayments').parentElement.removeChild(document.getElementById('cryptopayments'));
                                    if (getParameterByName("id") == "cryptopayments") goToStart();
                                }
                            }
                        }
                    }
                }
                clearInterval(interval);
            } else cont++;
        }, 1000);
    }
};