<?php
// cms/api/accounting/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", 'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 86))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    $sql = "SELECT ACC.id AS id, ".
    "       ACC.type AS acctype, ".
    "       ACC.account AS account, ".
    "       curr.id AS currencyid, ".
    "       curr.name AS currencyname, ".
    "       curr.symbol AS currencysymbol ".
    "       FROM currencies curr, accountingaccounts ACC ".
    "       WHERE ACC.id = ".mysqli_real_escape_string($db, $id).
    "       AND ACC.currencyid = curr.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    $out->entry = new stdClass();
    $out->entry->id = (int)$row['id'];
    $out->entry->account = $row['account'];
    
    $out->entry->currency = new stdClass();
    $out->entry->currency->id = (int)$row['currencyid'];
    $out->entry->currency->name = $row['currencyname'];
    $out->entry->currency->symbol = $row['currencysymbol'];
    
    $cod = '';
    // Si tiene la palabra base contiene un PAR
    if(strpos($row['acctype'], "BASE") !== false){
        $realcodarr = explode("BASE", $row['acctype']);
        $cod = $realcodarr[0]."BASE";
    } else {
        $cod = $row['acctype'];
    }
    
    // Buscamos el type
    $sql = "SELECT id, dsc ".
    "       FROM accountingtypes ".
    "       WHERE cod LIKE '%".mysqli_real_escape_string($db, $cod)."%'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $acctype = $res->fetch_assoc();
    
    $out->entry->type = new stdClass();
    $out->entry->type->id = (int)$acctype['id'];
    $out->entry->type->dsc = $acctype['dsc'];
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass();
    $access->create = tienePrivilegio($db, $sessionid, 83);
    $access->read =   tienePrivilegio($db, $sessionid, 86);
    $access->update = tienePrivilegio($db, $sessionid, 84);
    $access->delete = tienePrivilegio($db, $sessionid, 85);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>