<?php
// cms/api/accounting/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", 'id');//Quitado de aca el currencyid y el type 
    if (!parametrosValidos($_POST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_POST["sessionid"];
    $id = $_POST['id'];
    $currencyid = $_POST['currencyid'];
    $account = $_POST['account'];
    $type = $_POST['type'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    if($id == 0){
        badEnd("500", array("msg"=>'ID no puede ser 0'));
    }
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 84))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que exista el registro
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM accountingaccounts".
    "       WHERE id = ".mysqli_real_escape_string($db, $id);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    if($row['qty'] == 0){
        badEnd("204", array("msg"=>'Registro no encontrado'));
    }
    
    $sql = "UPDATE accountingaccounts SET ".
    "       account = '".mysqli_real_escape_string($db, $account)."'".
    "       WHERE id = ".mysqli_real_escape_string($db, $id);
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $out->id = (int)$id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
