<?php
// cms/api/accounts/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 26))
        badEnd("403", array("msg"=>"No tiene Privilegios"));

    
    $sql = "SELECT accounts.id AS accountid, accounts.paymentmethodid AS paymentmethodid, ".
    "       paymentmethods.dsc AS paymentmethodname, paymentmethods.countryid AS countryid, ".
    "       countries.name AS countryname, accounts.currencyid AS currencyid, ".
    "       currencies.name AS currencyname, accounts.status AS accountstatus, ".
    "       accounts.details1 AS accountdetail1, accounts.details2 AS accountdetail2,".
    "       accounts.details3 AS accountdetail3, accounts.details4 AS accountdetail4 ".
    "       FROM accounts, paymentmethods, currencies, countries ".
    "       WHERE accounts.paymentmethodid = paymentmethods.id AND ".
    "       paymentmethods.countryid = countries.id AND ".
    "       accounts.currencyid = currencies.id AND ".
    "       accounts.userid = -1 AND ".
    "       accounts.id = ".mysqli_real_escape_string($db, $id);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Ordenamos los datos
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    //Guardamos el id de la cuenta
    $out->entry->id = (int)$row["accountid"];
        
    //Metodo de pago
    $out->entry->paymentmethod = new stdClass();
    $out->entry->paymentmethod->id = (int)$row["paymentmethodid"];
    $out->entry->paymentmethod->dsc = $row["paymentmethodname"];
        
    //Pais del metodo de pago
    $out->entry->country = new stdClass();
    $out->entry->country->id = (int)$row["countryid"];
    $out->entry->country->dsc = $row["countryname"];
        
    //Moneda principal de la cuenta
    $out->entry->currency = new stdClass();
    $out->entry->currency->id = (int)$row["currencyid"];
    $out->entry->currency->dsc = $row["currencyname"];
    
        
    //Detalles de la cuenta
    $out->entry->status = (int)$row["accountstatus"];
    $out->entry->deleteable = $out->entry->status == 0 ? true : false;
    $out->entry->details1 = $row["accountdetail1"] == null ? "" : $row["accountdetail1"];
    $out->entry->details2 = $row["accountdetail2"] == null ? "" : $row["accountdetail2"];
    $out->entry->details3 = $row["accountdetail3"] == null ? "" : $row["accountdetail3"];
    $out->entry->details4 = $row["accountdetail4"] == null ? "" : $row["accountdetail4"];
    
    
    //Preguntar a javier si se requieren otros privilegios
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 23);
    $access->read =   tienePrivilegio($db, $sessionid, 26);
    $access->update = tienePrivilegio($db, $sessionid, 24);
    $access->delete = tienePrivilegio($db, $sessionid, 25);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
