<?php
// cms/api/accounts/update

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","paymentmethodid","currencyid","details1","status");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Criptomonedas 
    $cryptoarr = array("BTC","LTC","ETH","PTR");
    //Monedas Fiat
    $fiatarr = array("BSS","$","€");
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $paymentmethodid = $_GET["paymentmethodid"];
    $currencyid = $_GET["currencyid"];
    $details1 = $_GET["details1"];
    $status = $_GET["status"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es 0 se crea, si no se actualiza
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 23))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Insertamos la nueva cuenta
        $sql = "INSERT INTO accounts".
        "       (".
        "       paymentmethodid, ".
        "       userid, ".
        "       currencyid, ".
        "       details1, ".
        "       ".validateInsertField($db,"details2","details2").
        "       ".validateInsertField($db,"details3","details3").
        "       ".validateInsertField($db,"details4","details4").
        "       status".
        "       )".
        "       VALUES(".
        "       ".mysqli_real_escape_string($db, $paymentmethodid).", ".
        "       -1, ".
        "       ".mysqli_real_escape_string($db, $currencyid).", ".
        "       '".mysqli_real_escape_string($db, $details1)."', ".
        "       ".validateInsertValue($db,"details2","string")." ".
        "       ".validateInsertValue($db,"details3","string")." ".
        "       ".validateInsertValue($db,"details4","string")." ".
        "       ".mysqli_real_escape_string($db, $status).
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "CTAS. INTERNAS", $sessionid, "CMS", "Se agregó la cuenta interna ".$details1);
        
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 24))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT id, userid FROM accounts WHERE id = ".mysqli_real_escape_string($db, $id).
        "       AND userid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["id"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE accounts SET".
        "       paymentmethodid = ".mysqli_real_escape_string($db, $paymentmethodid).", ".
        "       currencyid = ".mysqli_real_escape_string($db, $currencyid).", ".
        "       details1 = '".mysqli_real_escape_string($db, $details1)."', ".
        "       details2 = ".($_GET["details2"] == "" ? "null" : "'".mysqli_real_escape_string($db, $_GET["details2"])."'").", ".
        "       details3 = ".($_GET["details3"] == "" ? "null" : "'".mysqli_real_escape_string($db, $_GET["details3"])."'").", ".
        "       details4 = ".($_GET["details4"] == "" ? "null" : "'".mysqli_real_escape_string($db, $_GET["details4"])."'").", ".
        "       entityusrid = -1, ".
        "       status = ".mysqli_real_escape_string($db, $status).
        "       WHERE id = ".mysqli_real_escape_string($db, $id);
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "CTAS. INTERNAS", $sessionid, "CMS", "Se actualizó la cuenta interna ".$details1);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para validar que el campo fue enviado, 
    *   y armar los campos a insertar
    *   Se reciben dos parametros:
    *   $param = Parametro a validar
    *   $field = nombre del campo
    */
    function validateInsertField($db, $param, $field){
        $str = "";
        
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            $str = $str." ".mysqli_real_escape_string($db, $field).",";
        }
        
        return $str;
    }
    
    /*  Funcion para validar que el valor fue enviado, 
    *   y armar el string para insertarlo
    *   Se recibe un parametro:
    *   $param = Parametro a validar
    *   $type = Tipo de valor
    */
    function validateInsertValue($db, $param,$type){
        $str = "";
        
        if(isset($_GET[$param]) && $_GET[$param] != ""){
            if($type == "string"){
                $str = $str." '".mysqli_real_escape_string($db, $_GET[$param])."',";
            }else if($type == "number"){
                $str = $str." ".mysqli_real_escape_string($db, $_GET[$param]).",";
            }else{
                $str = $str." '".mysqli_real_escape_string($db, $_GET[$param])."',";
            }
        }
        
        return $str;
    }
?>
