<?php
// cms/api/appusers/levelslist
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","userid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $userid = $_GET["userid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Consultamos los datos del usuario para saber si existe
    $sql = "SELECT count(id) AS qty FROM users WHERE id = ".mysqli_real_escape_string($db, $userid);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    
    if($row["qty"] == 0){
        badEnd("404",array("msg"=>"Usuario no encontrado"));
    }
    
    //Consultamos la cantidad de registros que existen
    $sql = "SELECT COUNT(id) AS qty FROM levels";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    //Retornamos el resultado
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos los registros a detalle
    $out->records = [];
    $out->records = getAvaliableLevels($db, $userid);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
