<?php
// cms/api/appusers/paymentstothirdsparty
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", "userid", "pagomovil");
    if (!parametrosValidos($_POST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_POST['sessionid'];
    $userid = mysqli_real_escape_string($db, $_POST['userid']);
    $pagomovil = $_POST['pagomovil'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    isLevelValid($db, $userid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 97))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consulta de los datos iniciales
    $sql = "SELECT *".
    "       FROM users".
    "       WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
    $userdata = $rs->fetch_assoc();
    
    if($userdata["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    // Nos traemos los objetos
    $configTmp = json_decode($userdata['paymentstothirdsparty'], true);
    foreach($configTmp as $index => $config){
        if($config['pagomovil'] == false || $config['pagomovil'] == true){
            $configTmp[$index]['pagomovil'] = $pagomovil == 1 ? true : false;
        }
    }

    //Se enciende la que se envía
    $sql = "UPDATE users SET ".
    "       paymentstothirdsparty = '".json_encode($configTmp)."'".
    "       WHERE id = ".$userid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $out->update = false;
    //Retornamos si no se actualizo ningun registro
    if ($db->affected_rows > 0)
        $out->update = true;
    
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se actualizaron las preferencias de Pago Movil"); 
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
