<?php
// cms/api/appusers/portoflioexn
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid", "userid", 'pairids', 'preffeefields', 'exonerated');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET["userid"];
    $pairids = $_GET['pairids'];
    $preffeefields = $_GET['preffeefields'];
    $exonerated = $_GET['exonerated'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 94))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Convertimos a string
    $pairIdsArr = explode('-', $pairids);
    $preffeefieldsArr = explode('|', $preffeefields);
    $exoneratedArr = explode('-', $exonerated);
    
    // Validamos que los parametros sean del mismo length
    if (
        count($pairIdsArr) != count($preffeefieldsArr) ||
        count($pairIdsArr) != count($exoneratedArr) ||
        count($preffeefieldsArr) != count($exoneratedArr)
    ) {
        badEnd("500", array("msg"=>"Parametros deben tener la misma cantidad de valores"));
    }
    
    //Consulta de los datos iniciales
    $sql = "SELECT *".
    "       FROM users".
    "       WHERE id = ".mysqli_real_escape_string($db, $id);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
            
    $userdata = $rs->fetch_assoc();
    
    if($userdata["id"] == null){
        badEnd("204", array("msg"=>"No se encuentra el usuario"));
    }
    
    // recorremos las monedas para actualizar o crear registros
    foreach($pairIdsArr as $index => $pairid) {
        // Validamos que existe la moneda
        // Validamos que no existe el registro
        $sql = "SELECT COUNT(id) AS qty FROM pairs ".
        "       WHERE id = ".$pairid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
        $rowCount = $rs->fetch_assoc();
        
        if ($rowCount['qty'] == 0) {
            badEnd("204", array("msg"=>"No se encuentra el par"));
        }
        
        // Validamos que el rate sea mayor a 0 y menor o igual a 100
        if ($exoneratedArr[$index] < 0) {
            badEnd("400", array("msg"=>"Descuento debe ser mayor a 0"));
        }
        
        if ($exoneratedArr[$index] > 100) {
            badEnd("400", array("msg"=>"Descuento debe ser menor a 100"));
        }
        
        // Validamos que no existe el registro
        $sql = "SELECT COUNT(userid) AS qty FROM userxchgprefs ".
        "       WHERE pairid = ".$pairid.
        "       AND userid = ".$id.
        "       AND preffeesfield = '".$preffeefieldsArr[$index]."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
        $rowCount = $rs->fetch_assoc();
        
        // Si es 0, creamos el registro
        if ($rowCount['qty'] == 0) {
            $sql = "INSERT INTO userxchgprefs(".
            "       userid, ".
            "       pairid, ".
            "       preffeesfield, ".
            "   	exonerated, ".
            "       datecreated ".
            "       ) ".
            "       VALUES(".
            "       ".$id.", ".
            "       ".$pairid.", ".
            "       '".$preffeefieldsArr[$index]."', ".
            "       ".$exoneratedArr[$index].", ".
            "       NOW() ".
            "       )";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        } else {
            // SI no es 0, le actualizamos el rate
            $sql = "UPDATE userxchgprefs SET".
            "   	exonerated = ".$exoneratedArr[$index].
            "       WHERE userid = ".$id.
            "       AND pairid = ".$pairid.
            "       AND preffeesfield = '".$preffeefieldsArr[$index]."'";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        }
    }
    
    // Consultamos los registros que tiene el usuario, para ver que se enviaron todas las monedas que tiene
    $sql = "SELECT * FROM userxchgprefs ".
    "       WHERE userid = ".$id;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
    while($row = $rs->fetch_assoc()){
        // Recorremos las monedas, si no existe, lo borramos
        $exist = false;
        
        foreach($pairIdsArr as $index => $pairid) {
            if ($pairid == $row['pairid'] && $preffeefieldsArr[$index] == $row['preffeesfield']) {
                $exist = true;
            }
        }
        
        if (!$exist) {
            // Si no existe en el arreglo, lo borramos
            $sql = "DELETE FROM userxchgprefs ".
            "       WHERE userid = ".$id.
            "       AND pairid = ".$row['pairid'].
            "       AND preffeesfield = '".$row['preffeesfield']."'";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        }
    }
    
    $out->pairs = $pairids;
    
    $sql = "SELECT usr ".
    "       FROM users ".
    "       WHERE id = ".$id;
    if (!$resPref=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $resPref->fetch_assoc();
    
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se Actualizarón las exoneraciones de intercambios del usuario ".$row['usr'].".");
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
