<?php
// cms/api/cities/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 55))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Consultamos los datos especificos de la ciudad que se requiere
    $sql = "SELECT cities.id AS citiesid, cities.name AS citiesname, ".
    "       cities.status AS citiesstatus, regions.id AS regionsid, ".
    "       regions.name AS regionsname, countries.id AS countriesid, ".
    "       countries.name AS countriesname ".
    "       FROM cities, regions, countries".
    "       WHERE cities.id =".$id.
    "       AND cities.countryid = countries.id".
    "       AND cities.regionid = regions.id";
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["citiesid"];
    $out->entry->dsc = $row["citiesname"];
    
    $out->entry->country = new stdClass();
    $out->entry->country->id = (int)$row["countriesid"];
    $out->entry->country->dsc = $row["countriesname"];
    
    $out->entry->region = new stdClass();
    $out->entry->region->id = (int)$row["regionsid"];
    $out->entry->region->dsc = $row["regionsname"];
    
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["citiesstatus"];
    $out->entry->status->dsc =  $out->entry->status->id == 1 ? "Activo" : "Inactivo";
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 52);
    $access->read =   tienePrivilegio($db, $sessionid, 55);
    $access->update = tienePrivilegio($db, $sessionid, 53);
    $access->delete = tienePrivilegio($db, $sessionid, 54);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
