<?php
// cms/api/currencies/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Consultamos los valores
    $sql = "SELECT * FROM currencies".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Ordenamos los valores
    $row = $rs->fetch_assoc();
    
    //Retornamos 204 si no se encontro un registro
    if($row["id"] == null)
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["id"];
    $out->entry->name = $row["name"];
    $out->entry->symbol = $row["symbol"];
    $out->entry->icon = $row["icon"];
    $out->entry->decimals = (int)$row["decimals"];
    $out->entry->interface = (int)$row['interface'];
    
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["status"];
    $out->entry->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
    
    $out->entry->xfer = new stdClass();
    $out->entry->xfer->id = (int)$row['xfer'];
    $out->entry->xfer->dsc = $out->entry->xfer->id == 1 ? 'Activo' : 'Inactivo';
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 11);
    $access->read =   tienePrivilegio($db, $sessionid, 14);
    $access->update = tienePrivilegio($db, $sessionid, 12);
    $access->delete = tienePrivilegio($db, $sessionid, 13);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
