<?php
// cms/api/departments/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id",'dsc','email','phone');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET["id"]);
    $dsc = mysqli_real_escape_string($db, $_GET['dsc']);
    $email = mysqli_real_escape_string($db, $_GET['email']);
    $phone = mysqli_real_escape_string($db, $_GET['phone']);
    $phone2 = '';
    $phone3 = '';
    $hduser = '';
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    // Si recibimos el phone 2, lo guardamos
    if(isset($_GET['phone2']) && $_GET['phone2'] != ''){
        $phone2 = mysqli_real_escape_string($db, $_GET['phone2']);
    }
    
    // Si recibimos el phone 2, lo guardamos
    if(isset($_GET['phone3']) && $_GET['phone3'] != ''){
        $phone3 = mysqli_real_escape_string($db, $_GET['phone3']);
    }
    
    // Si recibimos el phone 2, lo guardamos
    if(isset($_GET['hduser']) && $_GET['hduser'] != ''){
        $hduser = mysqli_real_escape_string($db, $_GET['hduser']);
    }
    
    /* SI es 0, ingresamos un nuevo registro */
    if($id == 0){
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 74))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        // Validamos que no exista ya el mismo nombre
        $sql = "SELECT COUNT(*) AS qty FROM departments ".
        "       WHERE dsc = '".$dsc."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Si es mayor a 0 ya existe un registro
        if($row['qty'] > 0){
            badEnd("402",array("msg"=>"Registro duplicado"));
        }
        
        $sql = "INSERT INTO departments(dsc, email, phone1, phone2, phone3, helpdesk)".
        "       VALUES('".$dsc."','".$email."', ".
        "       '".$phone."', '".$phone2."', ".
        "       '".$phone3."', '".$hduser."')";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "DEPARTAMENTOS", $sessionid, "CMS", "Se agregó el departamento ".$dsc);
        
        
    }else{
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 75))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        // Validamos que existe el departamento
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM departments ".
        "       WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $rs->fetch_assoc();
        
        // Si es 0 no se pudo encontrar
        if($row['qty'] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        // Validamos que no exista ya el mismo nombre
        $sql = "SELECT COUNT(*) AS qty FROM departments ".
        "       WHERE dsc = '".$dsc."'".
        "       AND id != ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Si es mayor a 0 ya existe un registro
        if($row['qty'] > 0){
            badEnd("402",array("msg"=>"Registro duplicado"));
        }
        
        // Actualizamos el registro
        $sql = "UPDATE departments SET ".
        "       dsc = '".$dsc."', ".
        "       email = '".$email."', ".
        "       phone1 = '".$phone."', ".
        "       phone2 = '".$phone2."', ".
        "       phone3 = '".$phone3."', ".
        "       helpdesk = '".$hduser."' ".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "DEPARTAMENTOS", $sessionid, "CMS", "Se actualizó el departamento ".$dsc);
        
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
