<?php
// cms/api/messages/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('id','msg',"sessionid",'email','sms', 'date','ref');
    if (!parametrosValidos($_POST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    
    //Definimos las variables que usaremos y las inicializamos
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_POST["sessionid"]);
    $id = mysqli_real_escape_string($db, $_POST['id']);
    $msg = mysqli_real_escape_string($db, $_POST['msg']);
    $email = mysqli_real_escape_string($db, $_POST['email']);
    $sms = mysqli_real_escape_string($db, $_POST['sms']);
    $date = mysqli_real_escape_string($db, $_POST['date']);
    $ref = mysqli_real_escape_string($db, $_POST['ref']);
    $tags = '';
    $userids = '';
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 73))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que recibimos tags o userids
    if(isset($_POST['tags']) && $_POST['tags'] != ''){
        $tags = $_POST['tags'];
    }else if(isset($_POST['userids']) && $_POST['userids'] != ''){
        $userids = $_POST['userids'];
    }else{
        badEnd('500',array('msg'=>'Debe enviar userids o tags'));
    }
    
    // Validamos tener almenos userids o tags
    if($tags == '' && $userids == ''){
        badEnd('500',array('msg'=>'Debe enviar userids o tags'));
    }
    
    // Si se tiene que enviar mensaje, validamos su length
    if($sms == 1){//Limite probado con provedor 155 caracteres
        if(strlen($msg) > 155){
            //Si es mayor a 124 caracteres mandamos error
            badEnd("410", array('msg'=>"Mensaje muy largo para envio por SMS"));
        }
    }
    
    if($id == 0){
        
        // Obtenemos el arreglo de userids o tags
        if($userids != ''){
            $useridsArr = explode('-',$userids);
            
            foreach($useridsArr as $user){
                
                $emails = 'NULL';
                $smss = 'NULL';
                
                // Si se envia por correo obtenemos el correo del usuario
                if($email == 1){
                    $sql = "SELECT usr ".
                    "       FROM users ".
                    "       WHERE id = ".$user;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    $row = $rs->fetch_assoc();
                    
                    $emails = $row['usr'];
                }
                
                // SI se envia por sms, obtenemos el numero del usuario
                if($sms == 1){
                    $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                    "       FROM users ".
                    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                    "       WHERE users.id = ".$user;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    $row = $rs->fetch_assoc();
                    
                    $smss = $row['phone'];
                    
                }
            
                // Creamos el mensaje
                $sql = "INSERT INTO comunications(userid, type, ref, tags, message, sentdate, date, createddate, readed, email, sms)".
                "       VALUES(".
                "       ".$user.", ".
                "       2, ".
                "       ".$ref.", ".
                "       NULL,".
                "       '".$msg."', ".
                "       NULL, ".
                "       '".$date."', ".
                "       NOW(), ".
                "       NULL, ".
                "       ".($emails == 'NULL' ? 'NULL' : "'".$emails."'").", ".
                "       ".($smss == 'NULL' ? 'NULL' : "'".$smss."'")." ".
                "       )";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                // Obtenemos el correo del usuario
                $sql = "SELECT usr FROM users WHERE id = ".$user;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $userdata = $res->fetch_assoc();
                
                //auditoria
                setAudit($db, "MENSAJERÍA", $sessionid, "CMS", "Se envió un mensaje a ".$userdata['usr']);
            }
            
            $out->id = $userids;
            
        }else if($tags != ''){
            $tagsArr = explode(',',$tags);
            
            foreach($tagsArr as $tag){
                
                // Consultamos los usuarios por el tag
                $sql = "SELECT id, usr ".
                "       FROM users ".
                "       WHERE tag LIKE  '%".$tag."%'";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                while($row = $rs->fetch_assoc()){
                    $emails = 'NULL';
                    $smss = 'NULL';
                    
                    // Si se envia por correo obtenemos el correo del usuario
                    if($email == 1){
                        $emails = $row['usr'];
                    }
                    
                    // SI se envia por sms, obtenemos el numero del usuario
                    if($sms == 1){
                        $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                        "       FROM users ".
                        "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                        "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                        "       WHERE users.id = ".$row['id'];
                        if (!$res=$db->query($sql))
                            badEnd("500", array("msg"=>determinateDBError($db)));
                            
                        $rowPhone = $res->fetch_assoc();
                        
                        $smss = $rowPhone['phone'];
                        
                    }
                
                    // Creamos el mensaje
                    $sql = "INSERT INTO comunications(userid, type, ref, tags, message, sentdate, date, createddate, readed, email, sms)".
                    "       VALUES(".
                    "       ".$row['id'].", ".
                    "       2, ".
                    "       ".$ref.", ".
                    "       '".implode(',',$tagsArr)."', ".
                    "       '".$msg."', ".
                    "       NULL, ".
                    "       '".$date."', ".
                    "       NOW(), ".
                    "       NULL, ".
                    "       ".($emails == 'NULL' ? 'NULL' : "'".$emails."'").", ".
                    "       ".($smss == 'NULL' ? 'NULL' : "'".$smss."'")." ".
                    "       )";
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    
                    // Obtenemos el correo del usuario
                    $sql = "SELECT usr FROM users WHERE id = ".$row['id'];
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    $userdata = $res->fetch_assoc();
                    
                    //auditoria
                    setAudit($db, "MENSAJERÍA", $sessionid, "CMS", "Se envió un mensaje a ".$userdata['usr']);
                }
            }
            
            $out->id = $tags;
        }
        
    }else{
        // Validamos que el usuario no haya sido enviado
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM comunications".
        "       WHERE id = ".$id.
        "       AND sentdate IS NULL";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $rs->fetch_assoc();
        
        // Si es igual a 0, no puede ser editado
        if($row['qty'] == 0){
            badEnd('304',array('msg'=>'Registro no puede ser actualizado'));
        }
        
        // Obtenemos la fecha y el ref para actualizar todos los registros
        $sql = "SELECT * ".
        "       FROM comunications ".
        "       WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        $emails = '';
        $smss = '';
        
        // Obtenemos los correos y telefonos si hace falta
        if($userids != ''){
            $useridsArr = explode('-',$userids);
            
            foreach($useridsArr as $user){
                
                // Si se envia por correo obtenemos el correo del usuario
                if($email == 1){
                    $sql = "SELECT usr ".
                    "       FROM users ".
                    "       WHERE id = ".$user;
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    $rowEmail = $res->fetch_assoc();
                    
                    // Actualizamos el row donde este este usuario
                    $sql = 'UPDATE comunications SET '.
                    "       email = '".$rowEmail['usr']."'".
                    "       WHERE userid = ".$user.
                    "       AND createddate = '".$row['createddate']."'".
                    "       AND ref = '".$row['ref']."' ";
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                }else{
                    // Actualizamos el row donde este este usuario
                    $sql = 'UPDATE comunications SET '.
                    "       email = NULL".
                    "       WHERE userid = ".$user.
                    "       AND createddate = '".$row['createddate']."'".
                    "       AND ref = '".$row['ref']."' ";
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                // SI se envia por sms, obtenemos el numero del usuario
                if($sms == 1){
                    $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                    "       FROM users ".
                    "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                    "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                    "       WHERE users.id = ".$user;
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    $rowPhone = $res->fetch_assoc();
                    
                    // Actualizamos el row donde este este usuario
                    $sql = 'UPDATE comunications SET '.
                    "       sms = '".$rowPhone['phone']."'".
                    "       WHERE userid = ".$user.
                    "       AND createddate = '".$row['createddate']."'".
                    "       AND ref = '".$row['ref']."' ";
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    
                }else{
                    // Actualizamos el row donde este este usuario
                    $sql = 'UPDATE comunications SET '.
                    "       sms = NULL".
                    "       WHERE userid = ".$user.
                    "       AND createddate = '".$row['createddate']."'".
                    "       AND ref = '".$row['ref']."' ";
                    if (!$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                }
            }
            
        }else if($tags != ''){
            $tagsArr = explode('-',$tags);
            
            foreach($tagsArr as $tag){
                
                // Consultamos los usuarios por el tag
                $sql = "SELECT id, usr ".
                "       FROM users ".
                "       WHERE tag LIKE  '%".$tag."%'";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                while($rowTag = $res->fetch_assoc()){
                    $out->testing [] = $rowTag;
                    
                    // Si se envia por correo obtenemos el correo del usuario
                    if($email == 1){
                        
                        // Actualizamos el row donde este este usuario
                        $sql = 'UPDATE comunications SET '.
                        "       email = '".$rowTag['usr']."'".
                        "       WHERE userid = ".$rowTag['id'].
                        "       AND createddate = '".$row['createddate']."'".
                        "       AND ref = '".$row['ref']."' ";
                        if (!$db->query($sql))
                            badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    }else{
                        
                        // Actualizamos el row donde este este usuario
                        $sql = 'UPDATE comunications SET '.
                        "       email = NULL".
                        "       WHERE userid = ".$rowTag['id'].
                        "       AND createddate = '".$row['createddate']."'".
                        "       AND ref = '".$row['ref']."' ";
                        if (!$db->query($sql))
                            badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                    
                    // SI se envia por sms, obtenemos el numero del usuario
                    if($sms == 1){
                        $sql = "SELECT IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone ".
                        "       FROM users ".
                        "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
                        "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
                        "       WHERE users.id = ".$rowTag['id'];
                        if (!$resPhone=$db->query($sql))
                            badEnd("500", array("msg"=>determinateDBError($db)));
                            
                        $rowPhone = $resPhone->fetch_assoc();
                        
                        // Actualizamos el row donde este este usuario
                        $sql = 'UPDATE comunications SET '.
                        "       sms = '".$rowPhone['phone']."'".
                        "       WHERE userid = ".$rowTag['id'].
                        "       AND createddate = '".$row['createddate']."'".
                        "       AND ref = '".$row['ref']."' ";
                        if (!$db->query($sql))
                            badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    }else{
                        // Actualizamos el row donde este este usuario
                        $sql = 'UPDATE comunications SET '.
                        "       sms = NULL".
                        "       WHERE userid = ".$rowTag['id'].
                        "       AND createddate = '".$row['createddate']."'".
                        "       AND ref = '".$row['ref']."' ";
                        if (!$db->query($sql))
                            badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                }
            }
        }
        
        // Si seguimos aqui ya sabemos que existe y que no ha sido enviado
        // Actualizamos el mensaje
        $sql = "UPDATE comunications SET".
        "       message = '".$msg."', ".
        "       ref = ".$ref.", ".
        "       ".($tags != '' ? "tags = '".implode(',',$tagsArr)."', " : 'tags = NULL, ').
        "       date = '".$date."' ".
        "       WHERE createddate = '".$row['createddate']."' ".
        "       AND ref = '".$row['ref']."'";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "MENSAJERÍA", $sessionid, "CMS", "Se actualizó el mensaje ".$id);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
