<?php
// cms/api/preferences/savedsclevels

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'levelids');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $parmsob = array("sessionid",'levelids','dsc','dsc_eng');
    if(!isset($_GET['dsc'])  || !isset($_GET['dsc_eng'])){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $levelids = mysqli_real_escape_string($db, $_GET['levelids']);
    $dsc = mysqli_real_escape_string($db, $_GET['dsc']);
    $dscEng = mysqli_real_escape_string($db, $_GET['dsc_eng']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 56))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Validamos que los parametros tengan el mismo size para continuar
    $levelidsarr = explode('-',$levelids);
    $dscarr = explode('|',$dsc);
    
    // SI son distintos retornamos error
    if(count($dscarr) != count($levelidsarr)){
        badEnd('400',array('msg'=>'Parametros invalidos'));
    }
    
    //Recorremos los ids
    foreach($levelidsarr as $index => $levelid){
        
        // Recorremos las descripciones 
        foreach($dscarr as $indextwo => $dscwithid){
            //Si los indices son el mismo, actualizamos el registro
            if($index == $indextwo){
                //Consultamos el id para saber si existe
                $sql = "SELECT COUNT(id) AS qty FROM levels WHERE id = ".$levelid;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $row = $rs->fetch_assoc();
                
                //SI es igual a 0 no existe
                if($row['qty'] == 0){
                    badEnd('400',array('msg'=>'No encontrado: '.$levelid));
                }
                
                // Actualizamos la descripcion
                $sql = "UPDATE levels SET ".
                "       dsc = '".$dscwithid."'".
                "       WHERE id = ".$levelid;
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                // auditoria
                setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizó la descripción para el nivel ".$levelid); 
            }
        }
    }
    
    $dscarr = explode('|',$dscEng);
    
    // SI son distintos retornamos error
    if(count($dscarr) != count($levelidsarr)){
        badEnd('400',array('msg'=>'Parametros invalidos'));
    }
    
    //Recorremos los ids
    foreach($levelidsarr as $index => $levelid){
        
        // Recorremos las descripciones 
        foreach($dscarr as $indextwo => $dscwithid){
            //Si los indices son el mismo, actualizamos el registro
            if($index == $indextwo){
                //Consultamos el id para saber si existe
                $sql = "SELECT COUNT(id) AS qty FROM levels WHERE id = ".$levelid;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $row = $rs->fetch_assoc();
                
                //SI es igual a 0 no existe
                if($row['qty'] == 0){
                    badEnd('400',array('msg'=>'No encontrado: '.$levelid));
                }
                
                // Actualizamos la descripcion
                $sql = "UPDATE levels SET ".
                "       dsc_eng = '".$dscwithid."'".
                "       WHERE id = ".$levelid;
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                // auditoria
                setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizó la descripción para el nivel ".$levelid); 
            }
        }
    }
    
    $out->ids = $levelids;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
