<?php
// cms/api/preferences/savepay
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'maxtimereverse','maxamountsend','pctreverse', 'sessidtime', 'optime', 'payrefcurrid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $out->update = false;
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $maxtimereverse = mysqli_real_escape_string($db, $_GET['maxtimereverse']);
    $maxamountsend = mysqli_real_escape_string($db, $_GET['maxamountsend']);
    $pctreverse = mysqli_real_escape_string($db, $_GET['pctreverse']);
    $sessidtime = mysqli_real_escape_string($db, $_GET['sessidtime']);
    $optime = mysqli_real_escape_string($db, $_GET['optime']);
    $payrefcurrid = mysqli_real_escape_string($db, $_GET['payrefcurrid']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 56))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Validamos
    if($maxtimereverse < 0 || $maxamountsend < 0 || $pctreverse < 0 || $sessidtime < 0 || $optime < 0)
        badEnd("402", array("msg"=>"Valores no pueden ser negativos"));
    
    //Consultamos las preferencias
    $sql = "UPDATE cmspreferences SET ".
    "       payoptime = ".$optime.", ".
    "       paysessidtime = ".$sessidtime." ".
    "       WHERE cmspreferences.id = 1 ";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Retornamos si no se actualizo ningun registro
    if ($db->affected_rows > 0)
        $out->update = true;
        
    //Consultamos las preferencias
    $sql = "UPDATE cmspreffees SET ".
    "       pctreversepay = ".$pctreverse.", ".
    "       maxamountopsendpay = ".$maxamountsend.", ".
    "       maxtimereversepay = ".$maxtimereverse." ".
    "       WHERE cmspreffees.currencyid = -1 ";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Retornamos si no se actualizo ningun registro
    if ($db->affected_rows > 0)
        $out->update = true;
    
    //Se apagan las otras
    $sql = "UPDATE currencies SET ".
    "       payref = 0 ".
    "       WHERE id <> ". $payrefcurrid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));

    //Se enciende la que se envía
    $sql = "UPDATE currencies SET ".
    "       payref = 1 ".
    "       WHERE id = ". $payrefcurrid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    //Retornamos si no se actualizo ningun registro
    if ($db->affected_rows > 0)
        $out->update = true;
    
    //auditoria
    setAudit($db, "PREFERENCIAS", $sessionid, "CMS", "Se actualizaron las preferencias de Pay"); 
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
