<?php
// cms/api/privileges/saverolprivileges

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","rolid","privileges");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $rolid = mysqli_real_escape_string($db, $_GET["rolid"]);
    $privileges = mysqli_real_escape_string($db, $_GET["privileges"]);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Consultamos la cantidad de registros que tiene
    $sql = "SELECT COUNT(userid) AS qty ".
    "       FROM userprivileges ".
    "       WHERE userid = ".$rolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
    
    //SI tiene 0 privilegios es por que se esta creando, si no se esta modificando
    if($row['qty'] != 0){
        //Validamos que tenga privilegios para modificar
        if (!tienePrivilegio($db, $sessionid, 8))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
    }else{
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 7))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
    }
    //Consultamos el rol para validar que existe
    $sql = "SELECT name, type FROM cmsusers WHERE type = 1 AND id = ".$rolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $row = $rs->fetch_assoc();
    //Si el dato no existe retornamos 204
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    // Guardamos el nombre del rol 
    $nameRol = $row["name"];
    
    // Se eliminan los privilegios anteriores
    $sql = "DELETE FROM userprivileges WHERE userid=" . $rolid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    // Se eliminan los privilegios anteriores de los usuarios que tienen el rol asignado
    $sql = "DELETE FROM userprivileges WHERE userid IN " . 
    "       (SELECT id FROM cmsusers WHERE rolid=" . $rolid . ")";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    //Insertamos los privilegios
    $sql =  "INSERT INTO userprivileges(userid, privilegeid) " . 
    "       VALUES".validateInsert($privileges, $rolid);
    if (!$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    
    //Obtenemos los usuarios que tienen el rolid
    $sql = "SELECT id FROM cmsusers WHERE type = 0 AND rolid = ".$rolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    while($row = $rs->fetch_assoc()){
        // Se asignan los nuevos privilegios a los usuarios que tengan el rol asignado
        $sql =  "INSERT INTO userprivileges(userid, privilegeid) " . 
        "       VALUES".validateInsert($privileges, $row["id"]);
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
    }
        
    $out->rolid = $rolid;
    
    //auditoria
    setAudit($db, "ROLES", $sessionid, "CMS", "Se actualizaron los privilegios del rol ".$nameRol);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para insertar los diversos privilegios  */
    function validateInsert($privileges, $rolid){
        //Separamos cada privilegio para crear cadena e insertarlos
        $privs = explode("-", $privileges);
        $insertString = "";
        
        foreach ($privs as $priv){
            $insertString = $insertString."(".$rolid.", ".$priv."),";
        }
        
        
        return substr($insertString, 0, -1);
    }
?>
