<?php
// cms/api/rates/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array('sessionid','id', 'date', 'currencyid', 'amount');
    if (!parametrosValidos($_POST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_POST["sessionid"]);
    $id = mysqli_real_escape_string($db, $_POST["id"]);
    $date = mysqli_real_escape_string($db, $_POST['date']);
    $currencyid = mysqli_real_escape_string($db, $_POST['currencyid']);
    $amount = mysqli_real_escape_string($db, $_POST['amount']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si el id es igual a 0, se crea, si no se actualiza la region
    if($id == 0){
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 79))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        // Validamos que exista la moneda
        $sql = "SELECT COUNT(id) AS qty FROM currencies WHERE id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 404 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("404", array("msg"=>"No se encuentra la moneda"));
        }
        
        // Obtenemos la moneda para formatear monto
        $sql = "SELECT symbol, name, decimals FROM currencies WHERE id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        $sql = "INSERT INTO rateshistory(createddate, currencyid, amount)".
        "       VALUES ('".$date."', ".$currencyid.", '".number_format($amount, $row['decimals'], '.', '')."')";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "TASAS", $sessionid, "CMS", "Se agrego la tasa ".numberFormatt($amount, $row['decimals'])." ".$row['symbol']);
    }else{
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 80))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Consultamos para validar que el registro exista
        $sql = "SELECT COUNT(id) AS qty FROM rateshistory WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        // Validamos que exista la moneda
        $sql = "SELECT COUNT(id) AS qty FROM currencies WHERE id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 404 cuando la busqueda no obtiene resutados
        if($row["qty"] == 0){
            badEnd("404", array("msg"=>"No se encuentra la moneda"));
        }
        
        // Obtenemos la moneda para formatear monto
        $sql = "SELECT symbol, name, decimals FROM currencies WHERE id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        $sql = "UPDATE rateshistory SET".
        "       createddate = '".$date."', ".
        "       currencyid = '".$currencyid."', ".
        "       amount = '".number_format($amount, $row['decimals'], '.', '')."' ".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "TASAS", $sessionid, "CMS", "Se actualizo la tasa # ".$id." a ".numberFormatt($amount, $row['decimals'])." ".$row['symbol']);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
