<?php
// cms/api/transactions/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = mysqli_real_escape_string($db, $_GET["sessionid"]);
    $id = mysqli_real_escape_string($db, $_GET['id']);
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 40))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    $sql = "SELECT t.id AS txid, ".
    "       t.datecreated AS date, ".
    "       t.amount AS amount, ".
    "       t.dsc AS dsc, ".
    "       currencies.symbol AS currencysymbol, ".
    "       currencies.id AS currencyid, ".
    "       currencies.decimals AS decimals, ".
    "       t.txid AS txindexid, ".
    "       CASE ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
    "           WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
    "           WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' ".
    "           WHEN t.dsc LIKE '%comis%' THEN 'Comisión' END AS type, ".
    "       users.usr AS usr, ".
    "       users.id AS userid, ".
    "       userpersons.fname AS personname, ".
    "       userpersons.flastname AS personlastname, ".
    "       usercompanies.name AS companyname, ".
    "       usercompanies.comercialname AS companycomercialname ".
    "       FROM transactions t, accounts, currencies, users ".
    "           LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "          	LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       WHERE t.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       AND accounts.currencyid = currencies.id ".
    "       AND users.id > 0 ".
    "       AND t.amount != 0 ".
    "       AND t.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    //$out->entry->test = $row;
    $out->entry->id = (int)$row['txid'];
        
    $out->entry->amount = new stdClass();
    $out->entry->amount->number = $row['amount'];
    $out->entry->amount->formatted = numberFormatt($row['amount'],$row['decimals']);
        
    $out->entry->currency = new stdClass();
    $out->entry->currency->id = (int)$row['currencyid'];
    $out->entry->currency->symbol = $row['currencysymbol'];
    $out->entry->currency->decimals = $row['decimals'];
        
    $out->entry->user = new stdClass();
    $out->entry->user->id = (int)$row['userid'];
    $out->entry->user->usr = $row['usr'];
        
    if($row["personname"] == null){
        $out->entry->user->fullname = $row['companyname'].( $row['companycomercialname'] == "" ? '' : ' / '.$row['companycomercialname'] );
    }else{
        $out->entry->user->fullname = $row['personname'].( $row['personlastname'] == "" ? '' : ' '.$row['personlastname'] );
    }
        
    $out->entry->date = new stdClass();
    $out->entry->date->cannonical = date("Y-m-d H:i:s", strtotime($row["date"]));
    $out->entry->date->formatted = date("d/m/Y", strtotime($row["date"]))." ".date("H:i:s", strtotime($row["date"]));
        
    $out->entry->description = $row['dsc'];
        
    $out->entry->type = $row['type'];
    
    if($out->entry->type == 'Ajuste' && strpos($row['dsc'], 'pago móvil #') !== false){
        // SI es un ajuste a un retiro apgo movil no se pued bro
        $out->entry->editable = false;
    }else{
        $out->entry->editable = true;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out->entry));
    die();
?>
