//Variables globales
var cleared = null;
var sessionId = sessionStorage.getItem("sessionId");
var dataC = false;

window.onload = function () {
    initApp();

    addEvents();
}

function callDownload() {
    var req = {
        "datefrom": document.getElementById("addDate").value,
        "dateto": document.getElementById("addDate1").value,
        "sessionid": sessionId,
    }
    download("reports/accountingreport.php?sessionid=" + encodeURIComponent(req.sessionid) + "&datefrom=" + encodeURIComponent(req.datefrom) + "&dateto=" + encodeURIComponent(req.dateto));
    return;
}
function callDownloadXml() {
    var req = {
        "datefrom": document.getElementById("addDate").value,
        "dateto": document.getElementById("addDate1").value,
        "sessionid": sessionId,
    }
    download("reports/accountingreportXML.php?sessionid=" + encodeURIComponent(req.sessionid) + "&datefrom=" + encodeURIComponent(req.datefrom) + "&dateto=" + encodeURIComponent(req.dateto));
    return;
}


//Función para cargar listado
function loadList() {
    if (verifyData()) {
        document.getElementById('bodyTableCurrencies').style.display = "none";
        document.getElementById('noCurrencieDefine').style.display = "none";

        var req = {
            "datefrom": document.getElementById("addDate").value,
            "dateto": document.getElementById("addDate1").value,
            "sessionid": sessionId,
        }
        callWS("GET", "reports/accounting", req, respLoadReports);
        return 0;
    } else {
        document.getElementById('serviceTable').style.display = "none"
    }
}

function verifyData() {
    document.getElementById('noServiceTable').style.display = "none"
    var ok = true;
    var arrayData = []
    if (!document.getElementById("addDate").value) {
        arrayData.push('Fecha inicial')
    }
    if (!document.getElementById("addDate1").value) {
        arrayData.push('Fecha final')
    }


    if (arrayData.length > 0) {
        ok = false
        if (arrayData.length > 1) {
            document.getElementById('msgInTable').innerHTML = "Faltan los siguientes datos: "
            for (var i = 0; i < arrayData.length; i++) {
                if (i + 1 == arrayData.length) {
                    document.getElementById('msgInTable').innerHTML += ' y ' + arrayData[i] + '.'
                } else {
                    document.getElementById('msgInTable').innerHTML += arrayData[i] + ', '
                }
            }
        } else {
            document.getElementById('msgInTable').innerHTML = "Falta el siguiente dato: " + arrayData[0] + '.'
        }
        document.getElementById('bodyTableCurrencies').style.display = "table";
        document.getElementById('noCurrencieDefine').style.display = "table-cell";
    }
    return ok;
}

function drawReport(rsp) {
    console.log(rsp);
    document.getElementById("serviceTable").lastElementChild.innerHTML = "";
    document.getElementById("serviceTable").style.display = "";
    //Primera sección por tipo
    for (var i = 0; i < rsp.types.length; i++) {
        var repSection = document.createElement("div");
        repSection.classList.add("tableInf");
        //Head superior del titulo
        var type = document.createElement("div");
        type.innerHTML = "Asiento por " + rsp.types[i].dsc;
        type.classList.add("tblInfHead");
        repSection.appendChild(type);
        //Subtitutlo por moneda
        if (rsp.types[i].currencies !== undefined) {
            for (currency of rsp.types[i].currencies) {

                if (currency.records.length) {
                    var secName = document.createElement("div");
                    secName.classList.add("tableInfName");
                    secName.innerHTML = "<p>" + rsp.types[i].dsc + " en " + currency.name + "</p>";
                    repSection.appendChild(secName);

                    switch (rsp.types[i].id) {
                        case 1:
                        case 2://Deposito y Pago móvil
                            //Se pintan las lineas por operación

                            for (operation of currency.records) {
                                //Se pinta el header
                                var tblHd = document.createElement("div");
                                tblHd.classList.add("tblOp", "tblHead");
                                var col1 = document.createElement("div");//Date
                                col1.classList.add("tblOpCell", "opCellDate");
                                col1.innerHTML = "Fecha";
                                var col2 = document.createElement("div");//Cuenta
                                col2.classList.add("tblOpCell", "opCellAcc");
                                col2.innerHTML = "Cuenta";
                                var col3 = document.createElement("div");//Dsc
                                col3.classList.add("tblOpCell", "opCellDsc");
                                col3.innerHTML = "Descripción";
                                var col35 = document.createElement("div");//Tasa NEW añadido 3.5 (35)
                                col35.classList.add("tblOpCell", "opCellAmo");
                                col35.innerHTML = "Tasa";
                                var col4 = document.createElement("div");//Debe
                                col4.classList.add("tblOpCell", "opCellAmo");
                                col4.innerHTML = "Debe";
                                var col5 = document.createElement("div");//Haber
                                col5.classList.add("tblOpCell", "opCellAmo");
                                col5.innerHTML = "Haber";
                                tblHd.appendChild(col1); tblHd.appendChild(col2); tblHd.appendChild(col3); tblHd.appendChild(col35);
                                tblHd.appendChild(col4); tblHd.appendChild(col5);

                                repSection.appendChild(tblHd);
                                //Dibujar las 3 lineas para el tipo deposito
                                for (var x = 0; x < 3; x++) {
                                    var tblOp = document.createElement("div");
                                    tblOp.classList.add("tblOp");
                                    if ((x % 2) !== 0) tblOp.style.backgroundColor = "rgb(245 246 248 / 80%)";
                                    var col1 = document.createElement("div");//Date
                                    col1.classList.add("tblOpCell", "opCellDate");
                                    col1.innerHTML = operation.datecreated.formatted;
                                    var col2 = document.createElement("div");//Cuenta
                                    col2.classList.add("tblOpCell", "opCellAcc");
                                    var col3 = document.createElement("div");//Dsc
                                    col3.classList.add("tblOpCell", "opCellDsc");
                                    var col35 = document.createElement("div");//tasa
                                    col35.classList.add("tblOpCell", "opCellAmo");
                                    var col4 = document.createElement("div");//Debe
                                    col4.classList.add("tblOpCell", "opCellAmo");
                                    var col5 = document.createElement("div");//Haber
                                    col5.classList.add("tblOpCell", "opCellAmo");
                                    col35.innerHTML = operation.rate;
                                    //Valores que varian col2,col3,col4,col5
                                    if (x == 0) {//Transit
                                        col2.innerHTML = operation.transit.account;
                                        col3.innerHTML = operation.transit.subtype.dsc;
                                        col4.innerHTML = operation.transit.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 1) {//Income
                                        col2.innerHTML = operation.income.account;
                                        col3.innerHTML = operation.income.subtype.dsc;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.income.formatted;
                                    } else if (x == 2) {//Client
                                        col2.innerHTML = operation.client.account;
                                        col3.innerHTML = operation.client.subtype.dsc;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.client.formatted;
                                    }

                                    tblOp.appendChild(col1); tblOp.appendChild(col2); tblOp.appendChild(col3); tblOp.appendChild(col35);
                                    tblOp.appendChild(col4); tblOp.appendChild(col5);

                                    repSection.appendChild(tblOp);
                                }
                                //Subtotal suma del debe y el haber
                                var subTot = document.createElement("div");
                                subTot.classList.add("tableSubtotal");
                                var col1 = document.createElement("div");//dsc
                                col1.classList.add("cellSubtotDsc");
                                col1.innerHTML = "Subtotal " + rsp.types[i].dsc + " en " + currency.name;
                                var col15 = document.createElement("div");//Tasa
                                col15.classList.add("cellSubtotAmo");
                                col15.innerHTML = "";
                                var col2 = document.createElement("div");//Debe
                                col2.classList.add("cellSubtotAmo");
                                col2.innerHTML = operation.subtotal.debit.formatted;
                                var col3 = document.createElement("div");//Haber
                                col3.classList.add("cellSubtotAmo");
                                col3.innerHTML = operation.subtotal.credit.formatted;


                                subTot.appendChild(col1); subTot.appendChild(col15); subTot.appendChild(col2);
                                subTot.appendChild(col3);
                                repSection.appendChild(subTot);
                            }
                            break;
                        case 3:
                        case 4://Retiros
                            //Se pintan las lineas por operación

                            for (operation of currency.records) {
                                //Se pinta el header
                                var tblHd = document.createElement("div");
                                tblHd.classList.add("tblOp", "tblHead");
                                var col1 = document.createElement("div");//Date
                                col1.classList.add("tblOpCell", "opCellDate");
                                col1.innerHTML = "Fecha";
                                var col2 = document.createElement("div");//Cuenta
                                col2.classList.add("tblOpCell", "opCellAcc");
                                col2.innerHTML = "Cuenta";
                                var col3 = document.createElement("div");//Dsc
                                col3.classList.add("tblOpCell", "opCellDsc");
                                col3.innerHTML = "Descripción";
                                var col35 = document.createElement("div");//Tasa NEW añadido 3.5 (35)
                                col35.classList.add("tblOpCell", "opCellAmo");
                                col35.innerHTML = "Tasa";
                                var col4 = document.createElement("div");//Debe
                                col4.classList.add("tblOpCell", "opCellAmo");
                                col4.innerHTML = "Debe";
                                var col5 = document.createElement("div");//Haber
                                col5.classList.add("tblOpCell", "opCellAmo");
                                col5.innerHTML = "Haber";
                                tblHd.appendChild(col1); tblHd.appendChild(col2); tblHd.appendChild(col3); tblHd.appendChild(col35);
                                tblHd.appendChild(col4); tblHd.appendChild(col5);

                                repSection.appendChild(tblHd);
                                //Dibujar las 3 lineas para el tipo deposito
                                for (var x = 0; x < 3; x++) {
                                    var tblOp = document.createElement("div");
                                    tblOp.classList.add("tblOp");
                                    if ((x % 2) !== 0) tblOp.style.backgroundColor = "rgb(245 246 248 / 80%)";
                                    var col1 = document.createElement("div");//Date
                                    col1.classList.add("tblOpCell", "opCellDate");
                                    col1.innerHTML = operation.datecreated.formatted;
                                    var col2 = document.createElement("div");//Cuenta
                                    col2.classList.add("tblOpCell", "opCellAcc");
                                    var col3 = document.createElement("div");//Dsc
                                    col3.classList.add("tblOpCell", "opCellDsc");
                                    var col35 = document.createElement("div");//tasa
                                    col35.classList.add("tblOpCell", "opCellAmo");
                                    var col4 = document.createElement("div");//Debe
                                    col4.classList.add("tblOpCell", "opCellAmo");
                                    var col5 = document.createElement("div");//Haber
                                    col5.classList.add("tblOpCell", "opCellAmo");
                                    col35.innerHTML = operation.rate;
                                    //Valores que varian col2,col3,col4,col5
                                    if (x == 0) {//Transit
                                        col2.innerHTML = operation.transit.account;
                                        col3.innerHTML = operation.transit.subtype.dsc;
                                        col4.innerHTML = operation.transit.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 1) {//Income
                                        col2.innerHTML = operation.income.account;
                                        col3.innerHTML = operation.income.subtype.dsc;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.income.formatted;
                                    } else if (x == 2) {//Client
                                        col2.innerHTML = operation.client.account;
                                        col3.innerHTML = operation.client.subtype.dsc;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.client.formatted;
                                    }

                                    tblOp.appendChild(col1); tblOp.appendChild(col2); tblOp.appendChild(col3); tblOp.appendChild(col35);
                                    tblOp.appendChild(col4); tblOp.appendChild(col5);

                                    repSection.appendChild(tblOp);
                                }
                                //Subtotal suma del debe y el haber
                                var subTot = document.createElement("div");
                                subTot.classList.add("tableSubtotal");
                                var col1 = document.createElement("div");//dsc
                                col1.classList.add("cellSubtotDsc");
                                col1.innerHTML = "Subtotal " + rsp.types[i].dsc + " en " + currency.name;
                                var col15 = document.createElement("div");//Tasa
                                col15.classList.add("cellSubtotAmo");
                                col15.innerHTML = "";
                                var col2 = document.createElement("div");//Debe
                                col2.classList.add("cellSubtotAmo");
                                col2.innerHTML = operation.subtotal.debit.formatted;
                                var col3 = document.createElement("div");//Haber
                                col3.classList.add("cellSubtotAmo");
                                col3.innerHTML = operation.subtotal.credit.formatted;

                                subTot.appendChild(col1); subTot.appendChild(col15); subTot.appendChild(col2);
                                subTot.appendChild(col3);
                                repSection.appendChild(subTot);
                            }
                            break;
                        case 6://Transferencia
                            //Se pintan las lineas por operación

                            for (operation of currency.records) {
                                //Se pinta el header
                                var tblHd = document.createElement("div");
                                tblHd.classList.add("tblOp", "tblHead");
                                var col1 = document.createElement("div");//Date
                                col1.classList.add("tblOpCell", "opCellDate");
                                col1.innerHTML = "Fecha";
                                var col2 = document.createElement("div");//Cuenta
                                col2.classList.add("tblOpCell", "opCellAcc");
                                col2.innerHTML = "Cuenta";
                                var col3 = document.createElement("div");//Dsc
                                col3.classList.add("tblOpCell", "opCellDsc");
                                col3.innerHTML = "Descripción";
                                var col35 = document.createElement("div");//Tasa NEW añadido 3.5 (35)
                                col35.classList.add("tblOpCell", "opCellAmo");
                                col35.innerHTML = "Tasa";
                                var col4 = document.createElement("div");//Debe
                                col4.classList.add("tblOpCell", "opCellAmo");
                                col4.innerHTML = "Debe";
                                var col5 = document.createElement("div");//Haber
                                col5.classList.add("tblOpCell", "opCellAmo");
                                col5.innerHTML = "Haber";
                                tblHd.appendChild(col1); tblHd.appendChild(col2); tblHd.appendChild(col3); tblHd.appendChild(col35);
                                tblHd.appendChild(col4); tblHd.appendChild(col5);

                                repSection.appendChild(tblHd);
                                //Dibujar las 3 lineas para el tipo deposito
                                for (var x = 0; x < 4; x++) {
                                    var tblOp = document.createElement("div");
                                    tblOp.classList.add("tblOp");
                                    if ((x % 2) !== 0) tblOp.style.backgroundColor = "rgb(245 246 248 / 80%)";
                                    var col1 = document.createElement("div");//Date
                                    col1.classList.add("tblOpCell", "opCellDate");
                                    col1.innerHTML = operation.datecreated.formatted;
                                    var col2 = document.createElement("div");//Cuenta
                                    col2.classList.add("tblOpCell", "opCellAcc");
                                    var col3 = document.createElement("div");//Dsc
                                    col3.classList.add("tblOpCell", "opCellDsc");
                                    var col35 = document.createElement("div");//tasa
                                    col35.classList.add("tblOpCell", "opCellAmo");
                                    var col4 = document.createElement("div");//Debe
                                    col4.classList.add("tblOpCell", "opCellAmo");
                                    var col5 = document.createElement("div");//Haber
                                    col5.classList.add("tblOpCell", "opCellAmo");
                                    col35.innerHTML = operation.rate;
                                    //Valores que varian col2,col3,col4,col5
                                    if (x == 0) {//Transit
                                        col2.innerHTML = operation.transit.account;
                                        col3.innerHTML = operation.transit.subtype.dsc;
                                        col4.innerHTML = operation.transit.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 1) {//Income
                                        col2.innerHTML = operation.income.account;
                                        col3.innerHTML = operation.income.subtype.dsc;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.income.formatted;
                                    } else if (x == 2) {//Custody
                                        col2.innerHTML = operation.custody.account;
                                        col3.innerHTML = operation.custody.subtype.dsc;
                                        col4.innerHTML = operation.custody.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 3) {//Custody2
                                        col2.innerHTML = operation.custody2.account;
                                        col3.innerHTML = operation.custody2.subtype.dsc;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.custody2.formatted;
                                    }

                                    tblOp.appendChild(col1); tblOp.appendChild(col2); tblOp.appendChild(col3); tblOp.appendChild(col35);
                                    tblOp.appendChild(col4); tblOp.appendChild(col5);

                                    repSection.appendChild(tblOp);
                                }
                                //Subtotal suma del debe y el haber
                                var subTot = document.createElement("div");
                                subTot.classList.add("tableSubtotal");
                                var col1 = document.createElement("div");//dsc
                                col1.classList.add("cellSubtotDsc");
                                col1.innerHTML = "Subtotal " + rsp.types[i].dsc + " en " + currency.name;
                                var col15 = document.createElement("div");//tasa
                                col15.classList.add("cellSubtotAmo");
                                col15.innerHTML = "";
                                var col2 = document.createElement("div");//Debe
                                col2.classList.add("cellSubtotAmo");
                                col2.innerHTML = operation.subtotal.debit.formatted;
                                var col3 = document.createElement("div");//Haber
                                col3.classList.add("cellSubtotAmo");
                                col3.innerHTML = operation.subtotal.credit.formatted;

                                subTot.appendChild(col1); subTot.appendChild(col15); subTot.appendChild(col2);
                                subTot.appendChild(col3);
                                repSection.appendChild(subTot);
                            }
                            break;
                    }
                    //Total suma del debe y el haber
                    var tot = document.createElement("div");
                    tot.classList.add("tableTot");
                    var col1 = document.createElement("div");//dsc
                    col1.classList.add("cellSubtotDsc");
                    col1.innerHTML = "Total " + rsp.types[i].dsc + " en " + currency.name;
                    var col15 = document.createElement("div");//Debe
                    col15.classList.add("cellSubtotAmo");
                    col15.innerHTML = "";
                    var col2 = document.createElement("div");//Debe
                    col2.classList.add("cellSubtotAmo");
                    col2.innerHTML = currency.total.debit.formatted;
                    var col3 = document.createElement("div");//Haber
                    col3.classList.add("cellSubtotAmo");
                    col3.innerHTML = currency.total.credit.formatted;

                    tot.appendChild(col1); tot.appendChild(col15); tot.appendChild(col2);
                    tot.appendChild(col3);
                    repSection.appendChild(tot);
                }
            }
        }
        if (rsp.types[i].pairs !== undefined) {
            for (pair of rsp.types[i].pairs) {
                if (pair.records.length) {
                    var secName = document.createElement("div");
                    secName.classList.add("tableInfName");
                    secName.innerHTML = "<p>" + rsp.types[i].dsc + " en " + pair.symbol + "</p>";
                    repSection.appendChild(secName);

                    switch (rsp.types[i].id) {
                        case 5://Intercambios
                            //Se pintan las lineas por operación
                            for (operation of pair.records) {
                                //Se pinta el header
                                var tblHd = document.createElement("div");
                                tblHd.classList.add("tblOp", "tblHead");
                                var col1 = document.createElement("div");//Date
                                col1.classList.add("tblOpCell", "opCellDate");
                                col1.innerHTML = "Fecha";
                                var col2 = document.createElement("div");//Cuenta
                                col2.classList.add("tblOpCell", "opCellAcc");
                                col2.innerHTML = "Cuenta";
                                var col3 = document.createElement("div");//Dsc
                                col3.classList.add("tblOpCell", "opCellDsc");
                                col3.innerHTML = "Descripción";
                                var col35 = document.createElement("div");//Tasa NEW añadido 3.5 (35)
                                col35.classList.add("tblOpCell", "opCellAmo");
                                col35.innerHTML = "Tasa";
                                var col4 = document.createElement("div");//Debe
                                col4.classList.add("tblOpCell", "opCellAmo");
                                col4.innerHTML = "Debe";
                                var col5 = document.createElement("div");//Haber
                                col5.classList.add("tblOpCell", "opCellAmo");
                                col5.innerHTML = "Haber";
                                tblHd.appendChild(col1); tblHd.appendChild(col2); tblHd.appendChild(col3); tblHd.appendChild(col35);
                                tblHd.appendChild(col4); tblHd.appendChild(col5);

                                repSection.appendChild(tblHd);
                                //Dibujar las 4 lineas para el tipo deposito
                                for (var x = 0; x < 8; x++) {
                                    var tblOp = document.createElement("div");
                                    tblOp.classList.add("tblOp");
                                    if ((x % 2) !== 0) tblOp.style.backgroundColor = "rgb(245 246 248 / 80%)";
                                    var col1 = document.createElement("div");//Date
                                    col1.classList.add("tblOpCell", "opCellDate");
                                    col1.innerHTML = operation.datecreated.formatted;
                                    var col2 = document.createElement("div");//Cuenta
                                    col2.classList.add("tblOpCell", "opCellAcc");
                                    var col3 = document.createElement("div");//Dsc
                                    col3.classList.add("tblOpCell", "opCellDsc");
                                    var col35 = document.createElement("div");//rate
                                    col35.classList.add("tblOpCell", "opCellAmo");
                                    var col4 = document.createElement("div");//Debe
                                    col4.classList.add("tblOpCell", "opCellAmo");
                                    var col5 = document.createElement("div");//Haber
                                    col5.classList.add("tblOpCell", "opCellAmo");

                                    //Valores que varian col2,col3,col4,col5
                                    //Valores que varian col2,col3,col4,col5
                                    if (x == 0) {//Transit
                                        col2.innerHTML = operation.custodybase.account;
                                        col3.innerHTML = operation.custodybase.subtype.dsc;
                                        col35.innerHTML = operation.rateBase;
                                        col4.innerHTML = operation.custodybase.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 1) {//Income
                                        col2.innerHTML = operation.custodyref.account;
                                        col3.innerHTML = operation.custodyref.subtype.dsc;
                                        col35.innerHTML = operation.rateRef;
                                        col4.innerHTML = operation.custodyref.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 2) {//Custody
                                        col2.innerHTML = operation.incomebase.account;
                                        col3.innerHTML = operation.incomebase.subtype.dsc;
                                        col35.innerHTML = operation.rateBase;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.incomebase.formatted;
                                    } else if (x == 3) {//Custody2
                                        col2.innerHTML = operation.incomeref.account;
                                        col3.innerHTML = operation.incomeref.subtype.dsc;
                                        col35.innerHTML = operation.rateRef;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.incomeref.formatted;
                                    } else if (x == 4) {//Transit
                                        col2.innerHTML = operation.transitbase.account;
                                        col3.innerHTML = operation.transitbase.subtype.dsc;
                                        col35.innerHTML = operation.rateBase;
                                        col4.innerHTML = operation.transitbase.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 5) {//Income
                                        col2.innerHTML = operation.custodybase2.account;
                                        col3.innerHTML = operation.custodybase2.subtype.dsc;
                                        col35.innerHTML = operation.rateBase;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.custodybase2.formatted;
                                    } else if (x == 6) {//Transit
                                        col2.innerHTML = operation.transitref.account;
                                        col3.innerHTML = operation.transitref.subtype.dsc;
                                        col35.innerHTML = operation.rateRef;
                                        col4.innerHTML = operation.transitref.formatted;
                                        col5.innerHTML = "";
                                    } else if (x == 7) {//Income
                                        col2.innerHTML = operation.custodyref2.account;
                                        col3.innerHTML = operation.custodyref2.subtype.dsc;
                                        col35.innerHTML = operation.rateRef;
                                        col4.innerHTML = "";
                                        col5.innerHTML = operation.custodyref2.formatted;
                                    }

                                    tblOp.appendChild(col1); tblOp.appendChild(col2); tblOp.appendChild(col3); tblOp.appendChild(col35);
                                    tblOp.appendChild(col4); tblOp.appendChild(col5);

                                    repSection.appendChild(tblOp);
                                }
                                //Subtotal suma del debe y el haber
                                var subTot = document.createElement("div");
                                subTot.classList.add("tableSubtotal");
                                var col1 = document.createElement("div");//dsc
                                col1.classList.add("cellSubtotDsc");
                                col1.innerHTML = "Subtotal " + rsp.types[i].dsc + " en " + pair.symbol;
                                var col15 = document.createElement("div");//rate
                                col15.classList.add("cellSubtotAmo");
                                col15.innerHTML = "";
                                var col2 = document.createElement("div");//Debe
                                col2.classList.add("cellSubtotAmo");
                                col2.innerHTML = operation.subtotal.debit.formatted;
                                var col3 = document.createElement("div");//Haber
                                col3.classList.add("cellSubtotAmo");
                                col3.innerHTML = operation.subtotal.credit.formatted;

                                subTot.appendChild(col1); subTot.appendChild(col15); subTot.appendChild(col2);
                                subTot.appendChild(col3);
                                repSection.appendChild(subTot);



                            }
                            break;
                    }
                    //Total suma del debe y el haber
                    var tot = document.createElement("div");
                    tot.classList.add("tableTot");
                    var col1 = document.createElement("div");//dsc
                    col1.classList.add("cellSubtotDsc");
                    col1.innerHTML = "Total " + rsp.types[i].dsc + " en " + pair.symbol;
                    var col2 = document.createElement("div");//Debe
                    col2.classList.add("cellSubtotAmo");
                    col2.innerHTML = pair.total.debit.formatted;
                    var col3 = document.createElement("div");//Haber
                    col3.classList.add("cellSubtotAmo");
                    col3.innerHTML = pair.total.credit.formatted;

                    tot.appendChild(col1); tot.appendChild(col2);
                    tot.appendChild(col3);
                    repSection.appendChild(tot);
                }
            }
        }

        document.getElementById("serviceTable").lastElementChild.appendChild(repSection);
    }
}

function addEvents() {

    document.getElementById("addDate").addEventListener("focusout", function () {
        // Fecha desde
        // Validamos que sea menor o igual a la fecha final

        if (document.getElementById('addDate1').value == '') {
            loadList();
        } else {
            if (this.value <= document.getElementById('addDate1').value) {
                loadList();
            } else {
                let msg = document.getElementById('msgInTable');

                msg.innerHTML = "Fecha inicial debe ser menor o igual a la fecha final";
                msg.classList.add("msgError");
                msg.style.display = "block";
                setTimeout(function () {
                    msg.classList.remove("msgError");
                    msg.style.display = "none";
                }, 3000);
            }
        }
    });

    document.getElementById("addDate1").addEventListener("focusout", function () {
        // Fecha hasta
        // Validamos que sea mayor o igual a la otra fecha inicial

        if (document.getElementById("addDate").value == '') {
            loadList();
        } else {
            if (this.value >= document.getElementById("addDate").value) {
                loadList();
            } else {
                let msg = document.getElementById('msgInTable');

                console.log(msg);
                msg.innerHTML = "Fecha final debe ser mayor o igual a la fecha inicial";
                msg.classList.add("msgError");
                msg.style.display = "block";
                setTimeout(function () {
                    msg.classList.remove("msgError");
                    msg.style.display = "none";
                }, 3000);
            }
        }
    });
    document.getElementById("downloadData").addEventListener('click', function () {
        var modal = document.getElementById("myModal");
        modal.style.display = "block";
        // callDownload();
    });
    document.getElementById("downloadExcel").addEventListener("click", function () {
        callDownload();
    });
    document.getElementById("downloadXml").addEventListener("click", function () {
        callDownloadXml();
    });
    //Cerrar modal
    document.getElementById("closeModal").addEventListener("click", function () {
        var modal = document.getElementById("myModal");
        modal.style.display = "none";
    });

}

function respLoadReports(status, rsp) {
    switch (status) {
        case 200:
            drawReport(JSON.parse(rsp));
            //putInf(JSON.parse(rsp))
            //if(currencies.records!==null)addOptions("modulFilter",currencies.records);
            break;
        case 400:
            console.log(rsp);
            break;
        case 401:
            document.getElementById('msgInTable').innerHTML = "Sesión expirada o inválida, vuelva a iniciar sesión";
            document.getElementById('msgInTable').classList.add("msgError");
            document.getElementById('msgInTable').style.display = "block";
            setTimeout(function () {
                document.getElementById('msgInTable').classList.remove("msgError");
                myLogout()
                document.getElementById('msgInTable').style.display = "none";
            }, 3000);
            break;
        case 403:
            document.getElementById('msgInTable').innerHTML = JSON.parse(rsp).msg;
            document.getElementById('msgInTable').classList.add("msgError");
            document.getElementById('msgInTable').style.display = "block";
            document.getElementById('bodyTableCurrencies').style.display = "table"
            document.getElementById('noCurrencieDefine').style.display = "table-cell"
            break;
        case 500:
            console.log(rsp);
            break;
        default:
            console.log(rsp);
    }
}

function putInf(inf) {
    console.log(inf)
    putRates(inf)
    putTags(inf)
    putTotalVes(inf)
    putTotals(inf)
    putRecords(inf)
}

function putRates(inf) {
    var temporalRates = "Tasa de cambio vigente: "
    if (inf.rates[0]) {
        temporalRates += "&nbsp;&nbsp;&nbsp;" + inf.rates[0].pair + "&nbsp;&nbsp;&nbsp;<span>" + inf.rates[0].lastprice.formatted + " </span>&nbsp;&nbsp;&nbsp;"
    }
    for (i = 1; i < inf.rates.length; i++) {
        temporalRates += "| &nbsp;&nbsp;&nbsp;" + inf.rates[i].pair + "&nbsp;&nbsp;&nbsp;<span>" + inf.rates[i].lastprice.formatted + " </span>&nbsp;&nbsp;&nbsp;"
    }
    document.getElementById('infT').innerHTML = temporalRates
}

function putTotalVes(inf) {
    document.getElementById('totalVESinffee').innerHTML = inf.totalVES ? inf.totalVES.formatted : 'N/A'
}

function putTags(inf) {
    document.getElementById('tagName').innerHTML = "Totales Fee " + inf.tags
}

function putTotals(inf) {
    drawTotals(inf.totals)
}

function drawTotals(rsp) {
    var tbl;
    var node;
    var error;
    var withWhiteBorder;
    var withoutWhiteBorder
    tbl = document.getElementById('totalsClass').children[0]
    node = tbl.children[0].cloneNode(true);
    error = tbl.children[0].cloneNode(true);
    withWhiteBorder = tbl.children[0]
    withoutWhiteBorder = tbl.children[1]
    tbl.innerHTML = "";
    //tbl.appendChild(error);
    var tmp = null; tmp = node.cloneNode(true);
    if ((rsp.numofrecords == 0)) {
        //var ele = null;
        //ele = tmp.cloneNode(true);
        //ele.style.display = "none";
        //tbl.appendChild(ele);
    } else {
        for (var i = 0; i < rsp.length; i++) {
            var ele = null;
            if (i + 1 == rsp.length) {
                ele = withoutWhiteBorder.cloneNode(true);
            } else {
                ele = withWhiteBorder.cloneNode(true);
            }
            ele.children[0].children[0].children[0].innerHTML = rsp[i].currency.symbol
            ele.children[0].children[1].children[0].innerHTML = rsp[i].formatted
            ele.style.display = "table-cell";
            ele.style.width = 100 / parseInt(rsp.length) + "%";
            tbl.appendChild(ele);
        }
    }
}

function putRecords(inf) {
    drawReportsInmp(inf.records)
}

function drawReportsInmp(rsp) {
    //console.log(rsp)
    var tbl;
    var node;
    var error;
    tbl = document.getElementById('reportImp')
    node = tbl.children[0].cloneNode(true);
    //error = tbl.children[0].cloneNode(true);
    tbl.innerHTML = "";
    //tbl.appendChild(error);
    var tmp = null; tmp = node.cloneNode(true);
    if ((rsp.numofrecords == 0)) {
        //var ele = null;
        //ele = tmp.cloneNode(true);
        //ele.style.display = "none";
        //tbl.appendChild(ele);
    } else {
        for (var i = 0; i < rsp.length; i++) {

            //console.log('-------------',i)

            var ele = null;
            ele = node.cloneNode(true);

            //console.log(rsp[i])
            // Name  
            ele.children[0].children[0].innerHTML = "<span class='tableInfNamePrincipal'>" + (rsp[i].fullname ? rsp[i].fullname : "N/A") + " </span> " + rsp[i].usr + " &nbsp;&nbsp;&nbsp; (Registrado el " + rsp[i].datecreated.formatted + " )"


            // Accounts
            //var nodeAccounts = null
            //console.log(ele)
            var nodeAccounts = ele.children[1].children[0].cloneNode(true);

            var nodeAccountsInt = ele.children[1].children[0].children[1].children[1].cloneNode(true);

            ele.children[1].innerHTML = ""
            //console.log(ele.children[1])
            //console.log(nodeAccounts)

            if ((rsp[i].accounts.length == 0)) {

            } else {

                var secondDiv, secondDivImg;
                var secondDivE, secondDivImgE;
                for (var j = 0; j < rsp[i].accounts.length; j++) {
                    //console.log(rsp[i].accounts[j])
                    secondDivImg = document.createElement("span")
                    secondDivImg.className = "divImg";
                    secondDiv = document.createElement("div");
                    secondDiv.className = "second";
                    secondDiv = nodeAccounts.cloneNode(true);
                    secondDiv.appendChild(secondDivImg);
                    secondDiv.children[0].children[0].innerHTML = "<span class='tableInfNamePrincipal'>" + rsp[i].accounts[j].currency.name +
                        " - </span>  <span class='spanIcon'>" +
                        "</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  <span> " + rsp[i].accounts[j].currency.symbol +
                        "</span> &nbsp;&nbsp;&nbsp; " + " (Creación del wallet el " + rsp[i].accounts[j].datecreated.formatted + ")"
                    for (var z = 0; z < icons.length; z++) {
                        if (icons[z].name == rsp[i].accounts[j].currency.name) {
                            secondDiv.children[0].children[0].children[1].setAttribute("style", "background-image:url('" + icons[z].url + "')");
                        }
                    }

                    ele.children[1].appendChild(secondDiv);
                }
            }

            tbl.appendChild(ele);

            drawExchange(rsp, i)
            drawSubtotalPerson(rsp, i)
        }
    }
}

function drawSubtotalPerson(rsp, i) {
    //console.log(rsp)
    document.getElementsByClassName('tagNameSubt')[i].innerHTML = "Subtotal " + (rsp[i].fullname ? rsp[i].fullname : "N/A")

    var tbl;
    var node;
    var error;
    var withWhiteBorder;
    var withoutWhiteBorder
    tbl = document.getElementsByClassName('totalsClassS')[i].children[0]
    node = tbl.children[0].cloneNode(true);
    error = tbl.children[0].cloneNode(true);
    withWhiteBorder = tbl.children[0]
    withoutWhiteBorder = tbl.children[1]
    tbl.innerHTML = "";
    var tmp = null; tmp = node.cloneNode(true);
    for (var j = 0; j < rsp[i].accounts.length; j++) {
        var ele = null;
        if (j + 1 == rsp[i].length) {
            ele = withoutWhiteBorder.cloneNode(true);
        } else {
            ele = withWhiteBorder.cloneNode(true);
        }
        ele.children[0].children[0].children[0].innerHTML = rsp[i].accounts[j].currency.symbol
        ele.children[0].children[1].children[0].innerHTML = rsp[i].accounts[j].subtotal.formatted
        ele.style.display = "table-cell";
        ele.style.width = 100 / parseInt(rsp[i].accounts.length) + "%";
        tbl.appendChild(ele);
    }
}

function drawExchange(rsp, i) {
    //console.log('drawExchange')
    //console.log(rsp)
    //console.log(i)
    var tbl;
    var node;
    var subtotal;
    if (rsp[i].accounts.length > 0) {
        var total = document.getElementsByClassName('feesTTT').length
        var me = document.getElementsByClassName('feesTTT').length - rsp[i].accounts.length
        for (var z = 0; z < total; z++) {
            if (document.getElementsByClassName('feesTTT')[z].children.length > 0) {
                tbl = document.getElementsByClassName('feesTTT')[z]
                //console.log(tbl)
                if (document.getElementsByClassName('feesTTT')[z].children.length > 1) {
                    node = tbl.children[0].cloneNode(true);
                    subtotal = tbl.children[1].cloneNode(true);
                } else {
                    subtotal = tbl.children[0].cloneNode(true);
                }
                //console.log('node',node)
            }
            if (z > me - 1) {
                document.getElementsByClassName('feesTTT')[z].innerHTML = "";
            }
        }
        //console.log(tbl)
        for (var j = 0; j < rsp[i].accounts.length; j++) {

            //.log(total)
            var ele = null;
            //console.log(me)
            //console.log(me + j) // Iterar
            ele = node.cloneNode(true);
            ele2 = subtotal.cloneNode(true)
            /*if(i+1 == rsp.length){
                ele = withoutWhiteBorder.cloneNode(true);
            }else{
                ele = withWhiteBorder.cloneNode(true);
            }
            ele.children[0].children[0].children[0].innerHTML = rsp[i].currency.symbol
            ele.children[0].children[1].children[0].innerHTML = rsp[i].formatted
            ele.style.display = "table-cell";
            ele.style.width = 100/parseInt(rsp.length) + "%";*/
            //console.log(me+j)
            //document.getElementsByClassName('feesTTT')[me+j].appendChild(ele); 
            for (var k = 0; k < rsp[i].accounts[j].exchanges.length; k++) {
                ele = node.cloneNode(true);
                if (k % 2 != 0) {
                    ele.classList.add('rowImpar')
                }
                ele.children[0].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].datecreated.formatted
                ele.children[1].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].id
                ele.children[2].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].pair
                ele.children[3].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].order.side
                ele.children[4].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].order.id
                ele.children[5].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].feeamount.formatted
                ele.children[6].children[0].children[0].innerHTML = rsp[i].accounts[j].exchanges[k].feeallies.formatted

                document.getElementsByClassName('feesTTT')[me + j].appendChild(ele);
            }
            //console.log(ele2.children[0].children[0].children[0])
            ele2.children[0].children[0].children[0].children[0].innerHTML = "Subtotal " + rsp[i].accounts[j].currency.name
            ele2.children[0].children[1].children[0].children[0].innerHTML = rsp[i].accounts[j].subtotalFee.formatted
            ele2.children[0].children[2].children[0].children[0].innerHTML = rsp[i].accounts[j].subtotal.formatted
            document.getElementsByClassName('feesTTT')[me + j].appendChild(ele2);
        }
    }
}

function addOptions(domElement, data) {
    var select = document.getElementById(domElement);
    select.innerHTML = '<option value="" selected style="font-size: 13px">Módulos</option>';
    for (i = 0; i < data.length; i++) {
        var option = document.createElement("option");
        option.value = data[i].dsc;
        option.text = data[i].dsc;
        select.add(option);
    }
}