<?php
// pay/api/app/home
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $out->user = new stdClass();
    
    if(isset($_GET['sessionid']) && $_GET['sessionid'] != ''){
        //Validamos la session
        $sql = "SELECT payusers.userid AS id, ".
        "       GROUP_CONCAT(IF(userpersons.fname IS NULL, ".
        "           CONCAT(usercompanies.name, ".
        "               IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))), ".
        "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) )".
        "       ) SEPARATOR '|') AS name ".
        "       FROM payusers ".
        "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
        "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
        "       WHERE payusers.sessionid ='".$_GET['sessionid']."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
    
        if($row['id'] != null){
            
            $userid = isSessionValidPAY($db, $_GET['sessionid']);

            $out->user->id = (int)$row['id'];
            $out->user->fullname = $row['name'];
            
            $sql = "SELECT avatarimgtype FROM payusers WHERE userid = ".$out->user->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $row = $res->fetch_assoc();
            
            if ($row['avatarimgtype'] != null) {
                $out->user->avatar = new stdClass();
                //Buscamos el archivo para obtener su nombre y extension
                $filestest = glob("../../../uploads/users/".$out->user->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                
                //El primer resultado
                $info = pathinfo($filestest[0]);
                
                if($info['basename'] != ""){
                    $out->user->avatar = new stdClass();
                    $out->user->avatar->type = $row['imagetype'];
                    $out->user->avatar->url = $uploadsURL."users/".$out->user->id."/".$info["basename"];
                }else{
                    $out->user->avatar = null;
                }
            } else {
                $out->user->avatar = null;
            }
        }else{
            $out->user->id = 0;
        }
    }else{
        $out->user->id = 0;
    }
    
    //Consultamos los datos de los pares
    $sql = "SELECT pairs.refcurrencyid AS pairsrefcurrency, ".
    "       currencies.name AS currencyname, currencies.symbol AS currencysymbol, ".
    "       currencies.icon AS currencyicon, ".
    "       currencies.id AS currencyid, pairs.id AS pairsid,".
    "       currencies.decimals AS currencydecimals ".
    "       FROM pairs, currencies ".
    "       WHERE pairs.status = 1 AND ".
    "       currencies.id = pairs.currencyid ".
    "       GROUP BY pairs.id".
    "       ORDER BY pairs.id ASC";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($pairdata = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int) $pairdata["pairsid"];
        
        //Consultamos decimales de moneda ref
        $sql = "SELECT * FROM currencies WHERE id = ".$pairdata['pairsrefcurrency'];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $pairrefdata = $res->fetch_assoc();
        
        $record->pair = $pairrefdata['symbol'].'/'.$pairdata['currencysymbol'];
        
        $record->basecurrency = new stdClass();
        $record->basecurrency->id = (int)$pairrefdata['id'];
        $record->basecurrency->symbol = $pairrefdata['symbol'];
        
        // Validamos que el file exista
        $urljson = "../../icons/icons.json";
        
        //$record->basecurrency->test = $pairrefdata['icon'];
        if(file_exists($urljson)){
            // SI existe obtenemos el json
            $json = json_decode(file_get_contents($urljson), true);
            $record->basecurrency->url = null;
            foreach($json['icons'] as $icon){
                if ($icon['name'] == $pairrefdata['icon']) {
                    $record->basecurrency->url = $homeurlpay."icons/".$icon['url'];
                }
            }
        }else{
            $record->basecurrency->url = null;
        }
    
        //Obtenemos la cantidad total que se ha hecho
        $sql = "SELECT SUM(transactions.amount) AS transactionamount FROM orders, transactions, accounts".
        "       WHERE orders.pairid = ".$record->id.
        "       AND accounts.id = IF(orders.side = 2, orders.paymentid, orders.accountid) ".
        "       AND accounts.currencyid = ".$pairdata["pairsrefcurrency"].
        "       AND accounts.id = transactions.accountid ".
        "       AND transactions.amount > 0".
        "       AND transactions.orderid = orders.id".
        "       AND transactions.datecreated >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $res->fetch_assoc();
            
        $record->volume = new stdClass();
        $record->volume->number = (float)number_format($row["transactionamount"], $pairrefdata["decimals"], '.','');
        $record->volume->formatted = numberFormatt($record->volume->number,$pairrefdata["decimals"]);
        
        //Consultamos la ultima venta
        $sql = "SELECT o.quantity AS qty, o.id AS grouptx, ".
        "       o.price, o.side, o.id, o.total".
        "       FROM orders o".
        "       WHERE o.side = 1 AND o.canceled IS NULL AND o.pairid = ".$record->id.
        "       AND (CASE ".
        "           WHEN o.canceled IS NOT NULL THEN -1 ".
        "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "               AND o.canceled IS NULL THEN 1 ".
        "           ELSE 0 ".
        "       END) = 0 ".
        "       ORDER BY o.price ASC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $res->fetch_assoc();
    
        $record->ask = new stdClass();
        $record->ask->number = (float)number_format($row['price'], $pairdata["decimals"], '.','');
        $record->ask->formatted = numberFormatt($record->ask->number,$pairdata["decimals"]);
    
        //Consultamos los datos de la ultima compra
        $sql = "SELECT o.quantity AS qty, o.id AS grouptx, ".
        "       o.price, o.side, o.id, o.total".
        "       FROM orders o".
        "       WHERE o.side = 2 AND o.canceled IS NULL AND o.pairid = ".$record->id.
        "       AND (CASE ".
        "           WHEN o.canceled IS NOT NULL THEN -1 ".
        "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "               FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND orders.id = o.id ".
        "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "               AND o.canceled IS NULL THEN 1 ".
        "           ELSE 0 ".
        "       END) = 0 ".
        "       ORDER BY o.price DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $res->fetch_assoc();
    
        $record->bid = new stdClass();
        $record->bid->number = (float)number_format($row['price'],$pairdata["decimals"],'.','');
        $record->bid->formatted = numberFormatt($record->bid->number,$pairdata["decimals"]);
        
        //Obtenemos la ultima transaccion realizada
        $sql = "SELECT (SELECT ord.price FROM orders ord ".
        "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS lastprice ".
        "       FROM orders, accounts, transactions t  ".
        "           LEFT JOIN transactions txother ".
        "               ON t.orderid != txother.orderid ".
        "               AND t.txid = txother.txid  ".
        "               AND txother.amount > 0 ".
        "               AND txother.dsc NOT LIKE 'Comisi%' ".
        "       WHERE t.orderid IS NOT NULL ".
        "       AND orders.id = txother.orderid ".
        "       AND orders.pairid = ".$record->id.
        "       AND t.id = t.txid ".
        "       AND t.dsc NOT LIKE 'Comisi%' ".
        "       AND accounts.id = orders.accountid ".
        "       GROUP BY t.txid ".
        "       ORDER BY t.datecreated DESC, t.id DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $res->fetch_assoc();
        
        $record->lastprice = new stdClass();
        $record->lastprice->number = (float)number_format($row["lastprice"], $pairdata["currencydecimals"], '.','');
        $record->lastprice->formatted = numberFormatt($record->lastprice->number,$pairdata["currencydecimals"]);
        
        //Consultamos la ultima transaccion hace 24horas
        $sql = "SELECT (SELECT ord.price FROM orders ord ".
        "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS transactionamount ".
        "       FROM orders, accounts, transactions t  ".
        "           LEFT JOIN transactions txother ".
        "               ON t.orderid != txother.orderid ".
        "               AND t.txid = txother.txid  ".
        "               AND txother.amount > 0 ".
        "               AND txother.dsc NOT LIKE 'Comisi%' ".
        "       WHERE t.orderid IS NOT NULL ".
        "       AND orders.id = txother.orderid ".
        "       AND orders.pairid = ".$record->id.
        "       AND t.id = t.txid ".
        "       AND t.dsc NOT LIKE 'Comisi%' ".
        "       AND accounts.id = orders.accountid ".
        "       AND t.datecreated <= DATE_SUB(NOW(), INTERVAL 1 DAY) ".
        "       GROUP BY t.txid ".
        "       ORDER BY t.datecreated DESC, t.id DESC".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $res->fetch_assoc();
    
        $record->change = new stdClass();
        
        if($record->lastprice->number == 0){
            $record->change->number = 0;
            $record->change->formatted = numberFormatt($record->change->number,2)."%";
        }else{
            if($row['transactionamount'] > 0){
                $record->change->number = (($record->lastprice->number - $row['transactionamount'])*100)/$row['transactionamount'] ;
                $record->change->formatted = numberFormatt($record->change->number,2)."%";
            }else{
                $record->change->number = 0;
                $record->change->formatted = numberFormatt($record->change->number,2)."%";
            }
        }
        
        $record->period = "Ultimas 24h";
        
        //  Grafica
        $chart = new stdClass();
        
        // Obtenemos el nombre del par
        $sql = "SELECT CONCAT(currencies.symbol,'/',cursec.symbol) AS pairdsc, ".
        "       currencies.decimals AS currendecimals, cursec.decimals AS cursecdecimals".
        "       FROM currencies, pairs par ".
        "       LEFT JOIN currencies cursec ON cursec.id = par.currencyid ".
        "       WHERE par.refcurrencyid = currencies.id ".
        "       AND par.id = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $res->fetch_assoc();
        
        $currencyrefdecimals = (int)$row['currendecimals'];
        $currencydecimals = (int)$row['cursecdecimals'];
        
        //Obtenemos el tipo de intervarlo y su equivalente en horas
        $hour = 1;
        
        //Convertimos el timeframe a segundos
        $secondsHour = $hour * 3600;
        
        //Lines es el precio del ultimo CADA TIMEFRAME
        $chart->lines = new stdClass();
        
        $sql = "SELECT orders.id AS orderid, 
                orders.price AS orderprice, 
                t.txid AS txid,
                FROM_UNIXTIME(CEILING(UNIX_TIMESTAMP(t.datecreated)/".$secondsHour.")*".$secondsHour.") AS label,
                CONCAT(HOUR(FROM_UNIXTIME(CEILING(UNIX_TIMESTAMP(t.datecreated)/".$secondsHour.")*".$secondsHour.")),':00') AS reallabel,
                t.datecreated AS datecreated
                FROM orders, transactions t  
                    LEFT JOIN transactions txother 
                    ON t.orderid != txother.orderid 
                    AND t.txid = txother.txid
                WHERE orders.id = t.orderid
                AND orders.pairid = ".$record->id."
                AND orders.type = 2
                AND t.orderid IS NOT NULL
                AND t.txid = (SELECT MAX(txmax.txid)
                   	FROM transactions txmax, orders
                    WHERE 
                    FROM_UNIXTIME(
                        CEILING(UNIX_TIMESTAMP(txmax.datecreated)/".$secondsHour.")*".$secondsHour."
                    ) = FROM_UNIXTIME(
                        CEILING(UNIX_TIMESTAMP(t.datecreated)/".$secondsHour.")*".$secondsHour."
                    ) 
                AND txmax.orderid = orders.id AND orders.pairid = ".$record->id.")
                GROUP BY label
            ORDER BY t.datecreated  DESC 
            LIMIT 60";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $lines = [];
        while($row = $res->fetch_assoc()){
            $line = new stdClass();
            
            $line->label = $row['reallabel'];
            $line->labeldetail = date("Y-m-d H:i:s", strtotime($row["label"]));
            
            $line->price = new stdClass();
            $line->price->number = (float)number_format($row['orderprice'],$currencydecimals, '.', '');
            $line->price->formatted = numberFormatt($row['orderprice'], $currencydecimals);
            
            $lines [] = $line;
        }
        
        $count = 0;
        
        // Obtenemos la hora y fecha de caracas
        $date = new DateTime('now', new DateTimeZone('America/Caracas'));
        $currentDate = $date->format('Y-m-d H:00:00');
        
        $linestest = [];
        $lineRes = [];
        if($lines != NULL){
            foreach($lines as $i => $line){
                if($i == 0){
                    $priceDay = new stdClass();
                    //Si la fecha actual es mayor a la del ultimo intercambio, colocamos ese encima
                    if(strtotime($currentDate) > strtotime($line->labeldetail)){
                        
                        $price = $line->price->number;
                        $priceDay->price = $line->price->number;
                        $priceDay->canonnical = $currentDate;
                        
                        $linestest [] = $priceDay;
                        $lineRes [] = $price;
                        $count++;
                        
                        $lastHour = $currentDate;
                        
                        //Aqui recorremos este primer valor ya que no fue guardado
                        do{
                            $priceDay = new stdClass();
                        
                            //Restamos la hora segun el timeframe
                            $lastHour = date('Y-m-d H:i:s', strtotime($lastHour) - $secondsHour);
                            
                            $price = $line->price->number;
                            $priceDay->price = $line->price->number;
                            $priceDay->canonnical = $lastHour;
                        
                            $linestest [] = $priceDay;
                            $lineRes [] = $price;
                            $count++;
                
                        }while(strtotime($lastHour) > strtotime($line->labeldetail) && $count < 10);
                        
                    }else{
                        $price = $line->price->number;
                        $priceDay->price = $line->price->number;
                        $priceDay->canonnical = $currentDate;
                        
                        $linestest [] = $priceDay;
                        $lineRes [] = $price;
                        $count++;
                    }
                    
                }else if($i != 0 && $count < 10){
                    //Guardamos la ultima hora
                    $lastHour = $linestest[$count-1]->canonnical;
                    do{
                        $priceDay = new stdClass();
                        
                        //Restamos la hora segun el timeframe
                        $lastHour = date('Y-m-d H:i:s', strtotime($lastHour) - $secondsHour);
                        
                        $price = $line->price->number;
                        $priceDay->price = $line->price->number;
                        $priceDay->canonnical = $lastHour;
                        $linestest [] = $priceDay;
                        $lineRes [] = $price;
                        $count++;
                
                    }while(strtotime($lastHour) > strtotime($line->labeldetail) && $count < 10);
                }
            }
        }
        
        $record->historical = $lineRes;
        //  $record->testing = $linestest;
        
        $pairs [] = $record;
    }
    
    $out->pairs = $pairs;
    
    // Obtenemos las noticias
    $sql = "SELECT * FROM paynews";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($news = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$news['id'];
        
        $record->title = new stdClass();
        $record->title->text = $news['title'];
        $record->title->color = $news['titcolor'];
        $record->title->font_size = $news['titsize'];
        
        $record->content = new stdClass();
        $record->content->text = $news['content'];
        $record->content->color = $news['concolor'];
        $record->content->font_size = $news['consize'];
        
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/news/".$record->id.".{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $record->background = new stdClass();
            $record->background->image = $uploadsURL."news/".$info["basename"];
            $record->background->color = $news['baccolor'];
        }else{
            $record->background = null;
        }
        
        $dateconverted = strtotime($news['createddate']);
        
        $record->createddate = new stdClass();
        $record->createddate->date = date('Y-m-d H:i', $dateconverted);

        $record->createddate->formatted = date('j', $dateconverted)." de ".determinateMonthEsp(date('n', $dateconverted))." de " .date('Y', $dateconverted)." - ".date('g:i a', $dateconverted);
        
        $newsArr [] = $record;
    }
    
    $out->news = $newsArr;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>