<?php
// app/api/login/login.php

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array("usr", 'devicetoken');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // Inicializamos las variables con los valores obtenidos por GET
    $out = new stdClass();
    $usr = strtoupper($_GET["usr"]);
    $sessid = randomString(32);
    
    // Los datos del agente
    $agent = $headers['User-Agent'];
    $devicetoken = $_GET['devicetoken'];
    
    //Primero validamos que el usuario exista
    $sql = "SELECT id, pwd FROM users".
    "       WHERE  UPPER(usr)=UPPER('".$usr."') ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    if($row["id"] == null){
        badEnd("404", array("msg"=>"Usuario no existe"));
    }
    
    $userid = (int)$row["id"];
    
    // Validamos que su pwd no sea null y que no se esté ingresando con hash
    if($row['pwd'] == null && ($_GET['pwd'] != '' && isset($_GET['pwd']))){
        badEnd('405', array("msg"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave"));
    }
    
    // Validamos si el device token existe, si no, toca ingresarlo
    $sql = "SELECT COUNT(paydevices.id) AS qty ".
    "       FROM paydevices, payuserdevices".
    "       WHERE paydevices.id = payuserdevices.paydeviceid ".
    "       AND payuserdevices.payuserid = ".$userid.
    "       AND paydevices.token = '".$devicetoken."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
     
    $row = $rs->fetch_assoc();
    
    // Validamos la cantidad
    if($row['qty'] == 0){
        
        // Validamos el SO
        $so = 0;
        if (strpos($agent, 'Android')) {
            $so = 1;
        } else if(strpos($agent, 'iPhone')) {
            $so = 2;
        } else {
            $so = 0;
        }
        
        // Si es 0, insertamos este device
        $sql = "INSERT INTO paydevices(token, platform, name) ".
        "       VALUES('".$devicetoken."', ".$so.", '".(strtoupper(substr($usr, 0, 4)).'_'.substr($devicetoken, 0, -6))."' )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $deviceid = (int)$db->insert_id;
        
        $sql = "INSERT INTO payuserdevices(paydeviceid, payuserid, status) ".
        "       VALUES(".$deviceid.", ".$userid.", 1)";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    }
    
    // Validamos que se envio PWD
    if ($_GET['pwd'] != '' && isset($_GET['pwd'])) {
        // SI se envio validamos que existe en payusers
        $sql = "SELECT COUNT(payusers.userid) AS qty ".
        "       FROM payusers, users ".
        "       WHERE users.id = payusers.userid ".
        "       AND UPPER(users.usr)=UPPER('".$usr."') ";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Si no existe, hacemos el proceso de registro
        if ($row['qty'] == 0){
            
            $sql = "SELECT cmspreferences.* ".
            "       FROM cmspreferences ".
            "       WHERE cmspreferences.id = 1 ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                
            $row = $rs->fetch_assoc();
            
            $sessidtime = $row['paysessidtime'] == null ? 24 : $row['paysessidtime'];
            
            // Obtenemos las 4 primeras monedas con el XFER activo
            $sql = "SELECT id FROM currencies ".
            "       WHERE xfer = 1 ".
            "       AND status = 1 ".
            "       AND id > 0 ".
            "       LIMIT 0, 4";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $count = 0;
            $currAcepted = '';
            
            while($row = $rs->fetch_assoc()) {
                if ($count == 0) {
                    $currAcepted .= $row['id'];
                } else {
                    $currAcepted .= ",".$row['id'];
                }
                $count++;
            }
            
            // Insertamos el usuario en Pay
            $sql = "INSERT INTO payusers(userid, status, sessionid, validthru, receivecurrencies, sendcurrencies, lastsession, acceptedcurrencies) ".
            "       VALUES(".$userid.", 1, '".$sessid."', DATE_ADD(NOW(), INTERVAL ".$sessidtime." MINUTE), '".$currAcepted."','".$currAcepted."', NOW(), '".$currAcepted."')";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            // SI todo es exacto, validamos que exista
            $sql = "SELECT COUNT(id) AS qty FROM users ".
            "       WHERE  UPPER(usr)=UPPER('".$usr."') ".
            "       AND    pwd='".$_GET['pwd']."' " .
            "       AND    status<>0";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $row = $rs->fetch_assoc();
            
            if ($row['qty'] == 0){
                // se incrementa los reintentos y se desactiva la cuenta en caso de llegar al maxfails
                $sql =  "UPDATE users " .
                        "       SET fails = " .
                        "               CASE WHEN fails < maxfails THEN ".
                        "                   fails + 1 ".
                        "               ELSE ".
                        "                   fails ".
                        "               END, ".
                        "           status = ".
                        "               CASE WHEN fails >= maxfails THEN ".
                        "                   0 ".
                        "               ELSE ".
                        "                   status ".
                        "               END, ".
                        "           blockedthru = ".
                        "               CASE WHEN fails >= maxfails THEN ".
                        "                   NOW() ".
                        "               ELSE ".
                        "                   null ".
                        "               END ".
                        "   WHERE  UPPER(usr)=UPPER('".$usr."') ".
                        "   AND    fails < maxfails";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $sql = "SELECT status FROM users WHERE UPPER(usr)=UPPER('".$usr."') ";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $row = $rs->fetch_assoc();
                
                if($row["status"] == "0"){
                    badEnd("402",array("msg"=>"Usuario bloqueado"));
                } else if($row["status"] == null){
                    badEnd("404", array("msg"=>"Usuario no existe"));
                }else{
                    badEnd("401", array("msg"=>"Usuario/Clave Inválidos"));
                }
            }
            
            //Validamos que la pwd no este vencida
            $sql = "SELECT IF(pwdexpiration IS NULL OR pwdexpiration < NOW(), 1, 0) AS pwdExpirated FROM users ".
            "       WHERE UPPER(usr)=UPPER('".$usr."') ".
            "       AND pwd='".$_GET['pwd']."' " .
            "       AND status<>0";
            if (!$rs = $db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            $row = $rs->fetch_assoc();
            
            if($row['pwdExpirated'] == 1){
                badEnd('405', array("msg"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave"));
            }
            
            $sql = "SELECT cmspreferences.* ".
            "       FROM cmspreferences ".
            "       WHERE cmspreferences.id = 1 ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                
            $row = $rs->fetch_assoc();
            
            $sessidtime = $row['paysessidtime'] == null ? 24 : $row['paysessidtime'];
            
            // destruir cualquier session anterior existente
            $sql =  "UPDATE payusers " .
                    "SET    sessionid = '" . $sessid . "', ".
                    "       lastsession = NOW(), ".
                    "       validthru = DATE_ADD(NOW(), INTERVAL ".$sessidtime." MINUTE) ".
                    "WHERE  userid=".$userid." ".
                    "AND    status<>0";
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            $sql =  "UPDATE users " .
                    "SET    fails = 0 ".
                    "WHERE id = ".$userid;
            if (!$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }
            
            // Obtenemos su numero de telefono y lo guardamos para el envio de SMS
            $sql = "SELECT IF(userpersons.usrid IS NULL, usercompanies.phone, userpersons.phone) AS phone, ".
            "       users.sessionid AS sessionid, ".
            "       users.pwd AS pwd, ".
            "       users.level AS level, ".
            "       users.type AS type ".
            "       FROM users ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       WHERE UPPER(users.usr)='".$usr."' ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $row = $rs->fetch_assoc();
            
            //Consultamos dependiendo del tipo de usuario junto su id
                if($row['type'] == 1){
                    $sql = "SELECT *".
                    "       FROM userpersons".
                    "       WHERE usrid = ".$userid;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                        
                    $userdetail = $rs->fetch_assoc();
                }else if($row['type'] == 2){
                    $sql = "SELECT *".
                    "       FROM usercompanies".
                    "       WHERE usrid = ".$userid;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                        
                    $userdetail = $rs->fetch_assoc();
                }else{
                    badEnd("304", array("msg"=>"Usuario no activado"));
                }
                
                $rejecteds = explode(",",$userdetail["rejected"]);
                $approveds = explode(",",$userdetail["approved"]);
                
                // Obtenemos sus datos requeridos del nivel 0.5
                $sql = "SELECT * FROM levels WHERE id = 4";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                
                $rowLevel = $res->fetch_assoc();
                
                if($row['type'] == 1){
                    $fieldsArr = explode(',', $rowLevel['userpersons']);
                    
                } else if ($row['type'] == 2){
                    $fieldsArr = explode(',', $rowLevel['usercompanies']);
                    
                }
                
                // Validamos los campos
                if (count($fieldsArr) > 0){
                    foreach($fieldsArr as $fiel){
                        $req = new stdClass();
                        $req->id = $fiel;
                        if ($fiel == 'terms' || $fiel == 'declaration') {
                            $req->value = $row[$fiel];
                        } else {
                            $req->value = $userdetail[$fiel];
                        }
                        
                        $req->status = validateField($fiel, $rejecteds, $approveds);
                        
                        $reqs [] = $req;
                    }
                }
                
                // Validamos el campo paymobilephone
                $sql = "SELECT paymobilephone, ".
                "       paymobileverified ".
                "       FROM users ".
                "       WHERE id = ".$userid;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $paymobileValid = $res->fetch_assoc();
                    
                $req = new stdClass();
                $req->id = 'paymobilephone';
                $req->value = $paymobileValid['paymobilephone'];
                $req->status = (int)$paymobileValid['paymobileverified'];
                    
                $reqs [] = $req;
                
                $out->requeriments = $reqs;
                
                // Validamos los uploads
                //Consulta para obtener los documentos que ha subido el usuario 
                $uploadArr = explode('-', $rowLevel['cmsprefuploads']);
                    
                foreach($uploadArr as $uploadid){
                    
                    //Consultamos los datos de cada tipo de documento
                    $sql = "SELECT * FROM cmsprefuploads".
                    "       WHERE id = ".$uploadid;
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                    
                    $uploaddetail = $res->fetch_assoc();
                    
                    
                    //Buscamos el archivo para obtener su nombre y extension
                    $filestest = glob("../../../uploads/users/".$userid."/".str_pad($uploadid, 2, "0", STR_PAD_LEFT).".{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                    
                    //El primer resultado
                    $info = pathinfo($filestest[0]);
                    
                    if($info['basename'] != ""){
                        //Consultamos los datos del upload si existe y esta validado
                        $sql = "SELECT * FROM useruploads WHERE prefuploadid = ".$uploadid.
                        "       AND userid = ".$userid;
                        if (!$resUp=$db->query($sql))
                            badEnd("500", array("msg"=>$db->error));
                            
                        $uploadUser = $resUp->fetch_assoc();
                        $upload = new stdClass();
                        $upload->id = (int)str_pad($uploadid, 2, "0", STR_PAD_LEFT);
                        
                        $arrRequiresUp = explode("-",$uploadid);
                        $upload->status = (int)$uploadUser['validated'];
                        $upload->value = $upload->url = $uploadsURLpay."?upid=".$uploadid."&sessionid=".$sessid;
                        
                        $uploads[] = $upload;
                        
                    } else {
                        $upload = new stdClass();
                        $upload->id = (int)str_pad($uploadid, 2, "0", STR_PAD_LEFT);
                        
                        $arrRequiresUp = explode("-",$uploadid);
                        $upload->value = '';
                        $upload->status = 0;
                        
                        $uploads[] = $upload;
                    }
                }
                
                $out->uploads = $uploads;
            
            $check = getValidator(5);
            $sql = "UPDATE users SET ".
            "       paymobilephone = '".$row['phone']."', ".
            "       paymobilecheck = '".$check."'".
            "       WHERE  UPPER(usr)=UPPER('".$usr."') ";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            
            // Obtenemos el nivel 
            $levelInfo = getLevelById($db, $row['level']);
            
            $out->id = $userid;
            $out->registered = false;
            $out->hasPwd = $row['pwd'] != '' && $row['pwd'] != null ? true : false;
            $out->active = false;
            $out->mobilephone = $row['phone'];
            $out->level = new stdClass();
            $out->level->id = $row['level'];
            $out->level->dsc = 'Nivel '.$levelInfo['orden'];
            $out->devices = getUserDevices($db, $userid, $devicetoken);
            
            enviarSMS($row['phone'], "Su código de activación para AFX es el siguiente: ".$check." \n rEl8y+fS/0G");//VLazi+zS5Wn");
        } else {
            // SI todo es exacto, validamos que exista
            $sql = "SELECT COUNT(id) AS qty FROM users ".
            "       WHERE  UPPER(usr)=UPPER('".$usr."') ".
            "       AND    pwd='".$_GET['pwd']."' " .
            "       AND    status<>0";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $row = $rs->fetch_assoc();
            
            if ($row['qty'] == 0){
                // se incrementa los reintentos y se desactiva la cuenta en caso de llegar al maxfails
                $sql =  "UPDATE users " .
                        "       SET fails = " .
                        "               CASE WHEN fails < maxfails THEN ".
                        "                   fails + 1 ".
                        "               ELSE ".
                        "                   fails ".
                        "               END, ".
                        "           status = ".
                        "               CASE WHEN fails >= maxfails THEN ".
                        "                   0 ".
                        "               ELSE ".
                        "                   status ".
                        "               END, ".
                        "           blockedthru = ".
                        "               CASE WHEN fails >= maxfails THEN ".
                        "                   NOW() ".
                        "               ELSE ".
                        "                   null ".
                        "               END ".
                        "   WHERE  UPPER(usr)=UPPER('".$usr."') ".
                        "   AND    fails < maxfails";
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $sql = "SELECT status FROM users WHERE UPPER(usr)=UPPER('".$usr."') ";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $row = $rs->fetch_assoc();
                
                if($row["status"] == "0"){
                    badEnd("402",array("msg"=>"Usuario bloqueado"));
                } else if($row["status"] == null){
                    badEnd("404", array("msg"=>"Usuario no existe"));
                }else{
                    badEnd("401", array("msg"=>"Usuario/Clave Inválidos"));
                }
            }
            
            //Validamos que la pwd no este vencida
            $sql = "SELECT IF(pwdexpiration IS NULL OR pwdexpiration < NOW(), 1, 0) AS pwdExpirated FROM users ".
            "       WHERE UPPER(usr)=UPPER('".$usr."') ".
            "       AND pwd='".$_GET['pwd']."' " .
            "       AND status<>0";
            if (!$rs = $db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            $row = $rs->fetch_assoc();
            
            if($row['pwdExpirated'] == 1){
                badEnd('405', array("msg"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave"));
            }
            
            $sql = "SELECT cmspreferences.* ".
            "       FROM cmspreferences ".
            "       WHERE cmspreferences.id = 1 ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
                
            $row = $rs->fetch_assoc();
            
            $sessidtime = $row['paysessidtime'] == null ? 24 : $row['paysessidtime'];
            
            // destruir cualquier session anterior existente
            $sql =  "UPDATE payusers " .
                    "SET    sessionid = '" . $sessid . "', ".
                    "       lastsession = NOW(), ".
                    "       validthru = DATE_ADD(NOW(), INTERVAL ".$sessidtime." MINUTE) ".
                    "WHERE  userid=".$userid." ".
                    "AND    status<>0";
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
            
            $sql =  "UPDATE users " .
                    "SET    fails = 0 ".
                    "WHERE id = ".$userid;
            if (!$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }
            
            $sql = "SELECT users.id AS id, ".
            "       users.pwd AS pwd, ".
            "       users.level AS level, ".
            "       users.type AS type,".
            "       users.pwd AS pwd, ".
            "       users.terms AS terms, ".
            "       users.declaration AS declaration, ".
            "       payusers.sessionid AS sessionid, ".
            "       IF(users.paymobilephone IS NOT NULL, users.paymobilephone, (  ".
            "           IF(userpersons.usrid IS NULL, usercompanies.phone, userpersons.phone) " .
            "       )) AS phone, ".
            "       IF(userpersons.usrid IS NULL, usercompanies.doc, userpersons.doc) AS doc, ".
            "       GROUP_CONCAT(IF(userpersons.fname IS NULL, ".
            "           CONCAT(usercompanies.name, ".
            "               IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))), ".
            "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) )".
            "       ) SEPARATOR '|') AS name ".
            "       FROM payusers, users ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       WHERE UPPER(users.usr)='".$usr."' ".
            "       AND users.pwd='".$_GET['pwd']."'".
            "       AND users.id = payusers.userid";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $row = $rs->fetch_assoc();
            
            if($row['id'] != null){
                $out->id = (int)$row['id'];
                $out->type = (int)$row['type'];
                $out->sessid = $row['sessionid'];
                $out->fullname = $row['name'];
                $out->mobilephone = $row['phone'];
                $out->doc = $row['doc'];
                $out->hasPwd = $row['pwd'] != '' && $row['pwd'] != null ? true : false;
                $out->devices = getUserDevices($db, $userid, $devicetoken);
                
                // Obtenemos el nivel 
                $levelInfo = getLevelById($db, $row['level']);
                $out->level = new stdClass();
                $out->level->id = $row['level'];
                $out->level->dsc = 'Nivel '.$levelInfo['orden'];
                
                $out->registered = true;
                //  Obtenemos el image/type de la tabla payusers
                $sql = "SELECT avatarimgtype, status FROM payusers WHERE userid = ".$out->id;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                    
                $rowImg = $res->fetch_assoc();
                
                $out->active = $rowImg['status'] == 1 ? true : false;
                
                if ($rowImg['avatarimgtype'] != null) {
                     $out->avatar = new stdClass();
                    //Buscamos el archivo para obtener su nombre y extension
                    $filestest = glob("../../../uploads/users/".$out->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                    
                    //El primer resultado
                    $info = pathinfo($filestest[0]);
                    
                    if($info['basename'] != ""){
                        $out->avatar = new stdClass();
                        $out->avatar->type = $row['avatarimgtype'];
                        $out->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessid;
                    }else{
                        $out->avatar = null;
                    }
                }else {
                    $out->avatar = null;
                }
                
                // Buscamos si tiene un cobros
                
                $sql = "SELECT COUNT(transactions.id) AS qty ".
                "       FROM paytxdetails, transactions, accounts, payusers ".
                "       WHERE payusers.userid = ".$out->id.
                "       AND accounts.userid = payusers.userid".
                "       AND accounts.id = transactions.accountid ".
                "       AND transactions.id = paytxdetails.transactionid".
                "       AND transactions.dsc LIKE '%Solicitud de Cobro%'";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                    
                $rowPayment = $res->fetch_assoc();
                // SI tiene cobros, retornamos el ultimo
                if ($rowPayment['qty'] > 0) {
                    $sql = "SELECT transactions.id AS txid, ".
                    "       IF(transactions.validthru > NOW() AND transactions.paypending = 1, 1, 0) AS pending".
                    "       FROM paytxdetails, transactions, accounts, payusers ".
                    "       WHERE payusers.userid = ".$out->id.
                    "       AND accounts.userid = payusers.userid".
                    "       AND accounts.id = transactions.accountid ".
                    "       AND transactions.id = paytxdetails.transactionid".
                    "       AND transactions.dsc LIKE '%Solicitud de Cobro%'".
                    "       ORDER BY transactions.datecreated DESC";
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error.$sql));
                        
                    $rowPayment = $res->fetch_assoc();
                    
                    $out->lastpayment = new stdClass();
                    $out->lastpayment->txid = (int)$rowPayment['txid'];
                    $out->lastpayment->pending = $rowPayment['pending'] == 1 ? true : false;
                } else {
                    $out->lastpayment = null;
                }
                
                //Consultamos dependiendo del tipo de usuario junto su id
                if($out->type == 1){
                    $sql = "SELECT *".
                    "       FROM userpersons".
                    "       WHERE usrid = ".$out->id;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                        
                    $userdetail = $rs->fetch_assoc();
                }else if($out->type == 2){
                    $sql = "SELECT *".
                    "       FROM usercompanies".
                    "       WHERE usrid = ".$out->id;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                        
                    $userdetail = $rs->fetch_assoc();
                }else{
                    badEnd("304", array("msg"=>"Usuario no activado"));
                }
                
                $rejecteds = explode(",",$userdetail["rejected"]);
                $approveds = explode(",",$userdetail["approved"]);
                
                // Obtenemos sus datos requeridos del nivel 0.5
                $sql = "SELECT * FROM levels WHERE id = 4";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                
                $rowLevel = $res->fetch_assoc();
                
                if($out->type == 1){
                    $fieldsArr = explode(',', $rowLevel['userpersons']);
                    
                } else if ($out->type == 2){
                    $fieldsArr = explode(',', $rowLevel['usercompanies']);
                    
                }
                
                // Validamos los campos
                foreach($fieldsArr as $fiel){
                    $req = new stdClass();
                    $req->id = $fiel;
                    if ($fiel == 'terms' || $fiel == 'declaration') {
                        $req->value = $row[$fiel];
                    } else {
                        $req->value = $userdetail[$fiel];
                    }
                    
                    $req->status = validateField($fiel, $rejecteds, $approveds);
                    
                    $reqs [] = $req;
                }
                
                // Validamos el campo paymobilephone
                $sql = "SELECT paymobilephone, ".
                "       paymobileverified ".
                "       FROM users ".
                "       WHERE id = ".$out->id;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $paymobileValid = $res->fetch_assoc();
                    
                $req = new stdClass();
                $req->id = 'paymobilephone';
                $req->value = $paymobileValid['paymobilephone'];
                $req->status = (int)$paymobileValid['paymobileverified'];
                    
                $reqs [] = $req;
                
                $out->requeriments = $reqs;
                
                // Validamos los uploads
                //Consulta para obtener los documentos que ha subido el usuario 
                $uploadArr = explode('-', $rowLevel['cmsprefuploads']);
                    
                foreach($uploadArr as $uploadid){
                    
                    //Consultamos los datos de cada tipo de documento
                    $sql = "SELECT * FROM cmsprefuploads".
                    "       WHERE id = ".$uploadid;
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                    
                    $uploaddetail = $res->fetch_assoc();
                    
                    
                    //Buscamos el archivo para obtener su nombre y extension
                    $filestest = glob("../../../uploads/users/".$out->id."/".str_pad($uploadid, 2, "0", STR_PAD_LEFT).".{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                    
                    //El primer resultado
                    $info = pathinfo($filestest[0]);
                    
                    if($info['basename'] != ""){
                        //Consultamos los datos del upload si existe y esta validado
                        $sql = "SELECT * FROM useruploads WHERE prefuploadid = ".$uploadid.
                        "       AND userid = ".$out->id;
                        if (!$resUp=$db->query($sql))
                            badEnd("500", array("msg"=>$db->error));
                            
                        $uploadUser = $resUp->fetch_assoc();
                        $upload = new stdClass();
                        $upload->id = (int)str_pad($uploadid, 2, "0", STR_PAD_LEFT);
                        
                        $arrRequiresUp = explode("-",$uploadid);
                        $upload->status = (int)$uploadUser['validated'];
                        $upload->value = $upload->url = $uploadsURLpay."?upid=".$uploadid."&sessionid=".$out->sessid;
                        
                        $uploads[] = $upload;
                        
                    } else {
                        $upload = new stdClass();
                        $upload->id = (int)str_pad($uploadid, 2, "0", STR_PAD_LEFT);
                        
                        $arrRequiresUp = explode("-",$uploadid);
                        $upload->value = '';
                        $upload->status = 0;
                        
                        $uploads[] = $upload;
                    }
                }
                
                $out->uploads = $uploads;
                
            }else{
                $out->id = 0;
            }
        }
    } else if ($_GET['hash'] != '' && isset($_GET['hash'])) {
        // Validamos un usuario con ese hash
        $sql = "SELECT COUNT(id) AS qty FROM users ".
        "       WHERE  UPPER(usr)=UPPER('".$usr."') ".
        "       AND    paymobilehash = '".$_GET['hash']."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Si no existe generamos el codigo a ese usuario
        if($row['qty'] == 0){
            // Obtenemos su numero de telefono y lo guardamos para el envio de SMS
            $sql = "SELECT IF(userpersons.usrid IS NULL, usercompanies.phone, userpersons.phone) AS phone, ".
            "       users.pwd AS pwd, ".
            "       users.id AS userid, ".
            "       users.level AS level ".
            "       FROM users ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       WHERE UPPER(users.usr)='".$usr."' ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $row = $rs->fetch_assoc();
            
            // Actualizamos el validthru
            $sql = "UPDATE payusers SET ".
            "       lastsession = NOW(), ".
            "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY)".
            "       WHERE userid = ".$row['userid'];
            if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
            $sql =  "UPDATE users " .
                    "SET    fails = 0 ".
                    "WHERE id = ".$userid;
            if (!$db->query($sql)){
                badEnd("500", array("msg"=>determinateDBError($db)));
            }

            $check = getValidator(5);
            $sql = "UPDATE users SET ".
            "       paymobilephone = '".$row['phone']."', ".
            "       paymobilecheck = '".$check."'".
            "       WHERE  UPPER(usr)=UPPER('".$usr."') ";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $out->id = $userid;
            $out->registered = false;
            $out->active = false;
            $out->hasPwd = $row['pwd'] != '' && $row['pwd'] != null ? true : false;
            $out->mobilephone = $row['phone'];
            
            // Obtenemos el nivel 
            $levelInfo = getLevelById($db, $row['level']);
            $out->level = new stdClass();
            $out->level->id = $row['level'];
            $out->level->dsc = 'Nivel '.$levelInfo['orden'];
            $out->devices = getUserDevices($db, $userid, $devicetoken);
            
            enviarSMS($row['phone'], "Su código de activación para AFX es el siguiente: ".$check." \n rEl8y+fS/0G");//VLazi+zS5Wn"););
        } else {
            badEnd("406", array("msg"=>'Ya esta registrado'));
        }
    } else if ($_GET['emailhash'] != '' && isset($_GET['emailhash'])) {
        
        // Obtenemos el id del usuario
        $sql = "SELECT id, usr ".
        "       FROM users ".
        "       WHERE UPPER(usr) = UPPER('".$usr."')";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        
        $sql = "SELECT cmspreferences.* ".
        "       FROM cmspreferences ".
        "       WHERE cmspreferences.id = 1 ";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $row = $rs->fetch_assoc();
        
        $sessidtime = $row['paysessidtime'] == null ? 24 : $row['paysessidtime'];
        
        // Actualizamos el validthru
        $sql = "UPDATE payusers SET ".
        "       lastsession = NOW(), ".
        "       validthru = DATE_ADD(NOW(), INTERVAL ".$sessidtime." MINUTE)".
        "       WHERE sessionid = '".$_GET['emailhash']."'".
        "       AND userid = ".$row['id'];
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        //Se actualiza el phone si se entra con el hash
        // Obtenemos su numero de telefono y lo guardamos para el envio de SMS
            $sql = "SELECT IF(userpersons.usrid IS NULL, usercompanies.phone, userpersons.phone) AS phone, ".
            "       users.pwd AS pwd, ".
            "       users.level AS level ".
            "       FROM users ".
            "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
            "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
            "       WHERE users.id=".$row['id']." ";
            if (!$rsPhn=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $rowPhone = $rsPhn->fetch_assoc();
        
        // Actualizamos el paymobilephone
        $sql = "UPDATE users SET ".
        "       paymobilephone = '".$rowPhone['phone']."' " .
        "       WHERE id = ".$row['id'];
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
            
        $sql = "SELECT users.id AS id, ".
        "       users.level AS level, ".
        "       users.type AS type,".
        "       users.pwd AS pwd, ".
        "       users.terms AS terms, ".
        "       users.declaration AS declaration, ".
        "       payusers.sessionid AS sessionid, ".
        "       users.paymobilephone AS phone, ".
        "       IF(userpersons.usrid IS NULL, usercompanies.doc, userpersons.doc) AS doc, ".
        "       GROUP_CONCAT(IF(userpersons.fname IS NULL, ".
        "           CONCAT(usercompanies.name, ".
        "               IF(usercompanies.comercialname IS NULL, '', CONCAT('/',usercompanies.comercialname))), ".
        "           CONCAT(userpersons.fname,IF(userpersons.sname IS NULL OR userpersons.sname = '', '', CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname)) )".
        "       ) SEPARATOR '|') AS name ".
        "       FROM payusers, users ".
        "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
        "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
        "       WHERE payusers.sessionid='".$_GET['emailhash']."' ".
        "       AND users.usr = '".$usr."' ".
        "       AND users.id = payusers.userid";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        
        if($row['id'] != null){
            $out->id = (int)$row['id'];
            $out->type = (int)$row['type'];
            $out->sessid = $row['sessionid'];
            $out->fullname = $row['name'];
            $out->doc = $row['doc'];
            $out->mobilephone = $row['phone'];
            $out->hasPwd = $row['pwd'] != '' && $row['pwd'] != null ? true : false;
            $out->devices = getUserDevices($db, $userid, $devicetoken);
            
            // Obtenemos el nivel 
            $levelInfo = getLevelById($db, $row['level']);
            $out->level = new stdClass();
            $out->level->id = $row['level'];
            $out->level->dsc = 'Nivel '.$levelInfo['orden'];
            
            $out->registered = true;
            //  Obtenemos el image/type de la tabla payusers
            $sql = "SELECT avatarimgtype, status FROM payusers WHERE userid = ".$out->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                
            $roImgw = $res->fetch_assoc();
            
            $out->active = $rowImg['status'] == 1 ? true : false;
            
            if ($rowImg['avatarimgtype'] != null) {
                 $out->avatar = new stdClass();
                //Buscamos el archivo para obtener su nombre y extension
                $filestest = glob("../../../uploads/users/".$out->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                
                //El primer resultado
                $info = pathinfo($filestest[0]);
                
                if($info['basename'] != ""){
                    $out->avatar = new stdClass();
                    $out->avatar->type = $row['avatarimgtype'];
                    $out->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessid;
                }else{
                    $out->avatar = null;
                }
            }else {
                $out->avatar = null;
            }
            
            // Buscamos si tiene un cobros
                
            $sql = "SELECT COUNT(transactions.id) AS qty ".
            "       FROM paytxdetails, transactions, accounts, payusers ".
            "       WHERE payusers.userid = ".$out->id.
            "       AND accounts.userid = payusers.userid".
            "       AND accounts.id = transactions.accountid ".
            "       AND transactions.id = paytxdetails.transactionid".
            "       AND transactions.dsc LIKE '%Solicitud de Cobro%'";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
                    
            $rowPayments = $res->fetch_assoc();
            // SI tiene cobros, retornamos el ultimo
            if ($rowPayments['qty'] > 0) {
                $sql = "SELECT transactions.id AS txid, ".
                "       IF(transactions.validthru > NOW() AND transactions.paypending = 1, 1, 0) AS pending".
                "       FROM paytxdetails, transactions, accounts, payusers ".
                "       WHERE payusers.userid = ".$out->id.
                "       AND accounts.userid = payusers.userid".
                "       AND accounts.id = transactions.accountid ".
                "       AND transactions.id = paytxdetails.transactionid".
                "       AND transactions.dsc LIKE '%Solicitud de Cobro%'".
                "       ORDER BY transactions.datecreated DESC";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error.$sql));
                        
                $rowPayments = $res->fetch_assoc();
                    
                $out->lastpayment = new stdClass();
                $out->lastpayment->txid = (int)$rowPayments['txid'];
                $out->lastpayment->pending = $rowPayments['pending'] == 1 ? true : false;
            } else {
                $out->lastpayment = null;
            }
            
            //Consultamos dependiendo del tipo de usuario junto su id
            if($out->type == 1){
                $sql = "SELECT *".
                "       FROM userpersons".
                "       WHERE usrid = ".$out->id;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $userdetail = $rs->fetch_assoc();
            }else if($out->type == 2){
                $sql = "SELECT *".
                "       FROM usercompanies".
                "       WHERE usrid = ".$out->id;
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $userdetail = $rs->fetch_assoc();
            }else{
                badEnd("304", array("msg"=>"Usuario no activado"));
            }
            
            $rejecteds = explode(",",$userdetail["rejected"]);
            $approveds = explode(",",$userdetail["approved"]);
            
            // Obtenemos sus datos requeridos del nivel 0.5
            $sql = "SELECT * FROM levels WHERE id = 4";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error.$sql));
            
            $rowLevel = $res->fetch_assoc();
            
            if($out->type == 1){
                $fieldsArr = explode(',', $rowLevel['userpersons']);
                
            } else if ($out->type == 2){
                $fieldsArr = explode(',', $rowLevel['usercompanies']);
                
            }
            
            // Validamos los campos
            foreach($fieldsArr as $fiel){
                $req = new stdClass();
                $req->id = $fiel;
                if ($fiel == 'terms' || $fiel == 'declaration') {
                    $req->value = $row[$fiel];
                } else {
                    $req->value = $userdetail[$fiel];
                }
                
                $req->status = validateField($fiel, $rejecteds, $approveds);
                
                $reqs [] = $req;
            }
            
            // Validamos el campo paymobilephone
            $sql = "SELECT paymobilephone, ".
            "       paymobileverified ".
            "       FROM users ".
            "       WHERE id = ".$out->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $paymobileValid = $res->fetch_assoc();
                
            $req = new stdClass();
            $req->id = 'paymobilephone';
            $req->value = $paymobileValid['paymobilephone'];
            $req->status = (int)$paymobileValid['paymobileverified'];
                
            $reqs [] = $req;
            
            $out->requeriments = $reqs;
            
            // Validamos los uploads
            //Consulta para obtener los documentos que ha subido el usuario 
            $uploadArr = explode('-', $rowLevel['cmsprefuploads']);
                
            foreach($uploadArr as $uploadid){
                
                //Consultamos los datos de cada tipo de documento
                $sql = "SELECT * FROM cmsprefuploads".
                "       WHERE id = ".$uploadid;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $uploaddetail = $res->fetch_assoc();
                
                
                //Buscamos el archivo para obtener su nombre y extension
                $filestest = glob("../../../uploads/users/".$out->id."/".str_pad($uploadid, 2, "0", STR_PAD_LEFT).".{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
                
                //El primer resultado
                $info = pathinfo($filestest[0]);
                
                if($info['basename'] != ""){
                    //Consultamos los datos del upload si existe y esta validado
                    $sql = "SELECT * FROM useruploads WHERE prefuploadid = ".$uploadid.
                    "       AND userid = ".$out->id;
                    if (!$resUp=$db->query($sql))
                        badEnd("500", array("msg"=>$db->error));
                        
                    $uploadUser = $resUp->fetch_assoc();
                    $upload = new stdClass();
                    $upload->id = (int)str_pad($uploadid, 2, "0", STR_PAD_LEFT);
                    
                    $arrRequiresUp = explode("-",$uploadid);
                    $upload->status = (int)$uploadUser['validated'];
                    $upload->value = $upload->url = $uploadsURLpay."?upid=".$uploadid."&sessionid=".$out->sessid;
                    
                    $uploads[] = $upload;
                    
                } else {
                    $upload = new stdClass();
                    $upload->id = (int)str_pad($uploadid, 2, "0", STR_PAD_LEFT);
                    
                    $arrRequiresUp = explode("-",$uploadid);
                    $upload->status = 0;
                    $upload->value = '';
                    
                    $uploads[] = $upload;
                }
            }
            
            $out->uploads = $uploads;
            
        }else{
            $out->id = 0;
        }
        
    } else {
        badEnd("500", array("msg"=>'Se debe enviar el hash o pwd'));
    }
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    
    /*  Funcion que valida el campo si fue rechazado, aceptado o sigue en espera
    *   $field = Campo que se esta validando
    *   $rejecteds = arreglo con campos rechazados
    *   $approveds = arreglo con campos aceptados
    */
    function validateField($field, $rejecteds, $approveds){
        
        foreach($rejecteds as $rejected){
            if($rejected == $field){
                return -1;
            }
        }
        
        foreach($approveds as $approved){
            if($approved == $field){
                return 1;
            }
        }
        
        return 0;
    }
    
    /*  Funcion que valida si una imagen es requerida para subir de nivel o no
    *   $field = Campo que se esta validando
    *   $rejecteds = arreglo con imagenes requeridas
    */
    function validateUpload($field, $requireds){
        
        foreach($requireds as $required){
            if($required == $field){
                return true;
            }
        }
        
        return false;
    }
    
    /*  Funcion para obtener los dispositivos del usuario
    *
    */
    function getUserDevices($db, $userid, $currenttoken) {
        // Consultamos los devices
        $sql = "SELECT paydevices.id AS deviceid, ".
        "       paydevices.name AS name, ".
        "       paydevices.token AS token ".
        "       FROM paydevices, payuserdevices".
        "       WHERE paydevices.id = payuserdevices.paydeviceid".
        "       AND payuserdevices.payuserid = ".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $devices = [];
        while($row = $rs->fetch_assoc()){
            $record = new stdClass();
            $record->id = (int)$row['deviceid'];
            $record->name = $row['name'];
            $record->actual = $currenttoken == $row['token'];
            
            $devices [] = $record;
        }
        
        return $devices;
    }
?>
