<?php
//pay/api/payment/read
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('txidcrc');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $txid = $_GET['txidcrc'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Validamos que exista el movimiento
    $sql = "SELECT COUNT(id) AS qty FROM transactions ".
    "       WHERE CONCAT(LPAD(id,'8','0'),RIGHT(CRC32(LPAD(id,'8','0')), 2)) = ".$txid.
    "       AND paypending = 1".
    "       AND validthru IS NOT NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0){
        badEnd("404", array("msg"=>"Cobro no encontrado o Expirado"));
    }
    
    // Obtenemos el movimientos
    $sql = "SELECT transactions.id AS txid, ".
    "       payusers.userid AS userid, ".
    "       payusers.receivecurrencies AS receivecurrencies, ".
    "       payusers.avatarimgtype AS avatartype, ".
    "       IF(transactions.amountghost = 0, transactions.amount, transactions.amountghost) AS amountrx, ".
    "       currencies.id AS currencyrxid, ".
    "       currencies.symbol AS currencyrxsymbol, ".
    "       currencies.name AS currencyrxname, ".
    "       currencies.decimals AS currencyrxdecimals, ".
    "       currencies.icon AS currencyrxicon, ".
    "       paytxdetails.amounttx AS amounttx, ".
    "       paytxdetails.currencytx AS currencytxid, ".
    "       IF(userpersons.fname IS NULL, ".
    "           CONCAT(usercompanies.name, ".
    "               IF(usercompanies.comercialname IS NULL, ".
    "                   '',".
    "                   CONCAT('/',usercompanies.comercialname)".
    "               )".
    "           ), ".
    "           CONCAT(userpersons.fname, ".
    "               IF(userpersons.sname IS NULL OR userpersons.sname = '',".
    "                   '',".
    "                   CONCAT(' ',userpersons.sname)),' ',userpersons.flastname, IF(userpersons.slastname IS NULL OR userpersons.slastname = '', '', CONCAT(' ',userpersons.slastname))".
    "               )".
    "       ) AS username ".
    "       FROM transactions, accounts, currencies, paytxdetails, payusers ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       WHERE CONCAT(LPAD(transactions.id,'8','0'),RIGHT(CRC32(LPAD(transactions.id,'8','0')), 2)) = ".$txid.
    "       AND accounts.id = transactions.accountid".
    "       AND accounts.userid = payusers.userid".
    "       AND accounts.currencyid = currencies.id".
    "       AND transactions.paypending = 1".
    "       AND paytxdetails.transactionid = transactions.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    
    $out->txid = (int)$row['txid'];
    
    // Receptor
    $out->receiver = new stdClass();
    $out->receiver->id = (int)$row['userid'];
    $out->receiver->name = $row['username'];
    
    if ($row['avatartype'] != null) {
        $out->receiver->avatar = new stdClass();
        //Buscamos el archivo para obtener su nombre y extension
        $filestest = glob("../../../uploads/users/".$out->receiver->id."/avatar.{jpg,png,jpeg,pdf,PNG,JPG,JPEG,PDF}", GLOB_BRACE);
        
        //El primer resultado
        $info = pathinfo($filestest[0]);
        
        if($info['basename'] != ""){
            $out->receiver->avatar = new stdClass();
            $out->receiver->avatar->type = $row['avatartype'];
            $out->receiver->avatar->url = $uploadsURLpay."?avatar=1&sessionid=".$sessionid;
        }else{
            $out->receiver->avatar = null;
        }
    } else {
        $out->receiver->avatar = null;
    }
    
    // Transaccion
    $sql = "SELECT * FROM currencies WHERE id = ".$row['currencytxid'];
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $currtx = $res->fetch_assoc();
    
    $out->transaction = new stdClass();
    
    $out->transaction->amount = new stdClass();
    $out->transaction->amount->number = (float)$row['amounttx'];
    $out->transaction->amount->formatted = numberFormatt($out->transaction->amount->number, $currtx['decimals']);
    
    $out->transaction->currency = new stdClass();
    $out->transaction->currency->id = (int)$currtx['id'];
    $out->transaction->currency->name = $currtx['name'];
    $out->transaction->currency->symbol = $currtx['symbol'];
    $out->transaction->currency->decimals = $currtx['decimals'];
    
    // Validamos que el file exista
    $urljson = "../../icons/icons.json";
    
    if(file_exists($urljson)){
        // SI existe obtenemos el json
        $json = json_decode(file_get_contents($urljson), true);
        $out->transaction->currency->icon = null;
        foreach($json['icons'] as $icon){
            if ($icon['name'] == $currtx['icon']) {
                $out->transaction->currency->icon = $homeurlpay."icons/".$icon['url'];
            }
        }
    }else{
        $out->transaction->currency->icon = null;
    }
    
    $out->reception = new stdClass();
    
    $out->reception->amount = new stdClass();
    $out->reception->amount->number = (float)$row['amountrx'];
    $out->reception->amount->formatted = numberFormatt($out->reception->amount->number, $row['currencyrxdecimals']);
    
    $out->reception->currency = new stdClass();
    $out->reception->currency->id = (int)$row['currencyrxid'];
    $out->reception->currency->name = $row['currencyrxname'];
    $out->reception->currency->symbol = $row['currencyrxsymbol'];
    $out->reception->currency->decimals = $row['currencyrxdecimals'];
    
    // Validamos que el file exista
    $urljson = "../../icons/icons.json";
    
    //$record->basecurrency->test = $pairrefdata['icon'];
    if(file_exists($urljson)){
        // SI existe obtenemos el json
        $json = json_decode(file_get_contents($urljson), true);
        $out->reception->currency->icon = null;
        foreach($json['icons'] as $icon){
            if ($icon['name'] == $row['currencyrxicon']) {
                $out->reception->currency->icon = $homeurlpay."icons/".$icon['url'];
            }
        }
    }else{
        $out->reception->currency->icon = null;
    }
    
    $receivecurrencies = explode(',', $row['receivecurrencies']);
    
    foreach($receivecurrencies as $currencyid){
        $sql = "SELECT curr.id AS currencyid,".
        "       curr.name AS currencyname, ".
        "       curr.symbol AS currencysymbol, ".
        "       curr.decimals AS currencydecimals, ".
        "       curr.status AS currencystatus, ".
        "       curr.interface AS currencyinterface, ".
        "       acc.id AS accountid, ".
        "       acc.paymentmethodid AS paymentmethodid, ".
        "       acc.status AS accountstatus, ".
        "       IF(acc.id IS NULL, 0, ( ".
        "           (SELECT SUM(amount) as qty FROM transactions WHERE accountid = acc.id AND paypending = 0) - ".
        "           ABS(IF(( ".
        "               SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
        "               FROM orders ".
        "               WHERE orders.accountid = acc.id".
    	"               AND orders.canceled IS NULL ".
    	"               AND orders.type != 1) IS NOT NULL,  ".
    	"                   ( ".
        "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
        "           FROM orders ".
        "           WHERE orders.accountid = acc.id".
    	"           AND orders.canceled IS NULL ".
    	"           AND orders.type != 1), 0)".
        "       + IF(( ".
        "           SELECT SUM(transactions.amount) AS amount ".
        "           FROM transactions, orders ".
        "           WHERE orders.id = transactions.orderid ".
        "           AND transactions.accountid = acc.id".
        "           AND orders.accountid = acc.id".
    	"           AND orders.canceled IS NULL ".
    	"               AND transactions.amount < 0 ".
    	"               AND orders.type != 1) IS NOT NULL, ( ".
        "               SELECT SUM(transactions.amount) AS amount ".
        "            FROM transactions, orders ".
        "               WHERE orders.id = transactions.orderid ".
        "               AND transactions.accountid = acc.id".
        "               AND orders.accountid = acc.id".
    	"               AND orders.canceled IS NULL ".
    	"                AND transactions.amount < 0 ".
    	"                AND orders.type != 1),0) ".
    	"           + IF ((SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
    	"                FROM transactions  ".
    	"               WHERE transactions.paypending = 1".
    	"               AND transactions.accountid = acc.id".
    	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)) IS NOT NULL, ".
    	"               (SELECT SUM(transactions.amount + transactions.amountghost) AS amount ".
    	"               FROM transactions  ".
    	"               WHERE transactions.paypending = 1".
    	"               AND transactions.accountid = acc.id".
    	"               AND NOT EXISTS(SELECT withdrawals.transactionid FROM withdrawals WHERE withdrawals.transactionid = transactions.id)), 0)".
    	"           )".
        "       )) AS avaliable ".
        "       FROM currencies curr ".
        "       LEFT JOIN accounts acc ON ".
        "           acc.currencyid = curr.id ".
        "           AND acc.userid = ".$userid.
        "           AND acc.paymentmethodid = -1 ".
        "           AND acc.entityusrid = ".$entityid.
        "       WHERE curr.status = 1 ".
        "       AND curr.id > 0 ".
        "       AND curr.id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
    
        $record = new stdClass();

        $record->id = (int)$row['currencyid'];
        $record->name = $row['currencyname'];
        $record->symbol = $row['currencysymbol'];
        $record->decimals = (int)$row['currencydecimals'];
        
        // Obtenemos la tasa de cambio
        $record->rate = determinateRate($db, $out->transaction->currency->id,$record->id , $record->decimals);
        
        $account = new stdClass();
        $account->id = (int)$row["accountid"];
        //Balance a partir de las transacciones
        $account->balance = new stdClass();
        $account->balance->number = $row['avaliable'] == null ? 0 : (float)bcdiv(number_format($row['avaliable'],13, '.', ''), '1',$row["currencydecimals"]);
        $account->balance->number = $account->balance->number < 0 ? 0 : $account->balance->number;
        $account->balance->formatted = numberFormatt($account->balance->number,$row["currencydecimals"]);
        
        $record->account = $account;
        
        $records [] = $record;
    }
    
    $out->acceptedcurrencies = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>