<?php
//pay/api/payment/validateexternal
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('transactionid', 'validator');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    
    $validator = $_GET['validator'];
    $transactionid = $_GET['transactionid'];
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    //Consultamos los datos de la transaccion
    $sql = "SELECT * FROM transactions WHERE id = ".$transactionid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["validator"] != $validator){
        badEnd("402", array("msg"=>"Código invalido"));
    }
    
    // Validamos que el codigo no este vencido
    $sql = "SELECT COUNT(id) AS qty FROM transactions ".
    "       WHERE id = ".$transactionid.
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("403", array("msg"=>"Código expirado"));
    }
    
    //Consultamos para saber si es un retiro o no
    $sql = "SELECT ( ".
    "           SELECT COUNT(withdrawals.transactionid) FROM withdrawals ".
    "           WHERE withdrawals.transactionid = tx.id ".
    "       ) AS isWithdraw, ".
    "       ( ".
    "           SELECT COUNT(deposits.transactionid) FROM deposits ".
    "           WHERE deposits.transactionid = tx.id ".
    "       ) AS isDeposit ".
    "       FROM transactions tx ".
    "       WHERE tx.id = ".$transactionid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $row = $rs->fetch_assoc();
    $isWithdraw = intval($row['isWithdraw']);
    
    //Si es un retiro, debemos consulta a las API de la moneda
    if(intval($row['isWithdraw']) == 1 && intval($row['isDeposit']) == 0){
    
        //Consultamos la moneda para hacer llamado a API
        $sql = "SELECT currencies.symbol AS symbol, ".
        "       currencies.name AS name, ".
        "       currencies.id AS id, ".
        "       currencies.interface AS interface, ".
        "       currencies.decimals AS decimals, ".
        "       ABS(transactions.amountghost) AS amount, ".
        "       withdrawals.ref AS ref, ".
        "       withdrawals.paymentwallet AS wallet ".
        "       FROM currencies, accounts, transactions, withdrawals ".
        "       WHERE transactions.id = ".$transactionid.
        "       AND transactions.accountid = accounts.id ".
        "       AND accounts.currencyid = currencies.id ".
        "       AND withdrawals.transactionid = transactions.id";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
            
        $currencydata = $rs->fetch_assoc();
        
        switch(intval($currencydata['interface'])){
            case 7:
                //createAlertWallet($db, $currencydata['wallet'], $userid);
                // Consultamos al nodo DASH
                $parms = array('address'=>$currencydata['wallet'],'amount'=>$currencydata['amount'],"subtractfeefromamount"=>true);
                $request = array('method'=>'sendtoaddress','parms' => $parms);
                $rsp = json_decode(queryServicesDash($DASH_URL, $request),true);
                
                //Consultamos la cuenta que tiene la moneda del retiro de AFX - PERMITE OMITIR AJUSTE DE SUMARLE LA COMISIÓN BLOCKCHAIN QUE NO ES GANANCIA
                $sql = "SELECT * FROM accounts WHERE userid = -1".
                "       AND currencyid = ".$currencydata["id"].
                "       AND paymentmethodid = -2";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                //Guardamos la data de la cuenta AFX
                $afxdata = $res->fetch_assoc();
                
                // SI error no es nulo, significa que hubo un error
                if($rsp['error'] != null){
                    deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                        "esp"=>"Error API ingreso de retiro ".$rsp['error']['message'],
                        "eng"=>"Withdrawal income API error ".$rsp['error']['message']), $lang, "Error API ingreso de retiro ".$rsp['error']['message']));
                }
                
                // Consultamos el movimiento
                $parms = array('txid'=>$rsp['result']);
                $request = array('method'=>'gettransaction','parms' => $parms);
                $rest = json_decode(queryServicesDash($DASH_URL, $request),true);
                
                //Actualizamos los movimientos 
                $sql = "UPDATE transactions SET ".
                "       amountghost = -1*ABS(amountghost + ".$rest['result']['fee'].") ".
                "       WHERE txid = ".$transactionid.
                "       AND accountid <> ".$afxdata["id"].
                "       AND dsc LIKE '%comision%'";
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                //Actualizamos los movimientos 
                $sql = "UPDATE transactions SET ".
                "       amountghost = -1*(ABS(amountghost) - ABS(".$rest['result']['fee'].")) ".
                "       WHERE id=".$transactionid;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                //Obtenemos el tx del retiro de BTC y lo guardamos en ref
                $sql = "UPDATE withdrawals SET ".
                "       amount = -1 * ABS(ABS(amount) - ABS(".$rest['result']['fee'].")), ".
                "       fee = fee + ABS(".$rest['result']['fee']."), ".//Ajuste faltaba agregar abs a fee en suma de fee se estaba restando
                "       ref = '".$rsp['result']."'".
                "       WHERE transactionid = ".$transactionid;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                $out->txid = $rsp['result'];
                
                break;
            case 1:
                $ci = '';
                // Si es fiat validamos que sea un pago movil
                $sql = "SELECT COUNT(*) AS qty ".
                "       FROM transactions WHERE id = ".$transactionid.
                "       AND dsc LIKE '%pago móvil%' ".
                "       AND (SELECT COUNT(*) AS qty FROM transactions WHERE txid = ".$transactionid.") = 3";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $paymentMobile = $res->fetch_assoc();
                
                // SI es mayor a 0 podemos ejecutar la llamada
                if($paymentMobile['qty'] > 0){
                    // Obtenemos primero que datos debemos consultas
                    $sql = "SELECT type FROM users ".
                    "       WHERE id = ".$userid;
                    if (!$rs=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                        
                    $uservalid = $rs->fetch_assoc();
                    
                    $ci = GetFormattedIdentification($db, $userid);
                    
                    // Validamos el length ci
                    if(strlen($ci) < 1 && strlen($ci) > 12){
                        badEnd("408",array("msg"=>determinateMsgFail(array(
                            "esp"=>"Cédula invalida",
                            "eng"=>"Invalid identification card"), $lang, "Cédula invalida")));
                    }
                    
                    // Obtenemos el telefono y el banco
                    $bankid = $currencydata['wallet'];
                    $phone = $currencydata['ref'];
                    
                    $nonce = generateNonce();
                    
                    // Llamamos a la api primerito
                    $request = array(
                        'banco'=>$bankid,
                        'idBeneficiario'=>$ci,
                        'telefono'=>$phone,
                        'monto'=>(float)number_format($currencydata['amount'], $currencydata['decimals'], '.', ''),
                        'motivo'=>'Retiro AFX',
                        'canal'=>'23',
                        'id-externo'=>$transactionid
                    );
                    
                    $headers = array('Content-Type:application/json', 
                        "api-key: $BP_C2P_KEY", 
                        "api-signature: ".
                        (
                            generateApiSignature("/".$BP_VERSION_P2P."/pagos/p2p".$nonce.json_encode($request),$BP_C2P_KEY_SECRET)
                        ),
                        "nonce: ".$nonce,
                    );
                    
                    // obtenemos respuesta
                    $rest = queryApiBP($BP_URL_QA, "pagos/p2p", $BP_VERSION_P2P, "POST", $headers, $request);
                    
                    if(($rest['bodyres']->numeroReferencia == null || $rest['bodyres']->numeroReferencia == '') && $rest['httpres'] != 200 && $rest['httpres'] != 201
                        && $rest['headerres']['codigorespuesta'] != '0084' ){
                        $msg_esp = "";
                        $msg_eng = "";
                        
                        switch($rest['headerres']['codigorespuesta']){
                            case 'E028':
                                $msg_esp = "El código de operaciones ingresado es inválido. Por favor intente de nuevo";
                                $msg_eng = "The operations code is invalid. Please try again";
                                break;
                            case 'E010':
                                $msg_esp = "Monto no válido";
                                $msg_eng = "Invalid amount";
                                break;
                            case 'E012':
                                $msg_esp = "Teléfono no habilitado para pagar";
                                $msg_eng = "Phone not enabled to pay";
                                break;
                            case 'E013':
                                $msg_esp = "Excede cantidad de pagos diarios";
                                $msg_eng = "Exceeds amount of daily payments";
                                break;
                            case 'E014':
                                $msg_esp = "Excede monto total de pagos diarios";
                                $msg_eng = "Exceeds total amount of daily payments";
                                break;
                            case 'E015':
                                $msg_esp = "Excede monto máximo para un pago";
                                $msg_eng = "Exceeds maximum amount for a payment";
                                break;
                            case 'E016':
                                $msg_esp = "Excede cantidad de pagos diarios";
                                $msg_eng = "Exceeds amount of daily payments";
                                break;
                            case 'E017':
                                $msg_esp = "Excede monto total de pagos diarios";
                                $msg_eng = "Exceeds total amount of daily payments";
                                break;
                            case 'E018':
                                $msg_esp = "Error en número de banco";
                                $msg_eng = "Bank number error";
                                break;
                            case 'E021':
                                $msg_esp = "Teléfono receptor no registrado";
                                $msg_eng = "Receiving phone not registered";
                                break;
                            case 'E022':
                                $msg_esp = "Teléfono receptor no acepta pagos";
                                $msg_eng = "Receiving phone does not accept payments";
                                break;
                            case 'E023':
                                $msg_esp = "Identificación del beneficiario no coincide";
                                $msg_eng = "Beneficiary ID does not match";
                                break;
                            case 'E024':
                                $msg_esp = "Cliente bloqueado";
                                $msg_eng = "Client blocked";
                                break;
                            case 'E030':
                                $msg_esp = "Banco no activo en pago móvil";
                                $msg_eng = "Bank not active in mobile payment";
                                break;
                            case 'A001':
                                $msg_esp = "Firma digital inválida";
                                $msg_eng = "Invalid digital signature";
                                break;
                            case '0080':
                                $msg_esp = 'Autorizador / Red no disponible';
                                $msg_eng = 'Authorizing / Red not avaliable';
                                break;
                            case '0057':
                                $msg_esp = 'Movimiento negado por el Receptor';
                                $msg_eng = 'Movement denied by Receiver';
                                break;
                            default:
                                $msg_esp = $rest['headerres']['descripcioncliente'];
                                $msg_eng = $rest['headerres']['descripcioncliente'];
                        }
                        $msg_esp = $msg_esp." Codigo: ".$rest['headerres']['codigorespuesta'];
                        $msg_eng = $msg_eng." Codigo: ".$rest['headerres']['codigorespuesta'];
                            
                        deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                            "esp"=>$msg_esp,
                            "eng"=>$msg_eng), $lang, $msg_esp));
                    }
                    
                    $reference = '';
                    
                    if($rest['headerres']['codigorespuesta'] == '0084'){
                        $reference = '0000';
                    }else{
                        $reference = $rest['bodyres']->numeroReferencia;
                    }
                    
                    //Obtenemos el id del retiro en la tcv y lo guardamos en ref
                    $sql = "UPDATE withdrawals SET ".
                    "       ".(strpos($rest['headerres']['descripcionSistema'], '9191') !== false ? " filetype = '9191', " : '').
                    "       paymentref = '".$reference."', ".
                    "       valid = NOW() ".
                    "       WHERE transactionid = ".$transactionid;
                    if (!$db->query($sql)){
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    }
                }
                break;
            case 6:
                // Si es 6, llamamos a la api de USDT para retirar de la wallet central
                //createAlertWallet($db, $currencydata['wallet'], $userid);
                // Lo primero que vamos a hacer es validar que la wallet de retiro es valida
                $request = array('method'=>'isvalid',"address" => $currencydata['wallet']);
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
                
                // si es false, es invalida, borramos todo
                if($rest['result'] == false){
                    deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                        "esp"=>'Dirección de retiro invalida',
                        "eng"=>'Invalid withdrawal address'), $lang, 'Dirección de retiro invalida'));
                }
                
                $value = "";
                $value = number_format($currencydata['amount'], $currencydata['decimals'], '.', '');
                $value = $value * 1000000;
                $request = array('method'=>'transferTo',"address" => $currencydata['wallet'], "amount" => $value, "feeLimit" => 10000000);
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
                
                $out->test = $rest;
                
                // Validamos que el error no sea nulo para mandar el mensaje
                if($rest == null){
                    deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                        "esp"=>'Error API ingreso de retiro ',
                        "eng"=>'Withdrawal income API error '), $lang, 'Error API ingreso de retiro '));
                }
                
                //Obtenemos el id del retiro en la tcv y lo guardamos en ref
                $sql = "UPDATE withdrawals SET ".
                "       ref = '".$rest['txid']."' ".
                "       WHERE transactionid = ".$transactionid;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                $out->txid = $rest['txid'];
                
                break;
            case 5:
                //createAlertWallet($db, $currencydata['wallet'], $userid);
                //Si es 5, llamamos a la api del TCV para hacer un retiro
                $rsp = queryPrivate('withdraws/new', $TCV_JWT, $TCV_URL, $VERSION_API, false, [
                    'rid' => $currencydata['wallet'], 
                    'currency' => $currencydata['symbol'],
                    'amount' => $currencydata['amount']
                ]);
                
                $out->test = $rsp;
                
                //Si el id es nulo, tenemos un error ya que es nuestra guia
                if($rsp['id'] == null || $rsp['httpres'] != 201){
                    deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                        "esp"=>'Error API ingreso de retiro '.$rsp['httpres'],
                        "eng"=>'Withdrawal income API error '.$rsp['httpres']), $lang, 'Error API ingreso de retiro '.$rsp['httpres']));
                }
                
                //Llamamos a la api por cada retiro para verificar su estado y actualizar sus datos
                $rsp2 = queryPrivate('withdraws/'.$rsp['id'], $TCV_JWT, $TCV_URL, $VERSION_API, true);
                
                if($rsp2['httpres'] != 200){
                    deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                        "esp"=>'Error API ingreso de retiro '.$rsp2['httpres'],
                        "eng"=>'Withdrawal income API error '.$rsp2['httpres']), $lang, 'Error API ingreso de retiro '.$rsp2['httpres']));
                }
                
                if($rsp2['fee'] > 0){
                    //Consultamos la cuenta que tiene la moneda del retiro de AFX
                    $sql = "SELECT * FROM accounts WHERE userid = -1".
                    "       AND currencyid = ".$currencydata["id"].
                    "       AND paymentmethodid = -2";
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    
                    //Guardamos la data de la cuenta AFX
                    $afxdata = $res->fetch_assoc();
                    
                    //Obtenemos la cuenta de la tx
                    $sql = "SELECT accountid FROM transactions WHERE id = ".$transactionid;
                    if (!$res=$db->query($sql))
                        badEnd("500", array("msg"=>determinateDBError($db)));
                    
                    //Guardamos la data de la cuenta AFX
                    $accountid = $res->fetch_assoc();
                    
                    // Insertamos un movimiento con el fee de la blockchain
                    $sql = "INSERT INTO transactions".
                    "       (".
                    "       datecreated, ".
                    "       dsc, ".
                    "       amount, ".
                    "       amountghost, ".
                    "       validthru, ".
                    "       accountid, ".
                    "       validator, ".
                    "       orderid, ".
                    "       txid, ".
                    "       accountorigin, ".
                    "       accountdestination".
                    "       )".
                    "       VALUES(".
                    "       NOW(), ".
                    "       'Comisión de Retiro', ".
                    "       -".abs($rsp2['fee']).", ".
                    "       0, ".
                    "       NULL, ".
                    "       ".$afxdata["id"].", NULL, ".
                    "       NULL, ".
                    "       ".$transactionid.", ".
                    "       ".$accountid["accountid"].", ".
                    "       ".$afxdata["id"].
                    "       )";
                    if (!$db->query($sql)){
                        deleteTransactions($db, $transactionid, $lang, '');
                    }
                }
                
                //Obtenemos el id del retiro en la tcv y lo guardamos en ref
                $sql = "UPDATE withdrawals SET ".
                "       ref = ".$rsp['id'].
                "       WHERE transactionid = ".$transactionid;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                $out->txid = $rsp['id'];
                
                break;
            case 4:
                //createAlertWallet($db, $currencydata['wallet'], $userid);
                // Consultamos al nodo BTC
                $parms = array('address'=>$currencydata['wallet'],'amount'=>$currencydata['amount'],"subtractfeefromamount"=>true,"replaceable"=>true);
                $request = array('method'=>'sendtoaddress','parms' => $parms);
                $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
                
                //Consultamos la cuenta que tiene la moneda del retiro de AFX - PERMITE OMITIR AJUSTE DE SUMARLE LA COMISIÓN BLOCKCHAIN QUE NO ES GANANCIA
                $sql = "SELECT * FROM accounts WHERE userid = -1".
                "       AND currencyid = ".$currencydata["id"].
                "       AND paymentmethodid = -2";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                //Guardamos la data de la cuenta AFX
                $afxdata = $res->fetch_assoc();
                
                // SI error no es nulo, significa que hubo un error
                if($rsp['error'] != null){
                    // Acomodamos el retiro para borrarlo
                    deleteTransactions($db, $transactionid, $lang, determinateMsgFail(array(
                        "esp"=>"Error API ingreso de retiro ".$rsp['error']['message'],
                        "eng"=>"Withdrawal income API error ".$rsp['error']['message']), $lang, "Error API ingreso de retiro ".$rsp['error']['message']));
                }
                
                // Consultamos el movimiento
                $parms = array('txid'=>$rsp['result']);
                $request = array('method'=>'gettransaction','parms' => $parms);
                $rest = json_decode(queryServicesBTC($BTC_URL, $request), true);
                
                //Actualizamos los movimientos 
                $sql = "UPDATE transactions SET ".
                "       amountghost = -1*ABS(amountghost + ".$rest['result']['fee'].") ".
                "       WHERE txid=".$transactionid.
                "       AND accountid <> ".$afxdata["id"]." ". //Agregado por javier, no se actualiza la ganancia de afx esta es solo el % (signos generaban falla de cálculo)
                "       AND dsc LIKE '%comision%'";
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                //Actualizamos los movimientos 
                $sql = "UPDATE transactions SET ".
                "       amountghost = -1*(ABS(amountghost) - ABS(".$rest['result']['fee'].")) ".
                "       WHERE id=".$transactionid;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                //Obtenemos el tx del retiro de BTC y lo guardamos en ref
                $sql = "UPDATE withdrawals SET ".
                "       amount = -1 * ABS(ABS(amount) - ABS(".$rest['result']['fee'].")), ".
                "       fee = fee + ABS(".$rest['result']['fee']."), ". //Agregado ajuste para cuadre de operaciones CMS faltaba "ABS" se restaba el fee blockchain
                "       ref = '".$rsp['result']."'".
                "       WHERE transactionid = ".$transactionid;
                if (!$db->query($sql)){
                    badEnd("500", array("msg"=>determinateDBError($db)));
                }
                
                $out->txid = $rsp['result'];
                
                break;
        }
        
        
        createAlertWallet($db, $currencydata['wallet'], $userid,$transactionid);
    }
    
    //Actualizamos la transaccion
    $sql = "UPDATE transactions SET".
    "       amount = amount + amountghost, ".
    "       validthru = NULL, ".
    "       amountghost = 0, ".
    "       validator = NULL ".
    "       WHERE txid = ".$transactionid.
    "       AND validthru > NOW()".
    "       AND validator = ".$validator;
    if (!$db->query($sql)){
        $error = determinateDBError($db);
        badEnd("500", array("msg"=>$error));
    }
    
    //Consultamos la moneda para hacer llamado a API
    $sql = "SELECT currencies.symbol AS symbol, ".
    "       currencies.name AS name, ".
    "       currencies.id AS id, ".
    "       currencies.interface AS interface, ".
    "       currencies.decimals AS decimals, ".
    "       ABS(transactions.amountghost) AS amount ".
    "       FROM currencies, accounts, transactions ".
    "       WHERE transactions.id = ".$transactionid.
    "       AND transactions.accountid = accounts.id ".
    "       AND accounts.currencyid = currencies.id ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db)));
        
    $currencydata = $rs->fetch_assoc();
    
    //$out->txid = (int)$transactionid;
    
    $out->currency = new stdClass();
    $out->currency->id = (int)$currencydata['id'];
    $out->currency->name = $currencydata['name'];
    $out->currency->symbol = $currencydata['symbol'];
    
    // Validamos que el file exista
    $urljson = "../../icons/icons.json";
    
    //$record->basecurrency->test = $pairrefdata['icon'];
    if(file_exists($urljson)){
        // SI existe obtenemos el json
        $json = json_decode(file_get_contents($urljson), true);
        $out->currency->icon = null;
        foreach($json['icons'] as $icon){
            if ($icon['name'] == $currtx['icon']) {
                $out->currency->icon = $homeurlpay."icons/".$icon['url'];
            }
        }
    }else{
        $out->currency->icon = null;
    }
    
    //Consultamos la transaccion requerida
    $sql = "SELECT transactions.id AS txid, ".
    "       transactions.txid AS txref, ".
    "       transactions.datecreated AS createddate, ".
    "       transactions.dsc AS dsc, ".
    "       (transactions.amount + transactions.amountghost) AS amount, ".
    "       transactions.accountorigin AS accountorigin, ".
    "       transactions.accountdestination AS accountdestination, ".
    "       transactions.accountid AS txaccountid, ".
    "       currencies.decimals AS decimals, ".
    "       currencies.id AS currencyid, ".
    "       IF(deposits.transactionid IS NOT NULL, deposits.valid, withdrawals.valid) AS valid, ".
    "       IF(deposits.transactionid IS NOT NULL, deposits.paymentdate, withdrawals.paymentdate) AS paymentdate, ".
    "       IF(deposits.transactionid IS NOT NULL, deposits.filetype, withdrawals.filetype) AS filetype, ".
    "       IF(deposits.transactionid IS NOT NULL, deposits.paymentref, withdrawals.paymentref) AS ref ".
    "       FROM accounts, currencies, transactions  ".
    "       LEFT JOIN deposits ON transactions.id = deposits.transactionid".
    "       LEFT JOIN withdrawals ON transactions.id = withdrawals.transactionid".
    "       LEFT JOIN paytxdetails ON paytxdetails.transactionid = transactions.id ".
    "       WHERE transactions.id = ".$transactionid.
    "       AND transactions.accountid = accounts.id".
    "       AND accounts.entityusrid = ".$entityid.
    "       AND accounts.currencyid = currencies.id";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
        
    $row = $rs->fetch_assoc();
    
    $out->amount = new stdClass();
    $out->amount->number = 0;
    
    $out->fee = new stdClass();
    $out->fee->number = 0;
    
    //Si es 0 no es comision, 1 es una comision
    $isFee = 0;
    
    //Si tiene la palabra comision retorna 1
    if(stripos($row["dsc"], "comisión") !== false){
        $isFee = 1;
    }
    
    if($isFee == 1){
        $sql = "SELECT (transactions.amount + transactions.amountghost) AS amount ".
        "       FROM transactions, accounts ".
        "       WHERE transactions.id = ".$row["txref"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
        
        $amountdata = $res->fetch_assoc();
        
        //Monto del movimiento
        $out->amount->number = bcdiv(number_format($amountdata['amount'],13, '.', ''), '1',$row['decimals']);
    }else{
        //Monto del movimiento
        $out->amount->number = bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
    }
    
    $out->amount->formatted = number_format(abs($out->amount->number),$row['decimals'], ',', '.');
    
    if($isFee == 1){
        $out->fee->number = bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
    }else{
        //Fee del movimiento
        $sql = "SELECT (transactions.amount + transactions.amountghost) AS amount ".
        "       FROM transactions, accounts ".
        "       WHERE transactions.txid = ".$transactionid.
        "       AND transactions.dsc LIKE '%Comision%'".
        "       AND transactions.accountid = accounts.id".
        "       AND accounts.paymentmethodid = -1".
        "       AND accounts.currencyid = ".$row['currencyid'];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db, $IS_PRODUCTION)));
            
        $feedata = $res->fetch_assoc();
        
        $out->fee->number = bcdiv(number_format($feedata["amount"],13, '.', ''), '1',$row['decimals']);
    }
    
    $out->fee->formatted = number_format(abs($out->fee->number),$row['decimals'], ',', '.');
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function deleteTransactions($db, $txid, $lang, $msg = ""){
        //Abrimos la transaccion
        $db->autocommit(FALSE);

        //eliminar el retiro(si existe)
        $sql = "DELETE FROM withdrawals WHERE transactionid = ".$txid;
        if (!$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    
        //eliminar la transaccion
        $sql = "DELETE FROM transactions ".
        "       WHERE id = ".$txid.
        "       OR txid = ".$txid;
        if (!$db->query($sql)){
            $error = determinateDBError($db);
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
    
        //Retornamos 304 si no se elimino ningun registro
        if ($db->affected_rows == 0){
            $db->rollback();
            $db->close();   
            badEnd("403", array("msg"=>determinateMsgFail(array(
                "esp"=>"No se pudo modificar",
                "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
        }
    
        $db->commit();
        $db->close();
            
        badEnd('500',array("msg"=>$msg == "" ? determinateDBError($db) : $msg));
    }
    
    function getAccountData($db, $depositaddress){
        $sql = "SELECT wallets.wallet AS wallet, ".
        "       accounts.id AS accountid, ".
        "       accounts.userid AS userid ".
        "       FROM wallets, accounts ".
        "       WHERE wallets.wallet = '".$depositaddress."'".
        "       AND accounts.id = wallets.accountid ".
        "       AND accounts.paymentmethodid = -1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
        return $res->fetch_assoc();
    }
    
    function createAlertWallet($db, $wallet, $userid, $txid) {
        $sql = "SELECT COUNT(id) AS qty,id FROM blacklist ".
        "       WHERE account = '".$wallet."'";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
                
        $row = $res->fetch_assoc();
        
        // Si existe levantamos una alerta con el id del usuario
        if ($row['qty'] > 0) {
            createAlert($db, 6, $userid, ' Cuenta encontrada en lista negativa <span>#'.$row['id'].'</span>. Transacción nro: <span>'.$txid.'</span>');
        }
    }
?>