<?php
//  app/api/queries/c2pbanks
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Validamos la session
    isSessionValidPAY($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    // Obtenemos la interfaz del banco
    $bankinterface = getActiveBank($db, 2, 1);
    
    // Traemos el listado de los bancos
    switch($bankinterface){
        case 0:
            badEnd("204", array("msg"=>determinateMsgFail(array(
                "esp"=>'Servicio inactivo, intente más tarde',
                "eng"=>'Service down, please try again later'), $lang, "Servicio inactivo, intente más tarde")));
            break;
        case 1:
            // Consultamos la api de banco plaza
            $headers = array('Content-Type:application/json');
            $request = array();
            $rest = queryApiBP($BP_URL_QA, "pagos/c2p/bancos", $BP_VERSION, "GET", $headers, $request);
            
            if($rest['httpres'] != 200 && $rest['httpres'] != 201){
                switch($rest['httpres']){
                    case 503:
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>'El servidor no puede atender temporalmente su petici贸n',
                            "eng"=>'The server is temporarily unable to service your petition BP'), $lang, "El servidor no puede atender temporalmente su petici贸n")));
                        break;
                    default:
                        badEnd("500", array("msg"=>determinateMsgFail(array(
                            "esp"=>'Error llamada a API BP',
                            "eng"=>'Error Call to API'), $lang, "Error llamada a API BP")));
                }
            }
            
            $out->bancos = $rest['bancos'];
            break;
        case 2:
            // Consultamos la api de banco activo
            $headers = array('Content-Type:application/json','apikey: '.$BA_API_KEY);
            $request = array("tipo_pagador"=>"C2P");
            $rest = queryApiBA($BA_URL_QA."lista_banco_pago_movil/1.0.0/bancos", "POST", $headers, $request);
            
            if($rest['httpres'] != 200 && $rest['httpres'] != 201){
                badEnd("500", array("msg"=>determinateMsgFail(array(
                    "esp"=>$msg_esp,
                    "eng"=>$msg_eng), $lang, $msg_esp)));
            }
            
            $bancos = $rest['bodyres']->bancos;
            foreach($bancos as $bank){
                $record = new stdClass();
                
                $record->codigo = $bank->codBanco;
                $record->nombre = $bank->nombreBanco;
                
                $out->bancos [] = $record;
            }
            break;
    }
    
    header("HTTP/1.1 200");
    echo(json_encode($out));
    die();
    
?>