<?php
//pay/api/queries/balance
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('deviceid', 'datefrom', 'dateto', 'offset', 'numofrecords', 'order');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $deviceid = $_GET['deviceid'];
    $type = determinateType((isset($_GET['typelst']))?$_GET['typelst']:'-1');
    $curr = ((determinateCurrencies($_GET['currlst'])=="")?"''":determinateCurrencies($_GET['currlst']));
    $datefrom = " AND DATE(A.datecreated) >= DATE('".mysqli_real_escape_string($db, date('Y-m-d', strtotime($_GET['datefrom'])))."') ";
    $dateto = " AND DATE(A.datecreated) <= DATE('".mysqli_real_escape_string($db, date('Y-m-d', strtotime($_GET['dateto'])))."') ";
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrecords'];
    $order = determinateOrder($_GET['order']);
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    $sqlDeposits =  "SELECT         t.id, t.dsc, ".
                    "               IF(d.valid IS NOT NULL, 1, " . //Si es valido, si no validamos el rechazado
                    "               IF(d.rejected IS NOT NULL, -1, 0)) AS status, " . //Si tampoco est�� rechazado pendiente
                    "               t.accountorigin, t.accountdestination, " .
                    "               IF(t.amount = 0, t.amountghost, t.amount) AS amount, ".
                    "               DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               t.amountghost AS amountghost,  ".
                	"		        t.accountid, ".
                	"               IF(t.id <> t.txid, 'Comisi&oacuten', 'Dep&oacutesito') AS typedsc, ".
                    "               IF(t.id <> t.txid, 'FEE', 'DEP') AS type, ".
                    "               'DEP' AS 'group' " .
                    "FROM           transactions t ".
                    "INNER JOIN     deposits d ON d.transactionid = t.txid ".
                    "INNER JOIN     accounts a " .
                    "ON             t.accountid = a.id " .
                    "               AND a.currencyid IN ($curr) ".//quitar para traer todos
                    "               AND a.userid = ". $userid .//quitar para traer todos
                    "               AND a.paymentmethodid = -1 " .
                    "               AND a.entityusrid = -1 ";
    
    $sqlWithdraw =  "SELECT         t.id, t.dsc, ".
                    "               IF(d.valid IS NOT NULL, 1, " . //Si es valido, si no validamos el rechazado
                    "               IF(d.rejected IS NOT NULL, -1, 0)) AS status, " . //Si tampoco est�� rechazado pendiente
                    "               t.accountorigin, t.accountdestination, " .
                    "               IF(t.amount = 0, t.amountghost, t.amount) AS amount, ".
                    "               DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               t.amountghost AS amountghost,  ".
                	"		        t.accountid, ".
                	"               IF(t.id <> t.txid, 'Comisi&oacuten', 'Retiro') AS typedsc, ".
                    "               IF(t.id <> t.txid, 'FEE', 'WITH') AS type, ".
                    "               'WITH' AS 'group' " .
                    "FROM           transactions t ".
                    "INNER JOIN     withdrawals d ON d.transactionid = t.txid ".
                    "INNER JOIN     accounts a " .
                    "ON             t.accountid = a.id " .
                    "               AND a.currencyid IN ($curr) ".//quitar para traer todos
                    "               AND a.userid = ". $userid .//quitar para traer todos
                    "               AND a.paymentmethodid = -1 " .
                    "               AND a.entityusrid = -1 ";
                    
    $sqlXch     =   "SELECT         t.id, t.dsc, ".
                    "               '1' AS status, " .
                    "               t.accountorigin, t.accountdestination, " .
                    "               IF(t.amount = 0, t.amountghost, t.amount) AS amount, ".
                    "               DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               t.amountghost AS amountghost,  ".
                	"		        t.accountid, ".
                	"               IF(adest.paymentmethodid<>-1, 'Comisi&oacuten', 'Intercambio') AS typedsc, ".
                    "               IF(adest.paymentmethodid<>-1, 'FEE', 'XCH') AS type, ".
		            "               'XCH' AS 'group' " .
                    "FROM           transactions t " . 
                    "INNER JOIN     orders o ON o.id = t.orderid " .
                    "INNER JOIN     accounts a " .
                    "ON             t.accountid = a.id " .
                    "               AND a.userid = ". $userid .//quitar para traer todos
                    "               AND a.currencyid IN ($curr) ".//quitar para traer todos
                    "               AND a.paymentmethodid = -1 " .
                    "               AND a.entityusrid = -1 " .
                	"LEFT JOIN      accounts adest ON adest.id = t.accountdestination ";
                	
                	
    $sqlXfer     =  "SELECT         t.id, t.dsc, ".
                    "               IF(t.paypending = 1, 0, 1) AS status, " .
                    "               t.accountorigin, t.accountdestination, " .
                    "               IF(t.amount = 0, t.amountghost, t.amount) AS amount, ".
                    "               DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               t.amountghost AS amountghost,  ".
                	"		        t.accountid, ".
                	"               IF(adest.paymentmethodid<>-1, 'Comisi&oacuten', 'Transferencia') AS typedsc, ".
                    "               IF(adest.paymentmethodid<>-1, 'FEE', 'XFER') AS type, ".
		            "               'XFER' AS 'group' " .
                    "FROM           transactions t " . 
                	"LEFT JOIN 	    deposits d ON d.transactionid = t.txid " .
                    "LEFT JOIN 	    withdrawals w ON w.transactionid = t.txid " .
                    "LEFT JOIN 	    pagomovildetails pm ON pm.transactionid = t.txid ".
                    "LEFT JOIN 	    paytxdetails ptx ON ptx.transactionid = t.txid ".
                	"INNER JOIN 	accounts a  ".
                	"ON    	   	    a.id = t.accountid  ".
                	"               AND a.entityusrid = -1 ".
                	"               AND a.paymentmethodid = -1 ".
                	"               AND a.userid = ". $userid ." " .//quitar para traer todos
                	"               AND a.currencyid IN ($curr) ".//quitar para traer todos
                	"LEFT JOIN      accounts adest ON adest.id = t.accountdestination " .
                	"WHERE 		    d.transactionid IS NULL ". 
                	"               AND w.transactionid IS NULL ".
                    "               AND ptx.transactionid IS NULL ".
                    "               AND pm.transactionid IS NULL ".
                	"               AND t.orderid IS NULL ".
                	"               AND t.accountorigin IS NOT NULL ";
                	
    $sqlPaytx =     "SELECT         t.id, t.dsc, ".
                    "               IF(t.paypending = 1, 0, 1) AS status, " .
                    "               t.accountorigin, t.accountdestination, " .
                    "               IF(t.amount = 0, t.amountghost, t.amount) AS amount, ".
                    "               DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               t.amountghost AS amountghost,  ".
                	"		        t.accountid, ".
                	"               IF(adest.paymentmethodid <> -1, 'Comisi&oacuten', 'Pagos AFX Pay') AS typedsc, ".
                    "               IF(adest.paymentmethodid <> -1, 'FEE', 'PAYTX') AS type, " .
                    "               'PAYTX' AS 'group' " .
                    "FROM           transactions t ".
                    "INNER JOIN     paytxdetails pd ON pd.transactionid = t.txid ".
                    "INNER JOIN     accounts a " .
                    "ON             t.accountid = a.id " .
                    "               AND a.currencyid IN ($curr) ".//quitar para traer todos
                    "               AND a.userid = ". $userid .//quitar para traer todos
                    "               AND a.paymentmethodid = -1 " .
                    "               AND a.entityusrid = -1 " .
                    "LEFT JOIN      accounts adest ON adest.id = t.accountdestination";
                    
        //Movimientos de movil sin sumar las comisiones
        $sqlPM =        "       SELECT  	    t.id, t.txid, t.dsc, pd.ref AS ref, " .
                        "                       t.accountorigin, t.accountdestination, " .
                        "                       IF(t.amount = 0, t.amountghost, t.amount) AS amount, " .
                        "                       DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated,  ". 
                        "                       t.amountghost AS amountghost, " .
    			        "                       t.accountid, t.paypending AS paypending, t.validator AS validator, " .
    			        "                       IF(adest.paymentmethodid <> -7, 'Comisi&oacuten', 'Cripto Pago') AS typedsc, ".
    			        "                       IF(adest.paymentmethodid <> -7, 'FEE', 'PMPAY') AS type " .
    			        "       FROM            transactions t " .
        		        "       INNER JOIN      accounts a ON t.accountid = a.id AND a.paymentmethodid = -1 ".
        		        "                       AND a.currencyid IN ($curr) ". //quitar para traer todos
                        "                       AND a.userid = ". $userid .//quitar para traer todos
        		        "       INNER JOIN      pagomovildetails pd ON pd.transactionid = t.txid ".
    			        "       LEFT JOIN       accounts adest ON adest.id = t.accountdestination" .
    			        "       ORDER BY        t.id ";
    
    $sqlPMGroup =   "SELECT         PM.id, PM.dsc, ".
                    "               IF(PM.ref IS NOT NULL, 1, 0) AS status, " .
                    "               MAX(PM.accountorigin) AS accountorigin, MAX(PM.accountdestination)  AS accountdestination, " .
                    "               IF(SUM(PM.amount) = 0, SUM(PM.amountghost), SUM(PM.amount)) AS amount, ".
                    "               DATE_FORMAT(PM.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               PM.amountghost AS amountghost,  ".
                	"		        PM.accountid, ".
                	"               PM.typedsc AS typedsc, " .
                    "               PM.type AS type, " .
                    "               'PMPAY' AS 'group' " .
                    "FROM           (" . $sqlPM . ") PM " .
                    "WHERE          PM.paypending = 0 AND PM.validator IS NULL " . //Filtro los que si se confirmaron con código
			        "GROUP BY PM.txid, PM.type";
    
                
    $sqlAjustes =   "SELECT         t.id, t.dsc, ".
                    "               '1' AS status, " .
                    "               t.accountorigin, t.accountdestination, " .
                    "               IF(t.amount = 0, t.amountghost, t.amount) AS amount, ".
                    "               DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, ".
                    "               t.amountghost AS amountghost,  ".
                	"		        t.accountid, ".
                	"               'Ajuste' AS typedsc, " .
                    "               'AJT' AS type, " .
                    "               'AJT' AS 'group' " .
                    "FROM           transactions t " .
                    "INNER JOIN     accounts a " .
                    "               ON  t.accountid = a.id " .
                    "               AND a.userid = ". $userid . //Quitar para traer todos
                    "               AND a.currencyid IN ($curr) ". //Quitar para traer todas
                    "               AND a.paymentmethodid = -1 " .
                    "               AND a.entityusrid = -1 " .
                    "LEFT JOIN (" . $sqlDeposits . " UNION " .
                    "           " . $sqlWithdraw . " UNION " .
                    "           " . $sqlXch .      " UNION " .
                    "           " . $sqlXfer .     " UNION " .
                    "           " . $sqlPaytx .    ") AL ON AL.id = t.id " .
                    "LEFT JOIN (" . $sqlPM . ") PM ON PM.id = t.id " .
                    "WHERE          AL.id IS NULL " . //Que no sea un movimiento de pago movil o ningún anterior          	
                	"               AND PM.id IS NULL";

    $sql =          "SELECT     A.*, " .
                    "           currencies.id AS currid, " .
                    "           currencies.name AS currname, " .
                    "           currencies.symbol AS currsymbol, " .
                    "           currencies.decimals AS decimals, " .
                    "           currencies.icon AS icon " .
                    "FROM ( " . $sqlDeposits . " UNION " .
                    "       " . $sqlWithdraw . " UNION " .
                    "       " . $sqlXch .      " UNION " .
                    "       " . $sqlXfer .     " UNION " .
                    "       " . $sqlPaytx .    " UNION " .
                    "       " . $sqlPMGroup .  " UNION " .
                    "       " . $sqlAjustes . "  ) A " .
                    "INNER JOIN accounts ON A.accountid = accounts.id " .
                    "INNER JOIN currencies ON accounts.currencyid = currencies.id " .
                    "WHERE      A.group IN ( ".$type. " ) ".
                    $datefrom.
                    $dateto.
                    $order. 
                    " LIMIT  $offset, $numofrecords";

    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db),"sql"=>$sql));
        
    $records = [];
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        //$record->txid = (int)$row['txid'];
        $record->dsc = $row['dsc'];
        $record->type = $row['typedsc'];
        
        $record->datehour = new stdClass();
        $record->datehour->date = date('Y-m-d H:i:s', strtotime($row['datecreated']));
        $record->datehour->formatted = date('d/m/Y h:i A', strtotime($row['datecreated']));
        
        $record->currency = new stdClass();
        $record->currency->id = (int)$row['currid'];
        $record->currency->name = $row['currname'];
        $record->currency->symbol = $row['currsymbol'];
        $record->currency->decimals = (int)$row['decimals'];
        
        $record->status = $row['status']; 
        
        // Validamos que el file exista
        $urljson = "../../icons/icons.json";
        
        if(file_exists($urljson)){
            // SI existe obtenemos el json
            $json = json_decode(file_get_contents($urljson), true);
            $record->currency->icon = null;
            foreach($json['icons'] as $icon){
                if ($icon['name'] == $row['icon']) {
                    $record->currency->icon = $homeurlpay."icons/".$icon['url'];
                }
            }
        }else{
            $record->currency->icon = null;
        }
        
        $record->amount =  new stdClass();
        $record->amount->number = (float)bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
        $record->amount->formatted = numberFormatt($record->amount->number,$row["decimals"]);
        
        $record->details = new stdClass();
        
        $records [] = $record;
    }
    
    $out->transactions = $records;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para determinar el orden de los movimientos
    *   1 = Fecha reciente
    */
    function determinateOrder($order){
        $str = '';
        
        switch($order){
            case 1:
                $str = 'ORDER BY datecreated DESC, id ASC';
                break;
            default:
                $str = 'ORDER BY datecreated DESC, id ASC';
        }
        
        return $str;
    }
    
    /* Funcion para determinar el tipo de operacion a obtener, donde:
    *   1 = Depositos
    *   2 = Retiros
    *   3 = Transferencias
    *   4 = Intercambios
    *
    function determinateType($types){
        if($types=="")return "";    
    
        $typeArr = explode('-', $types);
        $query = 'AND (';
        
        foreach($typeArr as $index => $type){
            if ($index > 0) {
                $query .= " OR ";
            }
            switch($type){
                case 1:
                    $query .= " paytxdetails.transactionid IS NOT NULL";
                    break;
                case 2:
                    $query .= " paytxdetails.transactionid IS NOT NULL";
                    break;
                case 3:
                    $query .= " t.txid = deposits.transactionid OR t.txid = withdrawals.transactionid";
                    break;
                case 4:
                    $query .= " (t.dsc LIKE '%Transferencia%' AND t.accountorigin IS NOT NULL OR t.dsc LIKE '%Intercambio%' AND t.accountorigin IS NOT NULL)";
                    break;
                default:
                    $query .= "";
            }
        }
        
        $query .= ")";
        
        return $query;
    }
    */
    /* Funcion para determinar el tipo de operacion a obtener, donde:
    *   1 = Depositos
    *   2 = Retiros
    *   3 = Transferencias
    *   4 = Intercambios
    */
    function determinateType($types){
        if($types=="-1")return "''";    
        
        $typeArr = explode('-', $types);
        $realTypes = "''";
        
        foreach($typeArr as $index => $type){
            switch($type){
                case 1:
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'PAYTX'";
                    break;
                case 2:
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'WITH'";
                    break;
                case 3:
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'DEP'";
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'XFER'";
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'PMPAY'";
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'AJT'";
                    break;
                case 4:
                    if($realTypes!="")$realTypes .= ",";
                    $realTypes .= "'XCH'";
                    break;
                default:
                    $query .= "";
            }
        }
        
        $query .= ")";
        
        return $realTypes;
    }
    
    function determinateCurrencies ($currlist){
        return str_replace("-",",",($currlist));
    }
    /*
    function determinateCurrencies($curr) {
        if($curr=="")return "AND (null)";  
        
        $currenciesArr = explode('-',$curr);
        $str = ' AND (';
        
        foreach($currenciesArr as $index => $currency){
            if($index == 0){
                $str .= ' accounts.currencyid = '.$currency;
            } else {
                $str .= ' OR accounts.currencyid = '.$currency;
            }
        }
        
        $str .= ' )';
        
        return $str;
    }*/
?>