<?php
//pay/api/queries/balance
//OJO HABLAR CON JAVIER ANTES DE HACER CUALQUIER MODIFICACIÓN EN ESTE SERVICIO NO INVERTIR TIEMPO INECESARIO

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('deviceid', 'datefrom', 'dateto', 'offset', 'numofrecords', 'order');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $deviceid = $_GET['deviceid'];
    $type = determinateType($_GET['typelst']);
    $curr = determinateCurrencies($_GET['currlst']);
    $datefrom = " AND DATE(t.datecreated) >= DATE('".mysqli_real_escape_string($db, date('Y-m-d', strtotime($_GET['datefrom'])))."') ";
    $dateto = " AND DATE(t.datecreated) <= DATE('".mysqli_real_escape_string($db, date('Y-m-d', strtotime($_GET['dateto'])))."') ";
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrecords'];
    $order = determinateOrder($_GET['order']);
    
    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    $sql = "SELECT A.* FROM (SELECT t.id AS id, 
           t.dsc AS  dsc,
           currencies.id AS currid,
           currencies.name AS currname,
           currencies.symbol AS currsymbol,
           currencies.decimals AS decimals,
           currencies.icon AS icon,
           (SELECT COUNT(tx.id) 
               FROM transactions tx 
               WHERE tx.txid = t.txid) AS txcount,
           (CASE 
               WHEN t.dsc LIKE '%Comisión %' THEN 'Comisión' 
               WHEN deposits.transactionid IS NOT NULL THEN 'Depósito' 
               WHEN withdrawals.transactionid IS NOT NULL THEN 'Retiro' 
               WHEN paytxdetails.transactionid IS NOT NULL THEN 'Pagos AFX Pay'
               WHEN (t.paypending = 0 AND t.accountorigin IS NULL) AND t.txid = t.id THEN 'Ajuste' 
               WHEN t.dsc LIKE '%Transferencia%' AND t.accountorigin IS NOT NULL THEN 'Transferencia' 
               WHEN t.dsc LIKE '%Intercambio%' AND t.accountorigin IS NOT NULL THEN 'Intercambio' 
               ELSE 'No definido'
               END) AS type,
           IF(t.amount = 0, t.amountghost, t.amount) AS amount, 
           DATE_FORMAT(t.datecreated, '%Y-%m-%d %H:%i') AS datecreated, 
           t.amountghost AS amountghost, 
           t.txid AS txid
           FROM currencies, accounts, transactions t 
            LEFT JOIN withdrawals ON withdrawals.transactionid = t.txid 
            LEFT JOIN paytxdetails ON paytxdetails.transactionid = t.txid
            LEFT JOIN deposits ON deposits.transactionid = t.txid
           WHERE t.accountid = accounts.id
           AND accounts.currencyid = currencies.id
           AND accounts.userid = $userid
           AND accounts.paymentmethodid = -1
           AND accounts.entityusrid = $entityid
           AND t.validthru IS NULL
           $datefrom
           $dateto
           $curr
           $type
            $order) A
            LIMIT $offset, $numofrecords";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>determinateDBError($db), "type" => $type));
        
    $records = [];
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        $record->txid = (int)$row['txid'];
        $record->dsc = $row['dsc'];
        $record->type = $row['type'];
        
        $record->datehour = new stdClass();
        $record->datehour->date = date('Y-m-d H:i:s', strtotime($row['datecreated']));
        $record->datehour->formatted = date('d/m/Y h:i A', strtotime($row['datecreated']));
        
        $record->currency = new stdClass();
        $record->currency->id = (int)$row['currid'];
        $record->currency->name = $row['currname'];
        $record->currency->symbol = $row['currsymbol'];
        $record->currency->decimals = (int)$row['decimals'];
        
        // Por default esta aprobado el movimiento
        $record->status = 1;
        
        // Validamos que el file exista
        $urljson = "../../icons/icons.json";
        
        if(file_exists($urljson)){
            // SI existe obtenemos el json
            $json = json_decode(file_get_contents($urljson), true);
            $record->currency->icon = null;
            foreach($json['icons'] as $icon){
                if ($icon['name'] == $row['icon']) {
                    $record->currency->icon = $homeurlpay."icons/".$icon['url'];
                }
            }
        }else{
            $record->currency->icon = null;
        }
        
        $record->amount =  new stdClass();
        $record->amount->number = (float)bcdiv(number_format($row['amount'],13, '.', ''), '1',$row['decimals']);
        $record->amount->formatted = numberFormatt($record->amount->number,$row["decimals"]);
        
        $record->details = new stdClass();
        
        // Validamos el tipo para deteminar su details
        if($record->type == 'Intercambio' || $record->type == 'Transferencia'){
            
            //  Obtenemos el paypending
            $sql = "SELECT paypending FROM transactions WHERE txid = ".$record->txid;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $paypending = $res->fetch_assoc();
            
            if($paypending['paypending'] == 1){
                $record->status = 0;
            } else if($row['txcount'] == 4 || $row['txcount'] == 8 || $row['txcount'] == 1){
                $record->status = 1;
            }else if($row['txcount'] == 0){
                $record->status = 0;
            } else if ($row['txcount'] == 3) {
                // Validamos si el movimiento tiene alguna devolucion
                $sql = "SELECT tran.dsc AS dsc ".
                "       FROM transactions tran ".
                "       WHERE tran.dsc LIKE '%".$record->txid."%'".
                "       AND '".$record->dsc."' LIKE 'Transferencia PAY%'".
                "       AND tran.id = tran.txid ".
                "       LIMIT 1";
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db).$sql));
                
                $payTransfer = $res->fetch_assoc();
                
                if ($payTransfer['dsc'] != null) {
                    $record->status = -1;
                } else {
                    $record->status = 1;
                }
            }
            
            // Obtenemos la moneda de la otra cuenta
            $sql = "SELECT transactions.id AS txid, accounts.id AS accountid ".
            "       FROM transactions, accounts ".
            "       WHERE transactions.txid = ".$record->id.
            "       AND transactions.accountid = accounts.id".
            "       AND accounts.currencyid != ".$record->currency->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $detailsrow = $res->fetch_assoc();
            
            // SI es null, colocamos la misma moneda
            if($detailsrow['txid'] != null){
                // Buscamos la moneda de ese ID
                $sql = "SELECT
                        currencies.id AS currid,
                        currencies.name AS currname,
                        currencies.symbol AS currsymbol,
                        currencies.decimals AS decimals,
                        currencies.icon AS icon
                        FROM accounts, currencies
                        WHERE accounts.id = ".$detailsrow['accountid'];
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
            
                $currrow = $res->fetch_assoc();
                        
                $record->details->currency = new stdClass();
                $record->details->currency->id = (int)$currrow['currid'];
                $record->details->currency->name = $currrow['currname'];
                $record->details->currency->symbol = $currrow['currsymbol'];
                $record->details->currency->decimals = (int)$currrow['decimals'];
                // Validamos que el file exista
                $urljson = "../../icons/icons.json";
                
                if(file_exists($urljson)){
                    // SI existe obtenemos el json
                    $json = json_decode(file_get_contents($urljson), true);
                    $record->currency->icon = null;
                    foreach($json['icons'] as $icon){
                        if ($icon['name'] == $currrow['icon']) {
                            $record->details->currency->icon = $homeurlpay."icons/".$icon['url'];
                        }
                    }
                }else{
                    $record->details->currency->icon = null;
                }
            } else {
                $record->details->currency = new stdClass();
                $record->details->currency->id = (int)$row['currid'];
                $record->details->currency->name = $row['currname'];
                $record->details->currency->symbol = $row['currsymbol'];
                $record->details->currency->decimals = (int)$row['decimals'];
                
                // Validamos que el file exista
                $urljson = "../../icons/icons.json";
                
                if(file_exists($urljson)){
                    // SI existe obtenemos el json
                    $json = json_decode(file_get_contents($urljson), true);
                    $record->currency->icon = null;
                    foreach($json['icons'] as $icon){
                        if ($icon['name'] == $row['icon']) {
                            $record->details->currency->icon = $homeurlpay."icons/".$icon['url'];
                        }
                    }
                }else{
                    $record->details->currency->icon = null;
                }
            }
        
        } else if ($record->type == 'Retiro' || $record->type == 'Depósito') {
            // Obtenemos la referencia
            $sql = "SELECT IF(wi.transactionid IS NULL, de.ref, wi.ref) AS ref ".
            "       FROM transactions".
            "       LEFT JOIN deposits de ON de.transactionid = transactions.txid".
            "       LEFT JOIN withdrawals wi ON wi.transactionid = transactions.txid".
            "       WHERE transactions.id = ".$record->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $detailsrow = $res->fetch_assoc();
            $record->details->ref = $detailsrow['ref'];
            
            //Consultamos datos del deposito
            $sql = "SELECT * FROM deposits WHERE transactionid = ".$record->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $deposit = $res->fetch_assoc();
            
            if($deposit["createddate"] != null){
                //Tipo deposito
                if($deposit["valid"] != null && $deposit["rejected"] == null){
                    $record->status = 1;
                }else if($deposit["valid"] == null && $deposit["rejected"] != null){
                    $record->status = -1;
                }else{
                    $record->status = 0;
                }
            } else {
                $sql = "SELECT * FROM withdrawals WHERE transactionid = ".$record->id;
                if (!$res=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
                    
                $withdrawals = $res->fetch_assoc();
                
                if($withdrawals["createddate"] != null){
                    if($withdrawals["valid"] != null && $withdrawals["rejected"] == null){
                        $record->status = 1;
                    }else if($withdrawals["valid"] == null && $withdrawals["rejected"] != null){
                        $record->status = -1;
                    }else{
                        $record->status = 0;
                    }
                }
            }
        } else if ($record->type == 'Pagos AFX Pay') {
            
            //  Obtenemos el paypending
            $sql = "SELECT paypending FROM transactions WHERE txid = ".$record->txid;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
            
            $paypending = $res->fetch_assoc();
            
            if ($paypending['paypending'] == 1) {
                $record->status = 0;
            } else {
                $record->status = 1;
            }
        
            // Obtenemos el pay details
            $sql = "SELECT accountdestination AS accountdest,".
            "       accountorigin AS accountor ".
            "       FROM transactions ".
            "       WHERE id = ".$record->id;
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>determinateDBError($db)));
        
            $detailsrow = $res->fetch_assoc();
            
            if ($detailsrow['accountor'] != null) {
                // COnsultamos la cuenta de origen
                $sql = "SELECT ".
                "       IF(users.type = 1, ".
                "           CONCAT(usrperson.fname,IF(".
                "               usrperson.sname IS NOT NULL, CONCAT(' ',usrperson.sname), '')), ".
                "           usrcompany.name) AS name, ".
                "       IF(users.type = 1, ".
                "           CONCAT(usrperson.flastname,IF(".
                "               usrperson.slastname IS NOT NULL, CONCAT(' ',usrperson.slastname), '')), ".
                "           usrcompany.comercialname) AS secondname, ".
                "       users.id AS userid ".
                "       FROM accounts, users ".
                "       LEFT JOIN userpersons usrperson ON users.id = usrperson.usrid ".
                "       LEFT JOIN usercompanies usrcompany ON users.id = usrcompany.usrid ".
                "       WHERE accounts.id = ".$detailsrow['accountor'].
                "       AND accounts.userid = users.id";
                if (!$resacc=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
            
                $accountor = $resacc->fetch_assoc();
                
                $record->details->origin = new stdClass();
                $record->details->origin->id = (int)$accountor['userid'];
                $record->details->origin->name = $accountor['name']." ".$accountor['secondname'];
            }
            
            if ($detailsrow['accountdest'] != null) {
                $sql = "SELECT ".
                "       IF(users.type = 1, ".
                "           CONCAT(usrperson.fname,IF(".
                "               usrperson.sname IS NOT NULL, CONCAT(' ',usrperson.sname), '')), ".
                "           usrcompany.name) AS name, ".
                "       IF(users.type = 1, ".
                "           CONCAT(usrperson.flastname,IF(".
                "               usrperson.slastname IS NOT NULL, CONCAT(' ',usrperson.slastname), '')), ".
                "           usrcompany.comercialname) AS secondname, ".
                "       users.id AS userid ".
                "       FROM accounts, users ".
                "       LEFT JOIN userpersons usrperson ON users.id = usrperson.usrid ".
                "       LEFT JOIN usercompanies usrcompany ON users.id = usrcompany.usrid ".
                "       WHERE accounts.id = ".$detailsrow['accountdest'].
                "       AND accounts.userid = users.id";
                if (!$resacc=$db->query($sql))
                    badEnd("500", array("msg"=>determinateDBError($db)));
            
                $accountdest = $resacc->fetch_assoc();
                
                $record->details->destination = new stdClass();
                $record->details->destination->id = (int)$accountdest['userid'];
                $record->details->destination->name = $accountdest['name']." ".$accountdest['secondname'];
            }
        }
        
        foreach($records as $transaction){
            //Si se encuentra validamos que status tiene el movimiento
            if($row["txid"] == $transaction->id){
                
                $record->status = (int)$transaction->status;
                
            }
        }
        
        $records [] = $record;
    }
    
    $out->transactions = $records;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para determinar el orden de los movimientos
    *   1 = Fecha reciente
    */
    function determinateOrder($order){
        $str = '';
        
        switch($order){
            case 1:
                $str = 'ORDER BY datecreated DESC, id ASC';
                break;
            default:
                $str = 'ORDER BY datecreated DESC, id ASC';
        }
        
        return $str;
    }
    
    /* Funcion para determinar el tipo de operacion a obtener, donde:
    *   1 = Depositos
    *   2 = Retiros
    *   3 = Transferencias
    *   4 = Intercambios
    */
    function determinateType($types){
        if($types=="")return "";    
    
        $typeArr = explode('-', $types);
        $query = 'AND (';
        
        foreach($typeArr as $index => $type){
            if ($index > 0) {
                $query .= " OR ";
            }
            switch($type){
                case 1:
                    $query .= " paytxdetails.transactionid IS NOT NULL";
                    break;
                case 2:
                    $query .= " paytxdetails.transactionid IS NOT NULL";
                    break;
                case 3:
                    $query .= " t.txid = deposits.transactionid OR t.txid = withdrawals.transactionid";
                    break;
                case 4:
                    $query .= " (t.dsc LIKE '%Transferencia%' AND t.accountorigin IS NOT NULL OR t.dsc LIKE '%Intercambio%' AND t.accountorigin IS NOT NULL)";
                    break;
                default:
                    $query .= "";
            }
        }
        
        $query .= ")";
        
        return $query;
    }
    
    function determinateCurrencies($curr) {
        if($curr=="")return "AND (null)";  
        
        $currenciesArr = explode('-',$curr);
        $str = ' AND (';
        
        foreach($currenciesArr as $index => $currency){
            if($index == 0){
                $str .= ' accounts.currencyid = '.$currency;
            } else {
                $str .= ' OR accounts.currencyid = '.$currency;
            }
        }
        
        $str .= ' )';
        
        return $str;
    }
?>