<?php
//pay/api/receivepayment/generate
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $headers = apache_request_headers();
    
    // parametros obligatorios
    $parmsob = array('Authentication', 'Entity');
    if (!parametrosValidos($headers, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    // parametros obligatorios
    $parmsob = array('amountrx','amounttx', 'currencytx', 'currencyrx');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //definimos las variables y las rellenamos con los datos recibidos del POST
    $out = new stdClass();
    $sessionid = $headers['Authentication'];
    $entityid = $headers['Entity'];
    $amountrx = $_POST['amountrx'];
    $amounttx = $_POST['amounttx'];
    $currencytx = $_POST['currencytx'];
    $currencyrx = $_POST['currencyrx'];
    $rate = 0;

    //Validamos la sesion
    $userid = isSessionValidPAY($db, $sessionid);
    
    // Obtenemos los datos del usuario
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $userdata = $res->fetch_assoc();
    
    // Obtenemos la moneda a recibir
    $sql = "SELECT * FROM currencies WHERE id = ".$currencyrx.
    "       AND xfer = 1";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $currencydata = $res->fetch_assoc();
    
    if($currencydata['id'] == null){
        badEnd("402", array("msg"=>"Moneda no encontrada"));
    }
    
    // Obtenemos la cuenta del usuario
    $sql = "SELECT accounts.currencyid AS accurrencyid, ".
    "       accounts.id AS accountid ".
    "       FROM accounts, payusers ".
    "       WHERE accounts.userid = payusers.userid ".
    "       AND payusers.sessionid = '".$sessionid."' ".
    "       AND accounts.paymentmethodid = -1 ".
    "       AND accounts.entityusrid = ".$entityid.
    "       AND accounts.currencyid = ".$currencyrx;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $accountdata = $rs->fetch_assoc();
    
    if($accountdata['accountid'] == null){
        badEnd("500",array("msg"=>"accountid no encontrado"));
    }
    
    // Obtenemos las monedas que acepta el usuario
    $sql = "SELECT receivecurrencies FROM payusers WHERE userid = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdata = $rs->fetch_assoc();
    $acceptedcurrencies = $userdata['receivecurrencies'];
    
    //Obtenemos el minimo de todos por nivel 1 y usuario natural
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$currencyrx.
    "       AND levelid = 1".
    "       AND usertype = 1";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    
    //Validamos que el monto sea mas que el minimo aceptado
    if(validateMin($currencyrx,1, 2, $db, $amountrx)){
        badEnd("403", array("msg"=>"Monto m&iacute;nimo autorizado: ".numberFormatt($fee['minxfer'], $currencydata['decimals'])));
    }
    
    validateOperations($db, $accountdata['accountid'], $userid, $amountrx, 3);
    
    $validator = getValidator(8);
    
    // Obtenemos el tiempo de expiracion del cobro
    $sql = "SELECT cmspreferences.* FROM cmspreferences WHERE id = 1 ";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg4"=>determinateDBError($db)));
    
    $expitime = $res->fetch_assoc();
    
    $payoptime = $expitime['payoptime'] == null ? 15 : $expitime['payoptime'];
    
    // Insertamos el cobro
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       accountid, ".
    "       accountorigin, ".
    "       amount, ".
    "       amountghost, ".
    "       accountdestination, ".
    "       validator, ".
    "       validthru, ".
    "       paypending ".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Solicitud de Cobro PAY de ".$userdata['usr']."', ".
    "       ".$accountdata["accountid"].", ".
   "        NULL, ".
    "       0, ".
    "       ".$amountrx.", ".
     "       ".$accountdata["accountid"].", ".
    "       ".$validator.", ".
    "       DATE_ADD(NOW(), INTERVAL ".$payoptime." MINUTE), ".
    "       1".
    "       )";
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>$db->error,"error"=>$sql));
    }
    
    //Guardamos el id de la transaccion de deposito
    $txid = (int)$db->insert_id;
    $out->txid = $txid;
    
    $sql = "UPDATE transactions SET ".
    "       txid = ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>$db->error,"error"=>$sql));
    }
    
    // Insertamos los datos del cobro
    $sql = "INSERT INTO paytxdetails ".
    "       (".
    "       transactionid, ".
    "       amounttx, ".
    "       currencytx,".
    "       acceptedcurrencies".
    "       )".
    "       VALUES(".
    "       ".$txid.", ".
    "       ".$amounttx.", ".
    "       ".$currencytx.", ".
    "       '".$acceptedcurrencies."'".
    "       )";
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>$db->error,"error"=>$sql));
    }
    
    // Obtenemos el nombre del usuario
    $sql = "SELECT IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name ".
    "       FROM payusers ".
    "       LEFT JOIN userpersons ON userpersons.usrid = payusers.userid ".
    "       LEFT JOIN usercompanies ON usercompanies.usrid = payusers.userid ".
    "       WHERE sessionid = '".$sessionid."'";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdataaudit = $res->fetch_assoc();
    
    $ipaddress = getRealIP();
    // Auditoria
    setAuditPAY($db, "OPERACIONES", $sessionid, "APP", "Se registró un cobro por ".$amountrx." (".$out->txid.") en ".$currencydata['name'].", del usuario ".$userdataaudit['name'], $ipaddress);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>