<?php
// pay/api/register/createuserperson
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../../app/hooks/PHPMailer5/PHPMailerAutoload.php';
    // parametros obligatorios
    $parmsob = array('email', 'mobilephone', 'doctype', 'doc', 'hash');
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $email = $_POST['email'];
    $mobilephone = $_POST['mobilephone'];
    $doctype = $_POST['doctype'];
    $doc = $_POST['doc'];
    $hash = $_POST['hash'];
    
    // Validamos si el usuario ya existe
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM users ".
    "       WHERE UPPER(usr) = UPPER('".$email."')";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    // Validamos el hash debe ser formato (email + mobilephone + hoy en formato yyyymmdd)
    // Hacemos 3 hash con fechas distintas
    $hashbase = md5($email.$mobilephone.date("Ymd"));
    $hashtomorrow = md5($email.$mobilephone.date('Ymd', strtotime(' +1 day')));
    $hashyesterday = md5($email.$mobilephone.date('Ymd', strtotime(' -1 day')));
    // validamos que la tercera parte sea igual a hoy en yyyymmdd, o ayer o mañana
    if ($hashbase != $hash && $hashtomorrow != $hash && $hashyesterday != $hash) {
        badEnd("401", array("msg"=>'hash incorrecto'));
    }
    
    if ($row['qty'] == 0) {
        
        $hash = randomString(128);
        
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM users ".
        "       WHERE UPPER(usr) = UPPER('".$email."')";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row = $rs->fetch_assoc();
        
        // Si es 0 no se hace nada
        if ($row['qty'] > 0) {
            badEnd("409", array("msg"=>'Usuario ya existente'));
        }
        
        //Consultamos para verificar que no existan registros con su cedula
        $sql = "SELECT COUNT(usrid) AS qty FROM userpersons ".
        "       WHERE doc = '".$doc."'".
        "       AND doctype = ".$doctype;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        $row = $rs->fetch_assoc();
        
        // Retornamos 409 cuando doc esta duplicado
        if($row["qty"] > 0){
            badEnd("409", array("msg"=> "Documento de identificacion duplicado"));
        }
        
        // Creamos el usuario primero en la tabla users
        $sql = "INSERT INTO users(usr, status, datecreated, lang, type, paymobilephone, sessionid, validthru, lastsession)".
        "       VALUES (".
        "           '".strtolower($email)."', ".
        "           0, ".
        "           NOW(), ".
        "           'esp',".
        "           1, ".
        "           '".$mobilephone."', ".
        "           '".$hash."', ".
        "           DATE_ADD(NOW(), INTERVAL 1 DAY), ".
        "           NOW() ".
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db).$sql));
        
        $out->id = (int)$db->insert_id;
        
        // Obtenemos las 4 primeras monedas con el XFER activo
        $sql = "SELECT id FROM currencies ".
        "       WHERE xfer = 1 ".
        "       AND status = 1 ".
        "       AND id > 0 ".
        "       LIMIT 0, 4";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $count = 0;
        $currAcepted = '';
        
        while($row = $rs->fetch_assoc()) {
            if ($count == 0) {
                $currAcepted .= $row['id'];
            } else {
                $currAcepted .= ",".$row['id'];
            }
            $count++;
        }
        
        // Insertamos el hash del registro en pay
        $sql = "INSERT INTO payusers(userid, sessionid, datecreated, validthru,receivecurrencies, sendcurrencies, acceptedcurrencies)".
        "       VALUES (".$out->id.", ".
        "       '".$hash."', ".
        "       NOW(), ".
        "       DATE_ADD(NOW(), INTERVAL 1 DAY), ".
        "       '".$currAcepted."', ".
        "       '".$currAcepted."', ".
        "       '".$currAcepted."' ".
        ")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>determinateDBError($db)));
        
        // Obtenemos el id de venezuela
        $sql = "SELECT id FROM countries WHERE name LIKE '%Venezuela%'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $country = $rs->fetch_assoc();

        //Insertamos el usuario como natural
        $sql = "INSERT INTO userpersons(usrid, venezuelan, countryid, doctype, doc, phone, lastupdate, step)".
        "       VALUES (".$out->id.", 1, ".$country['id'].", '".$doctype."', '".$doc."', '".$mobilephone."', NOW(), 0)";
        if (!$db->query($sql))
            badEnd("500", array("msg1"=>determinateDBError($db)));
        
        // Obtenemos el nombre del usuario
        $sql = "SELECT users.id, users.usr AS email, IF(userpersons.fname IS NULL, usercompanies.name, CONCAT(userpersons.fname,' ',userpersons.flastname)) AS name, ".
        "       IF(users.type = 1, userpersons.phone, usercompanies.phone) AS phone, " .
        "       users.level AS level, users.lang AS lang ".
        "       FROM users ".
        "       LEFT JOIN userpersons ON userpersons.usrid = users.id ".
        "       LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
        "       WHERE id = ".$out->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg2"=>determinateDBError($db)));
            
        $userdatatmp = $res->fetch_assoc();
        
        $subject = "Gracias por ser parte de AFX";
        $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
        $body = "<div class='emailBox'>".
        "           <img class='afxLogo' src='".$homeurl."/settings/img/logo-email.png'/>".
        "           <div class='mainBox'>".
        "               <h1 class='titleEmail'>".
        "                   ".$userdatatmp['name'].
        "               </h1>".
        "               <p class='msgEmail'>".
        "                   Te damos la bienvenida a AFX PAY.<br>Ingresa en nuestra aplicación móvil y completa el registro para comenzar a ser parte de la nueva economía digital.".
        "               </p>".
        "               <a class='urlNavigateBox' style='margin-top: 15px;' href=".$homeurl."?id=register&sid=register&hash=".$hash."&email=".strtolower($email).">".
        "                   <p style='margin: auto; display: block;color: #FFF;font-size: 16px;text-align:center;line-height: 58px;font-weight:bold;'>".
        "                       Regístrate".
        "                   </p>".
        "               </a>".
        "           </div>".
        "           <p class='copy'>".$footerEmails."</p>".
        "       </div>";
        
        $body = templateEmail($body, $STANDAR_STYLE_EMAIL);
        
        enviarCorreo2($fromeMail, strtolower($userdatatmp['email']), $subject, $body);
            
        // Se valida la preferenca del mensaje y se envia seggun el idioma
        $msg = "Te damos la bienvenida a AFX PAY. Ingresa en nuestra aplicación móvil y completa el registro para comenzar a ser parte de la nueva economía digital";
        enviarSMS($userdatatmp['phone'], $msg);

        // Enviamos el mensaje por la mensajeria interna
        saveInternalMsg($db, $msg, $userdatatmp["id"], $userdatatmp['email'], $userdatatmp['phone']);
    } else {
        // Validamos si es nivel 0
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM users ".
        "       WHERE UPPER(usr) = UPPER('".$email."')".
        "       AND level = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row = $rs->fetch_assoc();
        
        // Si es 0 no se hace nada
        if ($row['qty'] == 0) {
            badEnd("409", array("msg"=>'Usuario ya existente'));
        }
        
        // Obtenemos el id del usuario
        $sql = "SELECT id ".
        "       FROM users ".
        "       WHERE UPPER(usr) = UPPER('".$email."')";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row = $rs->fetch_assoc();
        
        // Actualizamos los datos del usuario
        $sql = "UPDATE userpersons SET ".
        "       doctype = '".$doctype."', ".
        "       doc = '".$doc."', ".
        "       phone = '".$mobilephone."'".
        "       WHERE usrid = ".$row['id'];
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        // Actualizamos el mobilephone de la tabla users
        $sql = "UPDATE users SET ".
        "       paymobilephone = '".$mobilephone."'".
        "       WHERE id = ".$row['id'];
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // ID del usuario actualizado
        $out->id = (int)$row['id'];
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>