<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Order;
use App\Currency;
use App\HistoricalMarkets;
use Carbon\Carbon;

class ChartData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Chart:Data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Minute By Minute Chart Historical Data';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $now = Carbon::now();
        $this->info('Start Chart Historical Data');

        $currencies = Currency::Where('exchangeable', '1')->get();

        foreach ($currencies as $currency) {
          $query = Currency::whereNotIn('symbol', [$currency->symbol])->where('active', true);

          if($currency->symbol == 'USD'){

          }elseif ($currency->symbol == 'BTC') {

            $query->whereNotIn('symbol', ['USD']);

          }else{

            $query->where('exchangeable', '0')->where('prima','0');

          }

          $name = $query->get();


          foreach($name as $secondCu){

            $orderf = Order::Where('status','complete')->where(function($query) use($currency){
              $query->Where('out_currency', 'like', '%'.$currency->id.'%')
              ->orWhere('in_currency', 'like', '%'.$currency->id.'%');
            });


            $orderf->where(function($query) use($secondCu){
              $query->Where('out_currency', 'like', '%'.$secondCu->id.'%')
              ->orWhere('in_currency', 'like', '%'.$secondCu->id.'%');
            })->orderBy('updated_at')->first();

            if($orderf->count()){

              $initstamp = $orderf->updated_at;
              $diff = $initstamp->diffInMinutes($now);

              for($i = 0; $i < $diff; $i++){

                $ordersHB = Order::where('updated_at', '<=', $initstamp)->where('trade_type', 'bid')->where(function($query) use($currency){
                  $query->Where('out_currency', 'like', '%'.$currency->id.'%')
                  ->orWhere('in_currency', 'like', '%'.$currency->id.'%');
                });

                $ordersHB->where(function($query) use($secondCu){
                  $query->Where('out_currency', 'like', '%'.$secondCu->id.'%')
                  ->orWhere('in_currency', 'like', '%'.$secondCu->id.'%');
                })->orderBy('rate')->first();


              }
            }
          }
        }







    }
}
