<?php

namespace App\Console\Commands;

use App\Currency;
use App\Order;
use App\User;
use Illuminate\Console\Command;
use Kraken;

class CreateOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'orders:create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Orders in Kraken';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        //Select Users With Client Role
        $users = User::whereHas('roles', function ($query) {
            $query->where('code', '30');
        })->get();

        $currencies = Currency::Where('exchangeable', true)->where('active', true)->where('type', 'Cryptocurrency')->get();

        foreach ($users as $user) {

            foreach ($currencies as $currency) {
                $query = Currency::whereNotIn('symbol', [$currency->symbol])->where('active', true);
                if ($currency->symbol == 'USD') {

                } else if ($currency->prima) {
                    $query->where('prima', '0');
                } else {
                    $query->where('exchangeable', '0')->where('prima', '0');
                }
                $currencies2 = $query->get();

                foreach ($currencies2 as $currency2) {
                    if ($currency->symbol == 'BTC') {
                        $sym = 'XBT';
                        $sym2 = $currency2->symbol;
                    } else if ($currency2->symbol == 'BTC') {
                        $sym2 = 'XBT';
                        $sym = $currency->symbol;
                    } else {
                        $sym = $currency->symbol;
                        $sym2 = $currency2->symbol;
                    }

                    $query = Order::where('orders.type', 'exchange')->where('status', 'pending')->orderBy('rate', 'asc');

                    $query->Where(function ($query) use ($currency) {
                        $query->Where('in_currency', 'like', '%' . $currency->id . '%')
                            ->orWhere('out_currency', 'like', '%' . $currency->id . '%');
                    });

                    $query->Where(function ($query) use ($currency2) {
                        $query->Where('in_currency', 'like', '%' . $currency2->id . '%')
                            ->orWhere('out_currency', 'like', '%' . $currency2->id . '%');
                    });

                    $orders = $query->get();

                    foreach ($orders as $order) {

                        if ($currency->type == 'FIAT') {
                            $pair = 'X' . $sym2 . 'Z' . $sym;
                        } else if ($currency2->type == 'FIAT') {
                            $pair = 'X' . $sym . 'Z' . $sym2;
                        } else {
                            $pair = 'X' . $sym2 . 'X' . $sym;
                        }

                        if ($order->trade_type == 'bid') {
                            $type = 'buy';
                            $volume = (string) number_format($order->in_amount, 8);
                        } else {
                            $type = 'sell';
                            $volume = (string) number_format($order->out_amount, 8);
                        }
                        $price = (string) number_format($order->rate, 8);
                        $this->info('Pair ' . $pair . ' amount ' . $price);
                        $kraken = Kraken::trade($pair, $type, "limit", $volume, $price);
                        $order->reference = $kraken['result']['txid'][0];
                        $order->status = 'processing';
                        $order->save();
                    }
                }
            }
        }
    }
}
