<?php

namespace App\Console\Commands;


use Illuminate\Console\Command;
use App\Http\Controllers\Mail\Maintenance;
use Illuminate\Support\Facades\Mail;
use App\User;
use App\Level;
use App\Balance;
use App\Setting;
use App\Order;


class MaintenanceCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:maintenance';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Put Maitenance';

    private $setting;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {
        $users = User::with(['orders', 'profile', 'balances'])->get();

        foreach($users as $user){

            $this->info($user->profile->fname . ' ' . $user->profile->flastname);
            foreach($user->orders as $order){
                /*$this->info($order->id . ' ' . $order->status);
 
                if($order->status == 'pending' && $order->status != 'complete'){
                    $or = Order::find($order->id);
                    $balanceout = $user->balances->where('currency_id', $or->out_currency)->first();
                    $balanceoutG = Balance::where('currency_id', $or->out_currency)->where('user_id', null)->first();

                    $balanceout->pending_amount -= $or->out_amount;
                    $balanceoutG->pending_amount -= $or->out_amount;

                    $balanceout->amount += $or->out_amount;
                    $balanceoutG->amount += $or->out_amount;

                    $user->push();
                    $balanceoutG->save();
                    $this->info('Deleted Order #' . $or->id);
                    
                    $or->delete();
                }
                */
            }

            //Mail::to($user->email)->send(new Maintenance());

        }


    }


}
