<?php

namespace App\Console\Commands;

use App\Balance;
use App\Historical;
use App\User;
use Carbon\Carbon;
use Illuminate\Console\Command;

class VerifyHistory extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'history:verify';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify if Historical Data exist in the system';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        //Select Users With Client Role
        $users = User::whereHas('roles', function ($query) {
            $query->where('code', '30');
        })->get();

        //Select Actual Date
        $today = Carbon::now();

        //Loop Users
        foreach ($users as $user) {

            $this->info('Start History Data For User ' . $user->name);

            //Verify If User Has Minutes histories and has a period
            if ($user->historicals()->first() == null) {

                //Show In terminal
                $this->info('User: ' . $user->name . ' Initiate Data History');

                $initialT = $user->created_at;

                //Diference beetween Last date and actual date
                $diffD = $initialT->diffInMinutes($today);

                // Declare Initial Date for Minutes
                $init = $initialT;

                //Loop Dates for Minutes
                for ($i = 0; $i <= $diffD; $i++) {

                    $this->info('Minute: Date ' . $init);

                    //Create Array
                    $balances = array();

                    //Declare Sumatory
                    $sum = 0;

                    //Select initial date timestamp
                    $initstamp = $init->timestamp;

                    //declare count
                    $count = 0;

                    //Select Balances
                    $balances = Balance::Where('balances.type', 'fund')->where('user_id', $user->id)->leftJoin('currencies', 'currencies.id', '=', 'balances.currency_id')->select('balances.*', 'symbol', 'value', 'currencies.type', 'name')->get();

                    //Loop $balances array
                    foreach ($balances as $balance) {

                        //Verify if balance amount is greater than 0
                        if ($balance->amount > 0) {

                            //select Symbol balance
                            $symbol = $balance->symbol;

                            //Sleep System for 1 second
                            sleep(1);

                            //Get price historical data from CryptoCompare
                            $json = file_get_contents('https://min-api.cryptocompare.com/data/pricehistorical?fsym=' . $symbol . '&tsyms=USD&ts=' . $initstamp);
                            $data = json_decode($json);

                            //Verify If Get Error from CryptoCompare
                            if (isset($data->Response)) {

                                $this->info('Minute: ' . $balance->symbol . ' ' . $data->Response);

                            } else {

                                $this->info('Minute: ' . $balance->symbol . ' value: ' . $data->$symbol->USD);

                                //Check Symbol for assign Values
                                if (strtolower($symbol) == 'prs') {
                                    sleep(1);

                                    $json2 = file_get_contents('https://min-api.cryptocompare.com/data/pricehistorical?fsym=ETH&tsyms=USD&ts=' . $initstamp);
                                    $data2 = json_decode($json2);

                                    //Put Data USD As Value
                                    $balance->value = $data2->ETH->USD;

                                } else {

                                    //Put Data USD As Value
                                    $balance->value = $data->$symbol->USD;

                                }
                            }

                            //Assign USD Amount for balance
                            $na = $balance->amount * $balance->value;

                            $this->info('Minute: ' . $balance->symbol . ' amount: ' . $balance->amount . ' newAmount: ' . $na);

                        } else {

                            // Assign USD Amount as 0 if balance is equal to 0
                            $na = 0;

                        }

                        //USD Amount Summatory
                        $sum += $na;

                    }

                    $this->info('Minute: Date ' . $init->toFormattedDateString() . ' Total: ' . $sum);

                    //Create Date History in Database
                    $history = new Historical;
                    $history->register = $init;
                    $history->amount = $sum;
                    $history->type = "balance";
                    $history->user()->associate($user);
                    $history->save();

                    //Add Minutes To Initial Time
                    $init = $init->addMinutes(1);

                }

                $this->info('End Minute Historical Data');
            }
        }
    }
}
