<?php

namespace App\Console\Commands;

use App\Account;
use App\Balance;
use App\Currency;
use App\User;
use Illuminate\Console\Command;
use Kraken;
use TCV;
class VerifyWithdraws extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'withdraw:verify';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verify withdraws in the system';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        //Select Users With Client Role
        $users = User::whereHas('roles', function ($query) {
            $query->where('code', '30');
        })->get();

        $currencies = Currency::Where('type', 'Cryptocurrency')->get();

        foreach ($users as $user) {

            foreach ($currencies as $currency) {
                if ($currency->symbol == 'PTR') {

                    $this->info('Verify Withdraw in ' . $currency->name . ' for user ' . $user->fname . ' ' . $user->flastname);

                    $withdraws = $user->orders()->where('type', 'withdraw')->where('status', 'pending')->where('out_currency', $currency->id)->get();

                    foreach ($withdraws as $withdraw) {

                        $this->info('Withdraws PTR ' . $withdraw->reference);

                        sleep(1);

                        $tcv = TCV::viewWithdraw($currency->symbol, 1000);
                        foreach ($tcv as $with) {
							$this->info($with['id']);
                            if (strtolower($withdraw->reference) == strtolower($with['id'])) {

                                $this->info('Withdraw N° ' . $withdraw->reference . ' Have A Match - Status: ' . $withdraw['state']);

                                if ($with['confirmations'] > 2 && $withdraw->status == 'pending') {

                                    $this->info('Withdraw N° ' . $withdraw->reference . ' Is Successfully');

                                    $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();
                                    $balanceG = Balance::where('currency_id', $currency->id)->where('user_id', null)->first();

                                    $balance->pending_amount = $balance->pending_amount - ($withdraw->out_amount + $withdraw->fee);
                                    $balanceG->pending_amount = $balanceG->pending_amount - ($withdraw->out_amount + $withdraw->fee);

                                    $withdraw->status = 'complete';
									$withdraw->reference = $with['blockchain_txid'];

                                    $withdraw->save();
                                    $balance->save();
                                    $balanceG->save();
                                }
                            }
                        }
                    }
                } else {
                    if ($currency->symbol == 'BTC') {
                        $sym = 'XBT';
                    } else {
                        $sym = $currency->symbol;
                    }

                    $this->info('Verify Withdraws in ' . $currency->name . ' for user ' . $user->fname . ' ' . $user->flastname);

                    $withdraws = $user->orders()->where('type', 'withdraw')->where('status', 'pending')->where('out_currency', $currency->id)->get();

                    if (count($withdraws)) {
                        foreach ($withdraws as $withdraw) {
                            $this->info('Verify Withdraw N° ' . $withdraw->reference);

                            sleep(1);

                            $account = Account::find($withdraw->account_id);

                            $kraken = Kraken::viewWithdraw($sym, $account->key_account);

                            foreach ($kraken['result'] as $with) {

                                if ($withdraw->reference == $with['refid']) {

                                    $this->info('Withdraw N° ' . $withdraw->reference . ' Have A Match');

                                    if (strtolower($with['status']) == 'success' && $withdraw->status == 'pending') {

                                        $this->info('Withdraw N° ' . $withdraw->reference . ' Is Successfully');

                                        $balance = Balance::where('currency_id', $currency->id)->where('user_id', $user->id)->first();
                                        $balanceG = Balance::where('currency_id', $currency->id)->where('user_id', null)->first();

                                        $balance->pending_amount -= $withdraw->out_amount + $withdraw->fee;
                                        $balanceG->pending_amount -= $withdraw->out_amount + $withdraw->fee;

                                        $withdraw->status = 'complete';
                                        $withdraw->reference = $with['txid'];

                                        $withdraw->save();
                                        $balance->save();
                                        $balanceG->save();
                                    }
                                }
                            }
                        }
                    }
                }

            }
        }
    }
}
