<?php

namespace App\Console\Commands;

use App\Balance;
use App\Http\Controllers\Mail\OrderComplete;
use App\Order;
use App\Setting;
use App\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use Kraken;
use TCV;

class fastMarket extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'market:create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Market in Kraken';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {
        $orders = Order::Where('orders.type', 'market')->where('status', 'pending')->with(['outCurrencyOrder', 'inCurrencyOrder'])->orderBy('created_at', 'asc')->get();
        $setting = Setting::First();

        foreach ($orders as $order) {

            if ($order->outCurrencyOrder->type == 'Cryptocurrency' && $order->inCurrencyOrder->type == 'FIAT') {
                $fee = $setting->fee_crypto_fiat;
            } else if ($order->outCurrencyOrder->type == 'Cryptocurrency' && $order->inCurrencyOrder->type == 'Cryptocurrency') {
                $fee = $setting->fee_crypto_crypto;
            } else {
                $fee = $setting->fee_fiat_crypto;
            }
            $firstP = (strtolower($order->outCurrencyOrder->symbol) == 'ves' || strtolower($order->outCurrencyOrder->symbol) == 'ptr');
            $secondP = (strtolower($order->inCurrencyOrder->symbol) == 'ves' || strtolower($order->inCurrencyOrder->symbol) == 'ptr');

            if ($firstP || $secondP) {

                /*if (strtolower($order->outCurrencyOrder->symbol) == 'ves' || strtolower($order->inCurrencyOrder->symbol) == 'ves') {
                    $this->info('VES OPERATION BEGIN');

                    $this->info('Order Type: ' . $order->trade_type . ' Out Amount: ' . $order->out_amount . ' ' . $order->outCurrencyOrder->symbol . ' In Amount: ' . $order->in_amount . ' ' . $order->inCurrencyOrder->symbol);

                    if ($order->trade_type == 'bid') {

                        $cprice = $order->outCurrencyOrder->price;
                        $vprice = $order->inCurrencyOrder->price;
                        $price = $cprice / $vprice;

                        $Torders = Order::WhereNotIn('user_id', [$order->user_id])->Where('orders.type', 'market')->where('in_currency', $order->outCurrencyOrder->id)->where('orders.trade_type', 'ask')->where('status', 'pending')->with(['outCurrencyOrder', 'inCurrencyOrder'])->orderBy('created_at', 'asc')->get();

                        $this->info('Out Price: ' . $cprice . ' In Price: ' . $vprice . ' Price: ' . $price);

                        foreach ($Torders as $or) {

                            $amount = ($or->out_amount - $or->fee_exchange) - $or->filled;

                            $filled = $amount / $price;

                            $priceBTC = $vprice / $cprice;

                            $amount2 = (($order->out_amount - $order->fee_exchange) - $order->filled);

                            $filled2 = $amount2 * $price;

                            $this->info('Amount: ' . $amount . ' filled: ' . $filled . ' price BTC: ' . $priceBTC . ' amount2: ' . $amount2 . ' filled2: ' . $filled2);

                            if ($filled >= $amount2) {

                                $rested = $amount - $filled2;

                                $this->info('Filled VES: ' . $filled2 . ' Filled BTC: ' . $order->out_amount . ' Amount: ' . $amount . ' Rested: ' . $rested);

                                if ($filled2 <= $amount) {

                                    $or->filled += $filled2;
                                    $or->counterSum += $price;
                                    $or->counter += 1;

                                    if ($or->filled == ($or->amount - $or->fee_exchange)) {

                                        $rate = $or->counterSum / $or->counter;
                                        $or->rate = $rate;
                                        $in = ($or->out_amount - $or->fee_exchange) / $rate;
                                        $or->in_amount = $in;
                                        $or->status = "complete";

                                        $balanceOI = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->in_currency)->first();
                                        $balanceOGI = Balance::Where('user_id', null)->Where('currency_id', $or->in_currency)->first();

                                        $balanceOI->amount += $or->in_amount;
                                        $balanceOGI->amount += $or->in_amount;

                                        $balanceOO = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->out_currency)->first();
                                        $balanceOGO = Balance::Where('user_id', null)->Where('currency_id', $or->out_currency)->first();

                                        $balanceOO->pending_amount -= $or->out_amount;
                                        $balanceOGO->pending_amount -= $or->out_amount;

                                        $balanceOI->save();
                                        $balanceOGI->save();
                                        $balanceOO->save();
                                        $balanceOGO->save();
                                    }
                                    $or->save();

                                    $data = [
                                        'reference' => $or->reference,
                                    ];

                                    $user = User::find($or->user_id);

                                    Mail::to([$user->email])->send(new OrderComplete($data));
                                }

                                $order->filled += $amount2;

                                $order->counterSum += $priceBTC;

                                $order->counter += 1;

                                $rate = $order->counterSum / $order->counter;

                                $order->rate = $rate;

                                $in = ($order->out_amount - $order->fee_exchange) / $rate;

                                $order->in_amount = $in;

                                $order->status = "complete";

                                $balanceI = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->in_currency)->first();
                                $balanceGI = Balance::Where('user_id', null)->Where('currency_id', $order->in_currency)->first();

                                $balanceI->amount += $order->in_amount;
                                $balanceGI->amount += $order->in_amount;

                                $balanceO = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->out_currency)->first();
                                $balanceGO = Balance::Where('user_id', null)->Where('currency_id', $order->out_currency)->first();

                                $balanceO->pending_amount -= $order->out_amount;
                                $balanceGO->pending_amount -= $order->out_amount;

                                $order->save();
                                $balanceI->save();
                                $balanceGI->save();
                                $balanceO->save();
                                $balanceGO->save();

                                $data = [
                                    'reference' => $order->reference,
                                ];

                                $user = User::find($order->user_id);

                                Mail::to([$user->email])->send(new OrderComplete($data));

                                break 2;
                            } else {

                                $this->info('Filled VES: ' . $order->out_amount . ' Filled BTC: ' . $filled . ' Amount: ' . $amount);

                                $or->filled += $amount;

                                $or->counterSum += $price;
                                $or->counter += 1;

                                $rate = $or->counterSum / $or->counter;

                                $or->rate = $rate;

                                $in = ($or->out_amount - $or->fee_exchange) / $rate;

                                $or->in_amount = $in;
                                $or->status = "complete";

                                $balanceI = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->in_currency)->first();
                                $balanceGI = Balance::Where('user_id', null)->Where('currency_id', $or->in_currency)->first();

                                $balanceI->amount += $or->in_amount;
                                $balanceGI->amount += $or->in_amount;

                                $balanceO = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->out_currency)->first();
                                $balanceGO = Balance::Where('user_id', null)->Where('currency_id', $or->out_currency)->first();

                                $balanceO->pending_amount -= $or->out_amount;
                                $balanceGO->pending_amount -= $or->out_amount;

                                $this->info('Order type: ' . $or->type . ' Order Out: ' . $or->out_amount . ' Order In: ' . $or->in_amount . ' Order Filled: ' . $or->filled . ' Order Rate: ' . $or->rate);

                                $or->save();

                                $balanceI->save();
                                $balanceGI->save();
                                $balanceO->save();
                                $balanceGO->save();

                                $data = [
                                    'reference' => $or->reference,
                                ];

                                $user = User::find($or->user_id);

                                Mail::to([$user->email])->send(new OrderComplete($data));

                                $order->filled += $filled;
                                $order->counterSum += $priceBTC;
                                $order->counter += 1;

                                if ($order->filled == ($order->amount - $order->fee_exchange)) {

                                    $rate = $order->counterSum / $order->counter;
                                    $order->rate = $rate;
                                    $in = ($order->out_amount - $order->fee_exchange) / $rate;
                                    $order->in_amount = $in;
                                    $order->status = "complete";

                                    $balanceOI = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->in_currency)->first();
                                    $balanceOGI = Balance::Where('user_id', null)->Where('currency_id', $order->in_currency)->first();

                                    $balanceOI->amount += $in;
                                    $balanceOGI->amount += $in;

                                    $balanceOO = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->out_currency)->first();
                                    $balanceOGO = Balance::Where('user_id', null)->Where('currency_id', $order->out_currency)->first();

                                    $balanceOO->pending_amount -= $order->out_amount;
                                    $balanceOGO->pending_amount -= $order->out_amount;

                                    $balanceOI->save();
                                    $balanceOGI->save();
                                    $balanceOO->save();
                                    $balanceOGO->save();

                                    $data = [
                                        'reference' => $order->reference,
                                    ];

                                    $user = User::find($order->user_id);

                                    Mail::to([$user->email])->send(new OrderComplete($data));
                                }
                                $order->save();
                                break 2;
                            }
                        }

                    }

                    if ($order->trade_type == 'ask') {

                        $this->info('Trade Type ASK start');

                        $cprice = $order->inCurrencyOrder->price;

                        $vprice = $order->outCurrencyOrder->price;

                        $price = $cprice / $vprice;

                        $Torders = Order::WhereNotIn('user_id', [$order->user_id])->Where('orders.type', 'market')->where('out_currency', $order->inCurrencyOrder->id)->where('orders.trade_type', 'bid')->where('status', 'pending')->with(['outCurrencyOrder', 'inCurrencyOrder'])->orderBy('created_at', 'asc')->get();

                        foreach ($Torders as $or) {

                            $amount = ($or->out_amount - $or->fee_exchange) - $or->filled;

                            $filled = $amount * $price;

                            $priceBTC = $vprice / $cprice;

                            $amount2 = (($order->out_amount - $order->fee_exchange) - $order->filled);

                            $filled2 = $amount2 / $price;

                            $this->info('Amount: ' . $amount . ' Price: ' . $price . ' filled: ' . $filled . ' price BTC: ' . $priceBTC . ' amount2: ' . $amount2 . ' filled2: ' . $filled2);

                            if ($filled >= $amount2) {

                                $rested = $amount - $filled2;

                                $this->info('Filled VES: ' . $filled2 . ' Filled BTC: ' . $order->out_amount . ' Amount: ' . $amount . ' Rested: ' . $rested);

                                if ($filled2 <= $amount) {

                                    $or->filled += $filled2;
                                    $or->counterSum += $priceBTC;
                                    $or->counter += 1;

                                    if ($or->filled == ($or->amount - $or->fee_exchange)) {

                                        $rate = $or->counterSum / $or->counter;
                                        $or->rate = $rate;
                                        $in = ($or->out_amount - $or->fee_exchange) / $rate;
                                        $or->in_amount = $in;
                                        $or->status = "complete";

                                        $balanceOI = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->in_currency)->first();
                                        $balanceOGI = Balance::Where('user_id', null)->Where('currency_id', $or->in_currency)->first();

                                        $balanceOI->amount += $or->in_amount;
                                        $balanceOGI->amount += $or->in_amount;

                                        $balanceOO = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->out_currency)->first();
                                        $balanceOGO = Balance::Where('user_id', null)->Where('currency_id', $or->out_currency)->first();

                                        $balanceOO->pending_amount -= $or->out_amount;
                                        $balanceOGO->pending_amount -= $or->out_amount;

                                        $balanceOI->save();
                                        $balanceOGI->save();
                                        $balanceOO->save();
                                        $balanceOGO->save();
                                    }
                                    $or->save();

                                    $data = [
                                        'reference' => $or->reference,
                                    ];

                                    $user = User::find($or->user_id);

                                    Mail::to([$user->email])->send(new OrderComplete($data));
                                }

                                $order->filled += $amount2;

                                $order->counterSum += $price;

                                $order->counter += 1;

                                $rate = $order->counterSum / $order->counter;

                                $order->rate = $rate;

                                $in = ($order->out_amount - $order->fee_exchange) / $rate;

                                $order->in_amount = $in;

                                $order->status = "complete";

                                $balanceI = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->in_currency)->first();
                                $balanceGI = Balance::Where('user_id', null)->Where('currency_id', $order->in_currency)->first();

                                $balanceI->amount += $order->in_amount;
                                $balanceGI->amount += $order->in_amount;

                                $balanceO = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->out_currency)->first();
                                $balanceGO = Balance::Where('user_id', null)->Where('currency_id', $order->out_currency)->first();

                                $balanceO->pending_amount -= $order->out_amount;
                                $balanceGO->pending_amount -= $order->out_amount;

                                $order->save();
                                $balanceI->save();
                                $balanceGI->save();
                                $balanceO->save();
                                $balanceGO->save();

                                $data = [
                                    'reference' => $order->reference,
                                ];

                                $user = User::find($order->user_id);

                                Mail::to([$user->email])->send(new OrderComplete($data));

                                break 2;
                            } else {

                                $this->info('Filled VES: ' . $order->out_amount . ' Filled BTC: ' . $filled . ' Amount: ' . $amount);

                                $or->filled += $amount;

                                $or->counterSum += $priceBTC;
                                $or->counter += 1;

                                $rate = $or->counterSum / $or->counter;

                                $or->rate = $rate;

                                $in = ($or->out_amount - $or->fee_exchange) / $rate;

                                $or->in_amount = $in;
                                $or->status = "complete";

                                $balanceI = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->in_currency)->first();
                                $balanceGI = Balance::Where('user_id', null)->Where('currency_id', $or->in_currency)->first();

                                $balanceI->amount += $or->in_amount;
                                $balanceGI->amount += $or->in_amount;

                                $balanceO = Balance::Where('user_id', $or->user_id)->Where('currency_id', $or->out_currency)->first();
                                $balanceGO = Balance::Where('user_id', null)->Where('currency_id', $or->out_currency)->first();

                                $balanceO->pending_amount -= $or->out_amount;
                                $balanceGO->pending_amount -= $or->out_amount;

                                $this->info('Order type: ' . $or->type . ' Order Out: ' . $or->out_amount . ' Order In: ' . $or->in_amount . ' Order Filled: ' . $or->filled . ' Order Rate: ' . $or->rate);

                                $or->save();

                                $balanceI->save();
                                $balanceGI->save();
                                $balanceO->save();
                                $balanceGO->save();

                                $data = [
                                    'reference' => $or->reference,
                                ];

                                $user = User::find($or->user_id);

                                Mail::to([$user->email])->send(new OrderComplete($data));

                                $order->filled += $filled;
                                $order->counterSum += $price;
                                $order->counter += 1;

                                if ($order->filled == ($order->amount - $order->fee_exchange)) {

                                    $rate = $order->counterSum / $order->counter;
                                    $order->rate = $rate;
                                    $in = ($order->out_amount - $order->fee_exchange) / $rate;
                                    $order->in_amount = $in;
                                    $order->status = "complete";

                                    $balanceOI = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->in_currency)->first();
                                    $balanceOGI = Balance::Where('user_id', null)->Where('currency_id', $order->in_currency)->first();

                                    $balanceOI->amount += $in;
                                    $balanceOGI->amount += $in;

                                    $balanceOO = Balance::Where('user_id', $order->user_id)->Where('currency_id', $order->out_currency)->first();
                                    $balanceOGO = Balance::Where('user_id', null)->Where('currency_id', $order->out_currency)->first();

                                    $balanceOO->pending_amount -= $order->out_amount;
                                    $balanceOGO->pending_amount -= $order->out_amount;

                                    $balanceOI->save();
                                    $balanceOGI->save();
                                    $balanceOO->save();
                                    $balanceOGO->save();

                                    $data = [
                                        'reference' => $order->reference,
                                    ];

                                    $user = User::find($order->user_id);

                                    Mail::to([$user->email])->send(new OrderComplete($data));
                                }
                                $order->save();
                                break 2;
                            }
                        }

                    }
                } else*/ 
                if (strtolower($order->outCurrencyOrder->symbol) == 'ptr' || strtolower($order->inCurrencyOrder->symbol) == 'ptr') {

                    $this->info('PTR BEGIN');
                    $this->info($order->id);
                    $sym = strtolower($order->outCurrencyOrder->symbol);//PTR
                    $sym2 = strtolower($order->inCurrencyOrder->symbol);//BTC
                    $balanceTCV = TCV::getBalance();
                    $validate = false;
                    foreach ($balanceTCV as $balance) {
                        if (strtolower($balance['currency']) == strtolower($order->outCurrencyOrder->symbol)) {
                            if (doubleval($balance['balance']) < $order->out_amount) {
                                $tcv = TCV::viewDeposits($order->outCurrencyOrder->symbol, 'submitted', 100);
                                $count = $balance['balance'];
                                foreach ($tcv as $depo) {
                                    $count += $depo['amount'];
                                }
                                if ($count < $order->out_amount) {
                                    $amount = $order->out_amount - $count;
                                    $amount = $amount + ($amount * 0.01);
                                    $value = $amount * $order->outCurrencyOrder->price;

                                    if ($value < 100) {
                                        $amount = 100 / $order->outCurrencyOrder->price;
                                    }

                                    //$kraken = KRAKEN::WithdrawFunds($order->outCurrencyOrder->symbol, 'TCV', $amount);

                                }
                            } else {
                                $validate = true;
                            }
                        }

                    }
                    if (!$validate) {
                        continue;
                    }

                    if ($order->trade_type == 'ask') {
                        $number = $order->in_amount;
                        $type = 'buy';
                        $xpair = $sym2 . $sym;
                        $volume = (string) number_format($number, 8);
                        $book = TCV::getOrderBook($xpair);
                        $this->info('BEGIN ' . $xpair);
                        $price = $book['asks'][0]['price'];
                    } else {
                        $number = $order->out_amount;
                        $type = 'sell';
                        $xpair = $sym . $sym2;
                        $volume = (string) number_format($number, 8);
                        $book = TCV::getOrderBook($xpair);
                        $price = $book['bids'][0]['price'];
                    }
                    $equivalent = $volume * $price;
                    $this->info('BEGIN ' . $price . ' ' . $xpair);

                    $this->info('Pair ' . $xpair);
                    $this->info('Pair ' . $xpair . ' type ' . $type . ' volume ' . $volume . ' price ' . $price . ' equivalent: ' . $equivalent);
                    /*error_log('Pair ' . $xpair . ' type ' . $type . ' volume ' . $volume . ' price ' . $price . ' equivalent: ' . $equivalent, 0);*/
                    if ($order->status == 'pending') {
                        $request = ['market' => $xpair, 'side' => $type, 'volume' => $volume, 'price' => $price];
                        $postdata = http_build_query($request, '', '&');

                        $curl = curl_init();

                        curl_setopt_array(
                            $curl,
                            array(
                                CURLOPT_SSL_VERIFYPEER => true,
                                CURLOPT_SSL_VERIFYHOST => 2,
                                CURLOPT_USERAGENT => 'TCV PHP API Agent',
                                CURLOPT_POST => true,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_CONNECTTIMEOUT => 20,
                                CURLOPT_TIMEOUT => 300,
                            )
                        );

                        $this->info($postdata);
                        curl_setopt($curl, CURLOPT_URL, 'https://tcvex.tcv.com.ve:443/api/v2/orders?' . $postdata);
                        curl_setopt($curl, CURLOPT_POSTFIELDS, $postdata);
                        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                            'Authorization: eyJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1ODkyOTY5MjAsImV4cCI6MTU4OTI5NjkyMCwic3ViIjoic2Vzc2lvbiIsImlzcyI6ImJhcm9uZyIsImF1ZCI6WyJwZWF0aW8iLCJiYXJvbmciXSwianRpIjoiRUE0ODhBQTY5NzQ1MTg2RTdCRTNGMjVDIiwidWlkIjoiSUQ5MUNDMkRBQ0U2IiwiZW1haWwiOiJhc2Vzb3JpYWZpbmFuY2llcmFjLmEyMDE4QGdtYWlsLmNvbSIsInJvbGUiOiJtZW1iZXIiLCJsZXZlbCI6Miwic3RhdGUiOiJhY3RpdmUifQ.u_ZrUoDRJ90EXmXI5WNwvnzovs6ZP3ImeuKD2VdqLkWHdcAh2IKvfuzvi4X0oSB45mRY6kibbvMk1ReLd6oE28oKXi5baanTfUcLbyxMbGv5W_ErO7GvtXDbp8laM8sVcQ76I63pynj-oXkbNVlyBnhTcRPwkn6LGIKgqmvm1xS7nJmnSKL9Ydw0oLcDxdJfUSjpnK03QM6CGNWvrrzBjOF7Se1HmeIB6BSX2PYtQZw3EbaiogsmoNYJ4ucZw0hMStUzWFESUIBItLFuXN32e1fHPafRzZkBzoRPM5y944sAoPQiDyTqhWfflbpSGE3FgxFAfm3O5Hnf8SaQV4fg5w',
                        ));

                        $result = curl_exec($curl);

                        if ($result === false) {
                            $this->info('CURL error: ' . curl_error($curl));
                        }

                        $this->info($result);

                        // decode results
                        $result = json_decode($result, true);

                        if (!is_array($result)) {
                            $this->info('JSON decode error');
                        }

                        if (!empty($result['error'])) {
                            $this->info($result['error']['message']);
                        } else {
                            $this->info($result['id']);
                        }
                        $order->txid = $result['id'];
                        $order->status = 'processing';
                        $order->save();
                        $this->info('Order Saved: Id ' . $result['id']);
                    }

                }
            } /*else {
                if ($order->outCurrencyOrder->symbol == 'BTC') {
                    $sym = 'XBT';
                    $sym2 = $order->inCurrencyOrder->symbol;
                } else if ($order->inCurrencyOrder->symbol == 'BTC') {
                    $sym = 'XBT';
                    $sym2 = $order->outCurrencyOrder->symbol;
                } else {
                    $sym = $order->inCurrencyOrder->symbol;
                    $sym2 = $order->outCurrencyOrder->symbol;
                }
                if ($order->outCurrencyOrder->symbol == 'FIAT') {

                    $pair = 'X' . $sym2 . 'Z' . $sym;
                } else if ($order->inCurrencyOrder->symbol == 'FIAT') {

                    $pair = 'X' . $sym . 'Z' . $sym2;
                } else {
                    if ($sym2 == 'DASH' || $sym == 'DASH') {
                        $pair = $sym2 . $sym;
                    } else {
                        $pair = 'X' . $sym2 . 'X' . $sym;
                    }
                }
                if ($sym == 'XBT' || $sym2 == "XBT") {

                    if ($order->trade_type == 'bid') {
                        $number = $order->in_amount - ($order->in_amount * $fee);
                        $type = 'buy';
                        $xpair = $sym . $sym2;
                        $volume = (string) number_format($number, 8);
                    } else {
                        $number = $order->out_amount - ($order->out_amount * $fee);
                        $type = 'sell';
                        $xpair = $sym2 . $sym;
                        $volume = (string) number_format($number, 8);
                    }
                    $this->info('Pair ' . $pair . ' Volume: ' . $volume . ' Type: ' . $type);

                    //dd($pair);
                    $krakenM = Kraken::trade($pair, $type, "market", $volume);

                    
                    if($krakenM['error']){
                        $this->info('Kraken Error: ' . $krakenM['error'][0]);
                    }

                    $order->txid = $krakenM['result']['txid'][0];
                    $order->status = 'processing';
                    $order->save();
                } else {

                    if ($order->trade_type == 'bid') {
                        $number = $order->in_amount - ($order->in_amount * $fee);

                        $volume = (string) number_format($number, 8);
                    } else {
                        $number = $order->in_amount - ($order->in_amount * $fee);

                        $volume = (string) number_format($number, 8);
                    }

                    $pair1 = $pair = 'X' . $sym2 . 'XXBT';
                    $type1 = "buy";
                    $pair2 = $pair = 'X' . $sym . 'XXBT';
                    $type2 = "sell";

                    $this->info('Pair ' . $pair1);
                    $kraken1 = Kraken::trade($pair1, $type1, "market", $volume);
                    $txid = $kraken1['result']['txid'][0];

                    do {

                        $krakenVerify = Kraken::getClosedOrders();

                        $krorder = $krakenVerify['result']['closed'];
                        $validate = false;

                        foreach ($krorder as $key => $value) {
                            if ($key == $txid) {
                                if ($value['status'] == 'closed') {
                                    $vol = $value['vol'];
                                    $validate = true;
                                }
                            }
                        }
                    } while ($validate == false);

                    $this->info('Pair ' . $pair2);

                    $kraken2 = Kraken::trade($pair2, $type2, "market", $vol);
                    $order->txid = $kraken2['result']['txid'][0];
                    $order->status = 'processing';
                    $order->save();
                }
            }*/
        }
    }
}
