<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    { 
        // $schedule->command('inspire')
        //          ->hourly();
        $schedule->command('market:create')->everyMinute()->withoutOverlapping(60);
        $schedule->command('market:verify')->everyMinute()->withoutOverlapping(60);
        $schedule->command('deposit:verify')->everyMinute()->withoutOverlapping(60);
        $schedule->command('withdraw:verify')->everyMinute()->withoutOverlapping(60);
        $schedule->command('newsletter:send')->daily();
       // $schedule->command('orders:verify')->everyMinute();
        $schedule->command('price:verify')->everyMinute();
        //$schedule->command('orders:create')->everyTenMinutes();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
