<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use PragmaRX\Google2FAQRCode\Google2FA;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Mail\SendCode;
use QrCode;

use App\UserData;
use App\Level;

class AuthenticatorController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('doublefactor.index');
    }

    /* Auth via email */
    public function emailTwoFactor()
    {
        return view('doublefactor.email2fa.two-factor');
    }

    public function generateSecretCode()
    {
        $code = mt_rand(999, 999999);
        $user = Auth::user();
        $email = $user->email;
        $data = $user->data;
        $data->email_code = $code;
        $data->save();
        Mail::to($email)->send(new SendCode($code));
        return view('doublefactor.email2fa.validate-auth');
    }

    public function verifyEmailCode(Request $request)
    {
        $user = Auth::user();
        $code = $user->data->email_code;
        $secret = $request->one_time_password;
        if($code == $secret) {
            $user->two_verified = 1;
            $user->data->verify_via_email = 1;
            $user->push();
            return response()->json('Verified', 200);
        }
        return response()->json('Not Verified ', 401);
    }


    /* Google Authenticator */
    public function twoFactor()
    {
        $url = 'https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=es';
        $qr = base64_encode(QrCode::format('png')->size(200)->generate($url));

        return view('doublefactor.google2fa.two-factor', ['QR_Image' => $qr]);
    }

    public function gAuthenticate(Request $request)
    {
        $user = Auth::User();
        $data = $user->data;
        if(!$data->secret_status){
            $google2fa = new Google2FA();
            $data->google2fa_secret = $google2fa->generateSecretKey(32);
            $data->save();
            
            $QR_Image = $google2fa->getQRCodeInline(
            'AFX Trade',
            $user->email,
            $data->google2fa_secret
            );

            return view('doublefactor.google2fa.register', ['QR_Image' => $QR_Image, 
                                                'secret' => $data->google2fa_secret
                                            ]);
        }
        return view('doublefactor.google2fa.validate-auth');
    }

    public function validateGoogleAuth()
    {
        return view('doublefactor.google2fa.validate-auth');
    }

    public function verifySecret(Request $request)
    {
        $user = Auth::user();
        $secret = $user->data->google2fa_secret;
        $otp = $request->input('one_time_password');
        $google2fa = new Google2FA();
        $val = $google2fa->verifykey($secret, $otp, 0);

        if($val){
            $user->two_verified = 1;
            $user->data->secret_status = 1;
            $user->push();
            return response()->json(['success' => 'Verified', 'google2fa' => 1], 202);
        }
        return response()->json(['error' => 'Not Verified'], 401);
    }

    public function validateCode(Request $request)
    {
        $secret = Auth::user()->data->google2fa_secret;

        $otp = $request->input('one_time_password');

        $google2fa = new Google2FA();
        $val = $google2fa->verifykey($secret, $otp, 0);

        if($val){
            return response()->json(['success' => 'Verified'], 200);
        }
        
        return response()->json(['error' => 'Not Verified'], 401);
    }


    /* Disable 2FA */
    public function desactive2FA()
    {
        $user = Auth::user();
        $user->data->secret_status = 0;
        $user->data->verify_via_email = 0;
        $user->two_verified = 0;
        $user->push();

        return response()->json(['success' => 'Success'], 200);
    }

    public function verifyAuth()
    {
        $user_id = Auth::user()->id;
        $data = UserData::select('secret_status', 'verify_via_email', 'sms_verify')
                        ->where('user_id', $user_id)
                        ->first();

        return response()->json(['data' => $data], 200);
    }

    /* Confirm Auth with email */
    public function gSecretEmailCode()
    {
        $code = mt_rand(999, 999999);
        $user = Auth::user();
        $email = $user->email;
        $data = $user->data;
        $data->email_code = $code;
        $data->save();
        Mail::to($email)->send(new SendCode($code));
    }

    public function vEmailCode(Request $request)
    {
        $user = Auth::user();
        $code = $user->data->email_code;
        $secret = $request->secret;

        if($code == $secret) {
            return response()->json('Verified', 200);
        }
        return response()->json('Not Verified ', 401);
    }

    /* Confirm Auth with Google Authenticator */
    public function vGoogleSecret(Request $request)
    {
        $user = Auth::user();
        $secret = $user->data->google2fa_secret;
        $otp = $request->secret;
        $google2fa = new Google2FA();
        $val = $google2fa->verifykey($secret, $otp, 0);

        if($val){
            return response()->json('Verified', 200);
        }
        return response()->json('Not Verified ', 401);
    }
}