<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Storage;
use App\Profile;
use App\User;
use App\Level;
use App\Organization;
use App\Patner;

class KycController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', '2fa', 'verify.ip']);
    }

    public function getLevel()
    {
        $user_id = Auth::user()->id;
        $user = User::where('id', $user_id)->with('data')->first();
        return response()->json(['user' => $user], 200);
    }

    public function kyc()
    {
        return view('kyc.index');
    }

    public function validTypePerson(Request $request)
    {
        if($request->has('type_person')) {
            $user = Auth::user()->profile;
            $type_person = $request->type_person;

            if($type_person == 2) {
                $organization = New Organization;
                $organization->user_id = $user->user_id;
                $organization->save();
            }

            $user->user_type = $type_person;
            $user->save();

            return response()->json('success', 200);
        }
    }

    /**************************************** Natural ********************************************/
    public function firstValidation()
    {
        return view('kyc.natural.first-verify');
    }

    public function validPersonalInformation(Request $request)
    {
        $request->validate([
            'type_id' => 'required|integer',
            'identification' => 'required|string|max:20',
            'issuing_state' => 'required|string',
            'date_issue' => 'required|string',
            'date_expiry' => 'required|string',
            'gender' => 'required|string',
            'marital_status' => 'required|integer',
            'country' => 'required|integer',
            'state' => 'required|integer',
            'city' => 'required|integer',
            'street' => 'required|string|max:100',
            'house' => 'required|string|max:100',
            'postal' => 'required|string|max:6',
            'phone' => 'required|string|max:18',
            'birthDate' => 'required|string|max:255',
            'bornCity' => 'required|integer'
        ]);

        $users = User::all();

        foreach($users as $user){
            if($request->identification == $user->profile->id_number){
                return response()->json(['result' => 'success', 'message' => 'Cedula de identidad ya existe.'], 400);
            }
        }
        
        $profile = Auth::user()->profile;
        $profile->type_id = $request->type_id;  
        $profile->issuing_state = $request->issuing_state;
        $profile->date_issue = $request->date_issue;
        $profile->date_expiry = $request->date_expiry;     
        $profile->gender = $request->gender;
        $profile->marital_status = $request->marital_status;     
        $profile->id_number = $request->identification;
        $profile->street = $request->street;
        $profile->house = $request->house;
        $profile->postal_code = $request->postal;
        $profile->born_date = $request->birthDate;
        $profile->phonenumber = $request->phone;
        $profile->country_id = $request->country;
        $profile->region_id = $request->state;
        $profile->city_id = $request->city;
        $profile->born_site = $request->bornCity;
        $profile->save();

        return response()->json(['result' => 'success'], 202);
    }

    public function secondValidation()
    {
        return view('kyc.natural.second-verify');
    }

    public function validatePhotoID(Request $request)
    {
        if($request->has('photo_id')) {
            $user = Auth::user();
            $file = $request->file('photo_id');
            $name = uniqid().'.jpg';
            $file->storeAs('public/'.$user->profile->id_number, $name);
            $document = $user->document;
            $document->identification = $name;
            $document->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validateSelfie(Request $request)
    {
        if($request->has('selfie')) {
            $user = Auth::user();
            $file = $request->file('selfie');
            $name = uniqid().'.jpg';
            $file->storeAs('public/'.$user->profile->id_number, $name);
            $document = $user->document;
            $document->selfie = $name;
            $document->save();

            $user->kyc_verified = 1;
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function thirdValidation()
    {
        return view('kyc.natural.third-verify');
    }

    public function validProfessionalInformation(Request $request)
    {
        $request->validate([
            'profession_occupation' => 'required|string',
            'position' => 'required|string|max:20',
            'politically_exposed_person' => 'required|integer',
            'years_in_company' => 'required|integer',
            'annual_income' => 'required'
        ]);

        $user_id = Auth::user()->id;
        $profile = Profile::where('user_id', $user_id)->first();
        $profile->profession_occupation = $request->profession_occupation;  
        $profile->position = $request->position;

        if($request->politically_exposed_person) {
            $profile->politically_exposed_person = $request->politically_exposed_person;
            if($request->select_exposed_person == 'public_employee') {
                $profile->public_employee = 1;
            }else if($request->select_exposed_person == 'military') {
                $profile->military = 1;
            }else if($request->select_exposed_person == 'political_party_member') {
                $profile->political_party_member = 1;
            }else if($request->select_exposed_person == 'diplomat') {
                $profile->diplomat = 1;
            }
        }

        $profile->years_in_company = $request->years_in_company;
        $profile->annual_income = $request->annual_income;

        $profile->save();

        return response()->json(['result' => 'success'], 202);
    }

    public function quarterValidation()
    {
        return view('kyc.natural.quarter-verify');
    }

    public function getPersonExposed()
    {
        $id = Auth::user()->id;
        $person = Profile::where('user_id', $id)->first()->politically_exposed_person;
        return response()->json($person);
    }

    public function validateAddress(Request $request)
    {
        if($request->has('address')) {
            $user = Auth::user();
            $file = $request->file('address');
            $name = uniqid().'.jpg';
            $file->storeAs('public/'.$user->profile->id_number, $name);
            $document = $user->document;
            $document->mailing_address = $name;
            $document->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function validatePersonExposed(Request $request)
    {
        if($request->has('person_exposed')) {
            $user = Auth::user();
            $file = $request->file('person_exposed');
            $name = uniqid().'.pdf';
            $file->storeAs('public/'. $user->profile->id_number, $name);
            $document = $user->document;
            $document->politically_exposed_person = $name;
            $document->save();

            $user->kyc_verified = 2;
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function fifthValidation()
    {
        return view('kyc.natural.fifth-verify');
    }

    public function validBankInformation(Request $request)
    {
        $request->validate([
            'financial_institution' => 'required|string',
            'account_number' => 'required|string',
        ]);
        $profile = Auth::user()->profile;
        $profile->financial_institution = $request->financial_institution;  
        $profile->account_number = $request->account_number;
        
        $profile->save();

        return response()->json(['result' => 'success'], 202);
    }

    public function sixthValidation()
    {
        return view('kyc.natural.sixth-verify');
    }

    public function validBankDocument(Request $request)
    {
        if($request->has('source_founds') && $request->has('sworn_declaration')) {
            $user_id = Auth::user()->id;
            $user = User::with('document')->where('id', $user_id)->first();
            $file_source = $request->file('source_founds');
            $name_source = uniqid().'.pdf';
            $file_source->storeAs('public/'. $user->profile->id_number, $name_source);
            $document = $user->document;
            $document->source_founds = $name_source;
            
            $file_sworn = $request->file('sworn_declaration');
            $name_sworn = uniqid().'.pdf';
            $file_sworn->storeAs('public/'. $user->profile->id_number, $name_sworn);
            $document = $user->document;
            $document->sworn_declaration = $name_sworn;

            $document->save();

            $user->kyc_verified = 3;
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }


    /******************************************************************************************/

    /************************************************Juridic**********************************/
    public function firstValidationJuridic()
    {
        return view('kyc.juridic.first-verify');
    }

    public function validJuridicInformation(Request $request)
    {   
        $request->validate([
            'corporate_name' => 'required|string',
            'date_incorporation' => 'required|string',
            'country' => 'required|integer',
            'state' => 'required|integer',
            'city' => 'required|integer',
            'place_incorporation' => 'required|string',
            'postal' => 'required|string|max:6',
            'register_incoporation_office' => 'required|string',
            'type_company' => 'required|string',
            'shareholders' => 'required|integer',
            'fname_legal_representative' => 'required|string',
            'sname_legal_representative' => 'required|string',
            'flastname_legal_representative' => 'required|string',
            'slastname_legal_representative' => 'required|string',
            'id_legal_representative' => 'required|string|max:18',
            'position' => 'required|string',
            'email_address' => 'required|string|max:100',
            'merchant_record' => 'required|string',
            'issuing_state' => 'required|string',
            'date_issue' => 'required|string',
            'date_expiry' => 'required|string',
            'phone_number' => 'required|string',
            'website' => 'nullable|string',
            
        ]);
        
        $shareholders = $request->shareholders;
        
        $user_id = Auth::user()->id;

        $organization = Organization::where('user_id', $user_id)->first();
        $organization->user_id = $user_id;
        $organization->corporate_name = $request->corporate_name;
        $organization->date_incorporation = $request->date_incorporation;
        $organization->country_id = $request->country;
        $organization->region_id = $request->state;
        $organization->city_id = $request->city;
        $organization->place_incorporation = $request->place_incorporation;
        $organization->postal_code = $request->postal;
        $organization->register_incoporation_office = $request->register_incoporation_office;
        $organization->type_company = $request->type_company;
        $organization->shareholders = $shareholders;
        $organization->email_address = $request->email_address;
        $organization->merchant_record = $request->merchant_record;
        $organization->issuing_state = $request->issuing_state;
        $organization->date_issue = $request->date_issue;
        $organization->date_expiry = $request->date_expiry;
        $organization->phone_number = $request->phone_number;
        $organization->website = $request->website;
        $organization->update();
        
        $patner = new Patner;
        $patner->organization_id = $organization->id;
        $patner->position = $request->position;
        $patner->fname_legal_representative = $request->fname_legal_representative;
        $patner->sname_legal_representative = $request->sname_legal_representative;
        $patner->flname_legal_representative = $request->flastname_legal_representative;
        $patner->slname_legal_representative = $request->slastname_legal_representative;
        $patner->id_legal_representative = $request->id_legal_representative;
        
        if($patner->save()) {
            return response()->json(['success' => 'Success', 'shareholders' => $shareholders], 201);
        }

        return response()->json('error', 400);
    }

    public function viewPatner()
    {
        return view('kyc.juridic.patners');
    }

    public function getPatners()
    {
        $user_id = Auth::user()->id;
        $shareholders = Organization::where('user_id', $user_id)->first()->shareholders;

        return response()->json(['patners' => $shareholders], 200);
    }

    public function postPatners(Request $request)
    {
        $organization_id = Auth::user()->organization->id;
        $shareholders = $request->shareholders;

        if($shareholders) {
            foreach($shareholders as $shareholder) {
                $patner = new Patner;
                $patner->organization_id = $organization_id;
                $patner->position = $shareholder['ocupation'];
                $patner->fname_legal_shareholder = $shareholder['fname'];
                $patner->sname_legal_shareholder = $shareholder['sname'];
                $patner->flname_legal_shareholder = $shareholder['flastname'];
                $patner->slname_legal_shareholder = $shareholder['slastname'];
                $patner->id_legal_shareholder = $shareholder['identification'];
                $patner->save();
            }
            
            return response()->json('success', 201);
        }

        return response()->json('error', 400);
    }

    public function secondValidationJuridic()
    {
        return view('kyc.juridic.second-verify');
    }

    public function validJuridicDocument(Request $request)
    {
        if($request->has('rif') && $request->has('register')) {
            $user_id = Auth::user()->id;
            $user = User::with('document', 'organization')->where('id', $user_id)->first();
            $file_rif = $request->file('rif');
            $name_rif = uniqid().'.pdf';
            $file_rif->storeAs('public/'.$user->organization->merchant_record, $name_rif);
            $document = $user->document;
            $document->rif = $name_rif;
            
            $file_register = $request->file('register');
            $name_register = uniqid().'.pdf';
            $file_register->storeAs('public/'.$user->organization->merchant_record, $name_register);
            $document = $user->document;
            $document->merchant_record = $name_register;

            $document->save();

            $user->kyc_verified = 1;
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }

    public function thirdValidationJuridic()
    {
        return view('kyc.juridic.third-verify');
    }

    public function validProfessionalInformationJuridic(Request $request)
    {
        $request->validate([
            'business_sector' => 'required|string',
            'products' => 'required|string',
            'services' => 'required|string',
            'monthly_income' => 'required|string',
            'annual_income' => 'required|string',
            'net_worth' => 'required|string',
        ]);
        
        $user_id = Auth::user()->id;

        $organization = Organization::with('user')->where('user_id', $user_id)->first();
        $organization->business_sector = $request->business_sector;
        $organization->products = $request->products;
        $organization->services = $request->services;
        $organization->monthly_income = $request->monthly_income;
        $organization->annual_income = $request->annual_income;
        $organization->net_worth = $request->net_worth;
        $organization->user->kyc_verified = 2;
        $organization->push();
        
        return response()->json(['success' => 'Success'], 201);
    }

    public function quarterValidationJuridic()
    {
        return view('kyc.juridic.quarter-verify');
    }

    public function validBankInformationJuridic(Request $request)
    {
        $request->validate([
            'account_number' => 'required|string',
            'ABA_routing' => 'required|string',
            'SWIFT' => 'required|string',
            'IBAN' => 'required|string',
            'financial_institution' => 'required|string',
            'bank_address' => 'required|string',
            'currency' => 'required|string',
        ]);
        
        $user_id = Auth::user()->id;

        $organization = Organization::with('user')->where('user_id', $user_id)->first();
        $organization->account_number = $request->account_number;
        $organization->ABA_routing = $request->ABA_routing;
        $organization->SWIFT = $request->SWIFT;
        $organization->IBAN = $request->IBAN;
        $organization->financial_institution = $request->financial_institution;
        $organization->bank_address = $request->bank_address;
        $organization->currency = $request->currency;
        $organization->update();

        return response()->json(['success' => 'Success'], 201);
    }

    public function fifthValidationJuridic()
    {
        return view('kyc.juridic.fifth-verify');
    }

    public function validJuridicBankDocument(Request $request)
    {
        if($request->has('source_founds')) {
            $user_id = Auth::user()->id;
            $user = User::with('document', 'organization')->where('id', $user_id)->first();
            $file_source = $request->file('source_founds');
            $name_source = uniqid().'.pdf';
            $file_source->storeAs('public/'.$user->organization->merchant_record, $name_source);
            $document = $user->document;
            $document->source_founds = $name_source;

            $document->save();

            $user->kyc_verified = 3;
            $user->save();

            return response()->json('success', 200);
        }
        return response()->json('error', 400);
    }
    /**********************************************************************************************/

    public function successView()
    {
        return view('kyc.success');
    }
}
