<?php

namespace App\Http\Controllers\Auth;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use JWTAuth;
use App\User;
use App\Session;
use Carbon\Carbon;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    //protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    //Validation function for login

    protected function validateLogin(Request $request)
    {   
        $this->validate($request, [
        $this->username() => 'required',
        'password' => 'required',
        'g-recaptcha-response' => 'required|captcha',
        ]);     
    }

    //Update after login 
    protected function authenticated(Request $request, $user)
    {
        if (Auth::check()){
            $session = new Session;

            $ip = $request->ip();
            $user_agent = $request->server('HTTP_USER_AGENT');
            $user_agent = $request->header('User-Agent');
            $time = Carbon::now();  

            $userAuth = Auth::user();
            $user = User::where('id', $userAuth->id)->first();
            $user->last_login = $time;
            //$user->ip_last_login = $ip;
            $user->save();

            $sessions = Session::where('user_id', $user->id)->get();
            $exist = count($sessions);

            if($exist == 0){
                $session->user_id = $user->id;
                $session->ip_address = $ip;
                $session->user_agent = $user_agent;
                $session->verified = 1;
                $session->last_activity = $time;
                $session->save();
            }

            $address = $session->where('user_id', $user->id)
                                ->where('ip_address', $ip)
                                ->first();

            if(!$address){
                $session->user_id = $user->id;
                $session->ip_address = $ip;
                $session->user_agent = $user_agent;
                $session->last_activity = $time;
                $session->save();
                return redirect()->route('validate-ip');
            }

            $token = $user->generateJWT();
            
            if($address){
                if($address->verified){
                    return redirect()->route('validate-ip');
                }else{
                    return redirect()->route('validate-ip');
                }
            }
        }
    }    

    public function logout(Request $request)
    {
        $user = Auth::user();
        $user->two_verified = 0;
        $user->save();
        Auth::logout();
        return redirect('/');
    }
}
