<?php

namespace App\Http\Controllers\Backend;

use App\Account;
use App\Currency;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Kraken;
use TCV;

class AccountController extends Controller
{

    //Execute if user is authenticated
    public function __construct()
    {

        $this->middleware(['auth', '2fa', 'verify.ip']);

    }

    //Function for order arrays
    private function sorting($order, $key)
    {

        return function ($a, $b) use ($order, $key) {

            if ($order == 'DESC') {
                if (empty($key)) {

                    return strnatcmp($a->amount, $b->amount);

                } else {

                    return strnatcmp($a->$key, $b->$key);

                }

            } else {

                if (empty($key)) {

                    return strnatcmp($b->amount, $a->amount);

                } else {

                    return strnatcmp($b->$key, $a->$key);

                }
            }
        };
    }

    public function address(Request $request)
    {

        $type = $request->type;
        
        $user = Auth::User();
        
        $symbol = Currency::where('symbol', $request->currency)->first();

        if ($type == 'withdraw') {

            $account = Account::Where('user_id', $user->id)->where('currency_id', $symbol->id)->where('verify', true)->get();

        } else if ($type == 'deposit') {

            if ($symbol->type == 'FIAT') {

                $accountS = Account::where('currency_id', $symbol->id)->where('user_id', null)->where('verify', true)->get();

                if ($accountS) {
                    $account = array();
                    $count = 0;
                    foreach ($accountS as $acc) {
                        $account[$count] = new \stdClass();
                        $account[$count]->address = $acc->address;
                        $account[$count]->bank = $acc->entity;
                        $count += 1;
                    }

                } else {

                    $account = array();
                }

            } else {

                if ($request->currency == 'PTR') {

                    $tcv = TCV::getWallet('ptr', $user->email . $user->created_at);

                    $account = array();
                    $account[0] = new \stdClass();
                    $account[0]->address = $tcv['address'];
                    $account[0]->bank = 'PTR';

                } else {

                    if ($request->currency == 'BTC') {
                        $sym = 'XBT';
                    } else {
                        $sym = $symbol->symbol;
                    }
                    $kraken = Kraken::depositAddress($sym);
                    $co = count($kraken['result']);

                    if ($co == 0) {
                        $account = '';
                    } else {
                        $account = array();
                        $account[0] = new \stdClass();
                        $account[0]->address = $kraken['result'][$co - 1]['address'];
                        $account[0]->bank = $sym;
                    }

                }

            }
        }

        return response()->json(['result' => $account, 'message' => 'success'], 202);

    }

    //List of Newsletters
    public function index(Request $request)
    {
        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $total = 0;

        //Verify if $orderBy is empty
        if (empty($orderBy)) {

            $orderBy = 'created_at';

        }

        //Create $accounts array
        $accounts = array();

        //Create $count variable
        $count = 0;

        //Verify if user has client role
        if ($user->hasCredential('451')) {

            //Select Orders
            $query = Account::leftJoin('profiles', 'profiles.user_id', '=', 'accounts.user_id')->leftJoin('currencies', 'currencies.id', '=', 'accounts.currency_id')->select('accounts.*', 'profiles.fname', 'profiles.flastname', 'currencies.name')->orderBy('created_at', 'desc');

        } else {

            //Select Orders
            $query = Account::where('accounts.user_id', $user->id)->leftJoin('profiles', 'profiles.user_id', '=', 'accounts.user_id')->leftJoin('currencies', 'currencies.id', '=', 'accounts.currency_id')->select('accounts.*', 'profiles.fname', 'profiles.flastname', 'currencies.name')->orderBy('created_at', 'desc');

        }

        //Search by
        if ($searchValue != '') {

            $query->Where(function ($query) use ($searchValue) {
                $query->Where('fname', 'like', '%' . $searchValue . '%')
                    ->orWhere('currencies.name', 'like', '%' . $searchValue . '%')
                    ->orWhere('accounts.user_id', 'like', '%' . $searchValue . '%')
                    ->orWhere('flastname', 'like', '%' . $searchValue . '%')
                    ->orWhere('accounts.type', 'like', '%' . $searchValue . '%')
                    ->orWhere('address', 'like', '%' . $searchValue . '%')
                    ->orWhere('entity', 'like', '%' . $searchValue . '%')
                    ->orWhere('accounts.created_at', 'like', '%' . $searchValue . '%')
                    ->orWhere('accounts.updated_at', 'like', '%' . $searchValue . '%');
            });

        }
        
        if ($resultPage == null || $resultPage == 0) {

            $resultPage = 10;

        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Fund Orders
        $accountsP = $query->get();

        //Loop Fund Orders
        foreach ($accountsP as $account) {

            //Verify if $transactions array is empty
            if (empty($accounts[$count])) {

                //Create object in $transactions array
                $accounts[$count] = new \stdClass();

                $accounts[$count]->id = $account->id;
                $accounts[$count]->user_id = $account->user_id;
                $accounts[$count]->user = $account->fname . ' ' . $account->flastname;
                $accounts[$count]->type = $account->type;
                $accounts[$count]->address = $account->address;
                $accounts[$count]->verify = $account->verify;
                $accounts[$count]->entity = $account->entity;
                $accounts[$count]->created_at = $account->created_at;
                $accounts[$count]->updated_at = $account->updated_at;
                $accounts[$count]->coin = $account->name;
            }

            $count += 1;

        }

        //Sort $transactions array
        usort($accounts, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($accounts as $account) {

            //Change date to formatted string
            $newcreated = $account->created_at->toFormattedDateString();
            $newupdated = $account->updated_at->toFormattedDateString();

            //Put New Dates
            $account->created_at = $newcreated;
            $account->updated_at = $newupdated;
        }

        //Verify if user is trader or admin

        if ($user->hasCredential('451')) {

            //Return true for administrative access
            $eaccess = true;

        } else {

            //Return false for administrative access
            $eaccess = false;

        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $accounts, 'total' => $total, 'eaccess' => $eaccess], 202);
    }

    //Store Newsletter
    public function store(Request $request)
    {

        //Validate $request data
        $request->validate([
            'type1' => 'required| max:50',
            'address' => 'required| max:50',
            'entity' => 'required| max:255',
        ]);

        //Select Authenticated user
        $user = Auth::User();
        if ($request->type1 == "bank") {
            $currency = Currency::where('symbol', $request->symbol)->first();
        } else {
            $currency = Currency::where('symbol', $request->entity)->first();
        }

        

        //Assign Variables
        $type = $request->type1;
        $address = $request->address;
        $entity = $request->entity;

        $verify = Account::where('address', $request->address)->get();

        if ($verify->count()) {
            return response()->json(['error' => 'Ya existe una cuenta creada con esta dirección, en caso de haber un error comunicarse con soporte'], 403);
        }

        //Create Account
        $acc = new Account;
        $acc->type = $type;
        $acc->address = $address;
        $acc->entity = $entity;
        $acc->currency()->associate($currency);
        if (!($user->hasCredential(451))) {
            $acc->user()->associate($user);
        } else {
            $acc->verify = true;
        }
        $acc->save();

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Update Newsletter
    public function update(Request $request)
    {

        //Validate $request Data
        $request->validate([

            'id' => 'required',
            'type' => 'required| max:50',
            'address' => 'required| max:50',
            'entity' => 'required| max:255',

        ]);

        //Select Authenticated User
        $user = Auth::User();

        //Assign Variables
        $id = $request->id;
        $type = $request->type;
        $address = $request->address;
        $entity = $request->entity;

        if ($request->type == "bank") {
            $currency = Currency::where('symbol', $request->symbol)->first();
        } else {
            $currency = Currency::where('symbol', $request->entity)->first();
        }

        //Find Newsletter
        $acc = Account::find($id);

        //Modify Newsletter
        $acc->type = $type;
        $acc->address = $address;
        $acc->entity = $entity;
        $acc->currency()->dissociate();
        $acc->currency()->associate($currency);
        $acc->save();

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Update Newsletter
    public function verify(Request $request)
    {

        //Validate $request Data
        $request->validate([

            'id' => 'required',
            'key' => 'max:50',

        ]);

        //Select Authenticated User
        $user = Auth::User();

        //Assign Variables
        $id = $request->id;
        $key = $request->key;

        $acc = Account::find($id);

        if (!($key == '')) {
            $acc->key_account = $key;
        }

        $acc->verify = true;

        $acc->save();

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }

    //Destroy Newsletter
    public function destroy(Request $request)
    {

        //Assign Newsletter ID
        $id = $request->id;

        //Find Newsletter
        $acc = Account::find($id);

        //Delete
        $acc->delete();

        //Return Response in JSON DataType
        return response()->json(['message' => "success"], 202);
    }
}
