<?php

namespace App\Http\Controllers\Backend;

use App\Balance;
use App\Currency;
use App\Http\Controllers\Controller;
use App\Order;
use App\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Kraken;
use TCV;

class OrderController extends Controller
{

    //Execute if user is authenticated
    public function __construct()
    {

        $this->middleware(['auth', '2fa', 'verify.ip']);

    }

    private function get_client_ip_server()
    {
        $ipaddress = '';

        if ($_SERVER['REMOTE_ADDR']) {

            $ipaddress = $_SERVER['REMOTE_ADDR'];

        } else {

            $ipaddress = 'UNKNOWN';

        }
        return $ipaddress;
    }
    //Function for order arrays
    private function sorting($order, $key)
    {

        return function ($a, $b) use ($order, $key) {

            if ($order == 'DESC') {
                if (empty($key)) {

                    return strnatcmp($a->amount, $b->amount);

                } else {

                    return strnatcmp($a->$key, $b->$key);

                }

            } else {

                if (empty($key)) {

                    return strnatcmp($b->amount, $a->amount);

                } else {

                    return strnatcmp($b->$key, $a->$key);

                }
            }
        };
    }

    //List of Transactions
    public function index(Request $request)
    {

        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $searchValue = $request->searchvalue;
        $page = $request->page;
        $resultPage = $request->resultPage;
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $total = 0;

        //Verify if $orderBy is empty
        if (empty($orderBy)) {

            $orderBy = 'created_at';

        }

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Verify if user has client role

        $query = Order::Where('orders.type', 'market')->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')->select('orders.*', 'symbol')->orderBy('created_at', 'desc');

        //Search by
        if ($searchValue != '') {

            $query->Where(function ($query) use ($searchValue) {
                $query->Where('in_amount', 'like', '%' . $searchValue . '%')
                    ->orWhere('out_amount', 'like', '%' . $searchValue . '%')
                    ->orWhere('rate', 'like', '%' . $searchValue . '%')
                    ->orWhere('fee', 'like', '%' . $searchValue . '%')
                    ->orWhere('reference', 'like', '%' . $searchValue . '%')
                    ->orWhere('status', 'like', '%' . $searchValue . '%')
                    ->orWhere('orders.created_at', 'like', '%' . $searchValue . '%')
                    ->orWhere('currencies.symbol', 'like', '%' . $searchValue . '%');
            });

        }

        if ($resultPage == null || $resultPage == 0) {

            $resultPage = 10;

        }

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Fund Orders
        $transactionsP = $query->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
                $transactions[$count]->txid = $transaction->txid;
            }
            $count++;

        }

        //Sort $transactions array
        usort($transactions, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Verify if user is trader or admin

        if ($user->hasCredential('158')) {

            //Return true for administrative access
            $eaccess = true;

        } else {

            //Return false for administrative access
            $eaccess = false;

        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $transactions, 'total' => $total, 'eaccess' => $eaccess], 202);
    }

    //Validate Balance
    public function validateDW(Request $request)
    {

        //Validate $request data
        $request->validate([
            'id' => 'required',
            'cout' => 'required',
            'aout' => 'required| min:1',
            'ain' => 'min:1',
            'cin' => 'required',
            'rate' => 'min:1',
        ]);

        //Declare Variables
        $cout = $request->cout;
        $cin = $request->cin;
        $aout = $request->aout;
        $ain = $request->ain;
        $id = $request->id;
        $rate = $request->rate;

        //Find Pending Transaction
        $order = FundOrder::find($id);

        //Declare Valid Balance
        $valid = Balance::Where('balances.type', 'fund')->where('user_id', null)->where('currencies.symbol', $cout)->leftJoin('currencies', 'currencies.id', '=', 'balances.currency_id')->select('balances.*')->first();

        //Declare Change Balance
        $change = Balance::Where('balances.type', 'fund')->where('user_id', null)->where('currencies.symbol', $cin)->leftJoin('currencies', 'currencies.id', '=', 'balances.currency_id')->select('balances.*')->first();

        //Declare In and Out Currencies
        $idout = Currency::Where('symbol', $cout)->select('id')->first();
        $idin = Currency::Where('symbol', $cin)->select('id')->first();

        //Verify if amount is valid
        if ($aout <= $valid->amount) {

            //Modify Valid Balance
            $balance = Balance::find($valid->id);
            $newbalance = $balance->amount - $aout;
            $balance->amount = $newbalance;

            //Modify Change Balance
            $balancen = Balance::find($change->id);
            $newbalancen = $balancen->amount + $ain;
            $balancen->amount = $newbalancen;

            //Complete order
            $order->in_amount = $ain;
            $order->status = 'complete';
            $order->rate = $rate;

        } else {

            //Return error
            return response()->json(['error' => 'You don\'t have enough funds'], 403);

        }

        //Save changes
        $order->save();
        $balance->save();
        $balancen->save();

        //Return Response in JSON dataType
        return response()->json(['message' => 'Your Validation was processed successfully'], 202);
    }

    public function activeMarket(Request $request)
    {
        //Select Authenticated user
        $user = Auth::User();

        $symbol = $request->symbol;
        //Assign Variables
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;
        $symbol2 = $request->symbol2;
        //Verify if $orderBy is empty
        if (empty($orderBy)) {

            $orderBy = 'created_at';

        }

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::where('user_id', $user->id)->where('orders.type', 'exchange')->where('status', 'pending')->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')->select('orders.*', 'symbol')->orderBy('created_at', 'desc');

        $query->Where(function ($query) use ($symbol) {
            $query->Where('in_currency', 'like', '%' . $symbol . '%')
                ->orWhere('out_currency', 'like', '%' . $symbol . '%');
        });

        $query->Where(function ($query) use ($symbol2) {
            $query->Where('in_currency', 'like', '%' . $symbol2 . '%')
                ->orWhere('out_currency', 'like', '%' . $symbol2 . '%');
        });

        //Get Fund Orders
        $transactionsP = $query->limit(10)->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        //Sort $transactions array
        usort($transactions, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Verify if user is trader or admin

        if ($user->hasCredential('158')) {

            //Return true for administrative access
            $eaccess = true;

        } else {

            //Return false for administrative access
            $eaccess = false;

        }

        //Return Response in JSON datatype
        return response()->json(['result' => $transactions, 'eaccess' => $eaccess], 202);
    }

    public function marketHistory(Request $request)
    {
        //Select Authenticated user
        $user = Auth::User();

        $symbol = $request->symbol;
        $symbol2 = $request->symbol2;
        //Assign Variables
        $orderBy = $request->orderBy;
        $orderDirection = $request->orderDirection;

        //Verify if $orderBy is empty
        if (empty($orderBy)) {

            $orderBy = 'created_at';

        }

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::where('user_id', $user->id)->where('orders.type', 'exchange')->wherenotIn('status', ['pending'])->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')->select('orders.*', 'symbol')->orderBy('created_at', 'desc');

        $query->Where(function ($query) use ($symbol) {
            $query->Where('in_currency', 'like', '%' . $symbol . '%')
                ->orWhere('out_currency', 'like', '%' . $symbol . '%');
        });

        $query->Where(function ($query) use ($symbol2) {
            $query->Where('in_currency', 'like', '%' . $symbol2 . '%')
                ->orWhere('out_currency', 'like', '%' . $symbol2 . '%');
        });

        //Get Fund Orders
        $transactionsP = $query->limit(10)->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->out_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $transaction->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $currency->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->ip = $transaction->ip;
                $transactions[$count]->ubication = $transaction->ubication;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->id = $transaction->id;
            }

            $count += 1;

        }

        //Sort $transactions array
        usort($transactions, $this->sorting($orderDirection, $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Verify if user is trader or admin

        if ($user->hasCredential('158')) {

            //Return true for administrative access
            $eaccess = true;

        } else {

            //Return false for administrative access
            $eaccess = false;

        }

        //Return Response in JSON datatype
        return response()->json(['result' => $transactions, 'eaccess' => $eaccess], 202);
    }

    public function orderBook(Request $request)
    {

        $symbol = $request->symbol;
        $symbol2 = $request->symbol2;
        //Assign Variables

        //Verify if $orderBy is empty
        if (empty($orderBy)) {

            $orderBy = 'created_at';

        }

        //Create $transactions array
        $transactionsB = array();
        $transactionsA = array();

        //Create $count variable
        $countB = -1;
        $countA = -1;

        //Select Orders
        $query = Order::where('orders.type', 'exchange')->where('status', 'pending')->leftJoin('currencies', 'currencies.id', '=', 'orders.in_currency')->select('orders.*', 'symbol')->orderBy('rate', 'desc');

        $query->Where(function ($query) use ($symbol) {
            $query->Where('in_currency', 'like', '%' . $symbol . '%')
                ->orWhere('out_currency', 'like', '%' . $symbol . '%');
        });

        $query->Where(function ($query) use ($symbol2) {
            $query->Where('in_currency', 'like', '%' . $symbol2 . '%')
                ->orWhere('out_currency', 'like', '%' . $symbol2 . '%');
        });

        //Get Fund Orders
        $transactionsP = $query->get();

        $co = 1;
        $priceA = 0;
        $priceB = 0;
        //Loop Fund Orders
        foreach ($transactionsP as $transaction) {

            if ($transaction->trade_type == 'bid') {
                if ($transaction->rate == $priceB) {
                    $transactionsB[$countB]->count += 1;
                    $transactionsB[$countB]->total += ($transaction->in_amount - ($transaction->rate * $transaction->filled));
                    $transactionsB[$countB]->amount += $transaction->in_amount;
                } else {
                    $priceB = $transaction->rate;
                    $countB += 1;
                    if (empty($transactionsB[$countB])) {
                        $transactionsB[$countB] = new \stdClass();
                        $transactionsB[$countB]->count = $co;
                        $transactionsB[$countB]->type = 'bid';
                        $transactionsB[$countB]->total = $transaction->in_amount - ($transaction->filled / $transaction->rate);
                        $transactionsB[$countB]->amount = $transaction->in_amount;
                        $transactionsB[$countB]->price = $transaction->rate;
                    }
                }
            } else {
                if ($transaction->rate == $priceA) {
                    $transactionsA[$countA]->count += 1;
                    $transactionsA[$countA]->total += $transaction->out_amount - $transaction->filled;
                    $transactionsA[$countA]->amount += $transaction->out_amount;
                } else {
                    $priceA = $transaction->rate;
                    $countA += 1;
                    if (empty($transactionsA[$countA])) {
                        $transactionsA[$countA] = new \stdClass();
                        $transactionsA[$countA]->count = $co;
                        $transactionsA[$countA]->type = 'ask';
                        $transactionsA[$countA]->total = $transaction->out_amount - ($transaction->filled / $transaction->rate);
                        $transactionsA[$countA]->amount = $transaction->out_amount;
                        $transactionsA[$countA]->price = $transaction->rate;
                    }
                }
            }

            //Verify if $transactions array is empty

        }
        //Sort $transactions array
        if (empty($transactionsB[0])) {
            $currency1 = Currency::find($symbol);
            $currency2 = Currency::find($symbol2);
            if ($currency1->symbol == 'BTC') {
                $sym = 'XBT';
                $sym2 = $currency2->symbol;
            } else if ($currency2->symbol == 'BTC') {
                $sym2 = 'XBT';
                $sym = $currency1->symbol;
            } else {
                $sym = $currency1->symbol;
                $sym2 = $currency2->symbol;
            }

            if ($currency1->type == 'FIAT') {
                $spair = 'X' . $sym2 . 'Z' . $sym;
                $pair = $sym2 . $sym;
            } else if ($currency2->type == 'FIAT') {
                $spair = 'X' . $sym . 'Z' . $sym2;
                $pair = $sym . $sym2;
            } else {
                $pair = $sym2 . $sym;
                $spair = 'X' . $sym2 . 'X' . $sym;
            }

            $kraken = Kraken::getOrderBook([$pair], 5);
            if ($currency1->symbol == 'DASH' || $currency2->symbol == 'DASH') {
                $results = $kraken['result'][$pair]['bids'];
            } else {
                $results = $kraken['result'][$spair]['bids'];
            }

            $countA = 0;
            foreach ($results as $result) {
                $transactionsB[$countA] = new \stdClass();
                $transactionsB[$countA]->count = 1;
                $transactionsB[$countA]->type = 'bid';
                $transactionsB[$countA]->total = $result[1];
                $transactionsB[$countA]->amount = $result[1];
                $transactionsB[$countA]->price = $result[0];
                $countA += 1;
            }

        }
        if (empty($transactionsA[0])) {
            $currency1 = Currency::find($symbol);
            $currency2 = Currency::find($symbol2);
            if ($currency1->symbol == 'BTC') {
                $sym = 'XBT';
                $sym2 = $currency2->symbol;
            } else if ($currency2->symbol == 'BTC') {
                $sym2 = 'XBT';
                $sym = $currency1->symbol;
            } else {
                $sym = $currency1->symbol;
                $sym2 = $currency2->symbol;
            }

            if ($currency1->type == 'FIAT') {
                $spair = 'X' . $sym2 . 'Z' . $sym;
                $pair = $sym2 . $sym;
            } else if ($currency2->type == 'FIAT') {
                $spair = 'X' . $sym . 'Z' . $sym2;
                $pair = $sym . $sym2;
            } else {
                $pair = $sym2 . $sym;
                $spair = 'X' . $sym2 . 'X' . $sym;
            }

            $kraken = Kraken::getOrderBook([$pair], 5);
            if ($currency1->symbol == 'DASH' || $currency2->symbol == 'DASH') {
                $results = $kraken['result'][$pair]['asks'];
            } else {
                $results = $kraken['result'][$spair]['asks'];
            }

            $countB = 0;
            foreach ($results as $result) {
                $transactionsA[$countB] = new \stdClass();
                $transactionsA[$countB]->count = 1;
                $transactionsA[$countB]->type = 'bid';
                $transactionsA[$countB]->total = $result[1];
                $transactionsA[$countB]->amount = $result[1];
                $transactionsA[$countB]->price = $result[0];
                $countB += 1;
            }
        }
        usort($transactionsB, $this->sorting('', 'price'));
        usort($transactionsA, $this->sorting('DESC', 'price'));

        //Return Response in JSON datatype
        return response()->json(['result1' => $transactionsB, 'result2' => $transactionsA], 202);
    }

    public function rateFast(Request $request)
    {

        $symbol1 = $request->symbol;
        $symbol2 = $request->symbol2;
        $amount = $request->value;
        $exchange = 0;
        $equivalent1 = 0;
        $equivalent2 = 0;
        $setting = Setting::first();
        $cu1 = Currency::Where('symbol', $symbol1)->first();
        $cu2 = Currency::Where('symbol', $symbol2)->first();

        if ($cu1->exchangeable && !($cu2->prima)) {
            $query = Order::where('orders.type', 'exchange')->where('status', 'pending');
            $query->where('trade_type', 'bid')->orderBy('rate', 'desc');
        } else if ($cu2->exchangeable && !($cu1->prima)) {
            $query = Order::where('orders.type', 'exchange')->where('status', 'pending')->where('trade_type', 'ask')->orderBy('rate', 'asc');
        } else {
            $query = Order::where('orders.type', 'exchange')->where('status', 'pending')->where('trade_type', 'ask')->orderBy('rate', 'asc');
        }
        $query->Where(function ($query) use ($cu1) {
            $query->Where('in_currency', 'like', '%' . $cu1->id . '%')
                ->orWhere('out_currency', 'like', '%' . $cu1->id . '%');
        });
        $query->Where(function ($query) use ($cu2) {
            $query->Where('in_currency', 'like', '%' . $cu2->id . '%')
                ->orWhere('out_currency', 'like', '%' . $cu2->id . '%');
        });
        if ($amount != '') {
            //Si existen ordenes en el mercado de afx
            if ($query->count()) {
                $orders = $query->get();
                $count = 0;
                $sum = 0;
                $filled = 0;
                foreach ($orders as $ord) {
                    if ($cu1->exchangeable && !($cu2->prima)) {
                        $fill = $ord->filled + $amount;
                    } else if ($cu2->exchangeable && !($cu1->prima)) {
                        $fill = ($ord->filled / $ord->rate) + $amount;
                    }

                    if ($ord->out_amount < $fill) {
                        $difex = $fill - $ord->out_amount;
                        $newPrifill = $ord->out_amount - $difex;
                        $sum += $ord->rate;
                        $count += 1;
                        $filled += $newPrifill;

                        if (bccomp($filled, $amount, 8) == 0) {
                            break;
                        }
                    } else if ($parse >= $fill) {
                        $filled += $fill;
                        $sum += $ord->rate;
                        $count += 1;
                        if (bccomp($filled, $amount, 8) == 0) {
                            break;
                        }
                    }
                }
                if ($cu1->exchangeable && !($cu2->prima)) {
                    $result = 1 / ($sum / $count);
                } else if ($cu2->exchangeable && !($cu1->prima)) {
                    $result = $sum / $count;
                }

            } else {
                $incog1 = ($request->type == 'cryptoexc' || $request->type == "fiatexc");
                $incog2 = ($request->type == 'cryptorec' || $request->type == "fiatrec");

                $incog3 = strtolower($cu1->symbol) == 'ptr' || strtolower($cu2->symbol) == 'ptr';
                $incog4 = strtolower($cu1->symbol) == 'ves' || strtolower($cu2->symbol) == 'ves';

                if ($incog4) {
                    if ($incog3) {

                        if (strtolower($cu1->symbol) == 'ptr') {
                            $cprice = $cu1->price;
                            $vprice = $cu2->price;
                            $price = $cprice / $vprice;
                            $result = $price;
                            if ($incog2) {
                                $resultT = 1 / $price;
                            } else {
                                $resultT = $price;
                            }
                        } else {
                            $cprice = $cu2->price;
                            $vprice = $cu1->price;
                            $price = $cprice / $vprice;
                            $result = $price;
                            if ($incog2) {
                                $resultT = $price;
                            } else {
                                $resultT = 1 / $price;
                            }
                        }
                    }

                } else if ($incog3) {
                    if (strtolower($cu1->symbol) == 'ptr') {
                        $pair = strtolower($cu1->symbol) . strtolower($cu2->symbol);
                        $kraken = TCV::getOrderBook($pair);
                        
                        $count = count($kraken['bids']) - 1;

                        if($count <= 0){
                            return response()->json(['error' => 'No existe volumen'], 404);
                        }
                        $price = $kraken['bids'][0]['price'];

                        $result = $price;

                        if ($incog2) {
                            $resultT = 1 / $price;
                        } else {
                            $resultT = $price;
                        }

                    } else if (strtolower($cu2->symbol) == 'ptr') {
                        $pair = strtolower($cu2->symbol) . strtolower($cu1->symbol);

                        $kraken = TCV::getOrderBook($pair);
                        //dd($kraken);
                        $count = count($kraken['asks']) - 1;
                        if($count <= 0){
                            return response()->json(['error' => 'No existe volumen'], 404);
                        }
                        $price = $kraken['asks'][0]['price'];

                        $result = 1 / $price;

                        if ($incog2) {
                            
                            $resultT = $price;
                        } else {
                            $resultT = 1 / $price;
                        }
                    }

                } else {

                    if ($cu1->symbol == 'BTC') {
                        
                        $sym = 'XBT';
                        $pair = $cu2->symbol . $sym;

                        if ($cu2->symbol == 'DASH') {
                            $spair = $cu2->symbol . $sym;
                        } else {
                            $spair = 'X' . $cu2->symbol . 'X' . $sym;
                        }

                        $kraken = Kraken::getOrderBook([$pair], 1);

                        $result = 1 / $kraken['result'][$spair]['bids'][0][0];

                        if ($incog2) {
                            $resultT = $kraken['result'][$spair]['bids'][0][0];
                        } else {
                            $resultT = 1 / $kraken['result'][$spair]['bids'][0][0];
                        }

                    } else if ($cu2->symbol == 'BTC') {

                        $sym = 'XBT';
                        $pair = $cu1->symbol . $sym;

                        if ($cu1->symbol == 'DASH') {
                            $spair = $cu1->symbol . $sym;
                        } else {
                            $spair = 'X' . $cu1->symbol . 'X' . $sym;
                        }

                        $kraken = Kraken::getOrderBook([$pair], 1);
                        $result = $kraken['result'][$spair]['asks'][0][0];

                        if ($incog2) {
                            $resultT = 1 / $kraken['result'][$spair]['bids'][0][0];
                        } else {
                            $resultT = $kraken['result'][$spair]['bids'][0][0];
                        }

                    } else {

                        $sym = 'XBT';

                        $pair1 = $cu1->symbol . $sym;
                        $spair1 = 'X' . $cu1->symbol . 'X' . $sym;

                        $kraken = Kraken::getOrderBook([$pair1], 1);
                        $result1 = $kraken['result'][$spair1]['asks'][0][0];

                        $pair2 = $cu2->symbol . $sym;
                        $spair2 = 'X' . $cu2->symbol . 'X' . $sym;

                        $kraken = Kraken::getOrderBook([$pair2], 1);
                        $result2 = $kraken['result'][$spair2]['asks'][0][0];

                        $result = (1 / $result2) / (1 / $result1);

                        if ($incog2) {
                            $resultT = (1 / $result1) / (1 / $result2);
                        } else {
                            $resultT = (1 / $result2) / (1 / $result1);
                        }
                    }
                }
                
                if ($incog1 || $incog2) {
                    if ($incog4) {
        

                            if (strtolower($cu2->symbol) == 'ves') {
                                $cprice = $cu1->price;
                                $vprice = $cu2->price;
                                $price = $cprice / $vprice;
                                $result = $price;
                                if ($incog2) {
                                    $resultT = 1 / $price;
                                } else {
                                    $resultT = $price;
                                }
                                $result3 = $cu1->price;
                                $result4 = $cu2->price;
                            } else if(strtolower($cu1->symbol) == 'ves'){
                                $cprice = $cu2->price;
                                $vprice = $cu1->price;
                                $price = $cprice / $vprice;
                                $result = $price;
                                if ($incog2) {
                                    $resultT = $price;
                                } else {
                                    $resultT = 1 / $price;
                                }
                                $result3 = $cu1->price;
                                $result4 = $cu2->price;
                            }
                            $krakenfee = 0;
                    

                    } else if ($incog3) {
                        if (strtolower($cu1->symbol) == 'ptr') {

                            $pair3 = strtolower($cu1->symbol) . strtolower($cu2->symbol);
                            $pair4 = $cu2->symbol . 'USD';
                            /*
                            if ($cu2->symbol == 'DASH') {

                                $spair4 = $cu2->symbol . 'USD';

                            } else if ($cu2->symbol == 'BTC') {
                                $pair4 = 'XBTUSD';
                                $spair4 = 'XXBTZUSD';
                            } else {

                                $spair4 = 'X' . $cu2->symbol . 'ZUSD';

                            }*/
                            $kraken = TCV::getOrderBook($pair3);
                            
                            $result3 = $cu1->price;
                            $result4 = $kraken['bids'][0]['price'];

                            $krakenfee = TCV::getFee('trading');

                            foreach ($krakenfee as $market) {
                                if ($market['market'] == $pair3) {
                                    $fee = $market['ask_fee']['value'];
                                }
                            }

                            $krakenfee = $fee;
                        } else if (strtolower($cu2->symbol) == 'ptr') {
                            $pair3 = $cu1->symbol . 'USD';
                            $pair4 = strtolower($cu2->symbol) . strtolower($cu1->symbol);

                            if ($cu1->symbol == 'DASH') {
                                $spair3 = $cu1->symbol . 'USD';
                            } else if ($cu1->symbol == 'BTC') {
                                $pair3 = 'XBTUSD';
                                $spair3 = 'XXBTZUSD';
                            } else {
                                $spair3 = 'X' . $cu1->symbol . 'ZUSD';
                            }

                            $kraken = Kraken::getOrderBook([$pair3], 1);
                            
                            $result3 = $kraken['result'][$spair3]['bids'][0][0];

                            $result4 = $cu2->price;

                            $krakenfee = TCV::getFee('trading');

                            foreach ($krakenfee as $market) {
                                if ($market['market'] == $pair4) {

                                    $fee = $market['bid_fee']['value'];

                                }
                            }

                            $krakenfee = $fee;

                        }

                    } else {

                        if ($cu1->symbol == 'BTC') {

                            $pair3 = 'XBTUSD';
                            $spair3 = 'XXBTZUSD';
                            $pair4 = $cu2->symbol . 'USD';

                            if ($cu2->symbol == 'DASH') {

                                $spair4 = $cu2->symbol . 'USD';

                            } else {

                                $spair4 = 'X' . $cu2->symbol . 'ZUSD';

                            }

                        } else if ($cu2->symbol == 'BTC') {

                            $pair3 = $cu1->symbol . 'USD';

                            if ($cu1->symbol == 'DASH') {
                                $spair3 = $cu1->symbol . 'USD';
                            } else {
                                $spair3 = 'X' . $cu1->symbol . 'ZUSD';
                            }

                            $pair4 = 'XBTUSD';
                            $spair4 = 'XXBTZUSD';

                        } else {
                            $pair3 = $cu1->symbol . 'USD';

                            if ($cu1->symbol == 'DASH') {
                                $spair3 = $cu1->symbol . 'USD';
                            } else {
                                $spair3 = 'X' . $cu1->symbol . 'ZUSD';
                            }

                            $pair4 = $cu2->symbol . 'USD';

                            if ($cu2->symbol == 'DASH') {
                                $spair4 = $cu2->symbol . 'USD';
                            } else {
                                $spair4 = 'X' . $cu2->symbol . 'ZUSD';
                            }
                        }

                        $kraken = Kraken::getOrderBook([$pair3], 1);
                        $result3 = $kraken['result'][$spair3]['bids'][0][0];

                        $kraken = Kraken::getOrderBook([$pair4], 1);
                        $result4 = $kraken['result'][$spair4]['bids'][0][0];

                        $kraken = Kraken::getAssetPairs([$pair]);

                        $krakenfee = $kraken['result'][$spair]['fees'][0][1];
                        $krakenfee = $krakenfee / 100;
                    }

                    if ($request->type == 'cryptorec' || $request->type == 'cryptoexc') {
                        if(strtolower($cu1->symbol) == 'ltc' && strtolower($cu2->symbol) == 'ptr'){
                            $exchange =  $amount * $price;
                        }else if(strtolower($cu2->symbol) == 'ltc' && strtolower($cu1->symbol) == 'ptr'){
                            $exchange =  $amount * (1 / $price);
                        }else{ 
                            $exchange = $amount * $resultT;
                        }
                    } else {

                        if ($request->type == "fiatrec") {

                            $exchange = $amount / $result3;

                        } else {

                            $exchange = $amount / $result4;

                        }

                    }

                    if ($request->type == 'cryptorec') {
                        $equivalent1 = $amount * $result4;
                        $equivalent2 = $exchange * $result3;

                        if ($cu1->type == 'FIAT' && $cu2->type == 'Cryptocurrency') {

                            $exchange += ($setting->fee_fiat_crypto * $exchange);
                            $equivalent2 += ($setting->fee_fiat_crypto * $equivalent2);

                        } else if ($cu1->type == 'Cryptocurrency' && $cu2->type == 'FIAT') {

                            $exchange += ($setting->fee_crypto_fiat * $exchange);
                            $equivalent2 += ($setting->fee_crypto_fiat * $equivalent2);

                        } else {

                            $exchange += ($setting->fee_crypto_crypto * $exchange);
                            $equivalent2 += ($setting->fee_crypto_crypto * $equivalent2);

                        }
                        $exchange += ($krakenfee * $exchange);
                        $equivalent2 += ($krakenfee * $equivalent2);

                    } else if ($request->type == 'cryptoexc') {

                        $equivalent1 = $amount * $result3;
                        $equivalent2 = $exchange * $result4;

                        if ($cu1->type == 'FIAT' && $cu2->type == 'Cryptocurrency') {

                            $exchange -= ($setting->fee_fiat_crypto * $exchange);
                            $equivalent2 -= ($setting->fee_fiat_crypto * $equivalent2);

                        } else if ($cu1->type == 'Cryptocurrency' && $cu2->type == 'FIAT') {

                            $exchange -= ($setting->fee_crypto_fiat * $exchange);
                            $equivalent2 -= ($setting->fee_crypto_fiat * $equivalent2);

                        } else {

                            $exchange -= ($setting->fee_crypto_crypto * $exchange);
                            $equivalent2 -= ($setting->fee_crypto_crypto * $equivalent2);

                        }
                        $exchange -= ($krakenfee * $exchange);
                        $equivalent2 -= ($krakenfee * $equivalent2);

                    } else if ($request->type == "fiatrec") {

                        $equivalent1 = $amount / $result4;
                        $equivalent2 = $exchange * $result3;

                        if ($cu1->type == 'FIAT' && $cu2->type == 'Cryptocurrency') {

                            $exchange += ($setting->fee_fiat_crypto * $exchange);
                            $equivalent2 += ($setting->fee_fiat_crypto * $equivalent2);

                        } else if ($cu1->type == 'Cryptocurrency' && $cu2->type == 'FIAT') {

                            $exchange += ($setting->fee_crypto_fiat * $exchange);
                            $equivalent2 += ($setting->fee_crypto_fiat * $equivalent2);

                        } else {

                            $exchange += ($setting->fee_crypto_crypto * $exchange);
                            $equivalent2 += ($setting->fee_crypto_crypto * $equivalent2);

                        }
                        $exchange += ($krakenfee * $exchange);
                        $equivalent2 += ($krakenfee * $equivalent2);

                    } else {

                        $equivalent1 = $amount / $result3;
                        $equivalent2 = $exchange * $result4;

                        if ($cu1->type == 'FIAT' && $cu2->type == 'Cryptocurrency') {

                            $exchange -= ($setting->fee_fiat_crypto * $exchange);
                            $equivalent2 -= ($setting->fee_fiat_crypto * $equivalent2);

                        } else if ($cu1->type == 'Cryptocurrency' && $cu2->type == 'FIAT') {

                            $exchange -= ($setting->fee_crypto_fiat * $exchange);
                            $equivalent2 -= ($setting->fee_crypto_fiat * $equivalent2);

                        } else {

                            $exchange -= ($setting->fee_crypto_crypto * $exchange);
                            $equivalent2 -= ($setting->fee_crypto_crypto * $equivalent2);

                        }
                        $exchange -= ($krakenfee * $exchange);
                        $equivalent2 -= ($krakenfee * $equivalent2);

                    }
                }

            }
        } else {
            if ($query->count()) {
                $order = $query->first();

                if ($cu1->exchangeable && !($cu2->prima)) {
                    $result = 1 / $order->rate;
                } else if ($cu2->exchangeable && !($cu1->prima)) {
                    $result = $order->rate;
                }
            } else {
                
                $incog3 = strtolower($cu1->symbol) == 'ptr' || strtolower($cu2->symbol) == 'ptr';

                if ($incog3) {
                    if (strtolower($cu1->symbol) == 'ptr') {
                        $pair = strtolower($cu1->symbol) . strtolower($cu2->symbol);
                        $kraken = TCV::getOrderBook($pair);
                        $count = 0;
                        if($kraken!="")$count = count($kraken['bids']) - 1;
                        
                        if($count <= 0){
                            return response()->json(['error' => 'No existe volumen'], 404);
                        }
                        
                        $price = $kraken['bids'][$count]['price'];
                        $result = $price;
                    } else if (strtolower($cu2->symbol) == 'ptr') {
                        $pair = strtolower($cu2->symbol) . strtolower($cu1->symbol);

                        $kraken = TCV::getOrderBook($pair);

                        $count = count($kraken['asks']) - 1;
                        if($count <= 0){
                            return response()->json(['error' => 'No existe volumen'], 404);
                        }
                        $price = $kraken['asks'][$count]['price'];

                        $result = 1 / $price;
                    }
                } else {
                    return response()->json(['error' => 'No existe volumen'], 404);
                    if ($cu1->symbol == 'BTC') {
                        $sym = 'XBT';
                        $pair = $cu2->symbol . $sym;
                        if ($cu2->symbol == 'DASH') {
                            $spair = $cu2->symbol . $sym;
                        } else {
                            $spair = 'X' . $cu2->symbol . 'X' . $sym;
                        }
                        $kraken = Kraken::getOrderBook([$pair], 1);
                        $result = 1 / $kraken['result'][$spair]['bids'][0][0];
                    } else if ($cu2->symbol == 'BTC') {
                        $sym = 'XBT';
                        $pair = $cu1->symbol . $sym;
                        if ($cu1->symbol == 'DASH') {
                            $spair = $cu1->symbol . $sym;
                        } else {
                            $spair = 'X' . $cu1->symbol . 'X' . $sym;
                        }
                        $kraken = Kraken::getOrderBook([$pair], 1);
                        $result = $kraken['result'][$spair]['asks'][0][0];
                    } else {
                        $sym = 'XBT';
                        $pair1 = $cu1->symbol . $sym;
                        if ($cu1->symbol == 'DASH') {
                            $spair1 = $cu1->symbol . $sym;
                        } else {
                            $spair1 = 'X' . $cu1->symbol . 'X' . $sym;
                        }
                        $kraken = Kraken::getOrderBook([$pair1], 1);
                        $result1 = $kraken['result'][$spair1]['asks'][0][0];

                        $pair2 = $cu2->symbol . $sym;
                        $spair2 = 'X' . $cu2->symbol . 'X' . $sym;
                        $kraken = Kraken::getOrderBook([$pair2], 1);
                        $result2 = $kraken['result'][$spair2]['asks'][0][0];

                        $result = (1 / $result2) / (1 / $result1);
                    }
                }
            }
        }

        return response()->json(['result' => $result, 'exchange' => [number_format($exchange, 12, '.', ''), number_format($equivalent1, 12, '.', ''), number_format($equivalent2, 12, '.', '')], 'message' => 'Complete'], 202);
    }
    //Destroy Order
    public function destroyOrder(Request $request)
    {

        //Validate $request data
        $request->validate([

            'id' => 'required',

        ]);
        
        $user = Auth::User();
        
        //Assign Variables
        $id = $request->id;

        //Find Fund Order
        $order = Order::find($id);

        //Select Out Balance
        //$balancein = Balance::Where('currency_id', $order->in_currency)->where('user_id', null)->first();
        $balanceout = Balance::Where('currency_id', $order->out_currency)->where('user_id', null)->first();
        
        //$balanceUin = Balance::Where('currency_id', $order->in_currency)->where('user_id', $user->id)->first();
        $balanceUout = Balance::Where('currency_id', $order->out_currency)->where('user_id', $order->user_id)->first();

        $balanceout->pending_amount -= $order->out_amount;
        $balanceUout->pending_amount -= $order->out_amount;

        $balanceout->amount += $order->out_amount;
        $balanceUout->amount += $order->out_amount;
        
        $balanceout->save();
        $balanceUout->save();
        
        //Delete Order
        $order->status = 'cancelled';
        $order->save();

        //Return response in Json Datatype
        return response()->json(['message' => 'Complete'], 202);
    }

    public function fastActivity(Request $request)
    {
        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $page = $request->page;
        $total = 0;
        $orderBy = 'created_at';
        $symbol = $request->symbol;

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::where('user_id', $user->id)->where('orders.type', 'market')->where('currencies.symbol', $symbol)->leftJoin('currencies', 'currencies.id', '=', 'orders.out_currency')->select('orders.*', 'symbol', 'price')->orderBy('created_at', 'desc');

        $resultPage = 10;

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Fund Orders
        $transactionsP = $query->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->in_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $currency->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $transaction->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->out_usd = $transaction->out_amount * $transaction->price;
                $transactions[$count]->rate_usd = $transaction->rate * $transaction->price;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->fee_network = $transaction->fee_network;
                $transactions[$count]->fee_exchange = $transaction->fee_exchange;
                $transactions[$count]->id = $transaction->id;
                $transactions[$count]->txid = $transaction->txid;
            }

            $count += 1;

        }

        //Sort $transactions array
        usort($transactions, $this->sorting('desc', $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $transactions, 'total' => $total], 202);

    }

    public function generalActivity(Request $request)
    {
        //Select Authenticated user
        $user = Auth::User();

        //Assign Variables
        $page = $request->page;
        $total = 0;
        $orderBy = 'created_at';

        //Create $transactions array
        $transactions = array();

        //Create $count variable
        $count = 0;

        //Select Orders
        $query = Order::where('user_id', $user->id)->where('orders.type', 'market')->leftJoin('currencies', 'currencies.id', '=', 'orders.out_currency')->select('orders.*', 'symbol', 'price')->orderBy('created_at', 'desc');

        $resultPage = 10;

        //Get Total
        $total = $query->get()->count();

        if ($page > 1) {

            $query->offset(($page - 1) * $resultPage);

        }

        $query->limit($resultPage);

        //Get Fund Orders
        $transactionsP = $query->get();

        //Loop Fund Orders
        foreach ($transactionsP as $transaction) {

            //Verify if $transactions array is empty
            if (empty($transactions[$count])) {
                $currency = Currency::find($transaction->in_currency);
                //Create object in $transactions array
                $transactions[$count] = new \stdClass();

                $transactions[$count]->in_amount = $transaction->in_amount;
                $transactions[$count]->in_symbol = $currency->symbol;
                $transactions[$count]->out_amount = $transaction->out_amount;
                $transactions[$count]->out_symbol = $transaction->symbol;
                $transactions[$count]->created_at = $transaction->created_at;
                $transactions[$count]->out_usd = $transaction->out_amount * $transaction->price;
                $transactions[$count]->rate_usd = $transaction->rate * $transaction->price;
                $transactions[$count]->reference = $transaction->reference;
                $transactions[$count]->status = $transaction->status;
                $transactions[$count]->trade_type = $transaction->trade_type;
                $transactions[$count]->updated_at = $transaction->updated_at;
                $transactions[$count]->rate = $transaction->rate;
                $transactions[$count]->fee = $transaction->fee;
                $transactions[$count]->fee_network = $transaction->fee_network;
                $transactions[$count]->fee_exchange = $transaction->fee_exchange;
                $transactions[$count]->id = $transaction->id;
                $transactions[$count]->txid = $transaction->txid;
            }

            $count += 1;

        }

        //Sort $transactions array
        usort($transactions, $this->sorting('desc', $orderBy));

        //Loop $transcations array
        foreach ($transactions as $transaction) {

            //Change date to formatted string
            $newcreated = $transaction->created_at->toFormattedDateString();
            $newupdated = $transaction->updated_at->toFormattedDateString();

            //Put New Dates
            $transaction->created_at = $newcreated;
            $transaction->updated_at = $newupdated;
        }

        //Return Response in JSON datatype
        return response()->json(['page' => $page, 'result' => $transactions, 'total' => $total], 202);

    }

}
